/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.values;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyHashItemPresentation;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyPrimitiveValue;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;

public class RubyHashItemValue
extends RubyDebugValue {
    @Nullable
    private RubyDebugValue myKeyDebugValue;
    @Nullable
    private RubyDebugValue myValueDebugValue;

    public RubyHashItemValue(Project project, XSourcePosition position, @NotNull String name, @NotNull RubyValue value, RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue) {
        if (name == null) {
            RubyHashItemValue.$$$reportNull$$$0(0);
        }
        if (value == null) {
            RubyHashItemValue.$$$reportNull$$$0(1);
        }
        super(project, position, name, value, frame, parentDebugValue);
        this.myKeyDebugValue = null;
        this.myValueDebugValue = null;
    }

    public RubyHashItemValue(Project project, XSourcePosition position, @NotNull String name, @NotNull RubyValue value, RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue, @NotNull RubyVariableInfo keyInfo, @NotNull RubyVariableInfo variableInfo) {
        if (name == null) {
            RubyHashItemValue.$$$reportNull$$$0(2);
        }
        if (value == null) {
            RubyHashItemValue.$$$reportNull$$$0(3);
        }
        if (keyInfo == null) {
            RubyHashItemValue.$$$reportNull$$$0(4);
        }
        if (variableInfo == null) {
            RubyHashItemValue.$$$reportNull$$$0(5);
        }
        super(project, position, name, value, frame, parentDebugValue);
        this.myKeyDebugValue = null;
        this.myValueDebugValue = null;
        RubyVariable variable = new RubyVariable(variableInfo, value.getOwner());
        if (RubyHashItemValue.keyValueHashPresentationDisabled()) {
            this.myValue = variable.getValue();
        }
        RubyVariable key = new RubyVariable(keyInfo, value.getOwner());
        this.myKeyDebugValue = RubyDebugValueFactory.create(project, position, frame, this, key.getName(), key);
        this.myValueDebugValue = RubyDebugValueFactory.create(project, position, frame, this, variable.getName(), variable);
    }

    @Override
    @Nullable
    public final String getEvaluationExpression() {
        if (this.myKeyDebugValue == null || this.myValueDebugValue == null || this.myParentDebugValue == null) {
            return null;
        }
        if (this.myKeyDebugValue instanceof RubyPrimitiveValue) {
            return this.myParentDebugValue.getEvaluationExpression() + "[" + ((RubyPrimitiveValue)this.myKeyDebugValue).getValueString() + "]";
        }
        return null;
    }

    @Override
    @Nullable
    protected Icon computeIconForNode(@NotNull XValueNode node) {
        if (node == null) {
            RubyHashItemValue.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    @NotNull
    public XValuePresentation getPresentation(@NotNull XValuePlace place) {
        if (place == null) {
            RubyHashItemValue.$$$reportNull$$$0(7);
        }
        if (this.myKeyDebugValue == null || this.myValueDebugValue == null) {
            String value = RubyDebuggerSupportUtils.convertToIdeEncoding(RubyDebuggerSupportUtils.getRubyValuePresentationString(this.myValue));
            return new XRegularValuePresentation(value, this.myValue.getReferenceTypeName(), " => ");
        }
        return new RubyHashItemPresentation(this.myKeyDebugValue, this.myValueDebugValue, place);
    }

    @Override
    public XValueModifier getModifier() {
        if (RubyHashItemValue.keyValueHashPresentationDisabled()) {
            return super.getModifier();
        }
        return null;
    }

    @Override
    public final void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            RubyHashItemValue.$$$reportNull$$$0(8);
        }
        if (this.myKeyDebugValue == null || this.myValueDebugValue == null || RubyHashItemValue.keyValueHashPresentationDisabled()) {
            super.computeChildren(node);
            return;
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(node, Arrays.asList(this.myKeyDebugValue, this.myValueDebugValue), true, true);
    }

    private static boolean keyValueHashPresentationDisabled() {
        return !RubyDebuggerSettings.getInstance().getState().isKeyValueHashPresentation();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableInfo";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyHashItemValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIconForNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPresentation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

