/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.values;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.CoreTypes;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyArrayValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueImpl;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyHashItemValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyHashValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyPrimitiveValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyStringValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubySymbolValue;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyHashItemInfo;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;
import org.rubyforge.debugcommons.model.RubyVariableInfo;

public final class RubyDebugValueFactory {
    private static final Logger LOG = Logger.getInstance(RubyStackFrame.class);

    private RubyDebugValueFactory() {
    }

    @NotNull
    public static RubyDebugValue create(Project project, XSourcePosition position, RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue, @NotNull String name, @NotNull RubyVariable rubyVariable) {
        if (name == null) {
            RubyDebugValueFactory.$$$reportNull$$$0(0);
        }
        if (rubyVariable == null) {
            RubyDebugValueFactory.$$$reportNull$$$0(1);
        }
        RubyValue value = rubyVariable.getValue();
        RubyVariableInfo variableInfo = rubyVariable.getVariableInfo();
        if (variableInfo instanceof RubyHashItemInfo) {
            RubyHashItemInfo hashItemInfo = (RubyHashItemInfo)variableInfo;
            return new RubyHashItemValue(project, position, name, value, frame, parentDebugValue, hashItemInfo.getKeyInfo(), hashItemInfo.getValueInfo());
        }
        String typeName = value.getReferenceTypeName();
        if ("Array".equals(typeName)) {
            return new RubyArrayValue(project, position, name, value, frame, parentDebugValue);
        }
        if ("Symbol".equals(typeName)) {
            return new RubySymbolValue(project, position, name, value, frame, parentDebugValue);
        }
        if ("Hash".equals(typeName)) {
            return new RubyHashValue(project, position, name, value, frame, parentDebugValue);
        }
        for (String type : CoreTypes.NUMBERS) {
            if (!type.equals(typeName)) continue;
            return new RubyPrimitiveValue(project, frame, parentDebugValue, position, name, value);
        }
        for (String type : CoreTypes.STRINGS) {
            if (!type.equals(typeName)) continue;
            return new RubyStringValue(project, position, frame, parentDebugValue, name, value);
        }
        if (rubyVariable.isHashValue()) {
            return new RubyHashItemValue(project, position, name, value, frame, parentDebugValue);
        }
        return new RubyDebugValueImpl(project, position, name, value, frame, parentDebugValue);
    }

    public static XValueGroup createGlobalVariables(final Project project, final XSourcePosition position, final RubyDebuggerProxy debuggerProxy, final Set<String> globalsProcessed, final RubyStackFrame frame) {
        return new XValueGroup(RBundle.message((String)"ruby.debugger.global.variables")){

            public void computeChildren(@NotNull XCompositeNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    ArrayList<RubyVariable> globals2Show = new ArrayList<RubyVariable>();
                    try {
                        for (RubyVariable variable : debuggerProxy.readGlobalVariables()) {
                            if (globalsProcessed.contains(variable.getName())) continue;
                            globals2Show.add(variable);
                        }
                    }
                    catch (RubyDebuggerException e) {
                        LOG.info((Throwable)e);
                    }
                    RubyVariable[] variables = globals2Show.toArray(RubyVariable.EMPTY_ARRAY);
                    RubyDebuggerSupportUtils.addRubyVariablesToNode(project, position, node, variables, frame, null, true);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValueFactory$1", "computeChildren"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rubyVariable";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyDebugValueFactory";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

