/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.values;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValue;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public abstract class RubyCompositeValue
extends RubyDebugValue {
    private static final int MAX_ELEMENTS_TO_SHOW = 100;
    private Integer mySize;

    public RubyCompositeValue(Project project, XSourcePosition position, @NotNull String name, @NotNull RubyValue value, RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue, @NotNull Icon icon) {
        if (name == null) {
            RubyCompositeValue.$$$reportNull$$$0(0);
        }
        if (value == null) {
            RubyCompositeValue.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            RubyCompositeValue.$$$reportNull$$$0(2);
        }
        super(project, position, name, value, frame, parentDebugValue, icon);
        this.mySize = null;
    }

    private int getSize() {
        if (this.mySize == null) {
            assert (this.myFrame.getFeatures().isPartialInstanceVariablesSupported());
            assert (this.myValue.getOwner().getVariableInfo().getAdditionalTags() != null);
            String size = (String)this.myValue.getOwner().getVariableInfo().getAdditionalTags().get("size");
            assert (size != null);
            return Integer.parseInt(size);
        }
        return this.mySize;
    }

    @Override
    protected final void doComputeChildren(int remainingElements, @NotNull XCompositeNode node) throws RubyDebuggerException {
        if (node == null) {
            RubyCompositeValue.$$$reportNull$$$0(3);
        }
        if (this.myFrame.getFeatures().isPartialInstanceVariablesSupported()) {
            int from = remainingElements < 0 ? 0 : this.getSize() - remainingElements;
            int to = from + 100;
            RubyDebuggerSupportUtils.addRubyVariablesToNode(this.myProject, this.myPosition, node, this.myValue.getVariablesSubsequence(from, 100), this.myFrame, this, this.alreadySorted());
            if (to < this.getSize()) {
                node.tooManyChildren(this.getSize() - to, () -> this.computeChildren(this.getSize() - to, node));
            }
            return;
        }
        RubyVariable[] variables = this.myValue.getVariables();
        int from = remainingElements < 0 ? 0 : variables.length - remainingElements;
        int to = variables.length;
        boolean isTooManyChildren = false;
        if (variables.length > 100 && remainingElements < 0) {
            to = 100;
            isTooManyChildren = true;
        }
        RubyDebuggerSupportUtils.addRubyVariablesToNode(this.myProject, this.myPosition, node, Arrays.copyOfRange(variables, from, to), this.myFrame, this, this.alreadySorted());
        if (isTooManyChildren) {
            node.tooManyChildren(variables.length - 100, () -> this.computeChildren(variables.length - 100, node));
        }
    }

    protected boolean alreadySorted() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyCompositeValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doComputeChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

