/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.values;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyValueModifier;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public class PinnedItemsRepresentation
extends XValuePresentation {
    private static final Logger LOG = Logger.getInstance(PinnedItemsRepresentation.class);
    @Nullable
    private final String myType;
    @NotNull
    private final XValuePlace myPlace;
    @NotNull
    private final List<RubyDebugValue> myChildValues;

    public PinnedItemsRepresentation(@NotNull RubyValue value, @NotNull List<String> instanceVariableNames, @NotNull RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue, @Nullable String typeName, @Nullable XSourcePosition position, @NotNull XValuePlace place, Project project, @NotNull Map<String, RubyVariable> namesToVariables) {
        if (value == null) {
            PinnedItemsRepresentation.$$$reportNull$$$0(0);
        }
        if (instanceVariableNames == null) {
            PinnedItemsRepresentation.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            PinnedItemsRepresentation.$$$reportNull$$$0(2);
        }
        if (place == null) {
            PinnedItemsRepresentation.$$$reportNull$$$0(3);
        }
        if (namesToVariables == null) {
            PinnedItemsRepresentation.$$$reportNull$$$0(4);
        }
        this.myChildValues = new ArrayList<RubyDebugValue>();
        this.myType = typeName;
        this.myPlace = place;
        for (String name : instanceVariableNames) {
            try {
                if (!instanceVariableNames.contains(name)) continue;
                RubyVariable variable = frame.getRubyFrame().inspectExpression(RubyValueModifier.wrapInObjectId(value.getOwner().getVariableInfo()) + RubyDebuggerSupportUtils.getObtainFieldCommand(name, namesToVariables.get(name)));
                this.myChildValues.add(RubyDebugValueFactory.create(project, position, frame, parentDebugValue, name, variable));
            }
            catch (RubyDebuggerException e) {
                LOG.error("Error while obtaining instance field: " + name + " for value of type:" + value.getOwner().getReferenceTypeName());
            }
        }
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        if (renderer == null) {
            PinnedItemsRepresentation.$$$reportNull$$$0(5);
        }
        assert (!this.myChildValues.isEmpty());
        renderer.renderComment("{");
        boolean isFirst = true;
        for (RubyDebugValue value : this.myChildValues) {
            if (!isFirst) {
                renderer.renderComment(", ");
            }
            renderer.renderValue(value.getName());
            renderer.renderValue(": ");
            value.getPresentation(this.myPlace).renderValue(renderer);
            isFirst = false;
        }
        renderer.renderComment("}");
    }

    @Nullable
    public String getType() {
        return this.myType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceVariableNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToVariables";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/PinnedItemsRepresentation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renderValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

