/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.settings;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;

class RubyDebuggerConfigurable
implements ConfigurableUi<RubyDebuggerSettings> {
    private JPanel myPanel;
    private JTextField myTimeoutTextField;
    private JCheckBox myVerboseOutput;
    private JBCheckBox myMultiprocess;
    private JBCheckBox myReadFramesOfNonSuspendedThreads;
    private JBCheckBox myEvaluationControl;
    private JTextField myTimeLimitTextField;
    private JBTextField myMemoryLimitTextField;
    private JLabel myTimeLimitLabel;
    private JLabel myMemoryLimitLabel;
    private JLabel myTimeLimitUnitsLabel;
    private JLabel myMemoryLimitUnitsLabel;
    private JCheckBox myKeyValueHashPresentation;
    private JBCheckBox myDisableSpring;

    RubyDebuggerConfigurable() {
        this.$$$setupUI$$$();
        this.myMemoryLimitTextField.getEmptyText().setText(RBundle.message((String)"ruby.debugger.debugger.unlimited.memory.limit"));
        this.myEvaluationControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RubyDebuggerConfigurable.this.enableLimitCheckboxes(RubyDebuggerConfigurable.this.myEvaluationControl.isSelected());
            }
        });
    }

    @NotNull
    public String getId() {
        return "ruby.debug.configurable";
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            RubyDebuggerConfigurable.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified(@NotNull RubyDebuggerSettings settings) {
        if (settings == null) {
            RubyDebuggerConfigurable.$$$reportNull$$$0(1);
        }
        RubyDebuggerSettings.RubyDebuggerSettingsState state = settings.getState();
        return this.myEvaluationControl.isSelected() != state.isEvaluationControl() || this.getTimeLimit() != state.getTimeLimit() || this.getMemoryLimit() != state.getMemoryLimit() || this.myVerboseOutput.isSelected() != state.isVerboseOutput() || this.myKeyValueHashPresentation.isSelected() != state.isKeyValueHashPresentation() || this.myMultiprocess.isSelected() != state.isMultiprocess() || this.myReadFramesOfNonSuspendedThreads.isSelected() != state.isReadNonSuspendedFrames() || this.getTimeout() != state.getTimeout() || this.myDisableSpring.isSelected() != SpringUtil.isSpringDebugPatchDenied();
    }

    private int getTimeout() {
        return Math.max(10, StringUtilRt.parseInt((String)this.myTimeoutTextField.getText().trim(), (int)10));
    }

    private int getTimeLimit() {
        return StringUtilRt.parseInt((String)this.myTimeLimitTextField.getText().trim(), (int)100);
    }

    private int getMemoryLimit() {
        return StringUtilRt.parseInt((String)this.myMemoryLimitTextField.getText().trim(), (int)0);
    }

    public void apply(@NotNull RubyDebuggerSettings settings) {
        if (settings == null) {
            RubyDebuggerConfigurable.$$$reportNull$$$0(2);
        }
        RubyDebuggerSettings.RubyDebuggerSettingsState state = settings.getState();
        state.setTimeout(this.getTimeout());
        state.setEvaluationControl(this.myEvaluationControl.isSelected());
        state.setTimeLimit(this.getTimeLimit());
        state.setMemoryLimit(this.getMemoryLimit());
        state.setVerboseOutput(this.myVerboseOutput.isSelected());
        state.setKeyValueHashPresentation(this.myKeyValueHashPresentation.isSelected());
        state.setMultiprocess(this.myMultiprocess.isSelected());
        state.setReadNonSuspendedFrames(this.myReadFramesOfNonSuspendedThreads.isSelected());
        SpringUtil.setSpringDebugPatchDenied(this.myDisableSpring.isSelected());
    }

    public void reset(@NotNull RubyDebuggerSettings settings) {
        if (settings == null) {
            RubyDebuggerConfigurable.$$$reportNull$$$0(3);
        }
        RubyDebuggerSettings.RubyDebuggerSettingsState state = settings.getState();
        this.myTimeoutTextField.setText(String.valueOf(state.getTimeout()));
        this.myTimeLimitTextField.setText(String.valueOf(state.getTimeLimit()));
        if (state.getMemoryLimit() > 0) {
            this.myMemoryLimitTextField.setText(String.valueOf(state.getMemoryLimit()));
        }
        this.myEvaluationControl.setSelected(state.isEvaluationControl());
        this.enableLimitCheckboxes(this.myEvaluationControl.isSelected());
        this.myKeyValueHashPresentation.setSelected(state.isKeyValueHashPresentation());
        this.myVerboseOutput.setSelected(state.isVerboseOutput());
        this.myMultiprocess.setSelected(state.isMultiprocess());
        this.myReadFramesOfNonSuspendedThreads.setSelected(state.isReadNonSuspendedFrames());
        this.myDisableSpring.setSelected(SpringUtil.isSpringDebugPatchDenied());
    }

    private void enableLimitCheckboxes(boolean enable) {
        this.myMemoryLimitTextField.setEnabled(enable);
        this.myTimeLimitTextField.setEnabled(enable);
        this.myTimeLimitLabel.setEnabled(enable);
        this.myMemoryLimitLabel.setEnabled(enable);
        this.myTimeLimitUnitsLabel.setEnabled(enable);
        this.myMemoryLimitUnitsLabel.setEnabled(enable);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JBTextField jBTextField;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JTextField jTextField;
        JLabel jLabel4;
        JBCheckBox jBCheckBox2;
        JTextField jTextField2;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myVerboseOutput = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.verbose.output"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myMultiprocess = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.attach.to.subprocesses.automatically.text"));
        jPanel.add((Component)jBCheckBox4, new GridConstraints(5, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myReadFramesOfNonSuspendedThreads = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.read.frames.of.non.suspended.threads.text"));
        jPanel.add((Component)jBCheckBox3, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.timeout"));
        jPanel.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myTimeoutTextField = jTextField2 = new JTextField();
        jTextField2.setHorizontalAlignment(10);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 0, null, new Dimension(150, -1), null));
        this.myEvaluationControl = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.enable.to_s.control"));
        jPanel.add((Component)jBCheckBox2, new GridConstraints(3, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myTimeLimitLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.execution.time.limit"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTimeLimitTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 2, 1, 1, 8, 0, 1, 0, null, new Dimension(150, -1), null));
        this.myMemoryLimitLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.execution.memory.limit"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JToolBar.Separator separator = new JToolBar.Separator();
        jPanel2.add((Component)separator, new GridConstraints(0, 0, 2, 1, 0, 1, 0, 0, null, null, null));
        this.myTimeLimitUnitsLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.execution.time.limit.units"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 3, 1, 4, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myMemoryLimitUnitsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.execution.memory.limit.units"));
        jPanel2.add((Component)jLabel, new GridConstraints(1, 3, 1, 4, 8, 0, 3, 0, null, new Dimension(50, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMemoryLimitTextField = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(1, 2, 1, 1, 8, 0, 1, 0, null, new Dimension(150, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.timeout.units"));
        jPanel.add((Component)jLabel6, new GridConstraints(0, 2, 1, 1, 8, 0, 1, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myKeyValueHashPresentation = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.key.value.presentation"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myDisableSpring = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/RBundle", RubyDebuggerConfigurable.class).getString("ruby.debugger.disable.spring.for.debug"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(7, 0, 1, 4, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/settings/RubyDebuggerConfigurable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/settings/RubyDebuggerConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

