/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.renderers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyNodeTypeRendererData;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyTypeRenderer;

@State(name="RubyTypeRenderersSettings", storages={@Storage(value="ruby-debugger-type-renderers-settings.xml")})
public class RubyTypeRenderersSettings
implements PersistentStateComponent<Element> {
    private static final String LIST_TAG = "LIST";
    private static final String RENDERER_TAG = "RENDERER";
    private static final String NAME = "name";
    private static final String IS_ENABLED = "isEnabled";
    private static final String EXPRESSION = "mainExpression";
    private static final String TYPE = "type";
    @NotNull
    private final List<RubyNodeTypeRendererData> myRenderers = new CopyOnWriteArrayList<RubyNodeTypeRendererData>();

    @Nullable
    public Element getState() {
        Element listElement = new Element(LIST_TAG);
        for (RubyNodeTypeRendererData renderer : this.myRenderers) {
            RubyTypeRenderersSettings.addRendererToElement(renderer, listElement);
        }
        return listElement;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(0);
        }
        ArrayList<RubyNodeTypeRendererData> result = new ArrayList<RubyNodeTypeRendererData>();
        for (Element rendererElement : state.getChildren(RENDERER_TAG)) {
            result.add(RubyTypeRenderersSettings.loadRenderer(rendererElement));
        }
        this.setRenderers(result);
    }

    @NotNull
    public List<RubyNodeTypeRendererData> getRenderers() {
        List<RubyNodeTypeRendererData> list = this.myRenderers;
        if (list == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setRenderers(@NotNull Collection<RubyNodeTypeRendererData> newRenderers) {
        if (newRenderers == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(2);
        }
        this.myRenderers.clear();
        this.myRenderers.addAll(newRenderers);
    }

    @NotNull
    public List<RubyTypeRenderer> getEnabledRenderers() {
        HashSet<String> foundTypes = new HashSet<String>();
        ArrayList<RubyTypeRenderer> filteredRenderers = new ArrayList<RubyTypeRenderer>();
        for (RubyNodeTypeRendererData renderer : this.myRenderers) {
            if (!renderer.isEnabled() || foundTypes.contains(renderer.getType())) continue;
            filteredRenderers.add(renderer.convertToTypeRenderer());
            foundTypes.add(renderer.getType());
        }
        ArrayList<RubyTypeRenderer> arrayList = filteredRenderers;
        if (arrayList == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static RubyTypeRenderersSettings getInstance() {
        RubyTypeRenderersSettings rubyTypeRenderersSettings = (RubyTypeRenderersSettings)ApplicationManager.getApplication().getService(RubyTypeRenderersSettings.class);
        if (rubyTypeRenderersSettings == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(4);
        }
        return rubyTypeRenderersSettings;
    }

    private static void addRendererToElement(@NotNull RubyNodeTypeRendererData renderer, @NotNull Element parent) {
        if (renderer == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(6);
        }
        Element rendererElement = new Element(RENDERER_TAG);
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)NAME, (String)renderer.getName());
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)IS_ENABLED, (String)String.valueOf(renderer.isEnabled()));
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)TYPE, (String)renderer.getType());
        JDOMExternalizerUtil.writeField((Element)rendererElement, (String)EXPRESSION, (String)renderer.getMainExpression());
        parent.addContent(rendererElement);
    }

    @NotNull
    private static RubyNodeTypeRendererData loadRenderer(@NotNull Element element) {
        if (element == null) {
            RubyTypeRenderersSettings.$$$reportNull$$$0(7);
        }
        String name = Strings.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)NAME));
        boolean isEnabled = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)IS_ENABLED));
        String type = Strings.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)TYPE));
        String mainExpression = Strings.notNullize((String)JDOMExternalizerUtil.readField((Element)element, (String)EXPRESSION));
        return new RubyNodeTypeRendererData(name, isEnabled, type, mainExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRenderers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/renderers/RubyTypeRenderersSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledRenderers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRenderers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRendererToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadRenderer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

