/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.ContextVariablesCollector;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEvaluator;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerFeatureBean;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyStepVariant;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class RubyStackFrame
extends XStackFrame {
    private static final Logger LOG = Logger.getInstance(RubyStackFrame.class);
    private static final Object RUBY_STACK_FRAME_EQUALITY_OBJECT = new Object();
    private final Project myProject;
    private List<RubyStepVariant> mySmartStepIntoVariants;
    boolean myIsUnableToStepSuspensionStack;
    @Nullable
    private final XSourcePosition myXSourcePosition;
    @NotNull
    private final RubyFrame myRubyFrame;
    private final RubyDebuggerProxy myDebuggerProxy;
    @NotNull
    private final RubyDebugProcess myRubyDebugProcess;
    private final boolean myIsInProjectFrame;

    public Object getEqualityObject() {
        return RUBY_STACK_FRAME_EQUALITY_OBJECT;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            RubyStackFrame.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myDebuggerProxy.waitForDebuggerProxyReady();
                LinkedList<RubyVariable> variables = new LinkedList<RubyVariable>();
                if (this.myRubyFrame.getLocation() != null) {
                    String methodName;
                    if (this.myRubyFrame.getLocation().getType() == RubySuspensionLocation.Type.METHOD && (methodName = (String)ContainerUtil.getLastItem((List)this.myRubyFrame.getLocation().getLocationMethods())) != null && !methodName.equals("yield")) {
                        variables.add(this.myRubyFrame.getReceiver());
                    }
                    if (this.getFeatures().isObtainingReturnValuesSupported() && this.myRubyFrame.getLocation().getType() == RubySuspensionLocation.Type.LEAVE) {
                        variables.add(this.myRubyFrame.getReturnValue());
                    }
                }
                variables.addAll(Arrays.asList(this.myRubyFrame.getVariables()));
                RubyDebuggerSupportUtils.addRubyVariablesToNode(this.myProject, this.getSourcePosition(), node, variables.toArray(RubyVariable.EMPTY_ARRAY), this, null, false, false);
                ContextVariablesCollector contextVariableCollector = new ContextVariablesCollector(this.myProject, node, this, this.getSourcePosition());
                contextVariableCollector.addContextVariableNodes();
                OrderedSet<String> alreadyProcessedContextVariables = contextVariableCollector.getProcessedContextVariables();
                XValueGroup globals = RubyDebugValueFactory.createGlobalVariables(this.myProject, this.getSourcePosition(), this.myDebuggerProxy, alreadyProcessedContextVariables, this);
                node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)globals), true);
            }
            catch (RubyDebuggerException e) {
                LOG.info((Throwable)e);
            }
        });
    }

    public RubyStackFrame(Project project, @NotNull RubyDebugProcess process, RubyDebuggerProxy debuggerProxy, @NotNull RubyFrame frame) {
        if (process == null) {
            RubyStackFrame.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            RubyStackFrame.$$$reportNull$$$0(2);
        }
        this.myIsUnableToStepSuspensionStack = false;
        this.myProject = project;
        this.myRubyFrame = frame;
        this.myDebuggerProxy = debuggerProxy;
        this.myRubyDebugProcess = process;
        XSourcePosition sourcePosition = this.getRubyDebugProcess().getPositionConverter().createLocalPosition(new RubyPosition(this.myRubyFrame));
        if (sourcePosition == null || sourcePosition.getLine() < 0) {
            this.myXSourcePosition = null;
            this.myIsInProjectFrame = false;
            return;
        }
        this.myXSourcePosition = sourcePosition;
        this.myIsInProjectFrame = (Boolean)ReadAction.compute(() -> ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(sourcePosition.getFile()));
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    @NotNull
    private RubyDebugProcess getRubyDebugProcess() {
        RubyDebugProcess rubyDebugProcess = this.myRubyDebugProcess;
        if (rubyDebugProcess == null) {
            RubyStackFrame.$$$reportNull$$$0(3);
        }
        return rubyDebugProcess;
    }

    @NotNull
    public RubyDebuggerFeatureBean getFeatures() {
        RubyDebuggerFeatureBean rubyDebuggerFeatureBean = this.getRubyDebugProcess().myFeatures;
        if (rubyDebuggerFeatureBean == null) {
            RubyStackFrame.$$$reportNull$$$0(4);
        }
        return rubyDebuggerFeatureBean;
    }

    public boolean isInProjectFrame() {
        return this.myIsInProjectFrame;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        XSourcePosition position;
        if (component == null) {
            RubyStackFrame.$$$reportNull$$$0(5);
        }
        if ((position = this.getSourcePosition()) == null) {
            component.append(RBundle.message((String)"ruby.debugger.stackframe.not.available"), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            return;
        }
        int line = position.getLine();
        String fileName = position.getFile().getName();
        String frameLabel = this.myRubyFrame.getLabel();
        boolean isFrameInProject = this.isInProjectFrame();
        if (frameLabel != null) {
            RubyStackFrame.addFrameLabelAndFileLineToComponent(component, frameLabel, fileName, isFrameInProject, line);
        } else {
            RubyStackFrame.addFileLineToComponent(component, fileName, RubyStackFrame.processAttributes(SimpleTextAttributes.REGULAR_ATTRIBUTES, isFrameInProject), line);
        }
        component.setIcon(AllIcons.Debugger.Frame);
    }

    public RubyThread getRubyThread() {
        return this.myRubyFrame.getThread();
    }

    public XDebuggerEvaluator getEvaluator() {
        return this.getSourcePosition() != null ? new RubyDebuggerEvaluator(this.myProject, this, this.myDebuggerProxy) : null;
    }

    @NotNull
    public RubyFrame getRubyFrame() {
        RubyFrame rubyFrame = this.myRubyFrame;
        if (rubyFrame == null) {
            RubyStackFrame.$$$reportNull$$$0(6);
        }
        return rubyFrame;
    }

    public List<RubyStepVariant> getSmartStepIntoVariants() {
        if (this.mySmartStepIntoVariants == null) {
            this.mySmartStepIntoVariants = this.myDebuggerProxy.getSmartStepIntoVariants();
        }
        return this.mySmartStepIntoVariants;
    }

    public String getName() {
        return this.myRubyFrame.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RubyStackFrame)) {
            return false;
        }
        RubyStackFrame frame = (RubyStackFrame)((Object)o);
        if (this.myIsUnableToStepSuspensionStack != frame.myIsUnableToStepSuspensionStack) {
            return false;
        }
        if (this.myIsInProjectFrame != frame.myIsInProjectFrame) {
            return false;
        }
        if (!Objects.equals(this.myProject, frame.myProject)) {
            return false;
        }
        if (!Objects.equals(this.myXSourcePosition, frame.myXSourcePosition)) {
            return false;
        }
        if (!this.myRubyFrame.equals((Object)frame.myRubyFrame)) {
            return false;
        }
        if (!Objects.equals(this.myDebuggerProxy, frame.myDebuggerProxy)) {
            return false;
        }
        return ((Object)((Object)this.myRubyDebugProcess)).equals((Object)frame.myRubyDebugProcess);
    }

    public int hashCode() {
        int result = this.myProject != null ? this.myProject.hashCode() : 0;
        result = 31 * result + (this.myIsUnableToStepSuspensionStack ? 1 : 0);
        result = 31 * result + (this.myXSourcePosition != null ? this.myXSourcePosition.hashCode() : 0);
        result = 31 * result + this.myRubyFrame.hashCode();
        result = 31 * result + (this.myDebuggerProxy != null ? this.myDebuggerProxy.hashCode() : 0);
        result = 31 * result + ((Object)((Object)this.myRubyDebugProcess)).hashCode();
        result = 31 * result + (this.myIsInProjectFrame ? 1 : 0);
        return result;
    }

    public String toString() {
        return "RubyStackFrame{mySmartStepIntoVariants=" + String.valueOf(this.mySmartStepIntoVariants) + ", myIsUnableToStepSuspensionStack=" + this.myIsUnableToStepSuspensionStack + ", myXSourcePosition=" + String.valueOf(this.myXSourcePosition) + ", myFrame=" + String.valueOf(this.myRubyFrame) + ", myDebuggerProxy=" + String.valueOf(this.myDebuggerProxy) + "}";
    }

    private static void addFrameLabelAndFileLineToComponent(@NotNull ColoredTextContainer component, @NlsContexts.Label @NotNull String frameLabel, @NlsContexts.Label @NotNull String fileName, boolean isFrameInProject, int lineNumber) {
        if (component == null) {
            RubyStackFrame.$$$reportNull$$$0(7);
        }
        if (frameLabel == null) {
            RubyStackFrame.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            RubyStackFrame.$$$reportNull$$$0(9);
        }
        component.append(frameLabel, RubyStackFrame.processAttributes(SimpleTextAttributes.REGULAR_ATTRIBUTES, isFrameInProject));
        SimpleTextAttributes processedItalicAttributes = RubyStackFrame.processAttributes(SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, isFrameInProject);
        component.append(" [", processedItalicAttributes);
        RubyStackFrame.addFileLineToComponent(component, fileName, processedItalicAttributes, lineNumber);
        component.append("]", processedItalicAttributes);
    }

    private static void addFileLineToComponent(@NotNull ColoredTextContainer component, @NlsContexts.Label @NotNull String fileName, @NotNull SimpleTextAttributes textAttributes, int lineNumber) {
        if (component == null) {
            RubyStackFrame.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            RubyStackFrame.$$$reportNull$$$0(11);
        }
        if (textAttributes == null) {
            RubyStackFrame.$$$reportNull$$$0(12);
        }
        component.append(fileName, textAttributes);
        component.append(":", textAttributes);
        component.append(String.valueOf(lineNumber + 1), textAttributes);
    }

    @NotNull
    private static SimpleTextAttributes processAttributes(@NotNull SimpleTextAttributes originalAttributes, boolean isFrameInProject) {
        boolean isItalicStyle;
        if (originalAttributes == null) {
            RubyStackFrame.$$$reportNull$$$0(13);
        }
        if (isFrameInProject) {
            SimpleTextAttributes simpleTextAttributes = originalAttributes;
            if (simpleTextAttributes == null) {
                RubyStackFrame.$$$reportNull$$$0(14);
            }
            return simpleTextAttributes;
        }
        boolean bl = isItalicStyle = (originalAttributes.getStyle() & 2) != 0;
        if (isItalicStyle) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                RubyStackFrame.$$$reportNull$$$0(15);
            }
            return simpleTextAttributes;
        }
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
        if (simpleTextAttributes == null) {
            RubyStackFrame.$$$reportNull$$$0(16);
        }
        return simpleTextAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyStackFrame";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameLabel";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyStackFrame";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyDebugProcess";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRubyFrame";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "customizePresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFrameLabelAndFileLineToComponent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFileLineToComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

