/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyLocationMapper;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySmartStepIntoVariant;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySourcePosition;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.rubyforge.debugcommons.model.RubyStepVariant;

public class RubySmartStepIntoHandler
extends XSmartStepIntoHandler<RubySmartStepIntoVariant> {
    @NotNull
    private final RubyDebugProcess myProcess;
    @NotNull
    private final XDebugSession mySession;

    public RubySmartStepIntoHandler(@NotNull RubyDebugProcess process) {
        if (process == null) {
            RubySmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        this.myProcess = process;
        this.mySession = this.myProcess.getSession();
    }

    @NotNull
    public List<RubySmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        List<RubyStepVariant> variants;
        XStackFrame frame;
        if (position == null) {
            RubySmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        if (!((frame = this.mySession.getCurrentStackFrame()) instanceof RubyStackFrame)) {
            List<RubySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                RubySmartStepIntoHandler.$$$reportNull$$$0(2);
            }
            return list;
        }
        RubyStackFrame rubyFrame = (RubyStackFrame)frame;
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> rubyFrame.getSmartStepIntoVariants());
        try {
            variants = (List<RubyStepVariant>)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            List<RubySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                RubySmartStepIntoHandler.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (variants == null) {
            List<RubySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                RubySmartStepIntoHandler.$$$reportNull$$$0(4);
            }
            return list;
        }
        variants = ContainerUtil.filter((Collection)variants, v -> !"to_s".equals(v.getText()));
        if (rubyFrame.myIsUnableToStepSuspensionStack) {
            variants = variants.subList(1, variants.size());
        }
        if (!(position instanceof RubySourcePosition)) {
            List<RubySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                RubySmartStepIntoHandler.$$$reportNull$$$0(5);
            }
            return list;
        }
        RubySourcePosition rubySourcePosition = (RubySourcePosition)position;
        List<RubySmartStepIntoVariant> answer = new RubyLocationMapper(position.getLine(), position.getFile(), this.mySession.getProject()).getStepVariantsElements(rubySourcePosition.getLocation(), variants);
        if (answer == null) {
            List<RubySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                RubySmartStepIntoHandler.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<RubySmartStepIntoVariant> list = answer;
        if (list == null) {
            RubySmartStepIntoHandler.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Promise<List<RubySmartStepIntoVariant>> computeStepIntoVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            RubySmartStepIntoHandler.$$$reportNull$$$0(8);
        }
        if (RubyDebuggerSettings.getInstance().getState().isPerformSmartStepInto()) {
            Promise promise = this.computeSmartStepVariantsAsync(position);
            if (promise == null) {
                RubySmartStepIntoHandler.$$$reportNull$$$0(9);
            }
            return promise;
        }
        Promise promise = Promises.rejectedPromise();
        if (promise == null) {
            RubySmartStepIntoHandler.$$$reportNull$$$0(10);
        }
        return promise;
    }

    public void startStepInto(@NotNull RubySmartStepIntoVariant smartStepIntoVariant) {
        if (smartStepIntoVariant == null) {
            RubySmartStepIntoHandler.$$$reportNull$$$0(11);
        }
        this.mySession.sessionResumed();
        this.myProcess.startSmartStepInto(smartStepIntoVariant.getId());
    }

    @NotNull
    public String getPopupTitle() {
        String string = RBundle.message((String)"ruby.debugger.smart.step.into.title");
        if (string == null) {
            RubySmartStepIntoHandler.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubySmartStepIntoHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartStepIntoVariant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubySmartStepIntoHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariants";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStepIntoVariants";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeStepIntoVariants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 9, 10, 12 -> new IllegalStateException(string);
        };
    }
}

