/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import org.jetbrains.annotations.NotNull;

public class RubyDebuggerFeatureBean {
    @NotNull
    private static final String BLOCK_BREAKPOINTS_SUPPORTED = "block breakpoints supported";
    @NotNull
    private static final String SMART_STEPPING_SUPPORTED = "smart steps supported";
    @NotNull
    private static final String OBTAINING_RETURN_VALUES_SUPPORTED = "obtaining return values supported";
    @NotNull
    private static final String PARTIAL_OBTAINING_INSTANCE_SUPPORTED = "partial obtaining of instance variables supported";
    private boolean myBlockBreakpointSupported = false;
    private boolean mySmartSteppingSupported = false;
    private boolean myPartialInstanceVariablesSupported = false;
    private boolean myObtainingReturnValuesSupported = false;

    void handleGreetingMessage(@NotNull String greetingMessage) {
        if (greetingMessage == null) {
            RubyDebuggerFeatureBean.$$$reportNull$$$0(0);
        }
        if (greetingMessage.contains(BLOCK_BREAKPOINTS_SUPPORTED)) {
            this.myBlockBreakpointSupported = true;
        }
        if (greetingMessage.contains(SMART_STEPPING_SUPPORTED)) {
            this.mySmartSteppingSupported = true;
        }
        if (greetingMessage.contains(OBTAINING_RETURN_VALUES_SUPPORTED)) {
            this.myObtainingReturnValuesSupported = true;
        }
        if (greetingMessage.contains(PARTIAL_OBTAINING_INSTANCE_SUPPORTED)) {
            this.myPartialInstanceVariablesSupported = true;
        }
    }

    public boolean isBlockBreakpointSupported() {
        return this.myBlockBreakpointSupported;
    }

    public boolean isSmartSteppingSupported() {
        return this.mySmartSteppingSupported;
    }

    public boolean isPartialInstanceVariablesSupported() {
        return this.myPartialInstanceVariablesSupported;
    }

    public boolean isObtainingReturnValuesSupported() {
        return this.myObtainingReturnValuesSupported;
    }

    public String toString() {
        return "RubyDebuggerFeatureBean{myBlockBreakpointSupported=" + this.myBlockBreakpointSupported + ", mySmartSteppingSupported=" + this.mySmartSteppingSupported + ", myPartialInstanceVariablesSupported=" + this.myPartialInstanceVariablesSupported + ", myObtainingReturnValuesSupported=" + this.myObtainingReturnValuesSupported + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "greetingMessage", "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebuggerFeatureBean", "handleGreetingMessage"));
    }
}

