/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlinx.serialization.json.JsonArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.config.IrbRunCommandLineState;
import org.jetbrains.plugins.ruby.console.debugger.RubyDebugConsoleBuilder;
import org.jetbrains.plugins.ruby.console.debugger.RubyDuplexDebugConsoleBuilder;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyProcessDispatcher;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.MyRubyDebugEventListener;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEditorsProvider;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerFeatureBean;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyExceptionBreakpointHandler;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyLineBreakpointHandler;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySmartStepIntoHandler;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.renderers.RubyTypeRendererJsonConverterKt;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.testing.testunit.runConfigurations.RAbstractTestsCommandLineState;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;

public class RubyDebugProcess
extends XDebugProcess {
    private static final Logger LOG = Logger.getInstance(RubyDebugProcess.class);
    @NotNull
    private final Collection<? extends VirtualFile> myDirsToInclude;
    @NotNull
    private final Collection<? extends VirtualFile> myDirsToExclude;
    private final boolean myEnableFileFiltering;
    @NotNull
    private final ExecutionEnvironment myEnvironment;
    private RubyStackFrame myStackFrameBeforeResume;
    final XBreakpointHandler<?>[] myBreakPointHandlers;
    final List<RubyDebuggerProxy> myRubyDebuggerProxies;
    final RubyDebugEventListener myRubyDebugEventListener;
    final RunProfileState myState;
    final RubyLineBreakpointHandler myLineBreakpointHandler;
    final RubyExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    final RubySmartStepIntoHandler myRubySmartStepIntoHandler;
    private final ProcessHandler myOSProcessHandler;
    private final int myRubyDebugTimeout;
    private final SourcePositionConverter myPositionConverter;
    @Nullable
    private final RubyProcessDispatcher myAcceptor;
    @Nullable
    private final XDebugTabLayouter myCustomLayouter;
    private volatile boolean isInitialized;
    @NotNull
    final RubyDebuggerFeatureBean myFeatures;
    private final AtomicBoolean myStopped;

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return new RubyDebuggerEditorsProvider();
    }

    public RubyDebugProcess(final @NotNull XDebugSession session, @NotNull RunProfileState state, @Nullable ProcessHandler processHandler, @NotNull RubyDebuggerProxy rubyDebuggerProxy, int rubyDebugTimeout, SourcePositionConverter positionConverter, @NotNull ExecutionEnvironment executionEnvironment, @Nullable RubyProcessDispatcher acceptor, boolean pauseActionSupported, boolean debugConsoleSupported, boolean enableFileFiltering, @NotNull Collection<? extends VirtualFile> dirsToInclude, @NotNull Collection<? extends VirtualFile> dirsToExclude) {
        if (session == null) {
            RubyDebugProcess.$$$reportNull$$$0(0);
        }
        if (state == null) {
            RubyDebugProcess.$$$reportNull$$$0(1);
        }
        if (rubyDebuggerProxy == null) {
            RubyDebugProcess.$$$reportNull$$$0(2);
        }
        if (executionEnvironment == null) {
            RubyDebugProcess.$$$reportNull$$$0(3);
        }
        if (dirsToInclude == null) {
            RubyDebugProcess.$$$reportNull$$$0(4);
        }
        if (dirsToExclude == null) {
            RubyDebugProcess.$$$reportNull$$$0(5);
        }
        super(session);
        this.myRubyDebuggerProxies = ContainerUtil.createConcurrentList();
        this.isInitialized = false;
        this.myFeatures = new RubyDebuggerFeatureBean();
        this.myStopped = new AtomicBoolean(false);
        this.myEnvironment = executionEnvironment;
        session.setPauseActionSupported(pauseActionSupported);
        this.myState = state;
        this.myOSProcessHandler = processHandler;
        this.myEnableFileFiltering = enableFileFiltering;
        this.myDirsToInclude = dirsToInclude;
        this.myDirsToExclude = dirsToExclude;
        this.myAcceptor = acceptor;
        if (this.myAcceptor != null) {
            this.myAcceptor.setProcess(this);
            this.myAcceptor.setProcessHandler(this.myOSProcessHandler);
        }
        if (this.myOSProcessHandler != null) {
            this.myOSProcessHandler.addProcessListener((ProcessListener)new DebugSessionController());
        }
        this.myRubyDebugTimeout = rubyDebugTimeout;
        this.myPositionConverter = positionConverter;
        this.myRubyDebugEventListener = new MyRubyDebugEventListener(session.getProject(), this);
        this.myLineBreakpointHandler = new RubyLineBreakpointHandler(this);
        this.myExceptionBreakpointHandler = new RubyExceptionBreakpointHandler(this);
        this.myBreakPointHandlers = new XBreakpointHandler[]{this.myLineBreakpointHandler, this.myExceptionBreakpointHandler};
        this.myRubySmartStepIntoHandler = new RubySmartStepIntoHandler(this);
        this.registerDebuggerProxy(rubyDebuggerProxy);
        session.addSessionListener(new XDebugSessionListener(){

            public void beforeSessionResume() {
                RubyDebugProcess.this.myStackFrameBeforeResume = session.getCurrentStackFrame() instanceof RubyStackFrame ? (RubyStackFrame)session.getCurrentStackFrame() : null;
            }
        });
        if (debugConsoleSupported && state instanceof IrbRunCommandLineState) {
            this.myCustomLayouter = new MyDebugTabLayouterWithDebuggerConsole(((IrbRunCommandLineState)state).createConsoleMessageFilters());
            return;
        }
        if (debugConsoleSupported && state instanceof RAbstractTestsCommandLineState) {
            this.myCustomLayouter = new MyDebugTabLayouterWithDebuggerConsole(((RAbstractTestsCommandLineState)state).createConsoleMessageFilters());
            return;
        }
        if (debugConsoleSupported && state instanceof CommandLineState) {
            RubyDuplexDebugConsoleBuilder debugConsoleBuilder = new RubyDuplexDebugConsoleBuilder(this.getSession().getProject(), this);
            ((CommandLineState)state).setConsoleBuilder((TextConsoleBuilder)debugConsoleBuilder);
        }
        this.myCustomLayouter = null;
    }

    public void registerDebuggerProxy(RubyDebuggerProxy rubyDebuggerProxy) {
        this.myRubyDebuggerProxies.add(rubyDebuggerProxy);
        rubyDebuggerProxy.addRubyDebugEventListener(this.myRubyDebugEventListener);
    }

    public void sessionInitialized() {
        super.sessionInitialized();
        if (this.myOSProcessHandler == null) {
            this.connectDebugger();
        }
    }

    public boolean checkCanPerformCommands() {
        return this.isInitialized;
    }

    private void connectDebugger() {
        ProgressManager.getInstance().run((Task)new Task.Modal(null, RBundle.message((String)"ruby.debugger.connecting"), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator.setText(RBundle.message((String)"ruby.debugger.cannot.connect.timeout", (Object[])new Object[]{RubyDebugProcess.this.myRubyDebugTimeout}));
                indicator.setIndeterminate(false);
                AtomicBoolean timeout = new AtomicBoolean(false);
                AtomicBoolean attached = new AtomicBoolean(false);
                Thread attachThread = RubyDebugProcess.this.startAttachingThread(indicator, timeout, attached);
                long startTime = System.currentTimeMillis();
                long fullTime = (long)RubyDebugProcess.this.myRubyDebugTimeout * 1000L;
                while (!(indicator.isCanceled() || timeout.get() || attached.get())) {
                    long timePassed = System.currentTimeMillis() - startTime;
                    indicator.setFraction(Math.min(1.0, 1.0 * (double)timePassed / (double)fullTime));
                    timeout.set(timePassed > fullTime);
                    TimeoutUtil.sleep((long)50L);
                }
                if (!attached.get() && (indicator.isCanceled() || timeout.get())) {
                    LOG.warn("Unable to connect debugger in specified timeout");
                    attachThread.interrupt();
                    RubyDebugProcess.this.getProcessHandler().destroyProcess();
                    indicator.checkCanceled();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess$2", "run"));
            }
        });
        this.isInitialized = true;
    }

    @NotNull
    private Thread startAttachingThread(@NotNull ProgressIndicator indicator, @NotNull AtomicBoolean timeout, @NotNull AtomicBoolean attached) {
        if (indicator == null) {
            RubyDebugProcess.$$$reportNull$$$0(6);
        }
        if (timeout == null) {
            RubyDebugProcess.$$$reportNull$$$0(7);
        }
        if (attached == null) {
            RubyDebugProcess.$$$reportNull$$$0(8);
        }
        Thread thread = new Thread(() -> {
            block2: {
                try {
                    LOG.debug("Connecting to debugger");
                    this.attachToProxy(this.myRubyDebuggerProxies.get(0));
                    attached.set(true);
                    LOG.debug("Connected successfully");
                }
                catch (RubyDebuggerException e) {
                    LOG.info("Couldn't connect to debugger: ", (Throwable)e);
                    this.getProcessHandler().destroyProcess();
                    if (indicator.isCanceled()) break block2;
                    ApplicationManager.getApplication().invokeLater(() -> {
                        Object message = e.getMessage();
                        if (timeout.get()) {
                            String settingsPath = "Settings | Debugger | Ruby | Debug connection timeout";
                            message = (String)message + "\n" + RBundle.message((String)"dialog.message.please.try.increasing.timeout.in", (Object[])new Object[]{settingsPath});
                        }
                        Messages.showErrorDialog((String)message, (String)RBundle.message((String)"ruby.debugger.cannot.connect"));
                    });
                }
            }
        }, "ruby attach process");
        thread.start();
        Thread thread2 = thread;
        if (thread2 == null) {
            RubyDebugProcess.$$$reportNull$$$0(9);
        }
        return thread2;
    }

    public void attachToProxy(RubyDebuggerProxy proxy) throws RubyDebuggerException {
        ArrayList<Object> breakPoints = new ArrayList<Object>();
        breakPoints.addAll(this.myLineBreakpointHandler.mySource2BreakpointMap.values());
        breakPoints.addAll(this.myExceptionBreakpointHandler.myName2BreakpointMap.values());
        Function getRemotePathFunction = file -> this.getPositionConverter().getRemotePath((VirtualFile)file);
        JsonArray typeRenderers = RubyTypeRendererJsonConverterKt.getEnabledTypeRenderers();
        proxy.attach(this.myEnableFileFiltering, breakPoints.toArray(new IRubyBreakpoint[0]), Collections2.transform(this.myDirsToInclude, (Function)getRemotePathFunction), Collections2.transform(this.myDirsToExclude, (Function)getRemotePathFunction), typeRenderers, this.myFeatures.isBlockBreakpointSupported());
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.myOSProcessHandler;
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        if (this.myCustomLayouter == null) {
            XDebugTabLayouter xDebugTabLayouter = super.createTabLayouter();
            if (xDebugTabLayouter == null) {
                RubyDebugProcess.$$$reportNull$$$0(10);
            }
            return xDebugTabLayouter;
        }
        XDebugTabLayouter xDebugTabLayouter = this.myCustomLayouter;
        if (xDebugTabLayouter == null) {
            RubyDebugProcess.$$$reportNull$$$0(11);
        }
        return xDebugTabLayouter;
    }

    public boolean isLibraryFrameFilterSupported() {
        return true;
    }

    public void startStepInto(@Nullable XSuspendContext context) {
        LOG.debug("Stepping into ", new Object[]{context, " at ", Thread.currentThread().getName()});
        RubyThread rubyThread = this.getThread();
        if (rubyThread == null) {
            LOG.warn("Can not step into (thread is null)");
            return;
        }
        RubyFrame[] frames = rubyThread.getFrames();
        RubyDebuggerProxy proxy = rubyThread.getProxy();
        if (proxy.waitForDebuggerProxyReady()) {
            proxy.sendStepIntoEnd(frames[0], false);
        } else {
            LOG.warn("Couldn't step into during timeout " + String.valueOf(proxy));
        }
    }

    @Nullable
    private RubyThread getThread() {
        return this.myStackFrameBeforeResume != null ? this.myStackFrameBeforeResume.getRubyThread() : null;
    }

    public void startStepOver(@Nullable XSuspendContext context) {
        LOG.debug("Stepping over ", new Object[]{context, " at ", Thread.currentThread().getName()});
        RubyThread thread = this.getThread();
        if (thread == null) {
            LOG.warn("Can not start step over because thread is null");
            return;
        }
        RubyFrame[] frames = thread.getFrames();
        thread.getProxy().sendStepOver(frames[0], false);
    }

    public void startStepOut(@Nullable XSuspendContext context) {
        LOG.debug("Stepping out ", new Object[]{context, " at ", Thread.currentThread().getName()});
        RubyThread thread = this.getThread();
        if (thread == null) {
            LOG.warn("Can not step out (thread is null)");
            return;
        }
        thread.getProxy().sendStepReturnEnd(thread.getFrames()[0]);
    }

    public void startSmartStepInto(int id) {
        LOG.debug("Starting smart step into ", new Object[]{id, " at ", Thread.currentThread().getName()});
        try {
            RubyThread thread = this.getThread();
            if (thread == null) {
                LOG.warn("Can not smart step into (thread is null)");
                return;
            }
            thread.getProxy().sendSmartStepInto(thread.getFrames()[0], id);
        }
        catch (RubyDebuggerException e) {
            LOG.info((Throwable)e);
        }
    }

    @Nullable
    public RubySmartStepIntoHandler getSmartStepIntoHandler() {
        return this.myFeatures.isSmartSteppingSupported() ? this.myRubySmartStepIntoHandler : null;
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context) {
        if (position == null) {
            RubyDebugProcess.$$$reportNull$$$0(12);
        }
        LOG.debug("Running to position ", new Object[]{position, " on ", context, " at ", Thread.currentThread().getName()});
        RubyThread thread = this.getThread();
        if (thread == null) {
            LOG.warn("Can not run to position (thread is null)");
            return;
        }
        if (thread.getProxy().waitForDebuggerProxyReady()) {
            RubyPosition rubyPosition = this.getPositionConverter().createRemotePosition(position);
            try {
                String path = rubyPosition.getPath();
                int line = rubyPosition.getLine();
                thread.runTo(path, line, this.myFeatures.isBlockBreakpointSupported());
            }
            catch (RubyDebuggerException e) {
                LOG.info((Throwable)e);
            }
        } else {
            LOG.warn("Couldn't run to position during timeout");
        }
    }

    public void stop() {
        String threadName = Thread.currentThread().getName();
        if (this.myStopped.getAndSet(true)) {
            LOG.debug("Debug process is already stopped on ", new Object[]{threadName});
            return;
        }
        LOG.debug("Stoppping debugger process on ", new Object[]{threadName});
        for (RubyDebuggerProxy proxy : this.myRubyDebuggerProxies) {
            LOG.debug("Processing ", new Object[]{proxy});
            proxy.removeRubyDebugEventListener(this.myRubyDebugEventListener);
            proxy.finish(true);
        }
        this.myRubyDebuggerProxies.clear();
        if (this.myAcceptor != null) {
            this.myAcceptor.stop();
        }
    }

    public void resume(@Nullable XSuspendContext context) {
        LOG.debug("Resuming debugging session on ", new Object[]{context, " at ", Thread.currentThread().getName()});
        for (RubyDebuggerProxy proxy : this.myRubyDebuggerProxies) {
            RubyThread suspended = RubyDebugProcess.getSuspended(proxy);
            if (suspended == null) {
                LOG.debug("No suspended threads for proxy: ", new Object[]{proxy});
                continue;
            }
            LOG.debug("Resuming thread: ", new Object[]{suspended, " in proxy ", proxy});
            proxy.resume(suspended);
        }
    }

    @Nullable
    private static RubyThread getSuspended(RubyDebuggerProxy proxy) {
        for (RubyThread thread : proxy.getDebugTarget().getThreads()) {
            if (!thread.isSuspended()) continue;
            return thread;
        }
        return null;
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        if (this.myBreakPointHandlers == null) {
            RubyDebugProcess.$$$reportNull$$$0(13);
        }
        return this.myBreakPointHandlers;
    }

    public SourcePositionConverter getPositionConverter() {
        return this.myPositionConverter;
    }

    public void removeBreakPoint(IRubyBreakpoint breakpoint) {
        if (!this.isInitialized) {
            LOG.warn("Attempt to remove breakpoint when session is not initialized yet");
        }
        for (RubyDebuggerProxy proxy : this.myRubyDebuggerProxies) {
            proxy.removeBreakpoint(breakpoint);
        }
    }

    public void addBreakPoint(IRubyBreakpoint breakpoint) {
        LOG.debug("Add breakpoint request: ", new Object[]{breakpoint, "; proxies: ", this.myRubyDebuggerProxies});
        if (this.isInitialized) {
            for (RubyDebuggerProxy proxy : this.myRubyDebuggerProxies) {
                LOG.debug("Adding breakpoint to the proxy ", new Object[]{proxy});
                proxy.addBreakpoint(breakpoint, this.myFeatures.isBlockBreakpointSupported());
            }
        } else {
            LOG.debug("Process is not initialized, skipping");
        }
    }

    public void setTypeRenderer() throws RubyDebuggerException {
        RubyDebuggerProxy proxy = this.myRubyDebuggerProxies.get(0);
        if (proxy.waitForDebuggerProxyReady()) {
            proxy.setTypeRenderers(RubyTypeRendererJsonConverterKt.getEnabledTypeRenderers());
        }
    }

    public void startPausing() {
        for (RubyDebuggerProxy proxy : this.myRubyDebuggerProxies) {
            if (proxy.waitForDebuggerProxyReady()) {
                proxy.threadPause(1);
                continue;
            }
            LOG.warn("Couldn't pause proxy: " + String.valueOf(proxy));
        }
    }

    public void terminateEventSeen(RubyDebuggerProxy origin) {
        LOG.debug("Got terminate event on ", new Object[]{origin, " at ", Thread.currentThread().getName()});
        origin.resume();
        this.myRubyDebuggerProxies.remove(origin);
        origin.removeRubyDebugEventListener(this.myRubyDebugEventListener);
        if (ContainerUtil.all(this.myRubyDebuggerProxies, it -> !it.isPaused())) {
            this.getSession().resume();
        }
    }

    @TestOnly
    public List<RubyDebuggerProxy> getRubyDebuggerProxies() {
        return Collections.unmodifiableList(this.myRubyDebuggerProxies);
    }

    @NotNull
    public ExecutionConsole createConsole() {
        DefaultExecutionResult executionResult;
        if (!(this.myState instanceof RubyAbstractCommandLineState) || this.myOSProcessHandler == null) {
            ExecutionConsole executionConsole = super.createConsole();
            if (executionConsole == null) {
                RubyDebugProcess.$$$reportNull$$$0(14);
            }
            return executionConsole;
        }
        try {
            executionResult = ((RubyAbstractCommandLineState)this.myState).execute(this.myEnvironment.getExecutor(), this.myEnvironment.getRunner(), this.myOSProcessHandler);
        }
        catch (ExecutionException e) {
            ExecutionConsole executionConsole = super.createConsole();
            if (executionConsole == null) {
                RubyDebugProcess.$$$reportNull$$$0(15);
            }
            return executionConsole;
        }
        XDebugSession session = this.getSession();
        if (session instanceof XDebugSessionImpl) {
            ((XDebugSessionImpl)session).addRestartActions(executionResult.getRestartActions());
        }
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        if (executionConsole == null) {
            RubyDebugProcess.$$$reportNull$$$0(16);
        }
        return executionConsole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyDebuggerProxy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToInclude";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToExclude";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeout";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attached";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "startAttachingThread";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTabLayouter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startAttachingThread";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    public class DebugSessionController
    extends ProcessAdapter {
        private boolean shouldUnmuteBreakpoints = false;

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                DebugSessionController.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                DebugSessionController.$$$reportNull$$$0(1);
            }
            String text = event.getText();
            if (!RubyDebugProcess.this.isInitialized && text != null && !ProcessOutputTypes.SYSTEM.equals((Object)outputType) && text.contains("Fast Debugger ")) {
                RubyDebugProcess.this.myFeatures.handleGreetingMessage(text);
                ApplicationManager.getApplication().invokeLater(RubyDebugProcess.this::connectDebugger);
            }
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            if (event == null) {
                DebugSessionController.$$$reportNull$$$0(2);
            }
            if (RubyDebugProcess.this.getSession().isSuspended()) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (!RubyDebugProcess.this.getSession().areBreakpointsMuted()) {
                        RubyDebugProcess.this.getSession().setBreakpointMuted(true);
                        this.shouldUnmuteBreakpoints = true;
                    }
                });
                RubyDebugProcess.this.getSession().resume();
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                DebugSessionController.$$$reportNull$$$0(3);
            }
            if (this.shouldUnmuteBreakpoints) {
                ApplicationManager.getApplication().runReadAction(() -> RubyDebugProcess.this.getSession().setBreakpointMuted(false));
            }
            super.processTerminated(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess$DebugSessionController";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processWillTerminate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyDebugTabLayouterWithDebuggerConsole
    extends XDebugTabLayouter {
        @NotNull
        private final List<Filter> myConsoleMessageFilters;

        MyDebugTabLayouterWithDebuggerConsole(List<Filter> consoleMessageFilters) {
            if (consoleMessageFilters == null) {
                MyDebugTabLayouterWithDebuggerConsole.$$$reportNull$$$0(0);
            }
            this.myConsoleMessageFilters = consoleMessageFilters;
        }

        public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
            if (ui == null) {
                MyDebugTabLayouterWithDebuggerConsole.$$$reportNull$$$0(1);
            }
            ConsoleView consoleView = new RubyDebugConsoleBuilder(RubyDebugProcess.this.getSession().getProject(), RubyDebugProcess.this).filters(this.myConsoleMessageFilters).getConsole();
            Content content = ui.createContent("Debugger console view", consoleView.getComponent(), RBundle.message((String)"debugger.console.layout.tab.name"), AllIcons.Debugger.Console, consoleView.getPreferredFocusableComponent());
            content.setCloseable(false);
            content.setActions((ActionGroup)new DefaultActionGroup(consoleView.createConsoleActions()), "DebuggerToolbar", consoleView.getPreferredFocusableComponent());
            ui.addContent(content, 3, PlaceInGrid.right, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleMessageFilters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyDebugProcess$MyDebugTabLayouterWithDebuggerConsole";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerAdditionalContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

