/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEvaluator;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyLineBreakpointHandler;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubySuspendContext;
import org.rubyforge.debugcommons.RubyDebugEvent;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.model.IRubyLineBreakpoint;
import org.rubyforge.debugcommons.model.SuspensionPoint;
import org.rubyforge.debugcommons.model.UnableToStepSuspensionPoint;

class MyRubyDebugEventListener
implements RubyDebugEventListener {
    private static final Logger LOG = Logger.getInstance(MyRubyDebugEventListener.class);
    @NotNull
    private final RubyDebugProcess myRubyDebugProcess;
    @Nullable
    private final ClientId myCliendId;
    @NotNull
    protected final Project myProject;

    MyRubyDebugEventListener(@NotNull Project project, @NotNull RubyDebugProcess rubyDebugProcess) {
        if (project == null) {
            MyRubyDebugEventListener.$$$reportNull$$$0(0);
        }
        if (rubyDebugProcess == null) {
            MyRubyDebugEventListener.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myCliendId = ClientId.getCurrentOrNull();
        this.myRubyDebugProcess = rubyDebugProcess;
    }

    public void onDebugEvent(@NotNull RubyDebugEvent event) {
        if (event == null) {
            MyRubyDebugEventListener.$$$reportNull$$$0(2);
        }
        try (AccessToken ignored = ClientId.withClientId((ClientId)this.myCliendId);){
            String conditionException;
            LOG.debug("Ruby debug event!: ", new Object[]{event, " on ", Thread.currentThread().getName()});
            if (event.isTerminateType()) {
                this.myRubyDebugProcess.terminateEventSeen(event.getOrigin());
                return;
            }
            IRubyLineBreakpoint setBreakpoint = event.getBreakpoint();
            if (setBreakpoint != null) {
                if (event.isBreakpointValid() == ThreeState.UNSURE) {
                    return;
                }
                RubyLineBreakpointHandler lineBreakpointHandler = this.myRubyDebugProcess.myLineBreakpointHandler;
                XDebugSession session = this.myRubyDebugProcess.getSession();
                lineBreakpointHandler.mySource2BreakpointMap.forEach((xBreakpoint, rBreakpoint) -> {
                    if (rBreakpoint != setBreakpoint) {
                        return;
                    }
                    if (event.isBreakpointValid() == ThreeState.NO) {
                        session.setBreakpointInvalid(xBreakpoint, RBundle.message((String)"ruby.debugger.breakpoint.invalidated"));
                        return;
                    }
                    session.setBreakpointVerified(xBreakpoint);
                });
                return;
            }
            if (!event.isSuspensionType() && !event.isExceptionType()) {
                LOG.debug("Unknown event: ", new Object[]{event});
                return;
            }
            String path = event.getFilePath();
            int line = event.getLine();
            SuspensionPoint suspensionPoint = event.getSuspensionPoint();
            if (suspensionPoint instanceof UnableToStepSuspensionPoint) {
                XDebuggerManagerImpl.getNotificationGroup().createNotification(RBundle.message((String)"ruby.debugger.cant.step.into", (Object[])new Object[]{path, Integer.toString(line)}), MessageType.WARNING).notify(this.myProject);
            }
            if ((conditionException = suspensionPoint.getConditionException()) != null) {
                LOG.warn("Got an exception evaluating breakpoint condition: " + conditionException);
                String htmlConditionException = new HtmlBuilder().append(StringUtil.shortenTextWithEllipsis((String)conditionException, (int)120, (int)0, (boolean)true)).toString();
                XDebuggerManagerImpl.getNotificationGroup().createNotification(RBundle.message((String)"ruby.debugger.condition.exception", (Object[])new Object[]{htmlConditionException}), MessageType.ERROR).notify(this.myProject);
            }
            this.processSuspensionEvent(event, path, line);
        }
    }

    private synchronized void processSuspensionEvent(@NotNull RubyDebugEvent event, @NotNull String path, int line) {
        XBreakpoint xBreakpoint;
        if (event == null) {
            MyRubyDebugEventListener.$$$reportNull$$$0(3);
        }
        if (path == null) {
            MyRubyDebugEventListener.$$$reportNull$$$0(4);
        }
        XDebugSession debugSession = this.myRubyDebugProcess.getSession();
        event.getOrigin().pause();
        RubySuspendContext rubySuspendContext = new RubySuspendContext(this.myProject, this.myRubyDebugProcess, event);
        XExecutionStack activeExecutionStack = rubySuspendContext.getActiveExecutionStack();
        if (activeExecutionStack != null) {
            activeExecutionStack.getTopFrame();
        }
        XBreakpoint xBreakpoint2 = xBreakpoint = event.isExceptionType() ? this.myRubyDebugProcess.myExceptionBreakpointHandler.findExceptionBreakpoint(event) : (XBreakpoint)this.myRubyDebugProcess.myLineBreakpointHandler.mySourceAndXBreakpointMap.get(new RubyPosition(path, line, event.getLocation()));
        if (xBreakpoint == null) {
            debugSession.positionReached((XSuspendContext)rubySuspendContext);
            LOG.debug("XDebugSession suspended at: ", new Object[]{rubySuspendContext});
            return;
        }
        if (RubyDebuggerEvaluator.evaluateCondition(rubySuspendContext, xBreakpoint.getConditionExpression())) {
            if (debugSession.breakpointReached(xBreakpoint, MyRubyDebugEventListener.getLogMessage(rubySuspendContext, xBreakpoint), (XSuspendContext)rubySuspendContext)) {
                LOG.debug("XDebugSession suspended at breakpoint: ", new Object[]{xBreakpoint});
                return;
            }
            LOG.debug("Breakpoint stop policy set to NONE, resuming at ", new Object[]{xBreakpoint});
        } else {
            LOG.debug("Condition is not met, continuing at ", new Object[]{xBreakpoint});
        }
        this.myRubyDebugProcess.resume(rubySuspendContext);
    }

    @Nullable
    private static String getLogMessage(@NotNull RubySuspendContext rubySuspendContext, @NotNull XBreakpoint<?> xBreakpoint) {
        XExpression expressionObject;
        if (rubySuspendContext == null) {
            MyRubyDebugEventListener.$$$reportNull$$$0(5);
        }
        if (xBreakpoint == null) {
            MyRubyDebugEventListener.$$$reportNull$$$0(6);
        }
        if ((expressionObject = xBreakpoint.getLogExpressionObject()) == null) {
            return null;
        }
        String expression = expressionObject.getExpression();
        return !StringUtil.isEmpty((String)expression) ? RubyDebuggerEvaluator.evaluateExpression(rubySuspendContext, expression) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyDebugProcess";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySuspendContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/MyRubyDebugEventListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onDebugEvent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuspensionEvent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLogMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

