/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import icons.RubyIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.debugger.breakpoints.RubyLineBreakpointProperties;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEditorsProvider;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyLocationMapper;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RFileImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

public final class RubyLineBreakpointType
extends XLineBreakpointType<RubyLineBreakpointProperties> {
    public RubyLineBreakpointType() {
        super("ruby-line", RBundle.message((String)"ruby.debugger.line.breakpoint.title"));
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        PsiFile psiFile;
        if (file == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (project == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(1);
        }
        if ((psiFile = PsiManager.getInstance((Project)project).findFile(file)) == null) {
            return false;
        }
        if (psiFile instanceof RFile || psiFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return false;
            }
            if (line > 0) {
                if (!project.isInitialized()) {
                    return false;
                }
                PsiElement prev = psiFile.findElementAt(document.getLineEndOffset(line - 1));
                if (prev != null && PsiUtilCore.getElementType((PsiElement)prev.getPrevSibling()) == RubyTokenTypes.tLINE_CONTINUATION) {
                    return false;
                }
            }
            Ref containsRubyElement = Ref.create((Object)false);
            XDebuggerUtil.getInstance().iterateLine(project, document, line, element -> {
                if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                RPsiElement rParent = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)element, RPsiElement.class, (boolean)false);
                if (rParent != null) {
                    if (psiFile instanceof RFileImpl) {
                        boolean canPut;
                        boolean bl = canPut = PsiTreeUtil.getDeepestFirst((PsiElement)rParent) == element || rParent instanceof RAssocList && PsiTreeUtil.getDeepestLast((PsiElement)rParent) == element;
                        if (canPut) {
                            containsRubyElement.set((Object)true);
                            return false;
                        }
                    } else {
                        containsRubyElement.set((Object)true);
                        return false;
                    }
                }
                return true;
            });
            return (Boolean)containsRubyElement.get();
        }
        return false;
    }

    @Nullable
    public RubyLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(2);
        }
        return new RubyLineBreakpointProperties();
    }

    private static boolean isGoodBlock(@NotNull RCodeBlock block, @NotNull Document document, int line) {
        RBlockArgumentList blockArgumentList;
        if (block == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(3);
        }
        if (document == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(4);
        }
        if ((blockArgumentList = block.getBlockArguments()) != null && ContainerUtil.exists((Iterable)blockArgumentList.getArgumentInfos(true), it -> it.getType().isOptional())) {
            return true;
        }
        RCompoundStatement bodyStatement = block.getCompoundStatement();
        PsiElement firstStatement = (PsiElement)ContainerUtil.getFirstItem((List)bodyStatement.getStatements());
        return firstStatement != null && document.getLineNumber(firstStatement.getTextOffset()) == line;
    }

    @NotNull
    private static List<RCodeBlock> doGetLineBlocks(@NotNull ControlFlowHolder holder, @NotNull RubyLocationMapper locationProducer, @NotNull VirtualFile file, int line) {
        if (holder == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(5);
        }
        if (locationProducer == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(6);
        }
        if (file == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(7);
        }
        List<PsiElement> elements = locationProducer.getElementsByControlFlowHolder(holder);
        ArrayList<RCodeBlock> lineBlocks = new ArrayList<RCodeBlock>();
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            ArrayList<RCodeBlock> arrayList = lineBlocks;
            if (arrayList == null) {
                RubyLineBreakpointType.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        if (elements != null) {
            for (PsiElement element : elements) {
                if (!(element instanceof RCodeBlock)) continue;
                RCodeBlock block = (RCodeBlock)element;
                if (RubyLineBreakpointType.isGoodBlock(block, document, line)) {
                    lineBlocks.add(block);
                }
                lineBlocks.addAll(RubyLineBreakpointType.doGetLineBlocks((ControlFlowHolder)block, locationProducer, file, line));
            }
        }
        ArrayList<RCodeBlock> arrayList = lineBlocks;
        if (arrayList == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    public static List<RCodeBlock> getLineBlocks(@NotNull Project project, @NotNull VirtualFile file, int line) {
        RubyLocationMapper locationProducer;
        ControlFlowHolder holder;
        if (project == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(10);
        }
        if (file == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(11);
        }
        if ((holder = (locationProducer = new RubyLocationMapper(line, file, project)).getControlFlowHolder()) == null) {
            return null;
        }
        return RubyLineBreakpointType.doGetLineBlocks(holder, locationProducer, file, line);
    }

    @NotNull
    public List<? extends XLineBreakpointType.XLineBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(12);
        }
        if (position == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(13);
        }
        SmartList result = new SmartList();
        result.add(new RubyLineBreakpointVariant(position));
        List<RCodeBlock> blocks = RubyLineBreakpointType.getLineBlocks(project, position.getFile(), position.getLine());
        int ordinal = 0;
        if (blocks != null) {
            for (RCodeBlock block : blocks) {
                XSourcePositionImpl blockPosition = XSourcePositionImpl.createByElement((PsiElement)block);
                if (blockPosition == null) continue;
                result.add(new RubyLineBreakpointVariant((XSourcePosition)blockPosition, (PsiElement)block, ordinal++));
            }
        }
        if (result.size() > 1) {
            result.add(new XLineBreakpointType.XLineBreakpointAllVariant((XLineBreakpointType)this, position));
        }
        SmartList smartList = result;
        if (smartList == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    @Nullable
    public RubyLineBreakpointProperties createProperties() {
        return new RubyLineBreakpointProperties();
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<RubyLineBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(15);
        }
        if (project == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(16);
        }
        return new RubyDebuggerEditorsProvider();
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<RubyLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    public String getBreakpointsDialogHelpTopic() {
        return "reference.dialogs.breakpoints";
    }

    @Nullable
    public static TextRange intersectWithLine(@Nullable TextRange range, @Nullable PsiFile file, int line) {
        Document document;
        if (range != null && file != null && (document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) != null) {
            range = range.intersection(DocumentUtil.getLineTextRange((Document)document, (int)line));
        }
        return range;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<RubyLineBreakpointProperties> breakpoint) {
        RubyLineBreakpointProperties properties = (RubyLineBreakpointProperties)breakpoint.getProperties();
        if (properties == null) {
            return null;
        }
        Integer ordinal = properties.getBlockOrdinal();
        if (ordinal == null || ordinal < 0) {
            return null;
        }
        XSourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        List<RCodeBlock> blocks = RubyLineBreakpointType.getLineBlocks(((XBreakpointBase)breakpoint).getProject(), position.getFile(), position.getLine());
        if (blocks == null || blocks.size() <= ordinal) {
            return null;
        }
        RCodeBlock block = blocks.get(ordinal);
        return RubyLineBreakpointType.intersectWithLine(block.getTextRange(), block.getContainingFile(), breakpoint.getLine());
    }

    public boolean variantAndBreakpointMatch(@NotNull XLineBreakpoint<RubyLineBreakpointProperties> breakpoint, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull XLineBreakpointType.XLineBreakpointVariant variant) {
        if (breakpoint == null) {
            RubyLineBreakpointType.$$$reportNull$$$0(17);
        }
        Integer breakpointBlockOrdinal = ((RubyLineBreakpointProperties)breakpoint.getProperties()).getBlockOrdinal();
        if (variant instanceof RubyLineBreakpointVariant) {
            RubyLineBreakpointVariant rubyVariant = (RubyLineBreakpointVariant)variant;
            int variantBlockOrdinal = rubyVariant.myBlockOrdinal;
            return Objects.equals(breakpointBlockOrdinal, variantBlockOrdinal) || breakpointBlockOrdinal == null && variantBlockOrdinal == -1;
        }
        return breakpointBlockOrdinal == null || breakpointBlockOrdinal == -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationProducer";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/breakpoints/RubyLineBreakpointType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/breakpoints/RubyLineBreakpointType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLineBlocks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGoodBlock";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetLineBlocks";
                break;
            }
            case 8: 
            case 9: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLineBlocks";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsProvider";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "variantAndBreakpointMatch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 14 -> new IllegalStateException(string);
        };
    }

    public class RubyLineBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        private final int myBlockOrdinal;
        private final PsiElement myElement;

        public RubyLineBreakpointVariant(XSourcePosition lambdaPosition) {
            super((XLineBreakpointType)RubyLineBreakpointType.this, lambdaPosition);
            this.myBlockOrdinal = -1;
            this.myElement = null;
        }

        public RubyLineBreakpointVariant(@NotNull XSourcePosition lambdaPosition, PsiElement element, int blockOrdinal) {
            if (lambdaPosition == null) {
                RubyLineBreakpointVariant.$$$reportNull$$$0(0);
            }
            if (element == null) {
                RubyLineBreakpointVariant.$$$reportNull$$$0(1);
            }
            super((XLineBreakpointType)RubyLineBreakpointType.this, lambdaPosition);
            this.myElement = element;
            this.myBlockOrdinal = blockOrdinal;
        }

        @Nullable
        public RubyLineBreakpointProperties createProperties() {
            RubyLineBreakpointProperties properties = (RubyLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.setBlockOrdinal(this.myBlockOrdinal);
            return properties;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return this.myElement != null ? this.myElement.getTextRange() : null;
        }

        @NotNull
        public String getText() {
            String string = this.myElement != null ? StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0) : RBundle.message((String)"debugger.breakpoint.position.line");
            if (string == null) {
                RubyLineBreakpointVariant.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Icon getIcon() {
            return this.myElement != null ? RubyIcons.Ruby.Debugger.BlockBreakpoint_12x12 : AllIcons.Debugger.Db_set_breakpoint;
        }

        public boolean isMultiVariant() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lambdaPosition";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/breakpoints/RubyLineBreakpointType$RubyLineBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/breakpoints/RubyLineBreakpointType$RubyLineBreakpointVariant";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

