/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.attach;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.fs.LazyAttachVirtualFS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;

public class SourcePositionDecorator
implements SourcePositionConverter {
    @NotNull
    private final SourcePositionConverter myBaseConverter;
    @NotNull
    private final EnvironmentAwareHost myHostInfo;

    public SourcePositionDecorator(@NotNull SourcePositionConverter baseConverter, @NotNull EnvironmentAwareHost hostInfo) {
        if (baseConverter == null) {
            SourcePositionDecorator.$$$reportNull$$$0(0);
        }
        if (hostInfo == null) {
            SourcePositionDecorator.$$$reportNull$$$0(1);
        }
        this.myBaseConverter = baseConverter;
        this.myHostInfo = hostInfo;
    }

    @Override
    @NotNull
    public RubyPosition createRemotePosition(@NotNull XSourcePosition xSourcePosition) {
        if (xSourcePosition == null) {
            SourcePositionDecorator.$$$reportNull$$$0(2);
        }
        RubyPosition rubyPosition = this.myBaseConverter.createRemotePosition(xSourcePosition);
        if (rubyPosition == null) {
            SourcePositionDecorator.$$$reportNull$$$0(3);
        }
        return rubyPosition;
    }

    @Override
    @Nullable
    public XSourcePosition createLocalPosition(@NotNull RubyPosition rubyPosition) {
        XSourcePosition position;
        if (rubyPosition == null) {
            SourcePositionDecorator.$$$reportNull$$$0(4);
        }
        if ((position = this.myBaseConverter.createLocalPosition(rubyPosition)) == null) {
            VirtualFile file = LazyAttachVirtualFS.getInstance().findFileByPath(rubyPosition.getPath(), this.myHostInfo);
            return XDebuggerUtil.getInstance().createPosition(file, rubyPosition.getLine() - 1);
        }
        return position;
    }

    @Override
    @NotNull
    public String getRemotePath(@NotNull VirtualFile file) {
        if (file == null) {
            SourcePositionDecorator.$$$reportNull$$$0(5);
        }
        String string = this.myBaseConverter.getRemotePath(file);
        if (string == null) {
            SourcePositionDecorator.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseConverter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xSourcePosition";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/SourcePositionDecorator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyPosition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/attach/SourcePositionDecorator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemotePosition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRemotePosition";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLocalPosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRemotePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

