/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.RubyProcessHandlerEx;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public class RubyProcessDispatcher {
    private static final Logger LOG = Logger.getInstance(RubyProcessDispatcher.class);
    private static int ourAcceptorCount = 0;
    private final AtomicBoolean myWasMainProxyConnected = new AtomicBoolean(false);
    private volatile ServerSocket myServerSocket;
    private volatile boolean myShouldAccept = true;
    private final String myDebuggerHost;
    private final boolean mySupportsNonSuspendedFramesReading;
    private final boolean mySupportsCatchpointRemoval;
    private final boolean mySupportsLoadingFulValue;
    private final boolean mySupportTypeRenderers;
    private final boolean myMasterConnectionExpected;
    private RubyDebugProcess myProcess;
    @Nullable
    private RubyProcessHandlerEx myProcessHandler;

    public RubyProcessDispatcher(String debuggerHost, String dispatcherHost, int port, boolean supportsNonSuspendedFramesReading, boolean supportsCatchpointRemoval, boolean supportsLoadingFullValue, boolean supportsTypeRenderers, boolean masterConnectionExpected) throws ExecutionException {
        this.myDebuggerHost = debuggerHost;
        this.mySupportsNonSuspendedFramesReading = supportsNonSuspendedFramesReading;
        this.mySupportsCatchpointRemoval = supportsCatchpointRemoval;
        this.mySupportsLoadingFulValue = supportsLoadingFullValue;
        this.mySupportTypeRenderers = supportsTypeRenderers;
        this.myMasterConnectionExpected = masterConnectionExpected;
        try {
            LOG.debug("Creating dispatcher server socket at port ", new Object[]{port});
            this.myServerSocket = new ServerSocket(port, 50, InetAddress.getByName(dispatcherHost));
        }
        catch (IOException e) {
            LOG.warn("Failed to create a dispatcher server socket at port " + port, (Throwable)e);
            throw new ExecutionException(RBundle.message((String)"dialog.message.failed.to.find.free.socket.port.for.process.dispatcher"));
        }
    }

    public void start() {
        new Thread("RubyProcessDispatcher " + ourAcceptorCount++){

            @Override
            public void run() {
                while (RubyProcessDispatcher.this.myShouldAccept) {
                    try {
                        Socket socket = RubyProcessDispatcher.this.myServerSocket.accept();
                        try {
                            try (PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);){
                                boolean oldWasMainProxyConnected = RubyProcessDispatcher.this.myWasMainProxyConnected.getAndSet(true) || !RubyProcessDispatcher.this.myMasterConnectionExpected;
                                writer.println(oldWasMainProxyConnected);
                                if (!oldWasMainProxyConnected || RubyProcessDispatcher.this.myProcess == null) continue;
                                byte[] in = new byte[5];
                                int result = socket.getInputStream().read(in);
                                if (result <= 0) continue;
                                RubyProcessDispatcher.this.spawnProxy(in, result);
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                        finally {
                            if (socket == null) continue;
                            socket.close();
                        }
                    }
                    catch (IOException ignored) {
                        if (RubyProcessDispatcher.this.myServerSocket != null) continue;
                        RubyProcessDispatcher.this.myShouldAccept = false;
                    }
                }
            }
        }.start();
    }

    private void spawnProxy(byte[] in, int length) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            int localPort = Integer.parseInt(new String(in, 0, length, StandardCharsets.UTF_8));
            try {
                if (this.myProcessHandler != null) {
                    localPort = this.myProcessHandler.addTunnelForRemoteServer(localPort);
                }
                int timeout = RubyDebuggerSettings.getInstance().getState().getTimeout();
                RubyDebuggerProxy rubyDebuggerProxy = new RubyDebuggerProxy(timeout, this.mySupportsNonSuspendedFramesReading, true, this.mySupportsCatchpointRemoval, this.mySupportsLoadingFulValue, this.mySupportTypeRenderers);
                RubyDebugTarget rubyDebugTarget = new RubyDebugTarget(rubyDebuggerProxy, this.myDebuggerHost, localPort);
                rubyDebuggerProxy.setDebugTarget(rubyDebugTarget);
                this.myProcess.registerDebuggerProxy(rubyDebuggerProxy);
                this.myProcess.attachToProxy(rubyDebuggerProxy);
                LOG.info("Connected to " + this.myDebuggerHost + ":" + localPort);
            }
            catch (Exception e) {
                LOG.warn("Failed to connect to process at " + this.myDebuggerHost + ":" + localPort, (Throwable)e);
            }
        });
    }

    public void stop() {
        if (this.myServerSocket != null && !this.myServerSocket.isClosed()) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.debug("Exception while closing server socket: ", new Object[]{e.getMessage()});
            }
        }
        this.myShouldAccept = false;
        this.myServerSocket = null;
    }

    public int getPort() {
        return this.myServerSocket.getLocalPort();
    }

    public void setProcess(RubyDebugProcess process) {
        this.myProcess = process;
    }

    public void setProcessHandler(@Nullable ProcessHandler processHandler) {
        if (processHandler instanceof RubyProcessHandlerEx) {
            this.myProcessHandler = (RubyProcessHandlerEx)processHandler;
        }
    }
}

