/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.preload.spring.SpringUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyProcessDispatcher;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyProgramRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.RubyDebugIdeGemHelper;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public class RubyDebugRunner
extends RubyProgramRunner {
    private static final Logger LOG = Logger.getInstance(RubyDebugRunner.class);
    public static final int RUBY_DEBUG_DEFAULT_TIMEOUT = 10;
    public static final int RUBY_DEBUG_DEFAULT_TIMELIMIT = 100;
    public static final int RUBY_DEBUG_DEFAULT_MEMORYLIMIT = 0;
    @NotNull
    public static final String RUBY_DEBUGGER_FULL_VALUE_TIMELIMIT_KEY = "ruby.debugger.fullValue.timelimit";
    @NotNull
    public static final String RUBY_DEBUGGER_FULL_VALUE_MEMORY_LIMIT_KEY = "ruby.debugger.fullValue.memorylimit";
    public static final String ID = "RubyDebugRunner";

    @Override
    @NotNull
    public String getRunnerId() {
        return ID;
    }

    @Override
    public boolean preloaderAllowed() {
        return !SpringUtil.isSpringDebugPatchDenied();
    }

    @Override
    public boolean isExplicitSpringAllowed() {
        return false;
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            RubyDebugRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            RubyDebugRunner.$$$reportNull$$$0(1);
        }
        if (profile instanceof WrappingRunConfiguration) {
            profile = ((WrappingRunConfiguration)profile).getPeer();
        }
        return "Debug".equals(executorId) && profile instanceof AbstractRubyRunConfiguration;
    }

    @Override
    protected void doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment, @NotNull AsyncPromise<RunContentDescriptor> result) throws ExecutionException {
        if (state == null) {
            RubyDebugRunner.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            RubyDebugRunner.$$$reportNull$$$0(3);
        }
        if (result == null) {
            RubyDebugRunner.$$$reportNull$$$0(4);
        }
        LOG.debug("Initializing debugger service");
        try {
            XDebugSession xDebugSession = new RubyDebugSessionBuilder((RubyAbstractCommandLineState)state, environment).setRubyDebuggerProxy().setAcceptor().setRubyDebugTarget().connectProxy().build();
            LOG.debug("Debugger service initialized. Starting RubyDebugProcess");
            result.setResult((Object)xDebugSession.getRunContentDescriptor());
        }
        catch (RubyDebugIdeGemHelper.DebugGemInstallationCancelledException ignored) {
            LOG.debug("Cancelled debugger installation handled.");
            result.setResult(null);
        }
    }

    protected static boolean supportsCatchpointRemoval(@NotNull DebugGemHelper helper, @Nullable Sdk sdk) {
        if (helper == null) {
            RubyDebugRunner.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            return false;
        }
        return helper.supportsCatchpointRemoval();
    }

    protected static boolean supportsLoadingFullValue(@NotNull DebugGemHelper helper, @Nullable Sdk sdk) {
        if (helper == null) {
            RubyDebugRunner.$$$reportNull$$$0(6);
        }
        if (sdk == null) {
            return false;
        }
        return helper.supportsLoadingFullValue();
    }

    protected static boolean supportsTypeRenderers(@NotNull DebugGemHelper helper, @Nullable Sdk sdk) {
        if (helper == null) {
            RubyDebugRunner.$$$reportNull$$$0(7);
        }
        if (sdk == null) {
            return false;
        }
        return helper.supportsTypeRenderers();
    }

    protected static boolean shouldUseDebugConsole(@NotNull DebugGemHelper helper, @Nullable Sdk sdk, @NotNull RubyCommandLineData data) {
        if (helper == null) {
            RubyDebugRunner.$$$reportNull$$$0(8);
        }
        if (data == null) {
            RubyDebugRunner.$$$reportNull$$$0(9);
        }
        if (sdk == null) {
            return false;
        }
        Boolean value = (Boolean)data.getUserData(RubyCommandLineData.DEBUG_CONSOLE_ALLOWED_KEY);
        if (value == null || !value.booleanValue()) {
            return false;
        }
        return helper.debugConsoleSupported(sdk);
    }

    @NotNull
    public static RubyDebugTarget getDebugTarget(@Nullable String debuggedScript, ProcessHandler serverProcessHandler, Integer debuggerPort, @NotNull RubyDebuggerProxy rubyDebuggerProxy, String localHostString) {
        Process serverProcess;
        if (rubyDebuggerProxy == null) {
            RubyDebugRunner.$$$reportNull$$$0(10);
        }
        Process process = serverProcess = serverProcessHandler instanceof OSProcessHandler ? ((OSProcessHandler)serverProcessHandler).getProcess() : null;
        if (serverProcess != null) {
            return new RubyDebugTarget(rubyDebuggerProxy, localHostString, debuggerPort.intValue(), serverProcess, debuggedScript, null);
        }
        return new RubyDebugTarget(rubyDebuggerProxy, localHostString, debuggerPort.intValue());
    }

    @Nullable
    public static RubyProcessDispatcher getAcceptor(boolean supportsNonSuspendedFramesReading, String debuggerHost, String dispatcherHost, boolean supportsCatchpointRemoval, boolean supportsLoadingFullValue, boolean supportsTypeRenderers, @Nullable Integer dispatcherPort, boolean masterConnectionExpected) throws ExecutionException {
        RubyProcessDispatcher acceptor;
        if (RubyDebuggerSettings.getInstance().getState().isMultiprocess() && dispatcherPort != null) {
            acceptor = new RubyProcessDispatcher(debuggerHost, dispatcherHost, dispatcherPort, supportsNonSuspendedFramesReading, supportsCatchpointRemoval, supportsLoadingFullValue, supportsTypeRenderers, masterConnectionExpected);
            acceptor.start();
        } else {
            acceptor = null;
        }
        return acceptor;
    }

    public static boolean supportsNonSuspendedFramesReading(@NotNull DebugGemHelper debugGemHelper, @Nullable Sdk sdk) {
        if (debugGemHelper == null) {
            RubyDebugRunner.$$$reportNull$$$0(11);
        }
        if (sdk == null) {
            return false;
        }
        if (!RubyDebuggerSettings.getInstance().getState().isReadNonSuspendedFrames()) {
            return false;
        }
        return debugGemHelper.supportsNonSuspendedFramesReading(sdk);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyDebuggerProxy";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugGemHelper";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsCatchpointRemoval";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLoadingFullValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsTypeRenderers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldUseDebugConsole";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getDebugTarget";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsNonSuspendedFramesReading";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RubyDebugSessionBuilder {
        protected RubyDebugTarget myRubyDebugTarget;
        protected List<VirtualFile> mySourceRoots;
        protected List<VirtualFile> myExcludedDirs;
        protected String myLocalHostString;
        @Nullable
        protected RubyDebuggerProxy myRubyDebuggerProxy;
        protected final Integer myDebuggerPort;
        protected boolean mySupportsNonSuspendedFramesReading;
        protected boolean myEnableFileFiltering;
        @NotNull
        private final RubyAbstractCommandLineState myState;
        @NotNull
        private final ExecutionEnvironment myEnvironment;
        @NotNull
        private final RubyCommandLineData myCommandLineData;
        @NotNull
        private final ProcessHandler myServerProcessHandler;
        @NotNull
        private final Project myProject;
        private DebugGemHelper myDebugGemHelper;
        private SourcePositionConverter myConverter;
        private int myTimeout;
        private Sdk mySdk;
        private RubyProcessDispatcher myAcceptor;
        private boolean myShouldUseDebugConsole;
        private boolean mySupportsCatchpointRemoval;
        private boolean mySupportsLoadingFullValue;
        private boolean mySupportTypeRenderers;
        @NlsSafe
        private String mySessionName;

        public RubyDebugSessionBuilder(@NotNull RubyAbstractCommandLineState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (state == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(0);
            }
            if (environment == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(1);
            }
            this.mySupportsNonSuspendedFramesReading = false;
            this.myEnableFileFiltering = false;
            this.myShouldUseDebugConsole = false;
            this.mySupportsCatchpointRemoval = false;
            this.mySupportsLoadingFullValue = false;
            this.mySupportTypeRenderers = false;
            this.myState = state;
            this.myEnvironment = environment;
            this.myProject = this.myState.getConfig().getProject();
            Pair<RubyCommandLineData, ProcessHandler> commandLineAndProcessHandler = this.myState.createCommandLineAndProcessHandler();
            this.myCommandLineData = (RubyCommandLineData)((Object)commandLineAndProcessHandler.getFirst());
            this.myServerProcessHandler = (ProcessHandler)commandLineAndProcessHandler.getSecond();
            this.myDebuggerPort = (Integer)this.myCommandLineData.getUserData(RubyCommandLineData.DEBUG_PORT_KEY);
            if (this.myDebuggerPort != null) {
                this.myDebugGemHelper = (DebugGemHelper)this.myCommandLineData.getUserData(RubyCommandLineData.DEBUG_GEM_HELPER_KEY);
                LOG.assertTrue(this.myDebugGemHelper != null, (Object)"cannot create debug runner without gem helper");
                this.myConverter = (SourcePositionConverter)this.myCommandLineData.getUserData(RubyCommandLineData.SOURCE_POSITION_CONVERTER_KEY);
                assert (this.myConverter != null) : "source position converter must not be null";
                this.myTimeout = RubyDebuggerSettings.getInstance().getState().getTimeout();
                this.mySdk = this.myState.getConfig().getSdk();
                this.mySupportsNonSuspendedFramesReading = RubyDebugRunner.supportsNonSuspendedFramesReading(this.myDebugGemHelper, this.mySdk);
                this.myShouldUseDebugConsole = RubyDebugRunner.shouldUseDebugConsole(this.myDebugGemHelper, this.mySdk, this.myCommandLineData);
                this.mySupportsCatchpointRemoval = RubyDebugRunner.supportsCatchpointRemoval(this.myDebugGemHelper, this.mySdk);
                this.mySupportsLoadingFullValue = RubyDebugRunner.supportsLoadingFullValue(this.myDebugGemHelper, this.mySdk);
                this.mySupportTypeRenderers = RubyDebugRunner.supportsTypeRenderers(this.myDebugGemHelper, this.mySdk);
                this.mySourceRoots = this.myDebugGemHelper.getSourceRoots(this.myProject);
                this.myExcludedDirs = this.myDebugGemHelper.getExcludedDirs(this.myProject);
                this.myEnableFileFiltering = this.myDebugGemHelper.supportFileFiltering() && RubyDebuggerSettings.getInstance().getState().isStepIntoProjectOnly();
                this.myLocalHostString = NetUtils.getLocalHostString();
            }
        }

        @NotNull
        public RubyDebugSessionBuilder setRubyDebuggerProxy() {
            if (this.myDebuggerPort != null) {
                this.myRubyDebuggerProxy = new RubyDebuggerProxy(this.myTimeout, this.mySupportsNonSuspendedFramesReading, true, this.mySupportsCatchpointRemoval, this.mySupportsLoadingFullValue, this.mySupportTypeRenderers);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(2);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder setAcceptor() throws ExecutionException {
            String dispatcherHost = (String)ObjectUtils.coalesce((Object)((String)this.myCommandLineData.getCopyableUserData(RubyCommandLineData.DISPATCHER_HOST_KEY)), (Object)this.myLocalHostString);
            if (this.myDebuggerPort != null) {
                this.myAcceptor = RubyDebugRunner.getAcceptor(this.mySupportsNonSuspendedFramesReading, this.myLocalHostString, dispatcherHost, this.mySupportsCatchpointRemoval, this.mySupportsLoadingFullValue, this.mySupportTypeRenderers, (Integer)this.myCommandLineData.getCopyableUserData(RubyCommandLineData.DISPATCHER_KEY), false);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(3);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder setRubyDebugTarget() {
            if (this.myDebuggerPort != null) {
                String debuggedScript = (String)this.myCommandLineData.getUserData(RubyCommandLineData.DEBUGED_SCRIPT_KEY);
                assert (debuggedScript != null) : "script cannot be null";
                assert (this.myRubyDebuggerProxy != null);
                this.myRubyDebugTarget = RubyDebugRunner.getDebugTarget(debuggedScript, this.myServerProcessHandler, this.myDebuggerPort, this.myRubyDebuggerProxy, this.myLocalHostString);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(4);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder connectProxy() {
            if (this.myDebuggerPort != null) {
                this.myRubyDebuggerProxy.setDebugTarget(this.myRubyDebugTarget);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(5);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder showTab(String sessionName) {
            this.mySessionName = sessionName;
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(6);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public XDebugSession build() throws ExecutionException {
            if (this.myDebuggerPort == null) {
                throw new ExecutionException(RBundle.message((String)"dialog.message.no.rubymotion.support.found"));
            }
            XDebugProcessStarter processStarter = new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new RubyDebugProcess(session, (RunProfileState)myState, myServerProcessHandler, myRubyDebuggerProxy, myTimeout, myConverter, myEnvironment, myAcceptor, myDebugGemHelper.pauseActionSupported(), myShouldUseDebugConsole, myEnableFileFiltering, mySourceRoots, myExcludedDirs);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder$1", "start"));
                }
            };
            XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)this.myEnvironment.getProject());
            XDebugSession xDebugSession = (XDebugSession)RubyProgramRunner.computeOnEdtWithExecutionException(() -> {
                if (this.mySessionName == null) {
                    return debuggerManager.startSession(this.myEnvironment, processStarter);
                }
                return debuggerManager.startSessionAndShowTab(this.mySessionName, null, processStarter);
            });
            if (xDebugSession == null) {
                RubyDebugSessionBuilder.$$$reportNull$$$0(7);
            }
            return xDebugSession;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebuggerProxy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAcceptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebugTarget";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "connectProxy";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showTab";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

