/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.OrderedSet;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class ContextVariablesCollector {
    private static final Logger LOG = Logger.getInstance(ContextVariablesCollector.class);
    @NotNull
    private final OrderedSet<String> myProcessedGlobals;
    @NotNull
    private final XCompositeNode myParentNode;
    @NotNull
    private final RubyStackFrame myRubyStackFrame;
    @NotNull
    private final RubyFrame myRubyFrame;
    @Nullable
    private final XSourcePosition myPosition;
    @NotNull
    private OrderedSet<String> myFieldsMentionedInContext;
    @NotNull
    private OrderedSet<String> myConstantsMentionedInContext;
    @NotNull
    private OrderedSet<String> myContextInfosFromProviders;
    @NotNull
    private OrderedSet<String> myGlobalsMentionedInContext;
    private Project myProject;

    public ContextVariablesCollector(@NotNull Project project, @NotNull XCompositeNode parentNode, @NotNull RubyStackFrame rubyStackFrame, @Nullable XSourcePosition position) {
        if (project == null) {
            ContextVariablesCollector.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            ContextVariablesCollector.$$$reportNull$$$0(1);
        }
        if (rubyStackFrame == null) {
            ContextVariablesCollector.$$$reportNull$$$0(2);
        }
        this.myProcessedGlobals = new OrderedSet();
        this.myFieldsMentionedInContext = new OrderedSet();
        this.myConstantsMentionedInContext = new OrderedSet();
        this.myContextInfosFromProviders = new OrderedSet();
        this.myGlobalsMentionedInContext = new OrderedSet();
        this.myProject = null;
        this.myParentNode = parentNode;
        this.myRubyStackFrame = rubyStackFrame;
        this.myRubyFrame = this.myRubyStackFrame.getRubyFrame();
        this.myPosition = position;
        ApplicationManager.getApplication().runReadAction(() -> {
            if (position == null) {
                return;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile());
            if (psiFile == null) {
                return;
            }
            PsiElement context = psiFile.findElementAt(position.getOffset());
            if (context == null) {
                return;
            }
            RContainer scope = RubyPsiUtilCore.getParentContainer((PsiElement)context);
            if (scope == null) {
                return;
            }
            this.myFieldsMentionedInContext = RubyDebuggerSupportUtils.collectFieldsMentionedInContext(scope);
            this.myConstantsMentionedInContext = RubyDebuggerSupportUtils.collectConstantsMentionedInContext(scope);
            this.myContextInfosFromProviders = RubyDebuggerSupportUtils.collectContextInfoFromProviders(scope, position);
            this.myGlobalsMentionedInContext = RubyDebuggerSupportUtils.addGlobalsMentionedInContext(scope);
            this.myProcessedGlobals.addAll(this.myFieldsMentionedInContext);
            this.myProcessedGlobals.addAll(this.myConstantsMentionedInContext);
            this.myProcessedGlobals.addAll(this.myContextInfosFromProviders);
            this.myProcessedGlobals.addAll(this.myGlobalsMentionedInContext);
            this.myProject = scope.getProject();
        });
    }

    @NotNull
    public OrderedSet<String> getProcessedContextVariables() {
        OrderedSet<String> orderedSet = this.myProcessedGlobals;
        if (orderedSet == null) {
            ContextVariablesCollector.$$$reportNull$$$0(3);
        }
        return orderedSet;
    }

    public void addContextVariableNodes() {
        this.addVariableNodes((List<String>)this.myFieldsMentionedInContext);
        this.addConstantContextVariableNodes();
        this.addVariableNodes((List<String>)this.myContextInfosFromProviders);
        this.addVariableNodes((List<String>)this.myGlobalsMentionedInContext);
    }

    private void addVariableNodes(List<String> contextVariableNames) {
        for (String fieldName : contextVariableNames) {
            RubyVariable fieldVariable = this.computeRubyVariable(fieldName);
            if (fieldVariable == null) continue;
            this.addVariableNode(fieldName, fieldVariable);
        }
    }

    private void addConstantContextVariableNodes() {
        List<String> validConstants = this.getValidConstants((List<String>)this.myConstantsMentionedInContext);
        for (String constantName : validConstants) {
            RubyVariable constantVariable = this.computeRubyVariable(constantName);
            if (constantVariable == null) continue;
            this.addVariableNode(constantName, constantVariable);
        }
    }

    private void addVariableNode(@NotNull String variableName, @NotNull RubyVariable rubyVariable) {
        if (variableName == null) {
            ContextVariablesCollector.$$$reportNull$$$0(4);
        }
        if (rubyVariable == null) {
            ContextVariablesCollector.$$$reportNull$$$0(5);
        }
        RubyDebugValue variableDebugValue = RubyDebugValueFactory.create(this.myProject, this.myPosition, this.myRubyStackFrame, null, variableName, rubyVariable);
        XValueChildrenList singletonChildList = XValueChildrenList.singleton((String)variableName, (XValue)variableDebugValue);
        this.myParentNode.addChildren(singletonChildList, false);
    }

    @Nullable
    private RubyVariable computeRubyVariable(@NotNull String variableName) {
        if (variableName == null) {
            ContextVariablesCollector.$$$reportNull$$$0(6);
        }
        try {
            return this.myRubyFrame.inspectExpression(variableName);
        }
        catch (RubyDebuggerException e) {
            LOG.info("Failed to get a context variable " + variableName + ".", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private List<String> getValidConstants(@NotNull List<String> fqnConstantsNames) {
        if (fqnConstantsNames == null) {
            ContextVariablesCollector.$$$reportNull$$$0(7);
        }
        ArrayList<String> isConstantsValidQueries = new ArrayList<String>();
        for (String fqnConstantName : fqnConstantsNames) {
            List<FqnConstant> fqnConstantRunningList = FqnConstant.createFqnConstantRunningList(fqnConstantName);
            StringJoiner isValidConstantQueryJoiner = new StringJoiner(" && ", "'", "'");
            ContextVariablesCollector.addIsConstantInitializedQueryPart(isValidConstantQueryJoiner, fqnConstantRunningList);
            ContextVariablesCollector.addIsConstantNotClassOrModuleQueryPart(isValidConstantQueryJoiner, fqnConstantName);
            isConstantsValidQueries.add(isValidConstantQueryJoiner.toString());
        }
        String requestQuery = ContextVariablesCollector.buildRequestQuery(isConstantsValidQueries);
        List<Boolean> isConstantValidList = this.requestIsConstantsValid(requestQuery);
        if (isConstantValidList == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ContextVariablesCollector.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (isConstantValidList.size() != fqnConstantsNames.size()) {
            LOG.info("Query eval result contains different elements! Constant names: " + String.valueOf(fqnConstantsNames) + ". Query: " + requestQuery + ". Query eval result: " + String.valueOf(isConstantValidList));
            List<String> list = Collections.emptyList();
            if (list == null) {
                ContextVariablesCollector.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = IntStream.range(0, fqnConstantsNames.size()).filter(i -> (Boolean)isConstantValidList.get(i)).mapToObj(i -> (String)fqnConstantsNames.get(i)).collect(Collectors.toList());
        if (list == null) {
            ContextVariablesCollector.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    private List<Boolean> requestIsConstantsValid(@NotNull String eachConstantInitializedQuery) {
        if (eachConstantInitializedQuery == null) {
            ContextVariablesCollector.$$$reportNull$$$0(11);
        }
        try {
            RubyVariable expressionResultArray = this.myRubyFrame.inspectExpression(eachConstantInitializedQuery);
            if (expressionResultArray == null || !expressionResultArray.getVariableInfo().isCollection()) {
                LOG.info("Failed to eval the query: " + eachConstantInitializedQuery);
                return null;
            }
            RubyVariable[] expressionResultElements = expressionResultArray.getValue().getVariables();
            return Arrays.stream(expressionResultElements).map(element -> Boolean.parseBoolean(element.getValue().getValueString())).toList();
        }
        catch (RubyDebuggerException e) {
            LOG.info("Failed to eval the query: " + eachConstantInitializedQuery, (Throwable)e);
            return null;
        }
    }

    private static void addIsConstantInitializedQueryPart(@NotNull StringJoiner isConstantInitializedQueryJoiner, @NotNull List<FqnConstant> fqnConstantNamespaceRunningList) {
        if (isConstantInitializedQueryJoiner == null) {
            ContextVariablesCollector.$$$reportNull$$$0(12);
        }
        if (fqnConstantNamespaceRunningList == null) {
            ContextVariablesCollector.$$$reportNull$$$0(13);
        }
        for (FqnConstant fqnConstant : fqnConstantNamespaceRunningList) {
            String isConstDefinedQueryPart = "(" + fqnConstant.namespaceName + ".const_defined? :" + fqnConstant.constantName + ")";
            isConstantInitializedQueryJoiner.add(isConstDefinedQueryPart);
            String isConstLoadedQueryPart = "((" + fqnConstant.namespaceName + ".autoload? :" + fqnConstant.constantName + ") == nil)";
            isConstantInitializedQueryJoiner.add(isConstLoadedQueryPart);
        }
    }

    private static void addIsConstantNotClassOrModuleQueryPart(@NotNull StringJoiner isConstantInitializedQueryJoiner, @NotNull String fqnConstantName) {
        if (isConstantInitializedQueryJoiner == null) {
            ContextVariablesCollector.$$$reportNull$$$0(14);
        }
        if (fqnConstantName == null) {
            ContextVariablesCollector.$$$reportNull$$$0(15);
        }
        isConstantInitializedQueryJoiner.add("(not (" + fqnConstantName + ".is_a? Class))");
        isConstantInitializedQueryJoiner.add("(not (" + fqnConstantName + ".is_a? Module))");
    }

    @NotNull
    private static String buildRequestQuery(@NotNull List<String> isConstantInitializedRubyQueries) {
        if (isConstantInitializedRubyQueries == null) {
            ContextVariablesCollector.$$$reportNull$$$0(16);
        }
        StringJoiner queriesArrayStringJoiner = new StringJoiner(", ", "[", "]");
        for (String query : isConstantInitializedRubyQueries) {
            queriesArrayStringJoiner.add(query);
        }
        String string = String.valueOf(queriesArrayStringJoiner) + ".map { |query| eval(query)}";
        if (string == null) {
            ContextVariablesCollector.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 10, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyStackFrame";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/ContextVariablesCollector";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyVariable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnConstantsNames";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachConstantInitializedQuery";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isConstantInitializedQueryJoiner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnConstantNamespaceRunningList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqnConstantName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isConstantInitializedRubyQueries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/ContextVariablesCollector";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedContextVariables";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidConstants";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRequestQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addVariableNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeRubyVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValidConstants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requestIsConstantsValid";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addIsConstantInitializedQueryPart";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addIsConstantNotClassOrModuleQueryPart";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildRequestQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 10, 17 -> new IllegalStateException(string);
        };
    }

    private record FqnConstant(@NotNull String namespaceName, @NotNull String constantName) {
        @NotNull
        private final String namespaceName;
        @NotNull
        private final String constantName;

        private FqnConstant(@NotNull String namespaceName, @NotNull String constantName) {
            if (namespaceName == null) {
                FqnConstant.$$$reportNull$$$0(0);
            }
            if (constantName == null) {
                FqnConstant.$$$reportNull$$$0(1);
            }
        }

        public static List<FqnConstant> createFqnConstantRunningList(@NotNull String fqnConstantName) {
            if (fqnConstantName == null) {
                FqnConstant.$$$reportNull$$$0(2);
            }
            List fqnNamespaceParts = StringUtil.split((String)fqnConstantName, (String)"::");
            ArrayList<FqnConstant> resultRunningList = new ArrayList<FqnConstant>();
            String firstFqnNamespacePart = (String)fqnNamespaceParts.get(0);
            resultRunningList.add(new FqnConstant("Module", firstFqnNamespacePart));
            StringBuilder accumulator = new StringBuilder(firstFqnNamespacePart);
            for (int i = 1; i < fqnNamespaceParts.size(); ++i) {
                String currentFqnNamespacePart = (String)fqnNamespaceParts.get(i);
                resultRunningList.add(new FqnConstant(accumulator.toString(), currentFqnNamespacePart));
                accumulator.append("::");
                accumulator.append(currentFqnNamespacePart);
            }
            return resultRunningList;
        }

        @NotNull
        public String namespaceName() {
            String string = this.namespaceName;
            if (string == null) {
                FqnConstant.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String constantName() {
            String string = this.constantName;
            if (string == null) {
                FqnConstant.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constantName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqnConstantName";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/ContextVariablesCollector$FqnConstant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/ContextVariablesCollector$FqnConstant";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "namespaceName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "constantName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createFqnConstantRunningList";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

