/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.compiler;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.beforeRun.jrubyc.JRubyCompileBeforeRunTask;
import org.jetbrains.plugins.ruby.ruby.run.configuration.rubyScript.RubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.utils.OSUtil;

public final class JRubyCompilerUtil {
    private static final String JRUBYC = "jrubyc";
    private static final String JRUBY_WINDOWS = "jruby.exe";

    public static void setExecutable(Sdk sdk, GeneralCommandLine cmd) {
        String binPath = RubySdkAdditionalData.getInterpreterDir(sdk);
        String exePath = binPath + File.separator + (SystemInfo.isWindows ? JRUBY_WINDOWS : JRUBYC);
        cmd.setExePath(exePath);
        if (SystemInfo.isWindows) {
            cmd.addParameters(new String[]{"-S", JRUBYC});
        }
    }

    @NotNull
    public static RubyCommandLine createJRubyCompilerCommandLine(@NotNull RubyRunner runner, RubyRunConfiguration rc, JRubyCompileBeforeRunTask task) {
        String options;
        String targetPath;
        if (runner == null) {
            JRubyCompilerUtil.$$$reportNull$$$0(0);
        }
        RubyCommandLine commandLine = new RubyCommandLine(runner, false);
        Sdk sdk = rc.getSdk();
        String wd = PathUtil.getParentPath((String)rc.getScriptPath());
        if (!StringUtil.isEmpty((String)wd)) {
            commandLine.setWorkDirectory(wd);
        }
        JRubyCompilerUtil.setExecutable(sdk, commandLine);
        commandLine.getEnvironment().putAll(JRubyCompilerUtil.getEnvParams(sdk));
        String heapSize = task.getHeapSize();
        if (!StringUtil.isEmpty((String)heapSize)) {
            commandLine.addParameter("-J-Xmx" + heapSize.trim() + "m");
        }
        if (!StringUtil.isEmpty((String)(targetPath = task.getTargetPath()))) {
            commandLine.addParameters(new String[]{"-t", PathUtil.getLocalPath((String)targetPath)});
        }
        if (!(options = task.getAdditionalOptions()).isEmpty()) {
            for (String param : options.split(" ")) {
                commandLine.addParameter(param);
            }
        }
        commandLine.addParameter("--verbose");
        commandLine.addParameter(".");
        RubyCommandLine rubyCommandLine = commandLine;
        if (rubyCommandLine == null) {
            JRubyCompilerUtil.$$$reportNull$$$0(1);
        }
        return rubyCommandLine;
    }

    private static Map<String, String> getEnvParams(Sdk sdk) {
        String PATH_KEY = OSUtil.getPathEnvVariableName();
        String interpreterPath = RubySdkAdditionalData.getInterpreterPathFor(sdk);
        String envPath = PathUtil.getParentPath((String)interpreterPath);
        HashMap<String, String> envMap = new HashMap<String, String>(EnvironmentUtil.getEnvironmentMap());
        String path = (String)envMap.get(PATH_KEY);
        envMap.put(PATH_KEY, OSUtil.appendToPATHenvVariable(path, envPath));
        return envMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/compiler/JRubyCompilerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/compiler/JRubyCompilerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createJRubyCompilerCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createJRubyCompilerCommandLine";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

