/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.Condition;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.KindOfCondition;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.RespondsToCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RCaseStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;

public final class ConditionAnalyzer {
    private ConditionAnalyzer() {
    }

    @Nullable
    public static Condition create(PsiElement condition) {
        if (condition instanceof RCondition) {
            return ConditionAnalyzer.create(RubyPsiUtilCore.getChildByFilter((PsiElement)condition, RPsiElement.class, (int)0));
        }
        if (condition instanceof RCall) {
            RCall commandCall = (RCall)condition;
            PsiElement command = commandCall.getPsiCommand();
            if (command instanceof RReference) {
                RReference reference = (RReference)command;
                RPsiElement receiver2 = reference.getReceiver();
                RPsiElement value = reference.getValue();
                if (value != null && (receiver2 instanceof RIdentifier && ((RIdentifier)receiver2).isLocalVariable() || receiver2 instanceof RField)) {
                    String valueName = value.getText();
                    if ("kind_of?".equals(valueName) || "is_a?".equals(valueName)) {
                        List args = commandCall.getArguments();
                        if (args.size() == 1) {
                            return new KindOfCondition(receiver2, args);
                        }
                    } else if ("respond_to?".equals(valueName)) {
                        String receiverName = receiver2.getText();
                        List args = commandCall.getArguments();
                        if (args.size() == 1) {
                            return new RespondsToCondition(receiverName, reference, args);
                        }
                    }
                }
            }
        } else if (condition instanceof RListOfExpressions) {
            RCaseStatement caseStatement = RCaseStatementNavigator.getByWhenCondition((PsiElement)condition);
            if (caseStatement == null) {
                return null;
            }
            List elements = ((RListOfExpressions)condition).getElements();
            if (ContainerUtil.and((Iterable)elements, it -> it instanceof RConstant || it instanceof RColonReference)) {
                return (Condition)ObjectUtils.doIfNotNull((Object)caseStatement.getExpression(), receiver -> new KindOfCondition((RPsiElement)receiver, elements));
            }
        }
        return null;
    }
}

