/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyVariance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RTypeBase;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public class RSymbolTypeImpl
extends RTypeBase
implements RSymbolType {
    protected final Symbol mySymbol;
    protected final List<Pair<RubyVariance, RType>> myTypeArguments;
    private boolean myTyped;

    public RSymbolTypeImpl(@NotNull Symbol symbol) {
        if (symbol == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(0);
        }
        this(symbol, Collections.emptyList());
    }

    public RSymbolTypeImpl(@NotNull Symbol symbol, @NotNull List<Pair<RubyVariance, RType>> typeArguments) {
        if (symbol == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(1);
        }
        if (typeArguments == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(2);
        }
        this.myTyped = true;
        this.mySymbol = symbol;
        this.myTypeArguments = List.copyOf(typeArguments);
    }

    @NotNull
    public Symbol getSymbol() {
        Symbol symbol = this.mySymbol;
        if (symbol == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(3);
        }
        return symbol;
    }

    @NotNull
    public List<Pair<RubyVariance, RType>> getTypeArguments() {
        List<Pair<RubyVariance, RType>> list = this.myTypeArguments;
        if (list == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public boolean isTyped() {
        return this.myTyped;
    }

    public void setTyped(boolean typed) {
        this.myTyped = typed;
    }

    public void processMembers(@NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Consumer<? super Symbol> consumer) {
        if (filter == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(6);
        }
        SymbolUtil.processMembers(this.getSymbol(), filter, invocationPoint, (Processor<? super Symbol>)((Processor)s -> {
            consumer.accept((Symbol)s);
            return true;
        }));
    }

    @Nullable
    public Symbol getMemberForName(@NotNull String name, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (name == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(8);
        }
        return SymbolUtil.findSymbolInHierarchy(this.mySymbol, name, filter, invocationPoint);
    }

    @NonNls
    @NotNull
    public String toString() {
        String string = this.getName();
        if (string == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String name = this.mySymbol.getFQNWithNesting().getFullPath();
        if (!this.hasTypeArguments()) {
            String string = name;
            if (string == null) {
                RSymbolTypeImpl.$$$reportNull$$$0(10);
            }
            return string;
        }
        String typeArguments = this.myTypeArguments.stream().map(it -> it.second != REmptyType.INSTANCE ? ((RType)it.second).getName() : RBundle.message((String)"editor.expressionTypeProvider.untypedType")).collect(Collectors.joining(", "));
        String string = String.format("%s[%s]", name, typeArguments);
        if (string == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public RSymbolType convertToNotSingletonType() {
        Symbol symbol = this.getSymbol();
        if (symbol instanceof SingletonClassSymbol) {
            RSymbolType rSymbolType = this.createThis(null, ((SingletonClassSymbol)symbol).getOriginSymbol());
            if (rSymbolType == null) {
                RSymbolTypeImpl.$$$reportNull$$$0(12);
            }
            return rSymbolType;
        }
        RSymbolTypeImpl rSymbolTypeImpl = this;
        if (rSymbolTypeImpl == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(13);
        }
        return rSymbolTypeImpl;
    }

    @Nullable
    public RSymbolType convertToSingletonTypeIfPossible() {
        Symbol singletonClassSymbol = this.getSymbol().getSingletonClassSymbol();
        if (singletonClassSymbol == null) {
            return null;
        }
        return this.createThis(null, singletonClassSymbol);
    }

    @Nullable
    public String getPresentableName() {
        String presentableName = RContainerPresentationUtil.getPresentableSymbolName((Symbol)this.mySymbol, (PsiElement)this.mySymbol.getPsiElement());
        if (!this.hasTypeArguments()) {
            return presentableName;
        }
        String typeArguments = this.myTypeArguments.stream().map(it -> it.second != REmptyType.INSTANCE ? ((RType)it.second).getPresentableName() : RBundle.message((String)"editor.expressionTypeProvider.untypedType")).collect(Collectors.joining(", "));
        return String.format("%s[%s]", presentableName, typeArguments);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RSymbolTypeImpl other = (RSymbolTypeImpl)((Object)obj);
        return this.mySymbol.equals(other.mySymbol) && this.myTypeArguments.equals(other.myTypeArguments);
    }

    public int hashCode() {
        return 31 * this.mySymbol.hashCode() + this.myTypeArguments.hashCode();
    }

    @NotNull
    protected <T extends RSymbolTypeImpl> T createThis(@Nullable T initialObject, @NotNull Symbol symbol) {
        if (symbol == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(14);
        }
        Object type = initialObject != null ? initialObject : new RSymbolTypeImpl(symbol);
        ((RSymbolTypeImpl)((Object)type)).setTyped(this.myTyped);
        Object object = type;
        if (object == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(15);
        }
        return (T)object;
    }

    private boolean hasTypeArguments() {
        return ContainerUtil.or(this.myTypeArguments, it -> it.second != REmptyType.INSTANCE);
    }

    @NotNull
    public static RType create(@NotNull Symbol symbol) {
        if (symbol == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(16);
        }
        return RSymbolTypeImpl.create(symbol, Collections.emptyList());
    }

    @NotNull
    public static RType create(@NotNull Symbol symbol, @NotNull List<RType> typeArguments) {
        RType type;
        if (symbol == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(17);
        }
        if (typeArguments == null) {
            RSymbolTypeImpl.$$$reportNull$$$0(18);
        }
        if ((type = RubyTypeProvider.createTypeBySymbolFromProviders((Symbol)symbol, typeArguments)) != null) {
            RType rType = type;
            if (rType == null) {
                RSymbolTypeImpl.$$$reportNull$$$0(19);
            }
            return rType;
        }
        return new RSymbolTypeImpl(symbol, ContainerUtil.map(typeArguments, it -> new Pair((Object)RubyVariance.INVARIANT, it)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 10, 11, 12, 13, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RSymbolTypeImpl";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/impl/RSymbolTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToNotSingletonType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createThis";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMemberForName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createThis";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 10, 11, 12, 13, 15, 19 -> new IllegalStateException(string);
        };
    }
}

