/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.types;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

@FileModifier.SafeTypeForPreview
public class ContextImpl
implements Context {
    public static final ContextImpl INSTANCE = new ContextImpl(Visibility.PUBLIC, Access.INSTANCE);
    public static final ContextImpl INSTANCE_PROTECTED = new ContextImpl(Visibility.PROTECTED, Access.INSTANCE);
    public static final ContextImpl INSTANCE_PRIVATE = new ContextImpl(Visibility.PRIVATE, Access.INSTANCE);
    public static final ContextImpl CLASS = new ContextImpl(Visibility.PUBLIC, Access.CLASS);
    public static final ContextImpl CLASS_PRIVATE = new ContextImpl(Visibility.PRIVATE, Access.CLASS);
    private static final Map<Pair<Visibility, Access>, ContextImpl> ourFactoryMap = new HashMap<Pair<Visibility, Access>, ContextImpl>();
    private final NotNullLazyValue<ContextImpl> myDefaultExtendContext;
    private final NotNullLazyValue<ContextImpl> myDefaultIncludeContext;
    private final NotNullLazyValue<ContextImpl> myDefaultExtendInIncludeContext;
    private final NotNullLazyValue<ContextImpl> myDefaultIncludeSingletonClassContext;
    @NotNull
    protected final Visibility myVisibility;
    @NotNull
    protected final Access myAccess;

    @NotNull
    public static ContextImpl create(@NotNull Visibility visibility, @NotNull Access access) {
        if (visibility == null) {
            ContextImpl.$$$reportNull$$$0(0);
        }
        if (access == null) {
            ContextImpl.$$$reportNull$$$0(1);
        }
        ContextImpl contextImpl = ourFactoryMap.computeIfAbsent((Pair<Visibility, Access>)Pair.create((Object)visibility, (Object)access), pair -> new ContextImpl((Visibility)pair.getFirst(), (Access)pair.getSecond()));
        if (contextImpl == null) {
            ContextImpl.$$$reportNull$$$0(2);
        }
        return contextImpl;
    }

    protected ContextImpl(@NotNull Visibility visibility, @NotNull Access access) {
        if (visibility == null) {
            ContextImpl.$$$reportNull$$$0(3);
        }
        if (access == null) {
            ContextImpl.$$$reportNull$$$0(4);
        }
        this.myVisibility = visibility;
        this.myAccess = access;
        this.myDefaultExtendContext = NotNullLazyValue.lazy(() -> ContextImpl.create(this.myVisibility, this.myAccess.or(Access.INSTANCE)));
        this.myDefaultIncludeContext = NotNullLazyValue.lazy(() -> access.acceptInstance() ? ContextImpl.create(this.myVisibility, this.myAccess) : this.getExtendInIncludeContext());
        this.myDefaultExtendInIncludeContext = NotNullLazyValue.lazy(() -> new ExtendInIncludeContext(this));
        this.myDefaultIncludeSingletonClassContext = NotNullLazyValue.lazy(() -> ContextImpl.create(this.myVisibility, this.myAccess.or(Access.CLASS)));
    }

    public boolean accept(@NotNull Symbol symbol) {
        if (symbol == null) {
            ContextImpl.$$$reportNull$$$0(5);
        }
        for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
            if (!provider.acceptsSymbol(symbol, this)) continue;
            return true;
        }
        if (!this.acceptsMethodVisibility(symbol)) {
            return false;
        }
        Type type = symbol.getType();
        if (type == Type.ALIAS) {
            Symbol aliasTargetSymbol;
            Symbol symbol2 = aliasTargetSymbol = this.myVisibility != Visibility.PRIVATE ? SymbolUtil.getMethodSymbolByAlias(symbol) : null;
            if (aliasTargetSymbol == null) {
                return true;
            }
            if (!this.acceptsMethodVisibility(aliasTargetSymbol)) {
                return false;
            }
            Type aliasTargetType = aliasTargetSymbol.getType();
            return this.myAccess.acceptInstance() && Types.INSTANCE_CONTEXT_TYPES.contains(aliasTargetType) || this.myAccess.acceptClass() && Types.STATIC_CONTEXT_TYPES.contains(aliasTargetType);
        }
        if (Types.FIELDS.contains(type)) {
            return true;
        }
        if (Types.MODULE_OR_CLASS_OR_CONSTANT.contains(type)) {
            return true;
        }
        return this.myAccess.acceptInstance() && Types.INSTANCE_CONTEXT_TYPES.contains(type) || this.myAccess.acceptClass() && Types.STATIC_CONTEXT_TYPES.contains(type);
    }

    private boolean acceptsMethodVisibility(Symbol symbol) {
        if (this.myVisibility != Visibility.PRIVATE && symbol instanceof RMethodSymbol) {
            RMethodSymbol methodSymbol = (RMethodSymbol)symbol;
            return methodSymbol.isSynthetic() || this.myVisibility.accepts(methodSymbol.getVisibility());
        }
        return true;
    }

    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.myVisibility;
        if (visibility == null) {
            ContextImpl.$$$reportNull$$$0(6);
        }
        return visibility;
    }

    @NotNull
    public Access getAccess() {
        Access access = this.myAccess;
        if (access == null) {
            ContextImpl.$$$reportNull$$$0(7);
        }
        return access;
    }

    @NotNull
    public static ContextImpl getContext(@NotNull PsiElement element) {
        if (element == null) {
            ContextImpl.$$$reportNull$$$0(8);
        }
        for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
            ContextImpl context = provider.getAccessContext(element);
            if (context == null) continue;
            ContextImpl contextImpl = context;
            if (contextImpl == null) {
                ContextImpl.$$$reportNull$$$0(9);
            }
            return contextImpl;
        }
        ContextImpl contextImpl = ContextImpl.getPsiContext(element);
        if (contextImpl == null) {
            ContextImpl.$$$reportNull$$$0(10);
        }
        return contextImpl;
    }

    public static ContextImpl getPsiContext(PsiElement element) {
        if (!(element instanceof RPsiElement)) {
            return INSTANCE;
        }
        RElementWithFQN container = Optional.ofNullable(PsiTreeUtil.getStubOrPsiParent((PsiElement)element)).filter(parent -> parent instanceof RPsiElement).map(SymbolUtil::getContextContainer).orElse(null);
        if (container != null && !(container instanceof RContainer)) {
            return RObjectClass.isSingletonFQN((FQN)container.getFQNWithNesting()) ? CLASS : INSTANCE;
        }
        return ContextImpl.getContextByContainer(((RPsiElement)element).getParentContainer());
    }

    @NotNull
    public static ContextImpl getContextByContainer(@Nullable RContainer container) {
        if (container instanceof RClass || container instanceof RModule || ContextImpl.isSingletonMethod(container)) {
            ContextImpl contextImpl = CLASS_PRIVATE;
            if (contextImpl == null) {
                ContextImpl.$$$reportNull$$$0(11);
            }
            return contextImpl;
        }
        ContextImpl contextImpl = INSTANCE_PRIVATE;
        if (contextImpl == null) {
            ContextImpl.$$$reportNull$$$0(12);
        }
        return contextImpl;
    }

    public ContextImpl includeContext(@NotNull Symbol symbol, @Nullable Symbol includeSymbol) {
        if (symbol == null) {
            ContextImpl.$$$reportNull$$$0(13);
        }
        if (includeSymbol instanceof SingletonClassSymbol) {
            return (ContextImpl)this.myDefaultIncludeSingletonClassContext.getValue();
        }
        return (ContextImpl)this.myDefaultIncludeContext.getValue();
    }

    public ContextImpl extendContext(@NotNull Symbol symbol) {
        if (symbol == null) {
            ContextImpl.$$$reportNull$$$0(14);
        }
        return (ContextImpl)this.myDefaultExtendContext.getValue();
    }

    public ContextImpl superclassContext(@NotNull Symbol symbol) {
        if (symbol == null) {
            ContextImpl.$$$reportNull$$$0(15);
        }
        return this;
    }

    public ContextImpl getExtendInIncludeContext() {
        return (ContextImpl)this.myDefaultExtendInIncludeContext.getValue();
    }

    public String toString() {
        return String.valueOf(this.myVisibility) + " " + String.valueOf(this.myAccess);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextImpl context = (ContextImpl)o;
        if (this.myAccess != context.myAccess) {
            return false;
        }
        return this.myVisibility == context.myVisibility;
    }

    public int hashCode() {
        int result = this.myVisibility.hashCode();
        result = 31 * result + this.myAccess.hashCode();
        return result;
    }

    private static boolean isSingletonMethod(@Nullable RContainer container) {
        return container instanceof RSingletonMethod || container instanceof RMethod && container.getParentContainer() instanceof RObjectClass;
    }

    static {
        for (ContextImpl context : Arrays.asList(INSTANCE, INSTANCE_PROTECTED, INSTANCE_PRIVATE, CLASS, CLASS_PRIVATE)) {
            ourFactoryMap.put((Pair<Visibility, Access>)Pair.create((Object)context.getVisibility(), (Object)context.getAccess()), context);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/ContextImpl";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/ContextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextByContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "includeContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extendContext";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "superclassContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static final class ExtendInIncludeContext
    extends ContextImpl {
        private final ContextImpl myBaseContext;

        private ExtendInIncludeContext(ContextImpl baseContext) {
            super(baseContext.getVisibility(), baseContext.getAccess());
            this.myBaseContext = baseContext;
        }

        @Override
        public ContextImpl includeContext(@NotNull Symbol symbol, @Nullable Symbol includeSymbol) {
            if (symbol == null) {
                ExtendInIncludeContext.$$$reportNull$$$0(0);
            }
            return this;
        }

        @Override
        public ContextImpl extendContext(@NotNull Symbol symbol) {
            if (symbol == null) {
                ExtendInIncludeContext.$$$reportNull$$$0(1);
            }
            return this.myBaseContext.extendContext(symbol);
        }

        @Override
        public ContextImpl superclassContext(@NotNull Symbol symbol) {
            if (symbol == null) {
                ExtendInIncludeContext.$$$reportNull$$$0(2);
            }
            return this.myBaseContext.superclassContext(symbol);
        }

        @Override
        public boolean accept(@NotNull Symbol symbol) {
            if (symbol == null) {
                ExtendInIncludeContext.$$$reportNull$$$0(3);
            }
            for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
                if (!provider.acceptsSymbol(symbol, this)) continue;
                return true;
            }
            return Types.MODULE_OR_CLASS_OR_CONSTANT.contains(symbol.getType());
        }

        @Override
        public String toString() {
            return "ExtendInIncludeContext";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "symbol";
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/types/ContextImpl$ExtendInIncludeContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "includeContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extendContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "superclassContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

