/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RubyAliasMethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.FieldSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AliasSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RDocumentationSymbolsHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class SymbolContainerVisitor
extends RubyElementVisitor {
    private final SymbolPsiProcessor myProcessor;
    private final Symbol mySymbol;
    private final PsiElement myInvocationPoint;
    private Ref<Boolean> myResult;

    public SymbolContainerVisitor(SymbolPsiProcessor processor, Symbol symbol, PsiElement invocationPoint) {
        this.myInvocationPoint = invocationPoint;
        this.myResult = new Ref();
        this.myProcessor = processor;
        this.mySymbol = symbol;
    }

    public boolean process(@NotNull PsiElement element) {
        if (element == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(0);
        }
        this.reset();
        element.accept((PsiElementVisitor)this);
        return (Boolean)this.myResult.get();
    }

    public void reset() {
        this.myResult = new Ref((Object)true);
    }

    public boolean getResult() {
        return (Boolean)this.myResult.get();
    }

    private boolean checkName(String symbolName) {
        String name2search = this.myProcessor.getName();
        return name2search != null && !name2search.equals(symbolName);
    }

    public void visitRAliasStatement(@NotNull RAliasStatement rAliasStatement) {
        if (rAliasStatement == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(1);
        }
        ProgressIndicatorProvider.checkCanceled();
        String newName = rAliasStatement.getNewName();
        if (newName == null || this.checkName(newName) || ExtensionsKt.getSymbolDeclaration((PsiElement)rAliasStatement) != null) {
            this.myResult.set((Object)true);
            return;
        }
        RubyAliasMethodNameFakePsiElement element = new RubyAliasMethodNameFakePsiElement(rAliasStatement);
        this.myResult.set((Object)this.myProcessor.process((Symbol)new AliasSymbol((PsiElement)element, newName, rAliasStatement.getOldName(), Type.ALIAS, this.mySymbol)));
    }

    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(2);
        }
        ProgressIndicatorProvider.checkCanceled();
        RubyCallType callType = rCall.getCallType();
        this.myResult.set((Object)callType.process((Processor)this.myProcessor, this.mySymbol, rCall, this.myInvocationPoint));
    }

    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(3);
        }
        ProgressIndicatorProvider.checkCanceled();
        RubyCallType callType = rIdentifier.getCallType();
        this.myResult.set((Object)callType.processRIdentifier((Processor)this.myProcessor, this.mySymbol, rIdentifier, this.myInvocationPoint));
    }

    public void visitRBlockCall(@NotNull RBlockCall blockCall) {
        if (blockCall == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(4);
        }
        this.processDocumentationSymbolsHolder((RDocumentationSymbolsHolder)blockCall);
        blockCall.getCall().accept((PsiElementVisitor)this);
    }

    public void visitRClass(@NotNull RClass rClass) {
        if (rClass == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(5);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.processDocumentationSymbolsHolder((RDocumentationSymbolsHolder)rClass);
        if (!((Boolean)this.myResult.get()).booleanValue()) {
            return;
        }
        this.myResult.set((Object)(this.checkName(rClass.getName()) || this.processIfNotNull(SymbolUtil.getSymbolByContainer((RElementWithFQN)rClass, this.mySymbol)) ? 1 : 0));
    }

    public void visitRModule(@NotNull RModule rModule) {
        if (rModule == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(6);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.processDocumentationSymbolsHolder((RDocumentationSymbolsHolder)rModule);
        if (!((Boolean)this.myResult.get()).booleanValue()) {
            return;
        }
        this.myResult.set((Object)(this.checkName(rModule.getName()) || this.processIfNotNull(SymbolUtil.getSymbolByContainer((RElementWithFQN)rModule, this.mySymbol)) ? 1 : 0));
    }

    public void visitRObjectClass(@NotNull RObjectClass rObjectClass) {
        if (rObjectClass == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(7);
        }
        ProgressIndicatorProvider.checkCanceled();
    }

    public void visitRMethod(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(8);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.myResult.set((Object)(this.checkName(rMethod.getName()) || this.myProcessor.process((Symbol)new RMethodSymbolImpl(rMethod, this.mySymbol)) ? 1 : 0));
    }

    public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
        if (rsMethod == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(9);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.myResult.set((Object)(this.checkName(rsMethod.getName()) || this.myProcessor.process((Symbol)new RMethodSymbolImpl((RMethod)rsMethod, this.mySymbol)) ? 1 : 0));
    }

    public void visitRConstant(@NotNull RConstant rConstant) {
        if (rConstant == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(10);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.myResult.set((Object)(this.checkName(rConstant.getName()) || this.myProcessor.process(new PsiElementSymbol<RConstant>(rConstant, rConstant.getName(), Type.CONSTANT, this.mySymbol)) ? 1 : 0));
    }

    public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
        if (rInstanceVariable == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(11);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.myResult.set((Object)(this.checkName(rInstanceVariable.getName()) || this.myProcessor.process((Symbol)new FieldSymbol(rInstanceVariable, rInstanceVariable.getName(), this.mySymbol)) ? 1 : 0));
    }

    public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
        if (rClassVariable == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(12);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.myResult.set((Object)(this.checkName(rClassVariable.getName()) || this.myProcessor.process(new PsiElementSymbol<RClassVariable>(rClassVariable, rClassVariable.getName(), Type.CLASS_FIELD, this.mySymbol)) ? 1 : 0));
    }

    private void processDocumentationSymbolsHolder(@NotNull RDocumentationSymbolsHolder holder) {
        if (holder == null) {
            SymbolContainerVisitor.$$$reportNull$$$0(13);
        }
        if (this.myProcessor.getName() != null) {
            DocumentationSymbol symbol = (DocumentationSymbol)holder.getDocumentationSymbols().get(this.myProcessor.getName());
            if (symbol != null) {
                this.myResult.set((Object)this.myProcessor.process(symbol.getSyntheticSymbol(this.mySymbol, (RPsiElement)holder, this.myInvocationPoint)));
            }
        } else {
            for (DocumentationSymbol symbol : holder.getDocumentationSymbols().values()) {
                this.myResult.set((Object)this.myProcessor.process(symbol.getSyntheticSymbol(this.mySymbol, (RPsiElement)holder, this.myInvocationPoint)));
                if (((Boolean)this.myResult.get()).booleanValue()) continue;
                return;
            }
        }
    }

    private boolean processIfNotNull(@Nullable Symbol symbol) {
        if (symbol != null) {
            return this.myProcessor.process(symbol);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAliasStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rModule";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rObjectClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rsMethod";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConstant";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rInstanceVariable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClassVariable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/SymbolContainerVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRAliasStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBlockCall";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRObjectClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRMethod";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRSingletonMethod";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRConstant";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRInstanceVariable";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRClassVariable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "processDocumentationSymbolsHolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

