/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemOrderingService;
import org.jetbrains.plugins.ruby.rdoc.DocumentationSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubySymbolsLookupCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolInheritanceInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolPsiCachingProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.LoadPathUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RDocumentationSymbolsHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyClassResolveUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyClassModuleHierarchyIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyInheritanceResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public final class SymbolContainerUtil {
    private static final Pattern STDLIB_ROOT_DIRNAME = Pattern.compile("\\d\\.\\d\\.0");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processOwnChildren(@NotNull SymbolPsiProcessor processor, @NotNull Symbol symbol, @NotNull FQN parentFQN, final @Nullable PsiElement invocationPoint) {
        boolean shouldDisableCaching;
        if (processor == null) {
            SymbolContainerUtil.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            SymbolContainerUtil.$$$reportNull$$$0(1);
        }
        if (parentFQN == null) {
            SymbolContainerUtil.$$$reportNull$$$0(2);
        }
        SymbolContainerVisitor visitor = new SymbolContainerVisitor(processor, symbol, invocationPoint){

            @Override
            public boolean process(@NotNull PsiElement element) {
                RElementWithFQN container;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((container = SymbolUtil.getContextContainer(element)) instanceof PsiFile) || RubyPsiUtil.isInSameFile(element, invocationPoint)) {
                    return super.process(element);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/SymbolContainerUtil$1", "process"));
            }
        };
        Project project = symbol.getProject();
        GlobalSearchScope scope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
        SymbolPsiCachingProcessor symbolCachingProcessor = (SymbolPsiCachingProcessor)ObjectUtils.tryCast((Object)processor, SymbolPsiCachingProcessor.class);
        String name = processor.getName();
        SmartList elements = new SmartList();
        if (name == null) {
            if (!SymbolContainerUtil.processClassModuleChildren(project, parentFQN, scope, (Processor<? super Symbol>)processor, symbol)) {
                return false;
            }
            if (!RubyResolutionIndex.ForCompletion.getInstance().processElements(project, (SearchScope)scope, parentFQN, visitor::process)) {
                return false;
            }
            return RubyResolutionIndex.ForDocumentation.getInstance().processElements(project, (SearchScope)scope, parentFQN, element -> {
                if (!(element instanceof RDocumentationSymbolsHolder)) {
                    return true;
                }
                RDocumentationSymbolsHolder holder = (RDocumentationSymbolsHolder)element;
                for (DocumentationSymbol documentationSymbol : holder.getDocumentationSymbols().values()) {
                    if (processor.process(documentationSymbol.getSyntheticSymbol(symbol, element, invocationPoint))) continue;
                    return false;
                }
                return true;
            });
        }
        FQN fqn = FQN.Builder.concat((FQN)parentFQN, (String)name);
        elements.addAll(SymbolContainerUtil.sortElements(RubyResolutionIndex.getInstance().getElements(project, (SearchScope)scope, fqn), invocationPoint));
        boolean bl = shouldDisableCaching = symbolCachingProcessor != null && !StringUtil.isCapitalized((String)name) && elements.size() > 1;
        if (shouldDisableCaching) {
            symbolCachingProcessor.disableCaching();
        }
        try {
            for (RPsiElement element2 : elements) {
                if (visitor.process((PsiElement)element2)) continue;
                boolean bl2 = false;
                return bl2;
            }
        }
        finally {
            if (shouldDisableCaching) {
                symbolCachingProcessor.enableCaching();
            }
        }
        for (Pair pair : RubyResolutionIndex.findDocumentationSymbol((Project)project, (SearchScope)scope, (FQN)fqn)) {
            DocumentationSymbol documentationSymbol = (DocumentationSymbol)pair.first;
            RPsiElement nestingContext = (RPsiElement)pair.second;
            if (documentationSymbol == null || processor.process(documentationSymbol.getSyntheticSymbol(symbol, nestingContext, invocationPoint))) continue;
            return false;
        }
        return true;
    }

    public static boolean processClassModuleChildren(@NotNull Project project, @NotNull FQN parentFQN, @NotNull GlobalSearchScope scope, @NotNull Processor<? super Symbol> processor, @Nullable Symbol symbol) {
        if (project == null) {
            SymbolContainerUtil.$$$reportNull$$$0(3);
        }
        if (parentFQN == null) {
            SymbolContainerUtil.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            SymbolContainerUtil.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            SymbolContainerUtil.$$$reportNull$$$0(6);
        }
        return RubyClassModuleHierarchyIndex.processChildren((GlobalSearchScope)scope, (String)parentFQN.getFullPath(), (name, type) -> processor.process((Object)new ClassModuleSymbol(project, FQN.Builder.concat((FQN)parentFQN, (String)name), (Type)type, null, symbol)));
    }

    @NotNull
    public static Symbol getSingletonClassSymbol(@NotNull Symbol symbol) {
        if (symbol == null) {
            SymbolContainerUtil.$$$reportNull$$$0(7);
        }
        if (RObjectClass.isSingletonFQN((FQN)symbol.getFQNWithNesting())) {
            Symbol symbol2 = symbol;
            if (symbol2 == null) {
                SymbolContainerUtil.$$$reportNull$$$0(8);
            }
            return symbol2;
        }
        return new SingletonClassSymbol(symbol, (RContainer)ObjectUtils.tryCast((Object)symbol.getPsiElement(), RContainer.class));
    }

    @NotNull
    public static SymbolInheritanceInfo getSymbolInheritanceInfo(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        RubySymbolsLookupCache cache;
        SymbolInheritanceInfo cachedInheritanceInfo;
        if (symbol == null) {
            SymbolContainerUtil.$$$reportNull$$$0(9);
        }
        if ((cachedInheritanceInfo = (cache = RubySymbolsLookupCache.getInstance(symbol.getProject())).getSymbolInheritanceInfo(invocationPoint, symbol)) != null) {
            SymbolInheritanceInfo symbolInheritanceInfo = cachedInheritanceInfo;
            if (symbolInheritanceInfo == null) {
                SymbolContainerUtil.$$$reportNull$$$0(10);
            }
            return symbolInheritanceInfo;
        }
        FQN symbolFQN = symbol.getFQNWithNesting();
        Project project = symbol.getProject();
        GlobalSearchScope scope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
        Collection elements = RubyInheritanceResolutionIndex.getInstance().getElements(project, (SearchScope)scope, symbolFQN);
        SmartList dependencies = new SmartList(symbol.getPsiElement() == null ? elements : SymbolContainerUtil.sortElements(elements, symbol.getPsiElement()));
        Symbol superClassSymbol = (Symbol)ObjectUtils.doIfCast((Object)symbol, ClassModuleSymbol.class, s -> s.getSuperClassSymbol(invocationPoint));
        SmartList prependCalls = new SmartList();
        SmartList includeCalls = new SmartList();
        SmartList extendCalls = new SmartList();
        SmartList dynamicCalls = new SmartList();
        for (RPsiElement element : ContainerUtil.reverse((List)dependencies)) {
            if (!(element instanceof RCall)) continue;
            RCall call = (RCall)element;
            if (RubyCallTypesCore.isPrependCall((RPossibleCall)call)) {
                prependCalls.add(call);
                continue;
            }
            if (RubyCallTypesCore.isIncludeCall((RPossibleCall)call)) {
                includeCalls.add(call);
                continue;
            }
            if (RubyCallTypesCore.isExtendCall((RPossibleCall)call)) {
                extendCalls.add(call);
                continue;
            }
            dynamicCalls.add(call);
        }
        SymbolInheritanceInfo inheritanceInfo = new SymbolInheritanceInfo(superClassSymbol, (List)prependCalls, (List)includeCalls, (List)extendCalls, (List)dynamicCalls);
        cache.registerSymbolInheritanceInfo(invocationPoint, symbol, inheritanceInfo);
        SymbolInheritanceInfo symbolInheritanceInfo = inheritanceInfo;
        if (symbolInheritanceInfo == null) {
            SymbolContainerUtil.$$$reportNull$$$0(11);
        }
        return symbolInheritanceInfo;
    }

    @Nullable
    static Symbol findSuperclass(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolContainerUtil.$$$reportNull$$$0(12);
        }
        FQN symbolFQN = symbol.getFQNWithNesting();
        Project project = symbol.getProject();
        GlobalSearchScope scope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
        Collection elements = RubyInheritanceResolutionIndex.ForSuperClasses.getInstance().getElements(project, (SearchScope)scope, symbolFQN);
        SmartList rClasses = new SmartList(symbol.getPsiElement() == null ? elements : SymbolContainerUtil.sortElements(elements, symbol.getPsiElement()));
        if (!rClasses.isEmpty()) {
            return RubyClassResolveUtil.resolveSuperClassSymbol((RClass)rClasses.get(0), invocationPoint);
        }
        if (symbol.getType() != Type.MODULE && !FQN.same((FQN)symbolFQN, (String)"BasicObject") && !FQN.same((FQN)symbolFQN, (String)"Object")) {
            return SymbolUtil.findConstantByFQN(project, Type.CLASS, CoreFqns.OBJECT, invocationPoint);
        }
        return null;
    }

    @NotNull
    public static <T extends PsiElement> Collection<T> sortElements(@NotNull Collection<T> elements, @Nullable PsiElement invocationPoint) {
        if (elements == null) {
            SymbolContainerUtil.$$$reportNull$$$0(13);
        }
        if (elements.size() <= 1 || invocationPoint == null) {
            Collection<T> collection = elements;
            if (collection == null) {
                SymbolContainerUtil.$$$reportNull$$$0(14);
            }
            return collection;
        }
        VirtualFile originalFile = RubyPsiUtil.getVirtualFileFromElement(invocationPoint);
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)invocationPoint);
        GlobalSearchScope moduleScope = module != null && !module.isDisposed() ? module.getModuleScope(true) : null;
        List<T> result = module != null && !module.isDisposed() ? LoadPathUtil.sortByProcessingOrder(elements, GemOrderingService.getComparator(module).thenComparing(VirtualFile::getName)) : LoadPathUtil.sortByProcessingOrder(elements, Comparator.comparing(VirtualFile::getName));
        Comparator<PsiElement> sortByKind = Comparator.comparingInt(obj -> obj instanceof RCall ? 0 : (obj instanceof RInstanceVariable ? 1 : 2));
        Comparator<PsiElement> sortByScope = Comparator.comparing(RubyPsiUtil::getVirtualFileFromElement, Comparator.nullsLast((first, second) -> {
            if (first.equals(originalFile) || second.equals(originalFile)) {
                return Boolean.compare(second.equals(originalFile), first.equals(originalFile));
            }
            return moduleScope != null ? Boolean.compare(moduleScope.accept(second), moduleScope.accept(first)) : 0;
        }));
        List list = ContainerUtil.sorted(result, sortByKind.thenComparing(sortByScope));
        if (list == null) {
            SymbolContainerUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static <T extends PsiElement> List<T> siftUpMainDeclarations(@NotNull FQN symbolFQN, @NotNull Collection<T> declarations) {
        if (symbolFQN == null) {
            SymbolContainerUtil.$$$reportNull$$$0(16);
        }
        if (declarations == null) {
            SymbolContainerUtil.$$$reportNull$$$0(17);
        }
        return SymbolContainerUtil.siftUpMainDeclarations(symbolFQN, declarations, Function.identity());
    }

    @NotNull
    public static <T> List<T> siftUpMainDeclarations(@NotNull FQN symbolFQN, @NotNull Collection<T> declarations, @NotNull Function<T, ? extends PsiElement> keyExtractor) {
        if (symbolFQN == null) {
            SymbolContainerUtil.$$$reportNull$$$0(18);
        }
        if (declarations == null) {
            SymbolContainerUtil.$$$reportNull$$$0(19);
        }
        if (keyExtractor == null) {
            SymbolContainerUtil.$$$reportNull$$$0(20);
        }
        List list = declarations.stream().map(decl -> Pair.create((Object)decl, (Object)SymbolContainerUtil.getDeclarationScore(symbolFQN, (PsiElement)keyExtractor.apply(decl)))).sorted(Pair.comparingBySecond()).map(pair -> pair.getFirst()).collect(Collectors.toList());
        if (list == null) {
            SymbolContainerUtil.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static int getDeclarationScore(@NotNull FQN symbolFQN, @NotNull PsiElement element) {
        String dirName;
        if (symbolFQN == null) {
            SymbolContainerUtil.$$$reportNull$$$0(22);
        }
        if (element == null) {
            SymbolContainerUtil.$$$reportNull$$$0(23);
        }
        VirtualFile containingFile = element.getContainingFile().getVirtualFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        for (String fqnPart : ContainerUtil.reverse((List)symbolFQN.asList())) {
            if (containingFile == null) break;
            if (fqnPart.equals(NamingConventions.toCamelCase((String)containingFile.getNameWithoutExtension(), (Module)module))) {
                containingFile = containingFile.getParent();
                continue;
            }
            containingFile = null;
        }
        int score = 0;
        if (containingFile != null && ("lib".equals(dirName = containingFile.getName()) || dirName.startsWith("rubystubs") || STDLIB_ROOT_DIRNAME.matcher(dirName).matches() || containingFile.getParent() != null && "app".equals(containingFile.getParent().getName()))) {
            score -= 10;
        }
        if (element instanceof RClass && ((RClass)element).getSuperClassFQN() != null) {
            --score;
        }
        return score;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10, 11, 14, 15, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFQN";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/SymbolContainerUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolFQN";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyExtractor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/SymbolContainerUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingletonClassSymbol";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolInheritanceInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "sortElements";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "siftUpMainDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processOwnChildren";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processClassModuleChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSingletonClassSymbol";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 21: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolInheritanceInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findSuperclass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "siftUpMainDeclarations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationScore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10, 11, 14, 15, 21 -> new IllegalStateException(string);
        };
    }
}

