/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.erb.psi.impl.ErbFileImpl;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.ImplicitRequireProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FQNCache;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.REmbeddedTopLevelContainerImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiFileBase;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;

public final class LoadPathUtil {
    private LoadPathUtil() {
    }

    public static Collection<VirtualFile> getLoadPath(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            LoadPathUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            LoadPathUtil.$$$reportNull$$$0(1);
        }
        ArrayList<VirtualFile> loadpath = new ArrayList<VirtualFile>();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        LoadPathUtil.appendExplicitLoadPath(loadpath, module);
        for (ImplicitRequireProvider provider : ImplicitRequireProvider.EP_NAME.getExtensionList()) {
            Collection<VirtualFile> files = provider.getLoadPath(module, virtualFile);
            loadpath.addAll(files);
        }
        loadpath.add(LocalFileSystem.getInstance().findFileByPath(Objects.requireNonNull(project.getBasePath())));
        Sdk sdk = LoadPathUtil.findSdkForBuiltInSymbol(virtualFile, project);
        if (sdk != null) {
            Collections.addAll(loadpath, RubySdkUtil.getSdkRootsWithAllGems(sdk, project));
        }
        return loadpath;
    }

    public static void appendExplicitLoadPath(Collection<? super VirtualFile> loadpath, Module module) {
        RSupportPerModuleSettings settings;
        if (module != null && (settings = RModuleUtil.getInstance().getRubyModuleSettings(module)) != null) {
            for (String path : settings.getLoadPaths()) {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                if (file == null && ApplicationManager.getApplication().isUnitTestMode()) {
                    file = TempFileSystem.getInstance().findFileByPath(path);
                }
                if (file == null) continue;
                loadpath.add((VirtualFile)file);
            }
        }
    }

    @Nullable
    public static Sdk findSdkForBuiltInSymbol(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Module module;
        if (virtualFile == null) {
            LoadPathUtil.$$$reportNull$$$0(2);
        }
        if (project == null) {
            LoadPathUtil.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project)) != null) {
            return RModuleUtil.getInstance().findRubySdkForModule(module);
        }
        List entriesForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
        for (OrderEntry orderEntry : entriesForFile) {
            if (orderEntry instanceof JdkOrderEntry) {
                Sdk sdk = ((JdkOrderEntry)orderEntry).getJdk();
                if (!RubySdkUtil.isRubySDK(sdk)) continue;
                return sdk;
            }
            for (RubySupportProvider provider : RubySupportProvider.EP_NAME.getExtensionList()) {
                Sdk sdk = provider.findRubySdkFromOrderEntry(orderEntry);
                if (!RubySdkUtil.isRubySDK(sdk)) continue;
                return sdk;
            }
        }
        return RubySdkUtil.findRubySdk(project);
    }

    @Nullable
    public static VirtualFile getBuiltinFile(@NotNull Sdk sdk) {
        if (sdk == null) {
            LoadPathUtil.$$$reportNull$$$0(4);
        }
        String stubsFolder = RubySdkUtil.getStubsFolderName(sdk);
        String builtinName = ((RubySdkType)sdk.getSdkType()).getBuiltinsName();
        for (VirtualFile root : RubySdkUtil.getSdkRoots(sdk)) {
            VirtualFile builtin;
            if (!root.getName().equals(stubsFolder) || (builtin = root.findChild(builtinName)) == null || !builtin.isValid()) continue;
            return builtin;
        }
        return null;
    }

    public static <T extends PsiElement> List<T> sortByProcessingOrder(@NotNull Collection<? extends T> elements, @NotNull Comparator<? super VirtualFile> comparator) {
        if (elements == null) {
            LoadPathUtil.$$$reportNull$$$0(5);
        }
        if (comparator == null) {
            LoadPathUtil.$$$reportNull$$$0(6);
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        if (elements.size() == 1) {
            return Collections.singletonList((PsiElement)elements.iterator().next());
        }
        Map elementsGroupedByFile = StreamEx.of(elements).groupingBy(element -> element.getContainingFile().getVirtualFile());
        return ((StreamEx)StreamEx.of(elementsGroupedByFile.keySet()).sorted(comparator)).flatMap(file -> ((List)elementsGroupedByFile.get(file)).stream().sorted(RubyPsiUtil.getRelativePositionComparator())).toList();
    }

    public static boolean isLoadPathRoot(PsiElement element) {
        RSupportPerModuleSettings settings;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && RModuleUtil.getInstance().hasRubySupport(module) && (settings = RModuleUtil.getInstance().getRubyModuleSettings(module)) != null) {
            for (String path : settings.getLoadPaths()) {
                if (!path.equals(((PsiDirectory)element).getVirtualFile().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public static void invalidateRubyCaches(@Nullable Project project) {
        if (project != null && !project.isDisposed()) {
            ApplicationManager.getApplication().assertWriteIntentLockAcquired();
            PsiManager.getInstance((Project)project).dropResolveCaches();
            FQNCache.getInstance(project).clearEverything();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
            ProjectView.getInstance((Project)project).refresh();
        }
    }

    public static @NotNull Collection<@Nullable VirtualFile> getLoadPath(@NotNull RTopLevelContainer topLevelContainer) {
        if (topLevelContainer == null) {
            LoadPathUtil.$$$reportNull$$$0(7);
        }
        if (topLevelContainer instanceof RPsiFileBase) {
            VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)topLevelContainer);
            Collection<VirtualFile> collection = virtualFile != null ? LoadPathUtil.getLoadPath(virtualFile, topLevelContainer.getProject()) : Collections.emptyList();
            if (collection == null) {
                LoadPathUtil.$$$reportNull$$$0(8);
            }
            return collection;
        }
        if (topLevelContainer instanceof REmbeddedTopLevelContainerImpl) {
            REmbeddedTopLevelContainerImpl container = (REmbeddedTopLevelContainerImpl)topLevelContainer;
            VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)container.getContainingFile());
            Collection<VirtualFile> collection = virtualFile != null ? LoadPathUtil.getLoadPath(virtualFile, container.getProject()) : Collections.emptyList();
            if (collection == null) {
                LoadPathUtil.$$$reportNull$$$0(9);
            }
            return collection;
        }
        if (topLevelContainer instanceof ErbFileImpl) {
            ErbFileImpl erbFile = (ErbFileImpl)topLevelContainer;
            return LoadPathUtil.getLoadPath((RTopLevelContainer)erbFile.getInnerRubyFile());
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            LoadPathUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelContainer";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/LoadPathUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/LoadPathUtil";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoadPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findSdkForBuiltInSymbol";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortByProcessingOrder";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

