/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PresentableLegacySymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.TypedSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RSymbolTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.classes.RClassBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyAnonymousDefiningCallIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.ClassModuleCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.InstanceEvalExecCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;

public final class AnonymousClassModuleSymbol
extends ClassModuleSymbol
implements TypedSymbol,
PresentableLegacySymbol {
    private static final char SUPERCLASS_DELIMITER = '<';
    private static final String SYMBOL_DELIMITER = "!!";
    @Nullable
    private String myPresentableName;
    @Nullable
    private final RPossibleCall myProducingCall;

    public AnonymousClassModuleSymbol(@NotNull Project project, @NotNull FQN fqn, @NotNull RBlockCall producingCall) {
        if (project == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(0);
        }
        if (fqn == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(1);
        }
        if (producingCall == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(2);
        }
        this(project, fqn, AnonymousClassModuleSymbol.getParentSymbol((RPossibleCall)producingCall, fqn), (RPossibleCall)producingCall);
    }

    private AnonymousClassModuleSymbol(@NotNull Project project, @NotNull FQN fqn, @Nullable Symbol parent, @Nullable RPossibleCall producingCall) {
        if (project == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(3);
        }
        if (fqn == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(4);
        }
        super(project, fqn, AnonymousDefiningCallType.getFQNType((FQN)fqn), null, parent);
        this.myProducingCall = producingCall;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        return Objects.equals(this.myProducingCall, ((AnonymousClassModuleSymbol)((Object)o)).myProducingCall);
    }

    @NotNull
    public RType getType(@NotNull Context context) {
        if (context == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(5);
        }
        if (this.myProducingCall == null) {
            RType rType = RSymbolTypeImpl.create((Symbol)this);
            if (rType == null) {
                AnonymousClassModuleSymbol.$$$reportNull$$$0(6);
            }
            return rType;
        }
        if (RubyCallTypesCore.isInstanceEvalOrInstanceExec((RubyCallType)this.myProducingCall.getCallType())) {
            StubBasedPsiElement stubBased;
            RPossibleCall rPossibleCall;
            List names = (List)this.myProducingCall.getData(new RubyCallType[]{(InstanceEvalExecCallType)this.myProducingCall.getCallType()});
            if (names.size() > 1) {
                Symbol receiver;
                FQN receiverName = (FQN)names.get(1);
                RContainer container = this.myProducingCall.getParentContainer();
                Symbol containerSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)container);
                if (container != null && containerSymbol != null && (receiver = SymbolUtil.lookupConstant(containerSymbol, (RPsiElement)container, receiverName, Types.MODULE_OR_CLASS_OR_CONSTANT, (PsiElement)this.myProducingCall)) != null) {
                    RType symbolType = RSymbolTypeImpl.create(receiver);
                    RType rType = receiver.getType() == Type.CONSTANT ? symbolType : RTypeFactory.createModuleOrClassType(receiver.getType(), this.myProject, symbolType);
                    if (rType == null) {
                        AnonymousClassModuleSymbol.$$$reportNull$$$0(7);
                    }
                    return rType;
                }
            }
            if ((rPossibleCall = this.myProducingCall) instanceof StubBasedPsiElement && (stubBased = (StubBasedPsiElement)rPossibleCall).getStub() == null) {
                RType rType = RTypeUtil.getType((PsiElement)this.myProducingCall.getReceiver());
                if (rType == null) {
                    AnonymousClassModuleSymbol.$$$reportNull$$$0(8);
                }
                return rType;
            }
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                AnonymousClassModuleSymbol.$$$reportNull$$$0(9);
            }
            return rEmptyType;
        }
        RType rType = RSymbolTypeImpl.create((Symbol)this);
        if (rType == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(10);
        }
        return rType;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + (this.myProducingCall != null ? this.myProducingCall.hashCode() : 0);
    }

    @NotNull
    private static String computePresentableName(@Nullable RPossibleCall producingCall) {
        if (producingCall == null) {
            return "anonymous";
        }
        RubyCallType callType = producingCall.getCallType();
        String string = callType instanceof ClassModuleCallType ? ((ClassModuleCallType)callType).getPresentationName() : callType.getCommandName();
        if (string == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public Symbol getSuperClassSymbol(@Nullable PsiElement invocationPoint) {
        FQN fqn = AnonymousClassModuleSymbol.getSuperclassFromFQN(this.getFQNWithNesting());
        RElementWithFQN container = this.getParentContainer();
        Symbol context = SymbolUtil.getSymbolByContainer(container);
        Symbol superclassSymbol = container != null && context != null ? SymbolUtil.resolveConstantFQN(context, (RPsiElement)container, fqn, Type.CLASS.asSet(), invocationPoint) : SymbolUtil.findConstantByFQN(this.myProject, Type.CLASS, fqn, invocationPoint);
        if (superclassSymbol == null || SymbolUtil.getClassTypes().contains(superclassSymbol.getType())) {
            return superclassSymbol;
        }
        return SymbolUtil.findConstantByFQN(this.getProject(), Type.CLASS, RClassBase.OBJECT_FQN, invocationPoint);
    }

    @NotNull
    public String getPresentableName(@Nullable PsiElement invocationPoint) {
        if (this.myPresentableName == null) {
            RPossibleCall possibleCall = this.myProducingCall == null ? AnonymousClassModuleSymbol.getProducingCall(this.myProject, this.getFQNWithNesting(), invocationPoint) : this.myProducingCall;
            this.myPresentableName = AnonymousClassModuleSymbol.computePresentableName(possibleCall);
        }
        String string = this.myPresentableName;
        if (string == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public RElementWithFQN getParentContainer() {
        if (this.myProducingCall == null) {
            return null;
        }
        RContainer container = (RContainer)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this.myProducingCall, RContainer.class);
        if (container == null) {
            return null;
        }
        if (container instanceof RClass) {
            RClass clazz = (RClass)container;
            if (this.getFQNWithNesting().equals(clazz.getSuperClassFQN())) {
                return (RElementWithFQN)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)clazz, RContainer.class);
            }
        }
        return container;
    }

    @NotNull
    public static AnonymousClassModuleSymbol create(@NotNull Project project, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(13);
        }
        if (fqn == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(14);
        }
        RPossibleCall producingCall = AnonymousClassModuleSymbol.getProducingCall(project, fqn, invocationPoint);
        return new AnonymousClassModuleSymbol(project, fqn, AnonymousClassModuleSymbol.getParentSymbol(producingCall, fqn), producingCall);
    }

    @NotNull
    public static FQN createFQNWithSuperclass(@NotNull FQN origin, @NotNull FQN superclass) {
        if (origin == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(15);
        }
        if (superclass == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(16);
        }
        if (superclass == FQN.INVALID) {
            FQN fQN = origin;
            if (fQN == null) {
                AnonymousClassModuleSymbol.$$$reportNull$$$0(17);
            }
            return fQN;
        }
        SmartList components = new SmartList((Collection)origin.asList());
        if (components.isEmpty()) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                AnonymousClassModuleSymbol.$$$reportNull$$$0(18);
            }
            return fQN;
        }
        String superclassSerialized = StreamEx.of((Stream)superclass.asStream()).joining((CharSequence)SYMBOL_DELIMITER);
        components.set(components.size() - 1, (String)components.get(components.size() - 1) + "<" + superclassSerialized);
        FQN fQN = FQN.Builder.create((List)components, (boolean)origin.isToplevel());
        if (fQN == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(19);
        }
        return fQN;
    }

    @NotNull
    public static FQN getSuperclassFromFQN(@NotNull FQN fqn) {
        String path;
        int i;
        if (fqn == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(20);
        }
        if ((i = (path = fqn.getFullPath()).indexOf(60)) == -1) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                AnonymousClassModuleSymbol.$$$reportNull$$$0(21);
            }
            return fQN;
        }
        FQN fQN = FQN.Builder.create((List)StringUtil.split((String)path.substring(i + 1), (String)SYMBOL_DELIMITER), (boolean)true);
        if (fQN == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(22);
        }
        return fQN;
    }

    @Nullable
    private static RPossibleCall getProducingCall(@NotNull Project project, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(23);
        }
        if (fqn == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(24);
        }
        GlobalSearchScope searchScope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
        return (RPossibleCall)ReadAction.compute(() -> AnonymousClassModuleSymbol.lambda$getProducingCall$0(project, (SearchScope)searchScope, fqn));
    }

    @Nullable
    private static Symbol getParentSymbol(@Nullable RPossibleCall producingCall, @NotNull FQN fqn) {
        if (fqn == null) {
            AnonymousClassModuleSymbol.$$$reportNull$$$0(25);
        }
        if (fqn.getCallerFQN() == FQN.INVALID) {
            return null;
        }
        return SymbolUtil.getSymbolByContainer((RElementWithFQN)ObjectUtils.tryCast((Object)RubyPsiUtilCore.getParentNamespace((PsiElement)producingCall), RContainer.class));
    }

    private static /* synthetic */ RPossibleCall lambda$getProducingCall$0(Project project, SearchScope searchScope, FQN fqn) throws RuntimeException {
        return (RPossibleCall)RubyAnonymousDefiningCallIndex.getInstance().findElement(project, searchScope, fqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10, 11, 12, 17, 18, 19, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 14: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producingCall";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/AnonymousClassModuleSymbol";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superclass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/AnonymousClassModuleSymbol";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createFQNWithSuperclass";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperclassFromFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFQNWithSuperclass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclassFromFQN";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProducingCall";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getParentSymbol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10, 11, 12, 17, 18, 19, 21, 22 -> new IllegalStateException(string);
        };
    }
}

