/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util;

import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.codeInsight.RailsCallTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.MethodMissingProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolMixinsProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubySymbolsLookupCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolInheritanceInfo;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolWithImplicitMixins;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.ResolveAncestor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolCachingProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolPsiCachingProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ScopeSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyAnonymousDefiningCallIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyIncludedExtendedFQNIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypesCore;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public final class SymbolHierarchy {
    private static final Logger LOG = Logger.getInstance(SymbolHierarchy.class);
    private static final FQN CONCERN_FQN = FQN.Builder.fromString((String)"ActiveSupport::Concern");
    private static final FQN CONCERN_SHORT_FQN = FQN.Builder.fromString((String)"Concern");
    private static final Map<Pair<Symbol, PsiElement>, CompletableFuture<List<ResolveAncestor>>> CURRENT_COMPUTATIONS = new ConcurrentHashMap<Pair<Symbol, PsiElement>, CompletableFuture<List<ResolveAncestor>>>();

    SymbolHierarchy() {
    }

    public static boolean processSymbolChildren(@NotNull Symbol symbol, @NotNull SymbolProcessor processor) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            SymbolHierarchy.$$$reportNull$$$0(1);
        }
        Symbol guardObject = symbol instanceof ScopeSymbol ? ((ScopeSymbol)symbol).getFQN() : symbol;
        Boolean result = (Boolean)RecursionManager.doPreventingRecursion((Object)guardObject, (boolean)false, () -> SymbolHierarchy.processSymbolChildrenInner(symbol, processor));
        return result == null || result != false;
    }

    public static boolean isInheritor(@NotNull Symbol symbol, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(2);
        }
        if (fqn == null) {
            SymbolHierarchy.$$$reportNull$$$0(3);
        }
        if (symbol instanceof ClassModuleSymbol) {
            RubySymbolsLookupCache cache = RubySymbolsLookupCache.getInstance(symbol.getProject());
            Boolean isInheritor = cache.isInheritor(invocationPoint, symbol, fqn.getFullPath());
            if (isInheritor != null) {
                return isInheritor;
            }
            if (!((ClassModuleSymbol)symbol).processSuperClassSymbols((Processor<? super Symbol>)((Processor)it -> !it.getFQNWithNesting().equals(fqn)), invocationPoint, true)) {
                cache.registerIsInheritor(invocationPoint, symbol, fqn.getFullPath(), true);
                return true;
            }
            cache.registerIsInheritor(invocationPoint, symbol, fqn.getFullPath(), false);
        }
        return false;
    }

    private static boolean processSymbolChildrenInner(@NotNull Symbol symbol, @NotNull SymbolProcessor symbolProcessor) {
        Symbol classSymbol;
        Symbol originSymbol;
        Type symbolType;
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(4);
        }
        if (symbolProcessor == null) {
            SymbolHierarchy.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        PsiElement invocationPoint = symbolProcessor.getInvocationPoint();
        List<ResolveAncestor> ancestors = SymbolHierarchy.getAncestorsCaching(symbol, invocationPoint);
        if (!SymbolHierarchy.processChildren(symbolProcessor, ancestors)) {
            return false;
        }
        Project project = symbol.getProject();
        if (symbol instanceof SingletonClassSymbol && ((symbolType = (originSymbol = ((SingletonClassSymbol)symbol).getOriginSymbol()).getType()) == Type.MODULE || symbolType == Type.CLASS) && (classSymbol = SymbolUtil.findConstantByFQN(project, Type.CLASS, FQN.Builder.fromString((String)(symbolType == Type.CLASS ? "Class" : "Module")), null)) != null && !SymbolHierarchy.processChildren(symbolProcessor, SymbolHierarchy.getAncestorsCaching(classSymbol, invocationPoint))) {
            return false;
        }
        for (ResolveAncestor ancestor : Lists.reverse(ancestors)) {
            Symbol delegate = MethodMissingProvider.getDelegateSymbolFromProviders(ancestor.getSymbol(), symbol);
            if (delegate == null) continue;
            if (SymbolHierarchy.processSymbolChildren(delegate, symbolProcessor)) break;
            return false;
        }
        return true;
    }

    private static boolean processChildren(SymbolProcessor symbolProcessor, List<ResolveAncestor> ancestors) {
        PsiElement invocationPoint = symbolProcessor.getInvocationPoint();
        for (ResolveAncestor entry : Lists.reverse(ancestors)) {
            boolean isNamePresent;
            RubySymbolsLookupCache cache = RubySymbolsLookupCache.getInstance(entry.getSymbol().getProject());
            String name = symbolProcessor.getName();
            boolean bl = isNamePresent = name != null && !symbolProcessor.ignoreLookupCache();
            if (isNamePresent) {
                Symbol success = cache.getMatchedSymbolByName(invocationPoint, entry.getSymbol(), symbolProcessor.getName());
                if (success != null && !symbolProcessor.process(success)) {
                    LOG.debug("Cache HIT for symbol lookup \"", new Object[]{name, "\" in ", entry.getSymbol()});
                    return false;
                }
                if (cache.isNotFound(invocationPoint, entry.getSymbol(), name)) continue;
            }
            final SymbolProcessor cachingProcessor = isNamePresent ? new SymbolCachingProcessor(symbolProcessor, entry.getSymbol(), cache, invocationPoint) : symbolProcessor;
            SymbolPsiCachingProcessor psiProcessor = new SymbolPsiCachingProcessor(){

                public String getName() {
                    return cachingProcessor.getName();
                }

                public boolean process(@NotNull Symbol symbol) {
                    if (symbol == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return cachingProcessor.process(symbol);
                }

                @Override
                public void disableCaching() {
                    if (isNamePresent) {
                        ((SymbolCachingProcessor)cachingProcessor).disableCaching();
                    }
                }

                @Override
                public void enableCaching() {
                    if (isNamePresent) {
                        ((SymbolCachingProcessor)cachingProcessor).enableCaching();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/SymbolHierarchy$1", "process"));
                }
            };
            if (!entry.getSymbol().processChildren((SymbolPsiProcessor)psiProcessor, invocationPoint)) {
                return false;
            }
            SymbolInheritanceInfo info = entry.getSymbolInheritanceInfo();
            for (RCall dynamicCall : info.getDynamicCalls()) {
                if (dynamicCall.getCallType().process((Processor)psiProcessor, entry.getSymbol(), dynamicCall, invocationPoint)) continue;
                return false;
            }
            if (!isNamePresent || !cachingProcessor.isSymbolNotFound()) continue;
            cache.registerNotFoundName(invocationPoint, entry.getSymbol(), name);
        }
        return true;
    }

    @NotNull
    public static List<ResolveAncestor> getAncestorsCaching(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        LOG.debug("Processing symbol: ", new Object[]{symbol});
        RubySymbolsLookupCache cache = RubySymbolsLookupCache.getInstance(symbol.getProject());
        List ancestors = cache.getAncestors(invocationPoint, symbol);
        if (ancestors != null) {
            List list = ancestors;
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(7);
            }
            return list;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Pair key = Pair.create((Object)symbol, (Object)invocationPoint);
        ancestors = (List)RecursionManager.doPreventingRecursion((Object)key, (boolean)false, () -> SymbolHierarchy.computeAncestors((Pair<Symbol, PsiElement>)key));
        if (ancestors == null) {
            List<ResolveAncestor> list = Collections.emptyList();
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(8);
            }
            return list;
        }
        if (stamp.mayCacheNow()) {
            cache.registerAncestors(invocationPoint, symbol, ancestors);
        }
        List list = ancestors;
        if (list == null) {
            SymbolHierarchy.$$$reportNull$$$0(9);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static List<ResolveAncestor> computeAncestors(@NotNull @NotNull Pair<@NotNull Symbol, @Nullable PsiElement> key) {
        if (key == null) {
            SymbolHierarchy.$$$reportNull$$$0(10);
        }
        Symbol symbol = (Symbol)key.first;
        PsiElement contextElement = (PsiElement)key.second;
        SlowOperations.assertSlowOperationsAreAllowed();
        CompletableFuture<List<ResolveAncestor>> newFuture = new CompletableFuture<List<ResolveAncestor>>();
        CompletableFuture future = CURRENT_COMPUTATIONS.putIfAbsent(key, newFuture);
        if (future != null && !ApplicationManager.getApplication().isDispatchThread()) {
            List list;
            ProgressIndicatorUtils.awaitWithCheckCanceled(future);
            try {
                list = (List)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Exception while waiting for previous computation for " + String.valueOf(symbol) + "; " + String.valueOf(contextElement), (Throwable)e);
                List<ResolveAncestor> list2 = Collections.emptyList();
                if (list2 == null) {
                    SymbolHierarchy.$$$reportNull$$$0(12);
                }
                return list2;
            }
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(11);
            }
            return list;
        }
        List<ResolveAncestor> result = symbol instanceof TopLevelSymbolImpl ? SymbolHierarchy.getAncestorsForToplevel(symbol, contextElement) : SymbolHierarchy.getAncestors(symbol, contextElement);
        newFuture.complete(result);
        List<ResolveAncestor> list = result;
        List<ResolveAncestor> list3 = list;
        if (list3 == null) {
            SymbolHierarchy.$$$reportNull$$$0(13);
        }
        return list3;
        finally {
            CURRENT_COMPUTATIONS.remove(key);
            if (!newFuture.isDone()) {
                newFuture.complete(Collections.emptyList());
            }
        }
    }

    @NotNull
    private static List<ResolveAncestor> getAncestorsForToplevel(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(14);
        }
        Symbol singletonClassSymbol = symbol.getSingletonClassSymbol();
        ArrayList<ResolveAncestor> objectAncestors = new ArrayList<ResolveAncestor>(SymbolHierarchy.getAncestors(symbol, invocationPoint));
        if (singletonClassSymbol == null) {
            ArrayList<ResolveAncestor> arrayList = objectAncestors;
            if (arrayList == null) {
                SymbolHierarchy.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        SymbolHierarchy.forceAddAll(SymbolHierarchy.getAncestors(singletonClassSymbol, invocationPoint), objectAncestors, new HashSet<Symbol>());
        ArrayList<ResolveAncestor> arrayList = objectAncestors;
        if (arrayList == null) {
            SymbolHierarchy.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private static List<ResolveAncestor> getAncestors(Symbol symbol, PsiElement invocationPoint) {
        return SymbolHierarchy.getAncestors(symbol, invocationPoint, new HashSet<Symbol>());
    }

    @NotNull
    private static List<ResolveAncestor> getAncestors(Symbol symbol, PsiElement invocationPoint, @NotNull Set<Symbol> processedAnonymousSymbols) {
        boolean isSingleton;
        if (processedAnonymousSymbols == null) {
            SymbolHierarchy.$$$reportNull$$$0(17);
        }
        HashSet<Symbol> processed = new HashSet<Symbol>();
        SymbolHierarchy.putIfNecessary(symbol, processed);
        ArrayList<ResolveAncestor> result = new ArrayList<ResolveAncestor>();
        SymbolInheritanceInfo info = symbol.getInheritanceInfo(invocationPoint);
        Symbol superClassSymbol = info.getSuperClass();
        if (superClassSymbol != null) {
            SymbolHierarchy.addAll(SymbolHierarchy.getAncestorsFromSuperclass(superClassSymbol, invocationPoint), result, processed);
        }
        if (symbol instanceof SymbolWithImplicitMixins) {
            for (Symbol implicitSuperClasses : ((SymbolWithImplicitMixins)symbol).getImplicitSuperClasses()) {
                SymbolHierarchy.addAll(SymbolHierarchy.getAncestorsCaching(implicitSuperClasses, invocationPoint), result, processed);
            }
        }
        Symbol targetSymbol = !(isSingleton = symbol instanceof SingletonClassSymbol) ? symbol : ((SingletonClassSymbol)symbol).getOriginSymbol();
        SymbolInheritanceInfo targetInheritanceInfo = !isSingleton ? info : targetSymbol.getInheritanceInfo(invocationPoint);
        SymbolHierarchy.addAllIncludeExtendsForSymbol(targetSymbol, targetInheritanceInfo, isSingleton, invocationPoint, processed, result, processedAnonymousSymbols);
        if (isSingleton) {
            SymbolHierarchy.addAllIncludeExtendsForSymbol(symbol, info, false, invocationPoint, processed, result, processedAnonymousSymbols);
        }
        result.add(new ResolveAncestor(symbol, info));
        SymbolHierarchy.addAllPrependsForSymbol(targetSymbol, targetInheritanceInfo, isSingleton, invocationPoint, processed, result);
        if (isSingleton) {
            SymbolHierarchy.addAllPrependsForSymbol(symbol, info, false, invocationPoint, processed, result);
        }
        ArrayList<ResolveAncestor> arrayList = result;
        if (arrayList == null) {
            SymbolHierarchy.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static void addAllPrependsForSymbol(@NotNull Symbol symbol, @NotNull SymbolInheritanceInfo inheritanceInfo, boolean isForSingleton, @Nullable PsiElement invocationPoint, @NotNull Set<Symbol> processed, @NotNull List<ResolveAncestor> result) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(19);
        }
        if (inheritanceInfo == null) {
            SymbolHierarchy.$$$reportNull$$$0(20);
        }
        if (processed == null) {
            SymbolHierarchy.$$$reportNull$$$0(21);
        }
        if (result == null) {
            SymbolHierarchy.$$$reportNull$$$0(22);
        }
        for (RCall prepend : inheritanceInfo.getPrepends()) {
            boolean prependInsideClass;
            Symbol context = SymbolUtil.getScopeContextWithCaching((PsiElement)prepend);
            boolean bl = prependInsideClass = context == null || context.getType() != Type.FILE || !symbol.getFQNWithNesting().equals(CoreFqns.OBJECT);
            if (!prependInsideClass && !RubyPsiUtil.isInSameFile((PsiElement)prepend, invocationPoint)) continue;
            SymbolHierarchy.addAll(SymbolHierarchy.getAncestorsFromIncludeExtend(symbol, symbol, prepend, invocationPoint, isForSingleton), result, processed);
        }
    }

    private static void addAllIncludeExtendsForSymbol(@NotNull Symbol symbol, @NotNull SymbolInheritanceInfo inheritanceInfo, boolean isForSingleton, @Nullable PsiElement invocationPoint, @NotNull Set<Symbol> processed, @NotNull List<ResolveAncestor> result, @NotNull Set<Symbol> processedAnonymousSymbols) {
        SymbolWithImplicitMixins symbolWithImplicitMixins;
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(23);
        }
        if (inheritanceInfo == null) {
            SymbolHierarchy.$$$reportNull$$$0(24);
        }
        if (processed == null) {
            SymbolHierarchy.$$$reportNull$$$0(25);
        }
        if (result == null) {
            SymbolHierarchy.$$$reportNull$$$0(26);
        }
        if (processedAnonymousSymbols == null) {
            SymbolHierarchy.$$$reportNull$$$0(27);
        }
        Symbol resolveContext = !result.isEmpty() ? MultiSymbol.of((Symbol[])((Symbol[])ContainerUtil.map2Array(result, Symbol.class, ResolveAncestor::getSymbol))) : symbol;
        for (RCall includeExtend : ContainerUtil.concat((List)inheritanceInfo.getIncludes(), (List)inheritanceInfo.getExtends())) {
            boolean includeExtendInsideClass;
            Symbol context = SymbolUtil.getScopeContextWithCaching((PsiElement)includeExtend);
            boolean bl = includeExtendInsideClass = context == null || context.getType() != Type.FILE || !symbol.getFQNWithNesting().equals(CoreFqns.OBJECT);
            if (!includeExtendInsideClass && !RubyPsiUtil.isInSameFile((PsiElement)includeExtend, invocationPoint)) continue;
            SymbolHierarchy.addAll(SymbolHierarchy.getAncestorsFromIncludeExtend(symbol, resolveContext, includeExtend, invocationPoint, isForSingleton), result, processed);
        }
        SymbolHierarchy.addAll(SymbolHierarchy.getAncestorsFromAnonymousDefiningCalls(symbol, invocationPoint, isForSingleton, processedAnonymousSymbols), result, processed);
        SymbolHierarchy.addAll(SymbolHierarchy.getAncestorsFromImplicitIncludeExtend(symbol, invocationPoint, isForSingleton), result, processed);
        if (symbol instanceof SymbolWithImplicitMixins && (symbolWithImplicitMixins = (SymbolWithImplicitMixins)symbol).shouldForceAdd()) {
            if (!isForSingleton) {
                SymbolHierarchy.forceAddAll(symbolWithImplicitMixins.getImplicitIncludes().stream().filter(it -> it != null).map(it -> new ResolveAncestor((Symbol)it, it.getInheritanceInfo(invocationPoint))).collect(Collectors.toList()), result, processed);
            } else {
                SymbolHierarchy.forceAddAll(symbolWithImplicitMixins.getImplicitExtends().stream().filter(it -> it != null).map(it -> new ResolveAncestor((Symbol)it, it.getInheritanceInfo(invocationPoint))).collect(Collectors.toList()), result, processed);
            }
        }
    }

    @NotNull
    private static List<ResolveAncestor> getAncestorsFromAnonymousDefiningCalls(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint, boolean isForSingleton, @NotNull Set<Symbol> processedAnonymousSymbols) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(28);
        }
        if (processedAnonymousSymbols == null) {
            SymbolHierarchy.$$$reportNull$$$0(29);
        }
        if (!SymbolUtil.isClassOrModuleSymbol(symbol.getType()) || symbol instanceof AnonymousClassModuleSymbol && processedAnonymousSymbols.contains(symbol)) {
            List<ResolveAncestor> list = Collections.emptyList();
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(30);
            }
            return list;
        }
        SmartList ancestors = new SmartList();
        Project project = symbol.getProject();
        GlobalSearchScope searchScope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
        Collection elements = (Collection)ReadAction.compute(() -> RubyAnonymousDefiningCallIndex.getInstance().getElements(project, (SearchScope)searchScope, symbol.getFQNWithNesting()));
        for (RPossibleCall call : elements) {
            if (!(call instanceof RBlockCall)) continue;
            ancestors.addAll(SymbolHierarchy.processEvalOrExecOrClassContextCall((RPsiElement)call, invocationPoint, isForSingleton));
        }
        SmartList smartList = ancestors;
        if (smartList == null) {
            SymbolHierarchy.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    @NotNull
    private static List<ResolveAncestor> getAncestorsFromImplicitIncludeExtend(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint, boolean isForSingleton) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(32);
        }
        SmartList ancestors = new SmartList();
        for (Symbol symbol2 : RubySymbolMixinsProvider.getAllImplicitIncludes(symbol, invocationPoint)) {
            ancestors.addAll(SymbolHierarchy.processInclude(invocationPoint, symbol2, isForSingleton, true));
        }
        for (Symbol symbol3 : RubySymbolMixinsProvider.getAllImplicitExtends(symbol, invocationPoint)) {
            ancestors.addAll(SymbolHierarchy.processExtend(invocationPoint, symbol3, isForSingleton));
        }
        if (symbol instanceof SymbolWithImplicitMixins) {
            for (Symbol symbol4 : ((SymbolWithImplicitMixins)symbol).getImplicitIncludes()) {
                if (symbol4 == null) continue;
                ancestors.addAll(SymbolHierarchy.processInclude(invocationPoint, symbol4, isForSingleton, true));
            }
            for (Symbol symbol5 : ((SymbolWithImplicitMixins)symbol).getImplicitExtends()) {
                if (symbol5 == null) continue;
                ancestors.addAll(SymbolHierarchy.processExtend(invocationPoint, symbol5, isForSingleton));
            }
        }
        SmartList smartList = ancestors;
        if (smartList == null) {
            SymbolHierarchy.$$$reportNull$$$0(33);
        }
        return smartList;
    }

    private static List<ResolveAncestor> getAncestorsFromSuperclass(@NotNull Symbol superClassSymbol, @Nullable PsiElement invocationPoint) {
        if (superClassSymbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(34);
        }
        return SymbolHierarchy.getAncestorsCaching(superClassSymbol, invocationPoint);
    }

    private static List<ResolveAncestor> getAncestorsFromIncludeExtend(@NotNull Symbol container, @NotNull Symbol context, @NotNull RCall rCall, @Nullable PsiElement invocationPoint, boolean isForSingleton) {
        if (container == null) {
            SymbolHierarchy.$$$reportNull$$$0(35);
        }
        if (context == null) {
            SymbolHierarchy.$$$reportNull$$$0(36);
        }
        if (rCall == null) {
            SymbolHierarchy.$$$reportNull$$$0(37);
        }
        ArrayList<ResolveAncestor> result = new ArrayList<ResolveAncestor>();
        Symbol substitute = SymbolUtil.getScopeContextWithCaching((PsiElement)rCall);
        Symbol symbol = context.equals(substitute) ? substitute : context;
        List names = (List)rCall.getData(RubyCallTypes.INCLUDE_EXTEND_CALLS);
        for (FQN qualifiedName : names) {
            Object includeSymbol;
            if (RubyCallTypes.isIgnoredIncludeExtendArgument((RPossibleCall)rCall, qualifiedName) || SymbolUtil.isAnonymousModule(qualifiedName) || (includeSymbol = RContainerPresentationUtil.isSelf((FQN)qualifiedName) ? (SymbolUtil.getModuleTypes().contains(container.getType()) ? container : null) : SymbolUtil.resolveConstantFQN(symbol, (RPsiElement)rCall, qualifiedName, SymbolUtil.getModuleTypes(), invocationPoint)) == null) continue;
            if (RubyCallTypesCore.isIncludeOrPrependCall((RPossibleCall)rCall)) {
                result.addAll(SymbolHierarchy.processInclude(invocationPoint, includeSymbol, isForSingleton, true));
                continue;
            }
            result.addAll(SymbolHierarchy.processExtend(invocationPoint, includeSymbol, isForSingleton));
        }
        return result;
    }

    @NotNull
    private static List<ResolveAncestor> processInclude(@Nullable PsiElement invocationPoint, @NotNull Symbol includeSymbol, boolean isForSingleton, boolean respectConcern) {
        List<ResolveAncestor> result;
        if (includeSymbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(38);
        }
        List<ResolveAncestor> list = (result = (List<ResolveAncestor>)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)includeSymbol, (Object)respectConcern), (boolean)false, () -> SymbolHierarchy.processIncludeImpl(invocationPoint, includeSymbol, isForSingleton, respectConcern))) != null ? result : Collections.emptyList();
        if (list == null) {
            SymbolHierarchy.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    private static List<ResolveAncestor> processIncludeImpl(@Nullable PsiElement invocationPoint, @NotNull Symbol includeSymbol, boolean isForSingleton, boolean respectConcern) {
        if (includeSymbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(40);
        }
        SmartList result = new SmartList();
        Project project = includeSymbol.getProject();
        if (respectConcern && SymbolHierarchy.isActiveSupportConcernModule(includeSymbol, invocationPoint)) {
            for (ResolveAncestor dependency : SymbolHierarchy.getConcernModuleAndItsDependencies(includeSymbol, invocationPoint, new HashSet<Symbol>())) {
                Symbol classMethodsAnon;
                Symbol classMethods;
                Symbol instanceMethods;
                Symbol dependencySymbol = dependency.getSymbol();
                result.addAll(SymbolHierarchy.processInclude(invocationPoint, dependencySymbol, isForSingleton, false));
                if (!isForSingleton && (instanceMethods = Symbol.getSymbolByFilter((Symbol)dependencySymbol, (Predicate)Symbol.Filter.byName((String)"InstanceMethods").and((Predicate)Symbol.Filter.byType((Type)Type.MODULE)), (PsiElement)invocationPoint)) != null) {
                    result.addAll(SymbolHierarchy.getAncestorsCaching(instanceMethods, invocationPoint));
                }
                if ((classMethods = Symbol.getSymbolByFilter((Symbol)dependencySymbol, (Predicate)Symbol.Filter.byName((String)"ClassMethods").and((Predicate)Symbol.Filter.byType((Type)Type.MODULE)), (PsiElement)invocationPoint)) != null) {
                    result.addAll(SymbolHierarchy.processExtend(invocationPoint, classMethods, isForSingleton));
                }
                if ((classMethodsAnon = SymbolUtil.findConstantByFQN(project, Types.MODULE_OR_CLASS, FQN.Builder.concat((FQN)dependencySymbol.getFQNWithNesting(), (FQN)RailsCallTypeProvider.CLASS_METHODS_FQN), invocationPoint)) == null) continue;
                result.addAll(SymbolHierarchy.processExtend(invocationPoint, classMethodsAnon, isForSingleton));
            }
        } else if (!isForSingleton) {
            result.addAll(SymbolHierarchy.getAncestorsCaching(includeSymbol, invocationPoint));
        }
        GlobalSearchScope searchScope = invocationPoint != null ? invocationPoint.getResolveScope() : GlobalSearchScope.allScope((Project)project);
        Collection members = (Collection)ReadAction.compute(() -> RubyIncludedExtendedFQNIndex.getInstance().getOnIncludedElements(project, (SearchScope)searchScope, includeSymbol.getFQNWithNesting()));
        for (RPsiElement hookedMember : members) {
            if (hookedMember instanceof RCall) {
                result.addAll(SymbolHierarchy.getAncestorsFromIncludeExtend(includeSymbol, includeSymbol, (RCall)hookedMember, invocationPoint, isForSingleton));
                continue;
            }
            if (!(hookedMember instanceof RBlockCall)) continue;
            result.addAll(SymbolHierarchy.processEvalOrExecOrClassContextCall(hookedMember, invocationPoint, isForSingleton));
        }
        SmartList smartList = result;
        if (smartList == null) {
            SymbolHierarchy.$$$reportNull$$$0(41);
        }
        return smartList;
    }

    @NotNull
    private static List<ResolveAncestor> processExtend(@Nullable PsiElement invocationPoint, @NotNull Symbol extendSymbol, boolean isForSingleton) {
        List<ResolveAncestor> result;
        if (extendSymbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(42);
        }
        List<ResolveAncestor> list = (result = (List<ResolveAncestor>)RecursionManager.doPreventingRecursion((Object)new Pair((Object)extendSymbol, (Object)isForSingleton), (boolean)false, () -> SymbolHierarchy.processExtendImpl(invocationPoint, extendSymbol, isForSingleton))) != null ? result : Collections.emptyList();
        if (list == null) {
            SymbolHierarchy.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    private static List<ResolveAncestor> processExtendImpl(@Nullable PsiElement invocationPoint, @NotNull Symbol extendSymbol, boolean isForSingleton) {
        if (extendSymbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(44);
        }
        SmartList result = new SmartList();
        Project project = extendSymbol.getProject();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        if (isForSingleton) {
            result.addAll(SymbolHierarchy.getAncestorsCaching(extendSymbol, invocationPoint));
        }
        Collection elements = (Collection)ReadAction.compute(() -> SymbolHierarchy.lambda$processExtendImpl$11(project, (SearchScope)searchScope, extendSymbol));
        for (RPsiElement hookedMember : elements) {
            if (hookedMember instanceof RCall) {
                result.addAll(SymbolHierarchy.getAncestorsFromIncludeExtend(extendSymbol, extendSymbol, (RCall)hookedMember, invocationPoint, isForSingleton));
                continue;
            }
            if (!(hookedMember instanceof RBlockCall)) continue;
            result.addAll(SymbolHierarchy.processEvalOrExecOrClassContextCall(hookedMember, invocationPoint, isForSingleton));
        }
        SmartList smartList = result;
        if (smartList == null) {
            SymbolHierarchy.$$$reportNull$$$0(45);
        }
        return smartList;
    }

    private static void addAll(@NotNull List<ResolveAncestor> src, @NotNull List<ResolveAncestor> dest, @NotNull Set<Symbol> processed) {
        if (src == null) {
            SymbolHierarchy.$$$reportNull$$$0(46);
        }
        if (dest == null) {
            SymbolHierarchy.$$$reportNull$$$0(47);
        }
        if (processed == null) {
            SymbolHierarchy.$$$reportNull$$$0(48);
        }
        for (ResolveAncestor entry : src) {
            boolean shouldAdd = SymbolHierarchy.putIfNecessary(entry.getSymbol(), processed);
            if (!shouldAdd) continue;
            dest.add(new ResolveAncestor(entry.getSymbol(), entry.getSymbolInheritanceInfo()));
        }
    }

    @NotNull
    private static List<ResolveAncestor> getConcernModuleAndItsDependencies(@NotNull Symbol concernModuleSymbol, @Nullable PsiElement invocationPoint, @NotNull Set<Symbol> processed) {
        if (concernModuleSymbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(49);
        }
        if (processed == null) {
            SymbolHierarchy.$$$reportNull$$$0(50);
        }
        if (processed.contains(concernModuleSymbol)) {
            List<ResolveAncestor> list = Collections.emptyList();
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(51);
            }
            return list;
        }
        assert (SymbolHierarchy.isActiveSupportConcernModule(concernModuleSymbol, invocationPoint));
        SmartList result = new SmartList();
        processed.add(concernModuleSymbol);
        SymbolInheritanceInfo info = concernModuleSymbol.getInheritanceInfo(invocationPoint);
        for (RCall includeCall : ContainerUtil.concat((List)info.getPrepends(), (List)info.getIncludes())) {
            List names = (List)includeCall.getData(RubyCallTypes.INCLUDE_EXTEND_CALLS);
            for (FQN qualifiedName : names) {
                Symbol transitiveIncludeSymbol;
                if (RubyCallTypes.isIgnoredIncludeExtendArgument((RPossibleCall)includeCall, qualifiedName) || SymbolUtil.isAnonymousModule(qualifiedName) || (transitiveIncludeSymbol = SymbolUtil.resolveConstantFQN(concernModuleSymbol, (RPsiElement)includeCall, qualifiedName, SymbolUtil.getModuleTypes(), invocationPoint)) == null || !SymbolHierarchy.isActiveSupportConcernModule(transitiveIncludeSymbol, invocationPoint)) continue;
                result.addAll(SymbolHierarchy.getConcernModuleAndItsDependencies(transitiveIncludeSymbol, invocationPoint, processed));
            }
        }
        result.add((Object)new ResolveAncestor(concernModuleSymbol, info));
        SmartList smartList = result;
        if (smartList == null) {
            SymbolHierarchy.$$$reportNull$$$0(52);
        }
        return smartList;
    }

    private static void forceAddAll(@NotNull List<ResolveAncestor> src, @NotNull List<ResolveAncestor> dest, @NotNull Set<Symbol> processed) {
        if (src == null) {
            SymbolHierarchy.$$$reportNull$$$0(53);
        }
        if (dest == null) {
            SymbolHierarchy.$$$reportNull$$$0(54);
        }
        if (processed == null) {
            SymbolHierarchy.$$$reportNull$$$0(55);
        }
        HashSet<ResolveAncestor> elementsSet = new HashSet<ResolveAncestor>(src);
        dest.removeIf(it -> elementsSet.contains(it));
        for (ResolveAncestor element : src) {
            dest.add(element);
            SymbolHierarchy.putIfNecessary(element.getSymbol(), processed);
        }
    }

    @NotNull
    private static List<ResolveAncestor> processEvalOrExecOrClassContextCall(@Nullable RPsiElement call, @Nullable PsiElement invocationPoint, boolean isForSingleton) {
        RBlockCall blockCall = (RBlockCall)ObjectUtils.tryCast((Object)call, RBlockCall.class);
        if (blockCall == null) {
            List<ResolveAncestor> list = Collections.emptyList();
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(56);
            }
            return list;
        }
        RubyCallType callType = blockCall.getCallType();
        if (!RubyCallTypesCore.isEvalOrExec((RubyCallType)callType) && !RubyCallTypes.hasClassContext((RPossibleCall)blockCall)) {
            List<ResolveAncestor> list = Collections.emptyList();
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(57);
            }
            return list;
        }
        Symbol originalAnonymousSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)blockCall);
        Symbol anonymousSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)blockCall);
        if (RubyCallTypesCore.isInstanceEvalOrInstanceExec((RubyCallType)callType)) {
            if (!isForSingleton) {
                List<ResolveAncestor> list = Collections.emptyList();
                if (list == null) {
                    SymbolHierarchy.$$$reportNull$$$0(58);
                }
                return list;
            }
        } else if (anonymousSymbol != null && isForSingleton) {
            anonymousSymbol = anonymousSymbol.getSingletonClassSymbol();
        }
        if (anonymousSymbol == null) {
            List<ResolveAncestor> list = Collections.emptyList();
            if (list == null) {
                SymbolHierarchy.$$$reportNull$$$0(59);
            }
            return list;
        }
        if (anonymousSymbol instanceof AnonymousClassModuleSymbol) {
            AnonymousClassModuleSymbol anonymousClassModuleSymbol = (AnonymousClassModuleSymbol)anonymousSymbol;
            if (RubyCallTypes.hasClassContext((RPossibleCall)blockCall)) {
                ArrayList<ResolveAncestor> ancestors = new ArrayList<ResolveAncestor>();
                RElementWithFQN container = anonymousClassModuleSymbol.getParentContainer();
                Symbol containerSymbol = SymbolUtil.getSymbolByContainer(container);
                if (containerSymbol == null) {
                    List<ResolveAncestor> list = Collections.emptyList();
                    if (list == null) {
                        SymbolHierarchy.$$$reportNull$$$0(60);
                    }
                    return list;
                }
                if (containerSymbol instanceof ClassModuleSymbol) {
                    ancestors.addAll(SymbolHierarchy.getAncestorsCaching(containerSymbol, invocationPoint));
                }
                Set<Symbol> processedAnonymousSymbols = anonymousSymbol.equals(originalAnonymousSymbol) ? Set.of(anonymousSymbol) : Set.of(anonymousSymbol, Objects.requireNonNull(originalAnonymousSymbol));
                ancestors.addAll(SymbolHierarchy.getAncestors(anonymousSymbol, invocationPoint, processedAnonymousSymbols));
                ArrayList<ResolveAncestor> arrayList = ancestors;
                if (arrayList == null) {
                    SymbolHierarchy.$$$reportNull$$$0(61);
                }
                return arrayList;
            }
        }
        return SymbolHierarchy.getAncestorsCaching(anonymousSymbol, invocationPoint);
    }

    private static boolean isActiveSupportConcernModule(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolHierarchy.$$$reportNull$$$0(62);
        }
        return symbol.getType() == Type.MODULE && symbol.getInheritanceInfo(invocationPoint).getExtends().stream().anyMatch(call -> RubyCallTypesCore.isExtendCall((RPossibleCall)call) && ((List)call.getData(RubyCallTypes.INCLUDE_EXTEND_CALLS)).stream().anyMatch(extendFQN -> CONCERN_FQN.equals(extendFQN) || CONCERN_SHORT_FQN.equals(extendFQN) && symbol.getFQNWithNesting().getFullPath().startsWith("ActiveSupport")));
    }

    private static boolean putIfNecessary(@Nullable Symbol symbol, @NotNull Set<Symbol> processed) {
        if (processed == null) {
            SymbolHierarchy.$$$reportNull$$$0(63);
        }
        if (symbol == null) {
            return false;
        }
        return processed.add(symbol);
    }

    private static /* synthetic */ Collection lambda$processExtendImpl$11(Project project, SearchScope searchScope, Symbol extendSymbol) throws RuntimeException {
        return RubyIncludedExtendedFQNIndex.getInstance().getOnExtendedElements(project, searchScope, extendSymbol.getFQNWithNesting());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11, 12, 13, 15, 16, 18, 30, 31, 33, 39, 41, 43, 45, 51, 52, 56, 57, 58, 59, 60, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolProcessor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 33: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/SymbolHierarchy";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedAnonymousSymbols";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritanceInfo";
                break;
            }
            case 21: 
            case 25: 
            case 48: 
            case 50: 
            case 55: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassSymbol";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeSymbol";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendSymbol";
                break;
            }
            case 46: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "concernModuleSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/SymbolHierarchy";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorsCaching";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAncestors";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorsForToplevel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestors";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorsFromAnonymousDefiningCalls";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorsFromImplicitIncludeExtend";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "processInclude";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "processIncludeImpl";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "processExtend";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "processExtendImpl";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getConcernModuleAndItsDependencies";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "processEvalOrExecOrClassContextCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processSymbolChildrenInner";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorsCaching";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 33: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 51: 
            case 52: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeAncestors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorsForToplevel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAncestors";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addAllPrependsForSymbol";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addAllIncludeExtendsForSymbol";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorsFromAnonymousDefiningCalls";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorsFromImplicitIncludeExtend";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorsFromSuperclass";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAncestorsFromIncludeExtend";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processInclude";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processIncludeImpl";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processExtend";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processExtendImpl";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getConcernModuleAndItsDependencies";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "forceAddAll";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isActiveSupportConcernModule";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "putIfNecessary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11, 12, 13, 15, 16, 18, 30, 31, 33, 39, 41, 43, 45, 51, 52, 56, 57, 58, 59, 60, 61 -> new IllegalStateException(string);
        };
    }
}

