/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubySymbolsLookupCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolDelegateProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;

public class SymbolCachingProcessor
implements SymbolDelegateProcessor {
    private static final Logger LOG = Logger.getInstance(SymbolCachingProcessor.class);
    private final SymbolProcessor mySymbolProcessor;
    @NotNull
    private final Symbol mySymbol;
    private final PsiElement myInvocationPoint;
    private final RubySymbolsLookupCache myCache;
    private boolean isCachingEnabled;

    SymbolCachingProcessor(@NotNull SymbolProcessor symbolProcessor, @NotNull Symbol symbol, @NotNull RubySymbolsLookupCache cache, @Nullable PsiElement invocationPoint) {
        if (symbolProcessor == null) {
            SymbolCachingProcessor.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            SymbolCachingProcessor.$$$reportNull$$$0(1);
        }
        if (cache == null) {
            SymbolCachingProcessor.$$$reportNull$$$0(2);
        }
        this.mySymbolProcessor = symbolProcessor;
        this.mySymbol = symbol;
        this.myInvocationPoint = invocationPoint;
        this.myCache = cache;
        this.isCachingEnabled = true;
    }

    @Override
    public boolean process(@NotNull Symbol s) {
        boolean result;
        if (s == null) {
            SymbolCachingProcessor.$$$reportNull$$$0(3);
        }
        if (!(result = this.mySymbolProcessor.process(s))) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Cached symbol \"" + s.getName() + "\" for context " + String.valueOf(this.mySymbol));
            }
            if (this.isCachingEnabled && s.isCacheable()) {
                this.myCache.registerMatchedSymbol(this.myInvocationPoint, this.mySymbol, s);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.mySymbolProcessor.getName();
    }

    @Override
    public PsiElement getInvocationPoint() {
        return this.mySymbolProcessor.getInvocationPoint();
    }

    @Override
    public SymbolProcessor getOriginalProcessor() {
        return this.mySymbolProcessor;
    }

    @Override
    public boolean isSymbolNotFound() {
        return this.mySymbolProcessor.isSymbolNotFound();
    }

    public void disableCaching() {
        this.isCachingEnabled = false;
    }

    public void enableCaching() {
        this.isCachingEnabled = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/util/SymbolCachingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

