/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsoleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RNamespace;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.TypeInferenceInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.RubySymbolProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.TypeSet;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubyModificationTrackers;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RubySymbolsLookupCache;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiPsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.util.SymbolHierarchy;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AliasSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ScopeSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SingletonClassSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolContainerUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.TopLevelSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RUnionTypeImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RVariableBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyResolutionIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.AnonymousDefiningCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public final class SymbolUtil {
    private static final Logger LOG = Logger.getInstance(SymbolUtil.class);
    private static final FQN METHOD_MISSING_FQN = FQN.Builder.fromString((String)"method_missing");
    private static final NotNullLazyValue<TypeSet> ourMethodTypesValue = NotNullLazyValue.createValue(() -> SymbolUtil.unionTypesFromProviders(Types.METHODS_LIKE, RubySymbolProvider::getMethodTypes));
    private static final NotNullLazyValue<TypeSet> ourClassTypesValue = NotNullLazyValue.createValue(() -> SymbolUtil.unionTypesFromProviders(Type.CLASS.asSet(), RubySymbolProvider::getClassTypes));
    private static final NotNullLazyValue<TypeSet> ourModuleTypesValue = NotNullLazyValue.createValue(() -> SymbolUtil.unionTypesFromProviders(Type.MODULE.asSet(), RubySymbolProvider::getClassTypes));
    private static final NotNullLazyValue<TypeSet> ourClassModuleConstantTypesValue = NotNullLazyValue.createValue(() -> SymbolUtil.unionTypesFromProviders(Types.MODULE_OR_CLASS_OR_CONSTANT, RubySymbolProvider::getClassTypes));
    private static final NotNullLazyValue<TypeSet> ourNonQualifiedReferenceTypesValue = NotNullLazyValue.createValue(() -> SymbolUtil.unionTypesFromProviders(TypeSet.EMPTY, RubySymbolProvider::getNonQualifiedTypes));

    private SymbolUtil() {
    }

    @Deprecated
    @Nullable
    public static Symbol findConstantByFQN(@NotNull Project project, @NotNull Type type, @NotNull String fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            SymbolUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            SymbolUtil.$$$reportNull$$$0(1);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(2);
        }
        return SymbolUtil.findConstantByFQN(project, type, FQN.Builder.create(Collections.singletonList(fqn), (boolean)false), invocationPoint);
    }

    @Nullable
    public static Symbol findConstantByFQN(@NotNull Project project, @NotNull Type type, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            SymbolUtil.$$$reportNull$$$0(3);
        }
        if (type == null) {
            SymbolUtil.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(5);
        }
        assert (Types.MODULE_OR_CLASS_OR_CONSTANT.contains(type)) : "Incorrect method usage";
        return SymbolUtil.findConstantByFQN(project, type.asSet(), fqn, invocationPoint);
    }

    @Nullable
    public static Symbol findConstantByFQN(@NotNull Project project, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        if (project == null) {
            SymbolUtil.$$$reportNull$$$0(6);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(7);
        }
        return SymbolUtil.findConstantByFQN(project, Types.MODULE_OR_CLASS_OR_CONSTANT, fqn, invocationPoint);
    }

    @Deprecated
    @Nullable
    public static Symbol findConstantByFQN(Project project, @NotNull String fqn) {
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(8);
        }
        return SymbolUtil.findConstantByFQN(project, Types.MODULE_OR_CLASS_OR_CONSTANT, FQN.Builder.create(Collections.singletonList(fqn), (boolean)false), null);
    }

    @Nullable
    public static Symbol findConstantByFQN(@NotNull Project project, @NotNull TypeSet types, @NotNull FQN fqn, @Nullable PsiElement invocationPoint) {
        FQN parentFQN;
        Symbol parentSymbol;
        if (project == null) {
            SymbolUtil.$$$reportNull$$$0(9);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(10);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(11);
        }
        if (fqn == FQN.INVALID) {
            return null;
        }
        Symbol symbolFromProvider = SymbolUtil.findSymbolFromProviders((Symbol)SymbolUtil.getRootSymbol(project), fqn, types, invocationPoint);
        if (symbolFromProvider != null) {
            return symbolFromProvider;
        }
        if (AnonymousDefiningCallType.isAnonymousFQN((FQN)fqn)) {
            return AnonymousClassModuleSymbol.create(project, fqn, invocationPoint);
        }
        RContainer containerByFQN = RubyFQNUtil.findContainerByFQN(project, types, fqn, invocationPoint);
        if (containerByFQN != null) {
            return SymbolUtil.getSymbolByContainer((RElementWithFQN)containerByFQN);
        }
        if (RObjectClass.isSingletonFQN((FQN)fqn) && types.contains(Type.CLASS) && (parentSymbol = SymbolUtil.findConstantByFQN(project, types, parentFQN = fqn.getCallerFQN(), invocationPoint)) != null) {
            return parentSymbol.getSingletonClassSymbol();
        }
        return null;
    }

    public static boolean isTopLevelSymbol(@NotNull Symbol symbol) {
        Symbol parent;
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(12);
        }
        return (parent = symbol.getParentSymbol()) == null || parent.getType() == Type.FILE;
    }

    @Nullable
    public static Symbol findMethod(@NotNull Symbol anchor, @NotNull String name, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (anchor == null) {
            SymbolUtil.$$$reportNull$$$0(13);
        }
        if (name == null) {
            SymbolUtil.$$$reportNull$$$0(14);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(15);
        }
        return SymbolUtil.lookupMethod(anchor, FQN.Builder.fromString((String)name), types, invocationPoint);
    }

    @Nullable
    public static Symbol lookupConstant(@NotNull Symbol contextSymbol, @NotNull RPsiElement nestingContext, @NotNull FQN fqn, @NotNull TypeSet types, PsiElement invocationPoint) {
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(16);
        }
        if (nestingContext == null) {
            SymbolUtil.$$$reportNull$$$0(17);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(18);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(19);
        }
        if (fqn == FQN.INVALID) {
            return null;
        }
        if (fqn.getShortName().equals("$$SINGLETON$$")) {
            if (!types.contains(Type.CLASS)) {
                return null;
            }
            Symbol symbol = SymbolUtil.lookupConstant(contextSymbol, nestingContext, fqn.getCallerFQN(), types, invocationPoint);
            if (symbol == null) {
                return null;
            }
            return symbol.getSingletonClassSymbol();
        }
        if (RContainerPresentationUtil.isSelf((FQN)fqn)) {
            return types.contains(contextSymbol.getType()) ? contextSymbol : null;
        }
        if (AnonymousDefiningCallType.isAnonymousFQN((FQN)fqn)) {
            return AnonymousClassModuleSymbol.create(contextSymbol.getProject(), fqn, invocationPoint);
        }
        Symbol symbolFromProvider = SymbolUtil.findSymbolFromProviders(contextSymbol, fqn, types = types.union(SymbolUtil.getNonQualifiedReferenceTypes()), invocationPoint);
        if (symbolFromProvider != null) {
            return symbolFromProvider;
        }
        Symbol nestingResult = SymbolUtil.findInNesting(contextSymbol, fqn, nestingContext, types, invocationPoint);
        if (nestingResult != null) {
            return nestingResult;
        }
        if (fqn.getCallerFQN() != FQN.INVALID) {
            Symbol symbol = TypeInferenceInstance.lookupConstant(fqn, contextSymbol, nestingContext, invocationPoint);
            if (symbol != null && types.contains(symbol.getType())) {
                return symbol;
            }
            return null;
        }
        return SymbolUtil.lookupSymbolInHierarchy(contextSymbol, fqn.getShortName(), types, invocationPoint);
    }

    @Nullable
    public static Symbol resolveConstantFQN(@NotNull Symbol contextSymbol, @NotNull RPsiElement nestingContext, @NotNull FQN fqn, @NotNull TypeSet types, PsiElement invocationPoint) {
        Symbol symbol;
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(20);
        }
        if (nestingContext == null) {
            SymbolUtil.$$$reportNull$$$0(21);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(22);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(23);
        }
        if ((symbol = SymbolUtil.lookupConstant(contextSymbol, nestingContext, fqn, types.union(new Type[]{Type.CONSTANT}), invocationPoint)) == null || symbol.getType() != Type.CONSTANT) {
            return symbol;
        }
        PsiElement element = symbol.getPsiElement();
        if (!(element instanceof RVariableBase)) {
            return null;
        }
        RVariableBase variableBase = (RVariableBase)element;
        RType type = TypeInferenceInstance.getTypeOfRVariable(variableBase, invocationPoint);
        Symbol resolvedSymbol = null;
        if (type instanceof RModuleType) {
            type = ((RModuleType)type).getOriginalType();
        }
        if (type instanceof RSymbolType && ((RSymbolType)type).getSymbol() instanceof SingletonClassSymbol) {
            resolvedSymbol = ((SingletonClassSymbol)((RSymbolType)type).getSymbol()).getOriginSymbol();
        }
        return resolvedSymbol != null && types.contains(resolvedSymbol.getType()) ? resolvedSymbol : null;
    }

    @Nullable
    public static Symbol lookupMethod(@NotNull Symbol contextSymbol, @NotNull FQN fqn, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(24);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(25);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(26);
        }
        ArrayList<RType> rtypes = new ArrayList<RType>();
        if (contextSymbol instanceof MultiSymbol) {
            MultiSymbol multiSymbol = (MultiSymbol)contextSymbol;
            for (Symbol symbol : multiSymbol.getSymbols()) {
                rtypes.add(RTypeFactory.createTypeBySymbol(symbol));
            }
        } else {
            rtypes.add(RTypeFactory.createTypeBySymbol(contextSymbol));
        }
        return SymbolUtil.lookupMethod(contextSymbol, RUnionTypeImpl.create(rtypes), fqn, types, invocationPoint);
    }

    @Nullable
    public static Symbol lookupMethod(@Nullable Symbol contextSymbol, @NotNull RType contextType, @NotNull FQN fqn, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (contextType == null) {
            SymbolUtil.$$$reportNull$$$0(27);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(28);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(29);
        }
        assert (TypeSet.EMPTY.equals((Object)Types.MODULE_OR_CLASS_OR_CONSTANT.intersect(types))) : "Incorrect method usage, types: " + String.valueOf(types);
        if (fqn == FQN.INVALID) {
            return null;
        }
        types = types.union(SymbolUtil.getNonQualifiedReferenceTypes());
        if (contextSymbol != null) {
            Symbol symbolFromProvider = SymbolUtil.findSymbolFromProviders(contextSymbol, fqn, types, invocationPoint);
            if (symbolFromProvider != null) {
                return symbolFromProvider;
            }
            if (SymbolUtil.isReferenceToContext(contextSymbol, fqn, types)) {
                return contextSymbol;
            }
        }
        return contextType.getMemberForName(fqn.getShortName(), (Predicate)Symbol.Filter.byTypes((TypeSet)types), invocationPoint);
    }

    public static void processMembersInNesting(@NotNull RPsiElement nestingContext, @NotNull Processor<? super Symbol> processor) {
        if (nestingContext == null) {
            SymbolUtil.$$$reportNull$$$0(30);
        }
        if (processor == null) {
            SymbolUtil.$$$reportNull$$$0(31);
        }
        FQN contextFQN = SymbolUtil.getNestingFQN(nestingContext);
        Project project = nestingContext.getProject();
        GlobalSearchScope scope = nestingContext.getResolveScope();
        contextFQN.processNestingResolution(partialFQN -> {
            if (!SymbolContainerUtil.processClassModuleChildren(project, partialFQN, scope, processor, null)) {
                return false;
            }
            return RubyResolutionIndex.ForCompletion.getInstance().processElements(project, (SearchScope)scope, partialFQN, child -> {
                Symbol symbol;
                return !(child instanceof RConstant ? !processor.process(new PsiElementSymbol<RPsiElement>((RPsiElement)child, child.getName(), Type.CONSTANT, null)) : child instanceof RContainer && (symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)child))) != null && Types.MODULE_OR_CLASS_OR_CONSTANT.contains(symbol.getType()) && !processor.process((Object)symbol));
            });
        });
    }

    @Nullable
    public static Symbol lookupSymbolInHierarchy(@NotNull Symbol contextSymbol, @NotNull String name, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(32);
        }
        if (name == null) {
            SymbolUtil.$$$reportNull$$$0(33);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(34);
        }
        Collection<Object> startSymbols = contextSymbol instanceof MultiSymbol ? ((MultiSymbol)contextSymbol).getSymbols() : Collections.singleton(contextSymbol);
        for (Symbol symbol : startSymbols) {
            RType symbolType = RTypeFactory.createTypeBySymbol(symbol);
            Symbol result = symbolType.getMemberForName(name, (Predicate)Symbol.Filter.byTypes((TypeSet)types), invocationPoint);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static Symbol getScopeContextWithCaching(@NotNull PsiElement element) {
        if (element == null) {
            SymbolUtil.$$$reportNull$$$0(35);
        }
        if (DumbService.isDumb((Project)element.getProject())) {
            return SymbolUtil.getScopeContext(element);
        }
        return (Symbol)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            Project project = element.getProject();
            Symbol context = SymbolUtil.getScopeContext(element);
            return CachedValueProvider.Result.create((Object)context, RubyModificationTrackers.getModelModificationTrackers(project));
        });
    }

    @Nullable
    public static Symbol getScopeContext(@NotNull Symbol symbol) {
        Symbol currentSymbol;
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(36);
        }
        for (currentSymbol = symbol; currentSymbol != null && !(currentSymbol instanceof ScopeSymbol); currentSymbol = currentSymbol.getParentSymbol()) {
        }
        return currentSymbol;
    }

    @NotNull
    public static RElementWithFQN getContextContainer(PsiElement element) {
        if (element instanceof RElementWithFQN && SymbolUtil.isValidContextElement((RElementWithFQN)element, element)) {
            RElementWithFQN rElementWithFQN = (RElementWithFQN)element;
            if (rElementWithFQN == null) {
                SymbolUtil.$$$reportNull$$$0(37);
            }
            return rElementWithFQN;
        }
        RElementWithFQN elementWithFQN = null;
        while ((elementWithFQN = (RElementWithFQN)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)((PsiElement)ObjectUtils.notNull(elementWithFQN, (Object)element)), RElementWithFQN.class)) != null && !SymbolUtil.isValidContextElement(elementWithFQN, element)) {
        }
        if (elementWithFQN == null) {
            List parents = PsiTreeUtil.collectParents((PsiElement)element, PsiElement.class, (boolean)false, parent -> parent instanceof PsiDirectory);
            throw new RuntimeException("No container found for " + String.valueOf(element) + " (parents: " + String.valueOf(parents) + ")");
        }
        RElementWithFQN rElementWithFQN = elementWithFQN;
        if (rElementWithFQN == null) {
            SymbolUtil.$$$reportNull$$$0(38);
        }
        return rElementWithFQN;
    }

    @Nullable
    public static Symbol getSymbolByContainer(@Nullable RElementWithFQN container) {
        return SymbolUtil.getSymbolByContainer(container, null);
    }

    @Contract(value="null,_ -> null")
    @Nullable
    public static Symbol getSymbolByContainer(@Nullable RElementWithFQN container, @Nullable Symbol parent) {
        PsiElement context;
        PsiElement context2;
        if (container == null || !container.isValid()) {
            LOG.debug("Cannot get symbol by container, container is " + (container != null ? "invalid" : "null"));
            return null;
        }
        FQN fqn = container.getFQNWithNesting();
        if (container instanceof RContainer) {
            for (RubySymbolProvider provider : (RubySymbolProvider[])RubySymbolProvider.EP_NAME.getExtensions()) {
                Symbol symbol = provider.createSymbolByContainer((RContainer)container, fqn, parent);
                if (symbol == null) continue;
                return symbol;
            }
        }
        Project project = container.getProject();
        if (container instanceof RubyExpressionCodeFragment && (context2 = container.getContext()) != null) {
            return SymbolUtil.getScopeContextWithCaching(context2);
        }
        if (container instanceof RFile && RubyLanguageConsoleUtil.isInLanguageConsole((PsiElement)container) && (context = RubyLanguageConsoleUtil.getLanguageConsoleContext((PsiElement)container)) != null) {
            return SymbolUtil.getScopeContextWithCaching(context);
        }
        if (container instanceof RTopLevelContainer) {
            RTopLevelContainer topLevelContainer = (RTopLevelContainer)container;
            return SymbolUtil.getRootSymbol(topLevelContainer);
        }
        if (container instanceof RObjectClass) {
            Symbol owner = SymbolUtil.getSymbolByContainer((RElementWithFQN)container.getParentContainer(), parent);
            if (owner != null) {
                return new SingletonClassSymbol(owner, container.getFQNWithNesting(), (RContainer)container);
            }
            LOG.debug("Cannot get symbol by container, singleton has no owner: ", new Object[]{container});
            return null;
        }
        if (container instanceof RModule || container instanceof RClass) {
            return new ClassModuleSymbol(project, container.getFQNWithNesting(), (RContainer)container, parent);
        }
        if (container instanceof RMethod) {
            return new RMethodSymbolImpl((RMethod)container, parent);
        }
        if (container instanceof RBlockCall) {
            RBlockCall blockCall = (RBlockCall)container;
            if (blockCall.getCallType() instanceof AnonymousDefiningCallType && AnonymousDefiningCallType.isAnonymousFQN((FQN)fqn)) {
                return new AnonymousClassModuleSymbol(project, fqn, blockCall);
            }
            Symbol object = SymbolUtil.findConstantByFQN(project, FQN.of((String)"Object"), (PsiElement)container);
            if (object != null) {
                return SymbolUtil.lookupConstant(object, SymbolUtil.findEmptyNestingContext((RPsiElement)container), blockCall.getFQN(), SymbolUtil.getClassModuleConstantTypes(), (PsiElement)container);
            }
        }
        LOG.debug("Cannot get symbol by container, unrecognised class: ", new Object[]{container});
        return null;
    }

    private static RPsiElement findEmptyNestingContext(@NotNull RPsiElement element) {
        if (element == null) {
            SymbolUtil.$$$reportNull$$$0(39);
        }
        RPsiElement emptyContext = element;
        RPsiElement parent;
        while ((parent = (RPsiElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)emptyContext, RPsiElement.class)) != null) {
            emptyContext = parent;
        }
        return emptyContext;
    }

    public static TypeSet getNonQualifiedReferenceTypes() {
        return (TypeSet)ourNonQualifiedReferenceTypesValue.getValue();
    }

    public static boolean isClassOrModuleSymbol(Type symbolType) {
        return SymbolUtil.getClassModuleConstantTypes().contains(symbolType);
    }

    @Nullable
    public static Symbol getMethodMissing(@NotNull Symbol symbol) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(40);
        }
        return (Symbol)RecursionManager.doPreventingRecursion((Object)symbol, (boolean)false, () -> SymbolUtil.lookupMethod(symbol, METHOD_MISSING_FQN, Types.METHODS, symbol.getPsiElement()));
    }

    @Nullable
    public static Symbol getMethodMissing(Project project, @NotNull String classFqn, @NotNull ContextImpl context) {
        if (classFqn == null) {
            SymbolUtil.$$$reportNull$$$0(41);
        }
        if (context == null) {
            SymbolUtil.$$$reportNull$$$0(42);
        }
        Symbol symbol = SymbolUtil.findConstantByFQN(project, classFqn);
        return (symbol = SymbolUtil.getSymbolRepresentingContext(symbol, context)) == null ? null : SymbolUtil.getMethodMissing(symbol);
    }

    @NotNull
    public static TopLevelSymbolImpl getRootSymbol(@NotNull RTopLevelContainer container) {
        if (container == null) {
            SymbolUtil.$$$reportNull$$$0(43);
        }
        return new TopLevelSymbolImpl((PsiElement)container);
    }

    @NotNull
    public static TopLevelSymbolImpl getRootSymbol(@NotNull Project project) {
        if (project == null) {
            SymbolUtil.$$$reportNull$$$0(44);
        }
        return new TopLevelSymbolImpl(project, null);
    }

    @Nullable
    public static Symbol getMethodSymbolByAlias(Symbol symbol) {
        if (!(symbol instanceof AliasSymbol)) {
            return null;
        }
        AliasSymbol aliasSymbol = (AliasSymbol)symbol;
        Symbol parentSymbol = aliasSymbol.getParentSymbol();
        if (parentSymbol == null) {
            return null;
        }
        final Ref name2search = new Ref((Object)aliasSymbol.getOldName());
        Object element = aliasSymbol.getPsiElement();
        final PsiFile file = (PsiFile)ObjectUtils.doIfNotNull(element, PsiElement::getContainingFile);
        Ref result = new Ref();
        SymbolHierarchy.processSymbolChildren(parentSymbol, new SymbolProcessor(){
            final /* synthetic */ PsiElement val$element;
            final /* synthetic */ Ref val$result;
            final /* synthetic */ Symbol val$symbol;
            {
                this.val$element = psiElement;
                this.val$result = ref2;
                this.val$symbol = symbol;
            }

            @Override
            public boolean process(@NotNull Symbol symbol) {
                PsiElement symbolElement;
                if (symbol == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((String)name2search.get()).equals(symbol.getName()) && Types.METHODS_LIKE.contains(symbol.getType()) && ((symbolElement = symbol.getPsiElement()) == null || !symbolElement.getContainingFile().equals(file) || RubyPsiUtil.getRelativePositionComparator().compare(symbolElement, this.val$element) > 0)) {
                    this.val$result.set((Object)symbol);
                }
                return this.val$result.isNull();
            }

            @Override
            public String getName() {
                return (String)name2search.get();
            }

            @Override
            public PsiElement getInvocationPoint() {
                return this.val$symbol.getPsiElement();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolUtil$1", "process"));
            }
        });
        if (result.get() instanceof AliasSymbol && ((Symbol)result.get()).getType() == Type.ALIAS) {
            return (Symbol)RecursionManager.doPreventingRecursion((Object)symbol, (boolean)false, () -> SymbolUtil.getMethodSymbolByAlias((Symbol)result.get()));
        }
        return (Symbol)result.get();
    }

    @Nullable
    public static Symbol getSymbolRepresentingContext(@Nullable Symbol originSymbol, @NotNull Context context) {
        if (context == null) {
            SymbolUtil.$$$reportNull$$$0(45);
        }
        if (originSymbol == null) {
            return null;
        }
        Access access = context.getAccess();
        if (access == Access.INSTANCE) {
            return originSymbol instanceof SingletonClassSymbol ? ((SingletonClassSymbol)originSymbol).getOriginSymbol() : originSymbol;
        }
        return originSymbol.getSingletonClassSymbol();
    }

    @NotNull
    public static ContextImpl getContextRepresentingSymbol(@NotNull Symbol symbol) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(46);
        }
        ContextImpl contextImpl = symbol instanceof SingletonClassSymbol ? ContextImpl.CLASS : ContextImpl.INSTANCE;
        if (contextImpl == null) {
            SymbolUtil.$$$reportNull$$$0(47);
        }
        return contextImpl;
    }

    @Nullable
    public static Symbol findSymbolInHierarchy(@NotNull Symbol anchor, @NotNull String name, TypeSet acceptableTypes, PsiElement invocationPoint) {
        if (anchor == null) {
            SymbolUtil.$$$reportNull$$$0(48);
        }
        if (name == null) {
            SymbolUtil.$$$reportNull$$$0(49);
        }
        return SymbolUtil.findSymbolInHierarchy(anchor, name, (Predicate<? super Symbol>)Symbol.Filter.byTypes((TypeSet)acceptableTypes), invocationPoint);
    }

    public static Symbol findSymbolInHierarchy(Symbol anchor, final String name, final Predicate<? super Symbol> filter, final PsiElement invocationPoint) {
        final Ref result = new Ref();
        final Ref isNotFound = new Ref((Object)true);
        SymbolHierarchy.processSymbolChildren(anchor, new SymbolProcessor(){

            @Override
            public boolean process(@NotNull Symbol symbol) {
                if (symbol == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (name.equals(symbol.getName()) && symbol.isResolvable()) {
                    isNotFound.set((Object)false);
                    if (filter.test(symbol)) {
                        result.set((Object)symbol);
                        return false;
                    }
                }
                return true;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public PsiElement getInvocationPoint() {
                return invocationPoint;
            }

            @Override
            public boolean isSymbolNotFound() {
                return (Boolean)isNotFound.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolUtil$2", "process"));
            }
        });
        return (Symbol)result.get();
    }

    public static List<Symbol> collectMembers(@NotNull Symbol symbol, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(50);
        }
        if (filter == null) {
            SymbolUtil.$$$reportNull$$$0(51);
        }
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        SymbolUtil.processMembers(symbol, filter, invocationPoint, (Processor<? super Symbol>)((Processor)result::add));
        return result;
    }

    public static boolean processMembers(@NotNull Symbol symbol, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, Processor<? super Symbol> processor) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(52);
        }
        if (filter == null) {
            SymbolUtil.$$$reportNull$$$0(53);
        }
        return SymbolUtil.processMembersImpl(symbol, invocationPoint, SymbolUtil.createSymbolProcessor(filter, processor));
    }

    @NotNull
    public static ThreeState isSuperMethod(@NotNull Symbol parent, @NotNull Symbol child) {
        if (parent == null) {
            SymbolUtil.$$$reportNull$$$0(54);
        }
        if (child == null) {
            SymbolUtil.$$$reportNull$$$0(55);
        }
        if (!Types.METHODS_LIKE.contains(child.getType()) && !Types.METHODS_LIKE.contains(parent.getType())) {
            LOG.warn("Both incoming symbols suppose to be method like");
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                SymbolUtil.$$$reportNull$$$0(56);
            }
            return threeState;
        }
        if (child.equals(parent)) {
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                SymbolUtil.$$$reportNull$$$0(57);
            }
            return threeState;
        }
        String parentSymbolName = parent.getName();
        String childSymbolName = child.getName();
        if (parentSymbolName == null || !parentSymbolName.equals(childSymbolName)) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                SymbolUtil.$$$reportNull$$$0(58);
            }
            return threeState;
        }
        Symbol childClass = child.getParentSymbol();
        Symbol parentClass = parent.getParentSymbol();
        if (childClass == null || parentClass == null || Types.METHODS_LIKE.contains(childClass.getType()) || Types.METHODS_LIKE.contains(parentClass.getType())) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                SymbolUtil.$$$reportNull$$$0(59);
            }
            return threeState;
        }
        RType childType = RTypeFactory.createTypeBySymbol(childClass);
        RType parentType = RTypeFactory.createTypeBySymbol(parentClass);
        ThreeState threeState = RTypeUtil.isSubtype(childType, parentType);
        if (threeState == null) {
            SymbolUtil.$$$reportNull$$$0(60);
        }
        return threeState;
    }

    public static void processMembersWithNesting(@NotNull Symbol symbol, @NotNull RPsiElement nestingContext, @NotNull Predicate<? super Symbol> filter, @Nullable PsiElement invocationPoint, @NotNull Processor<? super Symbol> processor) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(61);
        }
        if (nestingContext == null) {
            SymbolUtil.$$$reportNull$$$0(62);
        }
        if (filter == null) {
            SymbolUtil.$$$reportNull$$$0(63);
        }
        if (processor == null) {
            SymbolUtil.$$$reportNull$$$0(64);
        }
        Processor<? super Symbol> processorWrapper = SymbolUtil.createSymbolProcessor(filter, processor);
        SymbolUtil.processMembersInNesting(nestingContext, processorWrapper);
        SymbolUtil.processMembersImpl(symbol, invocationPoint, processorWrapper);
    }

    @NotNull
    public static TypeSet getClassTypes() {
        TypeSet typeSet = (TypeSet)ourClassTypesValue.getValue();
        if (typeSet == null) {
            SymbolUtil.$$$reportNull$$$0(65);
        }
        return typeSet;
    }

    @NotNull
    public static TypeSet getModuleTypes() {
        TypeSet typeSet = (TypeSet)ourModuleTypesValue.getValue();
        if (typeSet == null) {
            SymbolUtil.$$$reportNull$$$0(66);
        }
        return typeSet;
    }

    @NotNull
    public static TypeSet getClassModuleConstantTypes() {
        TypeSet typeSet = (TypeSet)ourClassModuleConstantTypesValue.getValue();
        if (typeSet == null) {
            SymbolUtil.$$$reportNull$$$0(67);
        }
        return typeSet;
    }

    @NotNull
    public static TypeSet getMethodTypes() {
        TypeSet typeSet = (TypeSet)ourMethodTypesValue.getValue();
        if (typeSet == null) {
            SymbolUtil.$$$reportNull$$$0(68);
        }
        return typeSet;
    }

    @NotNull
    public static Symbol createSymbolByScopeVariable(@NotNull ScopeVariable variable, @NotNull String name, @NotNull Project project) {
        ArrayList list;
        if (variable == null) {
            SymbolUtil.$$$reportNull$$$0(69);
        }
        if (name == null) {
            SymbolUtil.$$$reportNull$$$0(70);
        }
        if (project == null) {
            SymbolUtil.$$$reportNull$$$0(71);
        }
        if ((list = new ArrayList(variable.getDeclarations())).size() == 1) {
            return new PsiElementSymbol<PsiElement>((PsiElement)list.get(0), name, variable.getType());
        }
        list.sort((o1, o2) -> RubyPsiUtilCore.isBefore((PsiElement)o1, (PsiElement)o2) ? -1 : 1);
        return new MultiPsiElementSymbol(project, list, name, variable.getType());
    }

    @Nullable
    public static Symbol createLocalVariableSymbol(RPsiElement element, String name) {
        RPsiElement realContext = RubyPsiUtilCore.getRealContext((RPsiElement)element);
        assert (realContext != null) : "RealContext cannot be null here";
        Scope scope = ScopeUtilCore.getScope((RPsiElement)realContext);
        if (scope == null) {
            return null;
        }
        ScopeVariable variable = scope.getDeclaredVariable((PsiElement)realContext, name);
        if (variable != null) {
            return SymbolUtil.createSymbolByScopeVariable(variable, name, element.getProject());
        }
        PsiElement decl = scope.getLocalVariable((PsiElement)realContext, name);
        if (decl != null) {
            return new PsiElementSymbol<PsiElement>(decl, name, Type.LOCAL_VARIABLE, null);
        }
        return null;
    }

    public static boolean isAnonymousModule(@NotNull FQN qualifiedName) {
        if (qualifiedName == null) {
            SymbolUtil.$$$reportNull$$$0(72);
        }
        return qualifiedName.getFullPath().startsWith("Module.new");
    }

    @Nullable
    public static Collection<RVariableBase> getFieldAssignmentsForAttributeAccessor(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(73);
        }
        if (Types.ATTR_METHODS.contains(symbol.getType())) {
            Collection<RPsiElement> sorted = SymbolUtil.getDeclarationElements(symbol, invocationPoint);
            return ContainerUtil.filterIsInstance(sorted, RVariableBase.class);
        }
        return null;
    }

    @NotNull
    public static Collection<RPsiElement> getDeclarationElements(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(74);
        }
        Collection<RPsiElement> collection = RubySymbolsLookupCache.getInstance(symbol.getProject()).getOrCalculateDeclarationElements(invocationPoint, symbol, SymbolUtil::getDeclarationElementsInt);
        if (collection == null) {
            SymbolUtil.$$$reportNull$$$0(75);
        }
        return collection;
    }

    @NotNull
    private static Collection<RPsiElement> getDeclarationElementsInt(final @NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(76);
        }
        SmartList result = new SmartList();
        final String name = symbol.getName();
        if (name == null) {
            List<RPsiElement> list = Collections.emptyList();
            if (list == null) {
                SymbolUtil.$$$reportNull$$$0(77);
            }
            return list;
        }
        SymbolProcessor processor = new SymbolProcessor(){
            final /* synthetic */ List val$result;
            final /* synthetic */ PsiElement val$invocationPoint;
            {
                this.val$result = list;
                this.val$invocationPoint = psiElement;
            }

            @Override
            public boolean process(@NotNull Symbol foundSymbol) {
                if (foundSymbol == null) {
                    3.$$$reportNull$$$0(0);
                }
                SymbolUtil.processFoundDeclarationCandidate(symbol, foundSymbol, name, this.val$result);
                return true;
            }

            @Override
            @NotNull
            public String getName() {
                String string = name;
                if (string == null) {
                    3.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @Nullable
            public PsiElement getInvocationPoint() {
                return this.val$invocationPoint;
            }

            @Override
            @Contract(pure=true)
            public boolean ignoreLookupCache() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "foundSymbol";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolUtil$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolUtil$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
        Symbol parent = symbol.getParentSymbol();
        if (parent == null) {
            List<RPsiElement> list = Collections.emptyList();
            if (list == null) {
                SymbolUtil.$$$reportNull$$$0(78);
            }
            return list;
        }
        SymbolHierarchy.processSymbolChildren(parent, processor);
        SmartList smartList = result;
        if (smartList == null) {
            SymbolUtil.$$$reportNull$$$0(79);
        }
        return smartList;
    }

    private static void processFoundDeclarationCandidate(@NotNull Symbol symbol, @NotNull Symbol foundSymbol, @NotNull String name, @NotNull List<? super RPsiElement> result) {
        PsiElement psi;
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(80);
        }
        if (foundSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(81);
        }
        if (name == null) {
            SymbolUtil.$$$reportNull$$$0(82);
        }
        if (result == null) {
            SymbolUtil.$$$reportNull$$$0(83);
        }
        if (!name.equals(foundSymbol.getName())) {
            return;
        }
        Type symbolType = symbol.getType();
        Type foundSymbolType = foundSymbol.getType();
        if (foundSymbolType != symbolType) {
            if (Types.INSTANCE_FIELD_OR_ATTRS.contains(symbolType)) {
                if (!Types.INSTANCE_FIELD_OR_ATTRS.contains(foundSymbolType)) {
                    return;
                }
            } else if (Types.CLASS_FIELD_OR_ATTRS.contains(symbolType)) {
                if (!Types.CLASS_FIELD_OR_ATTRS.contains(foundSymbolType)) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((psi = foundSymbol.getPsiElement()) instanceof RPsiElement) {
            result.add((RPsiElement)((RPsiElement)psi));
        }
    }

    private static boolean sameReference(@NotNull FQN fqn, @NotNull Symbol contextSymbol) {
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(84);
        }
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(85);
        }
        if (contextSymbol instanceof ScopeSymbol) {
            return ((ScopeSymbol)contextSymbol).isInnerReferenceToMe(fqn);
        }
        return FQN.same((FQN)fqn, (String)contextSymbol.getName());
    }

    private static boolean isReferenceToContext(@NotNull Symbol contextSymbol, @NotNull FQN fqn, @NotNull TypeSet types) {
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(86);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(87);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(88);
        }
        return types.contains(contextSymbol.getType()) && (RContainerPresentationUtil.isSelf((FQN)fqn) || SymbolUtil.sameReference(fqn, contextSymbol));
    }

    @Nullable
    private static Symbol getScopeContext(@NotNull PsiElement element) {
        if (element == null) {
            SymbolUtil.$$$reportNull$$$0(89);
        }
        for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
            Symbol context = provider.getSymbolScope(element);
            if (context == null) continue;
            return context;
        }
        return SymbolUtil.getSymbolByContainer(SymbolUtil.getContextContainer(element));
    }

    @NotNull
    public static Processor<? super Symbol> createSymbolProcessor(@NotNull Predicate<? super Symbol> filter, @NotNull Processor<? super Symbol> processor) {
        if (filter == null) {
            SymbolUtil.$$$reportNull$$$0(90);
        }
        if (processor == null) {
            SymbolUtil.$$$reportNull$$$0(91);
        }
        Processor processor2 = symbol -> {
            ProgressManager.checkCanceled();
            return !filter.test((Symbol)symbol) || processor.process(symbol);
        };
        if (processor2 == null) {
            SymbolUtil.$$$reportNull$$$0(92);
        }
        return processor2;
    }

    @NotNull
    public static Processor<? super Symbol> createSymbolProcessor(@NotNull Predicate<? super Symbol> filter, @NotNull Consumer<? super Symbol> consumer) {
        if (filter == null) {
            SymbolUtil.$$$reportNull$$$0(93);
        }
        if (consumer == null) {
            SymbolUtil.$$$reportNull$$$0(94);
        }
        Processor processor = symbol -> {
            ProgressManager.checkCanceled();
            if (filter.test((Symbol)symbol)) {
                consumer.accept((Symbol)symbol);
            }
            return true;
        };
        if (processor == null) {
            SymbolUtil.$$$reportNull$$$0(95);
        }
        return processor;
    }

    private static boolean processMembersImpl(@NotNull Symbol symbol, final @Nullable PsiElement invocationPoint, final Processor<? super Symbol> processorWrapper) {
        if (symbol == null) {
            SymbolUtil.$$$reportNull$$$0(96);
        }
        return SymbolHierarchy.processSymbolChildren(symbol, new SymbolProcessor(){

            @Override
            public boolean process(@NotNull Symbol symbolInScope) {
                if (symbolInScope == null) {
                    4.$$$reportNull$$$0(0);
                }
                return processorWrapper.process((Object)symbolInScope);
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public PsiElement getInvocationPoint() {
                return invocationPoint;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolInScope", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolUtil$4", "process"));
            }
        });
    }

    @Nullable
    public static Symbol findInNesting(@NotNull Symbol contextSymbol, @NotNull FQN fqn, @NotNull RPsiElement context, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(97);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(98);
        }
        if (context == null) {
            SymbolUtil.$$$reportNull$$$0(99);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(100);
        }
        if (fqn == FQN.INVALID) {
            return null;
        }
        FQN contextFQN = SymbolUtil.getNestingFQN(context);
        Ref answer = Ref.create();
        contextFQN.processNestingResolution(partialFQN -> {
            FQN concatenated = FQN.Builder.concat((FQN)partialFQN, (FQN)fqn);
            Symbol symbolFromProvider = SymbolUtil.findSymbolFromProviders(contextSymbol, concatenated, types, invocationPoint);
            if (symbolFromProvider != null) {
                answer.set((Object)symbolFromProvider);
                return false;
            }
            RPsiElement constant = RubyFQNUtil.findConstantByFQN(context.getProject(), concatenated, invocationPoint);
            if (constant != null) {
                PsiElementSymbol<RPsiElement> symbol;
                PsiElementSymbol<Object> psiElementSymbol = symbol = constant instanceof RContainer ? SymbolUtil.getSymbolByContainer((RElementWithFQN)((RContainer)constant)) : new PsiElementSymbol<RPsiElement>(constant, constant.getName(), Type.CONSTANT, null);
                if (symbol != null && Symbol.Filter.byTypes((TypeSet)types).test(symbol)) {
                    answer.set(symbol);
                    return false;
                }
            }
            return true;
        });
        return (Symbol)answer.get();
    }

    @NotNull
    private static FQN getNestingFQN(@NotNull RPsiElement nestingContext) {
        if (nestingContext == null) {
            SymbolUtil.$$$reportNull$$$0(101);
        }
        while (nestingContext != null && !(nestingContext instanceof RClass) && !(nestingContext instanceof RModule)) {
            nestingContext = (RPsiElement)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)nestingContext, RNamespace.class);
        }
        FQN fQN = nestingContext != null ? ((RNamespace)nestingContext).getFQNWithNesting() : FQN.INVALID;
        if (fQN == null) {
            SymbolUtil.$$$reportNull$$$0(102);
        }
        return fQN;
    }

    private static boolean isValidContextElement(@NotNull RElementWithFQN contextElement, @NotNull PsiElement element) {
        if (contextElement == null) {
            SymbolUtil.$$$reportNull$$$0(103);
        }
        if (element == null) {
            SymbolUtil.$$$reportNull$$$0(104);
        }
        return !SymbolUtil.isInvalidBlockCall(contextElement, element) && !(contextElement instanceof RMethod) && !(contextElement instanceof RConstant);
    }

    private static boolean isInvalidBlockCall(@NotNull RElementWithFQN contextElement, @NotNull PsiElement element) {
        if (contextElement == null) {
            SymbolUtil.$$$reportNull$$$0(105);
        }
        if (element == null) {
            SymbolUtil.$$$reportNull$$$0(106);
        }
        if (!(contextElement instanceof RBlockCall)) {
            return false;
        }
        RBlockCall blockCall = (RBlockCall)contextElement;
        if (!blockCall.isValidNamespace()) {
            return true;
        }
        RCodeBlock block = blockCall.getBlock();
        while (element != null && element != block) {
            element = PsiTreeUtil.getStubOrPsiParent((PsiElement)element);
        }
        return element != block;
    }

    @NotNull
    private static TypeSet unionTypesFromProviders(@NotNull TypeSet initial, @NotNull Function<? super RubySymbolProvider, ? extends TypeSet> map) {
        if (initial == null) {
            SymbolUtil.$$$reportNull$$$0(107);
        }
        if (map == null) {
            SymbolUtil.$$$reportNull$$$0(108);
        }
        for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
            TypeSet additionalTypes = map.apply(provider);
            initial = additionalTypes != null ? initial.union(additionalTypes) : initial;
        }
        TypeSet typeSet = initial;
        if (typeSet == null) {
            SymbolUtil.$$$reportNull$$$0(109);
        }
        return typeSet;
    }

    @Nullable
    private static Symbol findSymbolFromProviders(@NotNull Symbol contextSymbol, @NotNull FQN fqn, @NotNull TypeSet types, @Nullable PsiElement invocationPoint) {
        if (contextSymbol == null) {
            SymbolUtil.$$$reportNull$$$0(110);
        }
        if (fqn == null) {
            SymbolUtil.$$$reportNull$$$0(111);
        }
        if (types == null) {
            SymbolUtil.$$$reportNull$$$0(112);
        }
        for (RubySymbolProvider provider : RubySymbolProvider.EP_NAME.getExtensionList()) {
            Symbol symbolFromProvider = provider.findSymbol(contextSymbol, fqn, types, invocationPoint);
            if (symbolFromProvider == null) continue;
            return symbolFromProvider;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 37, 38, 47, 56, 57, 58, 59, 60, 65, 66, 67, 68, 75, 77, 78, 79, 92, 95, 102, 109 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 84: 
            case 87: 
            case 98: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 10: 
            case 15: 
            case 19: 
            case 23: 
            case 26: 
            case 29: 
            case 34: 
            case 88: 
            case 100: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 12: 
            case 36: 
            case 40: 
            case 46: 
            case 50: 
            case 52: 
            case 61: 
            case 73: 
            case 74: 
            case 76: 
            case 80: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 13: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: 
            case 33: 
            case 49: 
            case 70: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 20: 
            case 24: 
            case 32: 
            case 85: 
            case 86: 
            case 97: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextSymbol";
                break;
            }
            case 17: 
            case 21: 
            case 30: 
            case 62: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestingContext";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 31: 
            case 64: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 35: 
            case 39: 
            case 89: 
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: 
            case 38: 
            case 47: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 92: 
            case 95: 
            case 102: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolUtil";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 42: 
            case 45: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 51: 
            case 53: 
            case 63: 
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundSymbol";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/SymbolUtil";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextContainer";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextRepresentingSymbol";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "isSuperMethod";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassTypes";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTypes";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassModuleConstantTypes";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodTypes";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElements";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationElementsInt";
                break;
            }
            case 92: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "createSymbolProcessor";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestingFQN";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "unionTypesFromProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findConstantByFQN";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelSymbol";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lookupConstant";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstantFQN";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lookupMethod";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processMembersInNesting";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lookupSymbolInHierarchy";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getScopeContextWithCaching";
                break;
            }
            case 36: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getScopeContext";
                break;
            }
            case 37: 
            case 38: 
            case 47: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 92: 
            case 95: 
            case 102: 
            case 109: {
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findEmptyNestingContext";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getMethodMissing";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getRootSymbol";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolRepresentingContext";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getContextRepresentingSymbol";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolInHierarchy";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "collectMembers";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processMembers";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isSuperMethod";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processMembersWithNesting";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolByScopeVariable";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousModule";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAssignmentsForAttributeAccessor";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationElements";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationElementsInt";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processFoundDeclarationCandidate";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "sameReference";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToContext";
                break;
            }
            case 90: 
            case 91: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolProcessor";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "processMembersImpl";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "findInNesting";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getNestingFQN";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "isValidContextElement";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidBlockCall";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "unionTypesFromProviders";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "findSymbolFromProviders";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 37, 38, 47, 56, 57, 58, 59, 60, 65, 66, 67, 68, 75, 77, 78, 79, 92, 95, 102, 109 -> new IllegalStateException(string);
        };
    }
}

