/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyFQNUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyOverrideImplementUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.AnnotationsHelperCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.DelegateMethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.YARDMethodData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.signature.RSignature;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ROverloadedSyntheticMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.SymbolPsiProcessor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RCommandArgumentListImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RMethodSymbolImpl
extends PsiElementSymbol<PsiElement>
implements RMethodSymbol {
    private final Visibility myVisibility;

    public RMethodSymbolImpl(@NotNull RMethod method, @Nullable Symbol parent) {
        if (method == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(0);
        }
        super(method, method.getName(), method.getSymbolType(), parent);
        this.myVisibility = method instanceof RSingletonMethod ? Visibility.PUBLIC : (method.isConstructor() ? Visibility.PRIVATE : method.getVisibility());
    }

    @NotNull
    public List<? extends RMethodSymbol> getSyntheticOverloads() {
        Object declaration = this.getPsiElement();
        if (declaration instanceof RMethod) {
            List list = Optional.ofNullable(this.getAnnotationData()).map(MethodAnnotationData::getYARDMethodData).map(YARDMethodData::getOverloads).map(it -> ContainerUtil.map((Collection)it, signature -> new ROverloadedSyntheticMethodSymbol((RMethod)declaration, signature.getParametersInfo(), signature.getYardMethodData()))).orElse(Collections.emptyList());
            if (list == null) {
                RMethodSymbolImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public FQN getFQNWithNesting() {
        String name = this.getName();
        if (name == null) {
            FQN fQN = FQN.INVALID;
            if (fQN == null) {
                RMethodSymbolImpl.$$$reportNull$$$0(3);
            }
            return fQN;
        }
        FQN currentFQN = FQN.of((String)("." + name));
        Symbol parentSymbol = this.getParentSymbol();
        FQN fQN = parentSymbol == null ? currentFQN : FQN.Builder.concat((FQN)parentSymbol.getFQNWithNesting(), (FQN)currentFQN);
        if (fQN == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(4);
        }
        return fQN;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getAllDeclarations(@Nullable PsiElement invocationPoint) {
        List<RContainer> declarations = RubyFQNUtil.findContainersByFQN(this.getProject(), this.getType().asSet(), this.getFQNWithNesting(), invocationPoint);
        Object element = this.getPsiElement();
        List<Object> list = !declarations.isEmpty() || !element.isValid() ? new ArrayList<RContainer>(declarations) : List.of(element);
        if (list == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public List<ArgumentInfo> getArgumentInfos() {
        Object declaration = this.getPsiElement();
        if (declaration instanceof RMethod) {
            return ((RMethod)declaration).getArgumentInfos();
        }
        return null;
    }

    @Nullable
    public List<ArgumentInfo> getArgumentInfos(boolean includeDefaultArgs) {
        if (!includeDefaultArgs) {
            return this.getArgumentInfos();
        }
        Object declaration = this.getPsiElement();
        if (declaration instanceof RMethod) {
            return Optional.ofNullable(((RMethod)declaration).getArgumentList()).map(argList -> argList.getArgumentInfos(true)).orElse(null);
        }
        return null;
    }

    public RType getCallType(RCall call) {
        return null;
    }

    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.myVisibility;
        if (visibility == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(6);
        }
        return visibility;
    }

    @Nullable
    public MethodAnnotationData getAnnotationData() {
        RMethod method = (RMethod)ContainerUtil.findInstance(this.getAllDeclarations(null), RMethod.class);
        if (method == null) {
            return null;
        }
        return RMethodSymbolImpl.getMethodAnnotationData(this.myProject, method);
    }

    @NotNull
    public List<? extends YARDTag> getInheritedYARDTags() {
        Object psi = this.getPsiElement();
        if (!(psi instanceof RMethod)) {
            List list = Collections.emptyList();
            if (list == null) {
                RMethodSymbolImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getCachedValue(psi, () -> {
            RMethod method = (RMethod)psi;
            PotentiallyInheritedData tags = (PotentiallyInheritedData)ObjectUtils.coalesce(RMethodSymbolImpl.obtainInheritedData(method, it -> {
                List curTags = it.getYARDTags();
                return curTags.isEmpty() ? null : curTags;
            }), new PotentiallyInheritedData(Collections.emptyList(), false));
            return CachedValueProvider.Result.create((Object)((List)tags.data), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootModificationTracker.getInstance((Project)this.myProject)});
        });
        if (list == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public String getArgsPresentation() {
        List<ArgumentInfo> argumentInfos = this.getArgumentInfos();
        return argumentInfos != null ? RCommandArgumentListImpl.getPresentableName(argumentInfos) : null;
    }

    @Override
    @Nullable
    public Symbol getParentSymbol() {
        if (this.myParent != null) {
            return this.myParent;
        }
        Symbol container = SymbolUtil.getSymbolByContainer((RElementWithFQN)ObjectUtils.chooseNotNull((Object)RubyPsiUtilCore.getParentNamespace((PsiElement)this.myPsiElement), (Object)RubyPsiUtil.getRFile(this.myPsiElement)));
        if (container == null) {
            return null;
        }
        if (this.myType == Type.CLASS_METHOD) {
            return container.getSingletonClassSymbol();
        }
        return container;
    }

    public boolean processChildren(SymbolPsiProcessor processor, PsiElement invocationPoint) {
        return super.processChildren(processor, invocationPoint);
    }

    @NotNull
    public String toString() {
        String string = "%s{myName='%s', myType=%s, myVisibility=%s, myParent=%s}".formatted(((Object)((Object)this)).getClass().getSimpleName(), this.myName, this.myType, this.myVisibility, this.myParent);
        if (string == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static MethodAnnotationData getMethodAnnotationData(@NotNull Project project, @NotNull RMethod method) {
        if (project == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(10);
        }
        if (method == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(11);
        }
        if (DumbService.isDumb((Project)project)) {
            return RMethodSymbolImpl.getMethodAnnotationDataImpl(method);
        }
        MethodAnnotationData methodAnnotationData = (MethodAnnotationData)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            MethodAnnotationData data = RMethodSymbolImpl.getMethodAnnotationDataImpl(method);
            return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, ProjectRootModificationTracker.getInstance((Project)project)});
        });
        if (methodAnnotationData == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(12);
        }
        return methodAnnotationData;
    }

    @NotNull
    private static MethodAnnotationData getMethodAnnotationDataImpl(@NotNull RMethod method) {
        boolean doesContainInformationInheritedFromSuper;
        if (method == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(13);
        }
        PotentiallyInheritedData<YARDMethodData> yardMethodData = RMethodSymbolImpl.obtainInheritedData(method, it -> it.getAnnotationData().getYARDMethodData());
        PotentiallyInheritedData<RSignature> sorbetMethodData = RMethodSymbolImpl.obtainInheritedData(method, it -> it.getAnnotationData().getSorbetSignature());
        MethodAnnotationData methodAnnotationData = AnnotationsHelperCore.createAnnotationData((YARDMethodData)((YARDMethodData)ObjectUtils.doIfNotNull(yardMethodData, it -> (YARDMethodData)it.data)), (RSignature)((RSignature)ObjectUtils.doIfNotNull(sorbetMethodData, it -> (RSignature)it.data)));
        boolean bl = doesContainInformationInheritedFromSuper = yardMethodData != null && yardMethodData.isInheritedFromParentClassOrModule || sorbetMethodData != null && sorbetMethodData.isInheritedFromParentClassOrModule;
        if (doesContainInformationInheritedFromSuper) {
            return new MethodAnnotationDataWithInheritedInformation(methodAnnotationData);
        }
        MethodAnnotationData methodAnnotationData2 = methodAnnotationData;
        if (methodAnnotationData2 == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(14);
        }
        return methodAnnotationData2;
    }

    @Nullable
    private static <T> PotentiallyInheritedData<T> obtainInheritedData(@NotNull RMethod currentMethod, @NotNull Function<RMethod, T> mapper) {
        if (currentMethod == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(15);
        }
        if (mapper == null) {
            RMethodSymbolImpl.$$$reportNull$$$0(16);
        }
        return Optional.ofNullable(mapper.apply(currentMethod)).map(it -> new PotentiallyInheritedData<Object>(it, false)).orElseGet(() -> {
            List parameterInfos = currentMethod.getArgumentInfos();
            for (PsiElement method : RubyOverrideImplementUtil.getOverriddenMethods(currentMethod)) {
                if (!(method instanceof RMethod) || !((RMethod)method).getArgumentInfos().equals(parameterInfos)) break;
                Object data = mapper.apply((RMethod)method);
                if (data == null) continue;
                return new PotentiallyInheritedData(data, true);
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/RMethodSymbolImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMethod";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/structure/RMethodSymbolImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntheticOverloads";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQNWithNesting";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibility";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritedYARDTags";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodAnnotationData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodAnnotationDataImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAnnotationData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAnnotationDataImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "obtainInheritedData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 14 -> new IllegalStateException(string);
        };
    }

    private static final class PotentiallyInheritedData<T> {
        final T data;
        final boolean isInheritedFromParentClassOrModule;

        private PotentiallyInheritedData(T data, boolean isInheritedFromParentClassOrModule) {
            this.data = data;
            this.isInheritedFromParentClassOrModule = isInheritedFromParentClassOrModule;
        }
    }

    private static final class MethodAnnotationDataWithInheritedInformation
    extends DelegateMethodAnnotationData {
        private MethodAnnotationDataWithInheritedInformation(MethodAnnotationData to) {
            super(to);
        }

        @Override
        public boolean doesContainInformationInheritedFromSuper() {
            return true;
        }
    }
}

