/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.graph;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.RequiresIndexExtension;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiFileBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;

public final class RequirementGraph
implements Graph<VirtualFile> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object2IntMap<VirtualFile> myLoadPath;
    @NotNull
    private final Set<VirtualFile> myNodes;
    @NotNull
    private final Map<VirtualFile, List<VirtualFile>> myOutEdges;
    @NotNull
    private final Map<VirtualFile, List<VirtualFile>> myInEdges;
    @NotNull
    private volatile CountDownLatch myBarrier;

    public RequirementGraph(@NotNull Project project, @NotNull Collection<VirtualFile> loadPath) {
        if (project == null) {
            RequirementGraph.$$$reportNull$$$0(0);
        }
        if (loadPath == null) {
            RequirementGraph.$$$reportNull$$$0(1);
        }
        this.myBarrier = new CountDownLatch(1);
        this.myLoadPath = RFileUtil.createMapByLoadpath(loadPath);
        this.myProject = project;
        this.myNodes = new HashSet<VirtualFile>();
        this.myOutEdges = new HashMap<VirtualFile, List<VirtualFile>>();
        this.myInEdges = new HashMap<VirtualFile, List<VirtualFile>>();
        this.myNodes.addAll(FileTypeIndex.getFiles((FileType)RubyFileType.RUBY, (GlobalSearchScope)RequiresIndexExtension.getProcessedScope(project)));
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        HashMap<String, Collection<VirtualFile>> filesToProbeCache = new HashMap<String, Collection<VirtualFile>>();
        for (VirtualFile node : this.myNodes) {
            this.addEdgesFor(psiManager, node, filesToProbeCache);
        }
        filesToProbeCache.clear();
        this.myBarrier.countDown();
    }

    @NotNull
    public Collection<VirtualFile> getNodes() {
        this.syncData();
        Set<VirtualFile> set = this.myNodes;
        if (set == null) {
            RequirementGraph.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Iterator<VirtualFile> getIn(VirtualFile n) {
        this.syncData();
        Iterator<VirtualFile> iterator = this.myInEdges.getOrDefault(n, Collections.emptyList()).iterator();
        if (iterator == null) {
            RequirementGraph.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    @NotNull
    public Iterator<VirtualFile> getOut(VirtualFile n) {
        this.syncData();
        Iterator<VirtualFile> iterator = this.myOutEdges.getOrDefault(n, Collections.emptyList()).iterator();
        if (iterator == null) {
            RequirementGraph.$$$reportNull$$$0(4);
        }
        return iterator;
    }

    public synchronized boolean invalidateOutEdges(@NotNull VirtualFile node, @NotNull List<RequireInfo> newRequires) {
        List oldDestinations;
        if (node == null) {
            RequirementGraph.$$$reportNull$$$0(5);
        }
        if (newRequires == null) {
            RequirementGraph.$$$reportNull$$$0(6);
        }
        this.syncData();
        if (!this.myNodes.contains(node)) {
            throw new IllegalArgumentException("No such node present in the graph");
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        List<VirtualFile> newDestinations = this.getDestinations(psiManager, node, newRequires, null);
        if (newDestinations.equals(oldDestinations = this.myOutEdges.getOrDefault(node, Collections.emptyList()))) {
            return false;
        }
        this.myBarrier = new CountDownLatch(1);
        for (VirtualFile destination : oldDestinations) {
            this.myInEdges.get(destination).remove(node);
        }
        oldDestinations.clear();
        for (VirtualFile destination : newDestinations) {
            RequirementGraph.addEdge(this.myOutEdges, node, destination);
            RequirementGraph.addEdge(this.myInEdges, destination, node);
        }
        this.myBarrier.countDown();
        return true;
    }

    private void addEdgesFor(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile, @Nullable Map<String, Collection<VirtualFile>> filesToProbeCache) {
        if (psiManager == null) {
            RequirementGraph.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            RequirementGraph.$$$reportNull$$$0(8);
        }
        for (VirtualFile destination : this.getDestinations(psiManager, virtualFile, null, filesToProbeCache)) {
            RequirementGraph.addEdge(this.myOutEdges, virtualFile, destination);
            RequirementGraph.addEdge(this.myInEdges, destination, virtualFile);
        }
    }

    @NotNull
    private List<VirtualFile> getDestinations(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile, @Nullable List<RequireInfo> requires, @Nullable Map<String, Collection<VirtualFile>> filesToProbeCache) {
        if (psiManager == null) {
            RequirementGraph.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            RequirementGraph.$$$reportNull$$$0(10);
        }
        if (requires == null) {
            PsiFile psiFile = psiManager.findFile(virtualFile);
            if (!(psiFile instanceof RPsiFileBase)) {
                List<VirtualFile> list = Collections.emptyList();
                if (list == null) {
                    RequirementGraph.$$$reportNull$$$0(11);
                }
                return list;
            }
            requires = RFileUtil.computeRequires((RFile)((RPsiFileBase)psiFile));
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (RequireInfo require : requires) {
            boolean isRelative = require.isRelative();
            Collection<? extends VirtualFile> filesForName = RFileUtil.findFilesForName(psiManager.getProject(), require.getPath(), this.myLoadPath, virtualFile.getParent(), isRelative, filesToProbeCache);
            if (isRelative && filesForName.isEmpty()) {
                filesForName = RFileUtil.findFilesForName(psiManager.getProject(), require.getPath(), this.myLoadPath, virtualFile.getParent(), false, filesToProbeCache);
            }
            filesForName.stream().filter(file -> file.getFileType() instanceof AbstractRubyFileType).forEachOrdered(file -> result.add((VirtualFile)file));
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            RequirementGraph.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void addEdge(@NotNull Map<VirtualFile, List<VirtualFile>> map, @NotNull VirtualFile from, @NotNull VirtualFile to) {
        if (map == null) {
            RequirementGraph.$$$reportNull$$$0(13);
        }
        if (from == null) {
            RequirementGraph.$$$reportNull$$$0(14);
        }
        if (to == null) {
            RequirementGraph.$$$reportNull$$$0(15);
        }
        map.computeIfAbsent(from, k -> ContainerUtil.createConcurrentList());
        map.get(from).add(to);
    }

    private void syncData() {
        try {
            this.myBarrier.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/graph/RequirementGraph";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRequires";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/graph/RequirementGraph";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOut";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invalidateOutEdges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addEdgesFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDestinations";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 11, 12 -> new IllegalStateException(string);
        };
    }
}

