/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.hints.FileTypeInputFilterPredicate;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.messages.Topic;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.AbstractRubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RequireInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RPsiFileBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;

public final class RequiresIndexExtension
extends SingleEntryFileBasedIndexExtension<List<RequireInfo>> {
    public static final ID<Integer, List<RequireInfo>> KEY = ID.create((String)"RequiresIndexExtension");
    private static final ListDataExternalizer DATA_EXTERNALIZER = new ListDataExternalizer();
    private static final int VERSION = 1;
    private final Int2IntMap myResultHashesMap = new Int2IntOpenHashMap();

    @NotNull
    public static GlobalSearchScope getProcessedScope(@NotNull Project project) {
        if (project == null) {
            RequiresIndexExtension.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        if (globalSearchScope == null) {
            RequiresIndexExtension.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static List<RequireInfo> getValue(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            RequiresIndexExtension.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            RequiresIndexExtension.$$$reportNull$$$0(3);
        }
        List data = (List)FileBasedIndex.getInstance().getSingleEntryIndexData(KEY, virtualFile, project);
        List list = ContainerUtil.notNullize((List)data);
        if (list == null) {
            RequiresIndexExtension.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public ID<Integer, List<RequireInfo>> getName() {
        ID<Integer, List<RequireInfo>> iD = KEY;
        if (iD == null) {
            RequiresIndexExtension.$$$reportNull$$$0(5);
        }
        return iD;
    }

    @NotNull
    public SingleEntryIndexer<List<RequireInfo>> getIndexer() {
        return new SingleEntryIndexer<List<RequireInfo>>(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected List<RequireInfo> computeValue(@NotNull FileContent inputData) {
                boolean hasChanged;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (Registry.is((String)"ruby.disable.require.processing", (boolean)true)) {
                    List<RequireInfo> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                VirtualFile virtualFile = inputData.getFile();
                PsiFile psiFile = inputData.getPsiFile();
                if (!(psiFile instanceof RPsiFileBase)) {
                    List<RequireInfo> list = Collections.emptyList();
                    if (list == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return list;
                }
                List<RequireInfo> newResult = RFileUtil.calculateRequireInfos(virtualFile, (RPsiFileBase)psiFile);
                int newHashCode = newResult.hashCode();
                int fileId = FileBasedIndex.getFileId((VirtualFile)virtualFile);
                Int2IntMap int2IntMap = RequiresIndexExtension.this.myResultHashesMap;
                synchronized (int2IntMap) {
                    boolean bl = hasChanged = newHashCode != RequiresIndexExtension.this.myResultHashesMap.get(fileId);
                    if (hasChanged) {
                        RequiresIndexExtension.this.myResultHashesMap.put(fileId, newHashCode);
                    }
                }
                if (hasChanged) {
                    ((RequireSetChangedListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RequireSetChangedListener.TOPIC)).notifySetMaybeChanged(virtualFile, newResult);
                }
                List<RequireInfo> list = newResult;
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RequiresIndexExtension$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RequiresIndexExtension$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "computeValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "computeValue";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public DataExternalizer<List<RequireInfo>> getValueExternalizer() {
        ListDataExternalizer listDataExternalizer = DATA_EXTERNALIZER;
        if (listDataExternalizer == null) {
            RequiresIndexExtension.$$$reportNull$$$0(6);
        }
        return listDataExternalizer;
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileTypeInputFilterPredicate(FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION, fileType -> fileType instanceof AbstractRubyFileType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RequiresIndexExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RequiresIndexExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedScope";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class ListDataExternalizer
    implements DataExternalizer<List<RequireInfo>> {
        private ListDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<RequireInfo> value) throws IOException {
            if (out == null) {
                ListDataExternalizer.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (RequireInfo s : value) {
                out.writeUTF(s.getPath());
                out.writeBoolean(s.isRelative());
            }
        }

        public List<RequireInfo> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                ListDataExternalizer.$$$reportNull$$$0(1);
            }
            int n = in.readInt();
            ArrayList<RequireInfo> result = new ArrayList<RequireInfo>(n);
            for (int i = 0; i < n; ++i) {
                result.add(new RequireInfo(in.readUTF(), in.readBoolean()));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/RequiresIndexExtension$ListDataExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RequireSetChangedListener {
        public static final Topic<RequireSetChangedListener> TOPIC = Topic.create((String)RequireSetChangedListener.class.getSimpleName(), RequireSetChangedListener.class);

        public void notifySetMaybeChanged(@NotNull VirtualFile var1, @NotNull List<RequireInfo> var2);
    }
}

