/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPathsChangedListener;
import org.jetbrains.plugins.ruby.rails.facet.versions.RailsFacet;
import org.jetbrains.plugins.ruby.ruby.RubyPsiManager;

@ApiStatus.Internal
public abstract class AbstractRubyPsiModificationCache
implements Disposable {
    protected final Project myProject;

    AbstractRubyPsiModificationCache(@NotNull Project project) {
        if (project == null) {
            AbstractRubyPsiModificationCache.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void clearEverything() {
        this.clearProjectCache();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            this.clearModuleCache(module);
        }
    }

    protected void initializeListeners() {
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    AbstractRubyPsiModificationCache.this.processChange(vFileEvent.getFile(), AbstractRubyPsiModificationCache.this.myProject);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/AbstractRubyPsiModificationCache$1", "after"));
            }
        });
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                AbstractRubyPsiModificationCache.this.clearEverything();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/AbstractRubyPsiModificationCache$2", "rootsChanged"));
            }
        });
        connection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    3.$$$reportNull$$$0(1);
                }
                AbstractRubyPsiModificationCache.this.clearEverything();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/AbstractRubyPsiModificationCache$3";
                objectArray[2] = "beforeModuleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerListener(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (facet instanceof RailsFacet) {
                    AbstractRubyPsiModificationCache.this.clearModuleCache(facet.getModule());
                }
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (facet instanceof RailsFacet) {
                    AbstractRubyPsiModificationCache.this.clearModuleCache(facet.getModule());
                }
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (facet instanceof RailsFacet) {
                    AbstractRubyPsiModificationCache.this.clearModuleCache(facet.getModule());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "facet";
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/AbstractRubyPsiModificationCache$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(InflectorService.INFLECTIONS_CHANGED, (Object)new InflectorService.InflectionChanged(){

            @Override
            public void changed(@NotNull Module module) {
                if (module == null) {
                    5.$$$reportNull$$$0(0);
                }
                AbstractRubyPsiModificationCache.this.clearModuleCache(module);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/AbstractRubyPsiModificationCache$5", "changed"));
            }
        });
        connection.subscribe(RailsPathsChangedListener.TOPIC, module -> this.clearModuleCache(module));
        RubyPsiManager.getInstance(this.myProject).addOutOfCodeBlockChangeWatcher(parentPsiElement -> this.processChange(parentPsiElement, this.myProject));
        LowMemoryWatcher.register(() -> this.clearEverything(), (Disposable)this);
    }

    private void processChange(PsiElement psiElement, Project project) {
        VirtualFile vFile;
        PsiFile file = psiElement != null ? psiElement.getContainingFile() : null;
        VirtualFile virtualFile = vFile = file != null ? file.getVirtualFile() : null;
        if (vFile == null) {
            this.clearEverything();
            return;
        }
        this.processChange(vFile, project);
    }

    private void processChange(@Nullable VirtualFile file, Project project) {
        if (file == null) {
            this.clearEverything();
            return;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || RailsUtil.isUnderVendor(file, module)) {
            this.clearProjectCache();
            return;
        }
        this.clearModuleCache(module);
    }

    protected abstract void clearModuleCache(@NotNull Module var1);

    protected abstract void clearProjectCache();

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/cache/AbstractRubyPsiModificationCache", "<init>"));
    }
}

