/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbolImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.CallAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ConstantAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ExplicitTypeAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.FieldWriteAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ObjectClassAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RescueBlockParameterAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.SingletonMethodAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.Condition;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.KindOfCondition;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.condition.RespondsToCondition;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.visitor.RubyUsagesVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class TypeInferenceUsagesVisitor
extends RubyUsagesVisitor {
    @NotNull
    private final NotNullFunction<RPsiElement, SymbolicExpression> myGetSymbolicExpression;
    @NotNull
    private final NotNullFunction<SymbolicExpression, RType> myGetType;
    @NotNull
    private final Map<SymbolicExpression, RType> myTypeMap;
    @NotNull
    private final SymbolicExpression myExpression;
    @NotNull
    private RType myOldType;
    @NotNull
    private final RPsiElement myElement;

    private TypeInferenceUsagesVisitor(@NotNull SymbolicExpression expression, @NotNull RPsiElement element, @NotNull NotNullFunction<RPsiElement, SymbolicExpression> getSymbolicExpression, @NotNull NotNullFunction<SymbolicExpression, RType> getType, @NotNull Map<SymbolicExpression, RType> typeMap) {
        if (expression == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(1);
        }
        if (getSymbolicExpression == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(2);
        }
        if (getType == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(3);
        }
        if (typeMap == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(4);
        }
        this.myExpression = expression;
        this.myElement = element;
        this.myGetSymbolicExpression = getSymbolicExpression;
        this.myGetType = getType;
        this.myTypeMap = typeMap;
        this.myOldType = (RType)getType.fun((Object)expression);
    }

    @Override
    public void visitRescueBlockParameterAccess(@NotNull RescueBlockParameterAccess access) {
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(5);
        }
        RPsiElement element = access.getElement();
        SymbolicExpression exceptionVariable = (SymbolicExpression)this.myGetSymbolicExpression.fun((Object)element);
        Object type = null;
        if (access.getTypeElement() != null) {
            SymbolicExpression exceptionSymbolicExpression = (SymbolicExpression)this.myGetSymbolicExpression.fun((Object)access.getTypeElement());
            type = (RType)this.myGetType.fun((Object)exceptionSymbolicExpression);
            type = type instanceof RModuleType ? ((RModuleType)((Object)type)).getGenericType() : null;
        }
        if (RTypeUtilCore.isNullOrEmpty(type)) {
            type = RTypeFactory.createTypeClassName(element.getProject(), "Exception", Visibility.PUBLIC);
        }
        this.myTypeMap.put(exceptionVariable, (RType)type);
    }

    @Override
    public void visitExplicitTypeAccess(@NotNull ExplicitTypeAccess access) {
        RType type;
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(6);
        }
        if (RTypeUtilCore.isNotEmpty((RType)(type = access.getType())) && RTypeUtilCore.isNullOrEmpty((RType)this.myTypeMap.get(this.myExpression))) {
            this.myTypeMap.put(this.myExpression, type);
        }
    }

    @Override
    public void visitFieldWriteAccess(@NotNull FieldWriteAccess access) {
        RPsiElement field;
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(7);
        }
        if ((field = access.getField()).getUserData(ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED) == null) {
            String text = field.getText() + "=";
            this.addMemberToRType(text, Type.FIELD_WRITE_ACCESS, access.getFullReference());
        }
    }

    @Override
    public void visitConstantAccess(@NotNull ConstantAccess access) {
        RConstant constant;
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(8);
        }
        if ((constant = access.getConstant()).getUserData(ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED) == null) {
            String text = constant.getText();
            this.addMemberToRType(text, Type.CONSTANT_ACCESS, access.getFullReference());
        }
    }

    @Override
    public void visitCallAccess(@NotNull CallAccess access) {
        RPsiElement call;
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(9);
        }
        if ((call = access.getCall()).getUserData(ReferenceCompletionUtilCore.REFERENCE_BEING_COMPLETED) == null) {
            String text = call.getText();
            this.addMemberToRType(text, Type.CALL_ACCESS, access.getFullReference());
        }
    }

    @Override
    public void visitObjectClassAccess(@NotNull ObjectClassAccess access) {
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(10);
        }
        RObjectClass rObjectClass = access.getObjectClass();
        for (RMethod method : RContainerUtilCore.selectElementsByType((List)rObjectClass.getStructureElements(), RMethod.class)) {
            if (method instanceof RSingletonMethod) continue;
            RType type = RTypeUtil.addMember(this.myOldType, (Symbol)new RMethodSymbolImpl(method, null));
            this.myTypeMap.put(this.myExpression, type);
        }
    }

    @Override
    public void visitSingletonMethodAccess(@NotNull SingletonMethodAccess access) {
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(11);
        }
        RSingletonMethod method = access.getSingletonMethod();
        RType type = RTypeUtil.addMember(this.myOldType, (Symbol)new RMethodSymbolImpl((RMethod)method, null));
        this.myTypeMap.put(this.myExpression, type);
    }

    @Override
    public void visitKindOfCondition(@NotNull KindOfCondition kindOfCondition) {
        if (kindOfCondition == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(12);
        }
        ArrayList<RType> types = new ArrayList<RType>();
        for (RPsiElement argument : kindOfCondition.getArguments()) {
            for (RType type : RTypeUtil.flattenUnionType((RType)this.myGetType.fun((Object)((SymbolicExpression)this.myGetSymbolicExpression.fun((Object)argument))))) {
                if (!(type instanceof RModuleType)) continue;
                RType newType = ((RModuleType)type).getGenericType();
                if (types.addAll(ContainerUtil.filter(RTypeUtil.flattenUnionType(this.myOldType), it -> RTypeUtil.isSubtype(it, newType) == ThreeState.YES))) continue;
                types.add(newType);
            }
        }
        if (!types.isEmpty()) {
            this.myTypeMap.put(this.myExpression, RTypeUtil.union(types));
        }
    }

    @Override
    public void visitRespondsToCondition(@NotNull RespondsToCondition respondsToCondition) {
        RPsiElement receiver;
        if (respondsToCondition == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(13);
        }
        if ((receiver = respondsToCondition.getFullReference().getReceiver()) == null) {
            return;
        }
        SymbolicExpression expression = (SymbolicExpression)this.myGetSymbolicExpression.fun((Object)receiver);
        List<RPsiElement> args = respondsToCondition.getArgs();
        if (args.size() == 1) {
            String text = args.get(0).getName();
            this.myOldType = (RType)this.myGetType.fun((Object)expression);
            if (text != null) {
                this.addMemberToRType(text, Type.CALL_ACCESS, (RPsiElement)respondsToCondition.getFullReference());
            }
        }
    }

    private void addMemberToRType(@NotNull String text, @NotNull Type accessType, @NotNull RPsiElement reference) {
        if (text == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(14);
        }
        if (accessType == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(15);
        }
        if (reference == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(16);
        }
        if (this.myOldType.getMemberForName(text, Symbol.Filter.ACCEPT_ALL, (PsiElement)this.myElement) == null && TypeInferenceUsagesVisitor.getObjectResults(this.myElement.getProject(), text) == null) {
            RType type = RTypeUtil.addMember(this.myOldType, (Symbol)new CallSymbol(text, accessType, reference));
            this.myTypeMap.put(this.myExpression, type);
        }
    }

    @Nullable
    private static Symbol getObjectResults(Project project, String name) {
        return RTypeFactory.createTypeByFQN(project, "Object").getMemberForName(name, Symbol.Filter.ACCEPT_ALL, null);
    }

    public static void processAccess(@NotNull Access access, @NotNull SymbolicExpression expression, @NotNull RPsiElement element, @NotNull NotNullFunction<RPsiElement, SymbolicExpression> getSymbolicExpression, @NotNull NotNullFunction<SymbolicExpression, RType> getType, @NotNull Map<SymbolicExpression, RType> typeMap) {
        if (access == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(17);
        }
        if (expression == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(18);
        }
        if (element == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(19);
        }
        if (getSymbolicExpression == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(20);
        }
        if (getType == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(21);
        }
        if (typeMap == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(22);
        }
        new TypeInferenceUsagesVisitor(expression, element, getSymbolicExpression, getType, typeMap).accept(access);
    }

    public static void processCondition(@NotNull Condition condition, @NotNull SymbolicExpression expression, @NotNull RPsiElement element, @NotNull NotNullFunction<RPsiElement, SymbolicExpression> getSymbolicExpression, @NotNull NotNullFunction<SymbolicExpression, RType> getType, @NotNull Map<SymbolicExpression, RType> typeMap) {
        if (condition == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(23);
        }
        if (expression == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(24);
        }
        if (element == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(25);
        }
        if (getSymbolicExpression == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(26);
        }
        if (getType == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(27);
        }
        if (typeMap == null) {
            TypeInferenceUsagesVisitor.$$$reportNull$$$0(28);
        }
        new TypeInferenceUsagesVisitor(expression, element, getSymbolicExpression, getType, typeMap).accept(condition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getSymbolicExpression";
                break;
            }
            case 3: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getType";
                break;
            }
            case 4: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMap";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindOfCondition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "respondsToCondition";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/TypeInferenceUsagesVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRescueBlockParameterAccess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExplicitTypeAccess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFieldWriteAccess";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstantAccess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallAccess";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitObjectClassAccess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSingletonMethodAccess";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitKindOfCondition";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRespondsToCondition";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addMemberToRType";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "processAccess";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "processCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

