/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeComputer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RTopConstReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public final class PsiTypeInferenceVisitor
extends RubyElementVisitor {
    @NotNull
    private RType myResult;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TypeComputer myTypeComputer;

    private PsiTypeInferenceVisitor(@NotNull Project project, @NotNull TypeComputer typeComputer) {
        if (project == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(0);
        }
        if (typeComputer == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(1);
        }
        this.myResult = REmptyType.INSTANCE;
        this.myProject = project;
        this.myTypeComputer = typeComputer;
    }

    public void visitRAssocList(@NotNull RAssocList rAssocList) {
        if (rAssocList == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(2);
        }
        Pair<RType, RType> type = this.getHashElementType(rAssocList.getElements());
        this.myResult = RTypeFactory.createHashType(this.myProject, (RType)type.first, (RType)type.second);
    }

    public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
        if (rBinaryExpression == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(3);
        }
        if (rBinaryExpression instanceof RRangeExpression) {
            REmptyType rangeType;
            RRangeExpression rangeExpression = (RRangeExpression)rBinaryExpression;
            RPsiElement left = rangeExpression.getLeftOperand();
            RPsiElement right = rangeExpression.getRightOperand();
            Object object = rangeType = left instanceof RExpression ? this.getType(left) : REmptyType.INSTANCE;
            if (right instanceof RExpression) {
                rangeType = RTypeUtil.union((RType)rangeType, this.getType(right));
            }
            this.myResult = RTypeFactory.createRangeType(this.myProject, (RType)rangeType);
        } else {
            this.myResult = REmptyType.INSTANCE;
        }
    }

    public void visitRBoolMatchingExpression(@NotNull RBoolMatchingExpression rBoolMatchingExpression) {
        if (rBoolMatchingExpression == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(4);
        }
        this.myResult = List.of(RubyTokenTypes.tMATCH, RubyTokenTypes.tCMP).contains(rBoolMatchingExpression.getOperationType()) ? RTypeFactory.createIntType(this.myProject) : RTypeFactory.createBoolType(this.myProject);
    }

    public void visitRInstanceVariable(@NotNull RInstanceVariable rInstanceVariable) {
        if (rInstanceVariable == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(5);
        }
        this.visitRField((RField)rInstanceVariable);
    }

    public void visitRClassVariable(@NotNull RClassVariable rClassVariable) {
        if (rClassVariable == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(6);
        }
        this.visitRField((RField)rClassVariable);
    }

    public void visitRField(RField field) {
    }

    public void visitRGlobalVariable(@NotNull RGlobalVariable rGlobalVariable) {
        if (rGlobalVariable == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(7);
        }
    }

    public void visitRConstant(@NotNull RConstant rConstant) {
        if (rConstant == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(8);
        }
    }

    public void visitGroupedExpression(@NotNull RGroupedExpression groupedExpression) {
        if (groupedExpression == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(9);
        }
        if (groupedExpression.getExpression() instanceof RExpression) {
            this.myResult = this.getType(groupedExpression.getExpression());
        }
    }

    public void visitRHeredocId(@NotNull RHeredocId heredocId) {
        if (heredocId == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(10);
        }
        this.myResult = RTypeFactory.createStringType(this.myProject);
    }

    public void visitRIfModStatement(@NotNull RIfModStatement rIfModStatement) {
        if (rIfModStatement == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(11);
        }
        this.myResult = this.getType(rIfModStatement.getCommand());
    }

    public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
        if (ifStatement == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(12);
        }
        RCompoundStatement thenBlock = ifStatement.getThenBlock();
        List elsifBlocks = ifStatement.getElsifBlocks();
        RElseBlock elseBlock = ifStatement.getElseBlock();
        RType result = this.getType((RPsiElement)thenBlock);
        for (RElsifBlock elsifBlock : elsifBlocks) {
            result = RTypeUtil.union(result, elsifBlock.getBody().getType());
        }
        if (elseBlock != null) {
            result = RTypeUtil.union(result, elseBlock.getBody().getType());
        }
        this.myResult = result;
    }

    public void visitRLambda(@NotNull RLambda rLambda) {
        if (rLambda == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(13);
        }
        this.myResult = RTypeFactory.createTypeClassName("Proc", (RPsiElement)rLambda);
    }

    public void visitRModule(@NotNull RModule rModule) {
        if (rModule == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(14);
        }
        Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)rModule);
        this.myResult = RTypeFactory.createTypeBySymbol(symbol);
    }

    public void visitRArray(@NotNull RArray array) {
        if (array == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(15);
        }
        this.myResult = RTypeFactory.createArrayType(this.myProject, this.getCollectionElementTypes(array.getElements()));
    }

    public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
        RPsiElement receiver;
        if (arrayIndexing == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(16);
        }
        if ((receiver = arrayIndexing.getReceiver()) instanceof RConstant) {
            List indexes = arrayIndexing.getIndexes();
            String name = receiver.getName();
            if ("Set".equals(name) || "Array".equals(name)) {
                List<RType> itemTypes = this.getCollectionElementTypes(indexes);
                this.myResult = "Set".equals(name) ? RTypeFactory.createSetType(this.myProject, RTypeUtil.union(itemTypes)) : RTypeFactory.createArrayType(this.myProject, itemTypes);
            }
        }
    }

    public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(17);
        }
        this.myResult = this.getType(assignmentExpression.getValue());
    }

    public void visitRBoolNegExpression(@NotNull RBoolNegExpression rBoolNegExpression) {
        if (rBoolNegExpression == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(18);
        }
        if (rBoolNegExpression.getElement() == null) {
            return;
        }
        RType type = this.getType(rBoolNegExpression.getElement());
        this.myResult = RTypeUtil.notType(this.myProject, type);
    }

    public void visitRReturnStatement(@NotNull RReturnStatement rReturnStatement) {
        RListOfExpressions returnList;
        if (rReturnStatement == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(19);
        }
        this.myResult = (returnList = rReturnStatement.getReturnList()) == null ? REmptyType.INSTANCE : (returnList.getElements().size() > 1 ? RTypeFactory.createTypeClassName(this.myProject, "Array", Visibility.PUBLIC) : this.getType(returnList.getFirstElement()));
    }

    public void visitRSelfAssignmentExpression(RSelfAssignmentExpression selfAssignmentExpression) {
        this.myResult = RTypeUtil.union(this.getType(selfAssignmentExpression.getObject()), this.getType(selfAssignmentExpression.getValue()));
    }

    public void visitRStringLiteral(@NotNull RStringLiteral rStringLiteral) {
        if (rStringLiteral == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(20);
        }
        this.myResult = RTypeFactory.createStringType((RPsiElement)rStringLiteral);
    }

    public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
        if (rDStringLiteral == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(21);
        }
        this.myResult = RTypeFactory.createStringType((RPsiElement)rDStringLiteral);
    }

    public void visitRSymbol(@NotNull RSymbol rSymbol) {
        if (rSymbol == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(22);
        }
        this.myResult = RTypeFactory.createTypeClassName(this.myProject, "Symbol", Visibility.PUBLIC);
    }

    public void visitRSymbols(@NotNull RWords rSymbols) {
        if (rSymbols == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(23);
        }
        this.visitSymbols(rSymbols);
    }

    public void visitRDSymbols(@NotNull RWords rdSymbols) {
        if (rdSymbols == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(24);
        }
        this.visitSymbols(rdSymbols);
    }

    public void visitRWords(@NotNull RWords words) {
        if (words == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(25);
        }
        this.visitWords(words);
    }

    public void visitRDWords(@NotNull RWords words) {
        if (words == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(26);
        }
        this.visitWords(words);
    }

    public void visitRTernaryExpression(@NotNull RTernaryExpression ternaryExpression) {
        if (ternaryExpression == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(27);
        }
        this.myResult = RTypeUtil.union(this.getType(ternaryExpression.getFalseCommand()), this.getType(ternaryExpression.getTrueCommand()));
    }

    public void visitRTopConstReference(@NotNull RTopConstReference rTopConstReference) {
        Symbol symbol;
        if (rTopConstReference == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(28);
        }
        if ((symbol = ResolveUtil.resolveToSymbolWithCaching(rTopConstReference.getReference())) == null) {
            this.myResult = REmptyType.INSTANCE;
        } else {
            if (Types.MODULE_OR_CLASS.contains(symbol.getType())) {
                symbol = symbol.getSingletonClassSymbol();
            }
            this.myResult = RTypeFactory.createTypeBySymbol(symbol);
        }
    }

    public void visitRUnaryExpression(@NotNull RUnaryExpression rUnaryExpression) {
        IElementType type;
        if (rUnaryExpression == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(29);
        }
        if (RubyTokenTypes.tEXCLAMATION == (type = rUnaryExpression.getOperationType())) {
            RPsiElement element = rUnaryExpression.getElement();
            this.myResult = element instanceof RExpression ? RTypeUtil.notType(rUnaryExpression.getProject(), this.getType(element)) : RTypeFactory.createBoolType(rUnaryExpression.getProject());
        }
    }

    public void visitRUnlessModStatement(@NotNull RUnlessModStatement rUnlessModStatement) {
        if (rUnlessModStatement == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(30);
        }
        RPsiElement command = rUnlessModStatement.getCommand();
        this.myResult = this.getType(command);
    }

    public void visitRUnlessStatement(@NotNull RUnlessStatement rUnlessStatement) {
        if (rUnlessStatement == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(31);
        }
        RCompoundStatement thenBlock = rUnlessStatement.getThenBlock();
        RElseBlock elseBlock = rUnlessStatement.getElseBlock();
        RType result = this.getType((RPsiElement)thenBlock);
        if (elseBlock != null) {
            result = RTypeUtil.union(result, this.getType((RPsiElement)elseBlock.getBody()));
        }
        this.myResult = result;
    }

    @NotNull
    public static RType getExpressionType(@NotNull RExpression element, @NotNull TypeComputer getType) {
        if (element == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(32);
        }
        if (getType == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(33);
        }
        PsiTypeInferenceVisitor visitor = new PsiTypeInferenceVisitor(element.getProject(), getType);
        element.accept((PsiElementVisitor)visitor);
        RType rType = visitor.myResult;
        if (rType == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(34);
        }
        return rType;
    }

    @NotNull
    private List<RType> getCollectionElementTypes(@NotNull List<RPsiElement> indexes) {
        if (indexes == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(35);
        }
        ArrayList<RType> elementTypes = new ArrayList<RType>();
        for (RPsiElement element : indexes) {
            elementTypes.add((RType)(element instanceof RExpression ? this.getType(element) : REmptyType.INSTANCE));
        }
        ArrayList<RType> arrayList = elementTypes;
        if (arrayList == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    private Pair<RType, RType> getHashElementType(@NotNull List<RPsiElement> indexes) {
        if (indexes == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(37);
        }
        REmptyType keyType = REmptyType.INSTANCE;
        REmptyType valueType = REmptyType.INSTANCE;
        int size = indexes.size();
        int typedElements = 0;
        for (int i = 0; i < size && typedElements < 5; ++i) {
            RPsiElement arg = indexes.get(i);
            if (!(arg instanceof RAssoc)) continue;
            RPsiElement key = ((RAssoc)arg).getKey();
            RPsiElement value = ((RAssoc)arg).getValue();
            if (!(key instanceof RExpression) && !(key instanceof RAssocKey) && !(value instanceof RExpression)) continue;
            keyType = RTypeUtil.union((RType)keyType, key instanceof RAssocKey ? RTypeFactory.createSymbolType(this.myProject) : this.getType(key));
            valueType = RTypeUtil.union((RType)valueType, this.getType(value));
            ++typedElements;
        }
        Pair pair = Pair.create((Object)keyType, (Object)valueType);
        if (pair == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(38);
        }
        return pair;
    }

    @NotNull
    private RType getType(@Nullable RPsiElement element) {
        if (!(element instanceof RExpression)) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                PsiTypeInferenceVisitor.$$$reportNull$$$0(39);
            }
            return rEmptyType;
        }
        RType rType = this.myTypeComputer.computeType((RExpression)element);
        if (rType == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(40);
        }
        return rType;
    }

    private void visitWords(@NotNull RWords rWords) {
        if (rWords == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(41);
        }
        this.myResult = RTypeFactory.createArrayType(this.myProject, RTypeFactory.createStringType((RPsiElement)rWords));
    }

    private void visitSymbols(@NotNull RWords rWords) {
        if (rWords == null) {
            PsiTypeInferenceVisitor.$$$reportNull$$$0(42);
        }
        RType elementType = RTypeFactory.createTypeClassName(this.myProject, "Symbol", Visibility.PUBLIC);
        this.myResult = RTypeFactory.createArrayType(this.myProject, elementType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 34, 36, 38, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeComputer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAssocList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBinaryExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolMatchingExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rInstanceVariable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClassVariable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rGlobalVariable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConstant";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredocId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIfModStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rLambda";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rModule";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayIndexing";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolNegExpression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rReturnStatement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rStringLiteral";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDStringLiteral";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbol";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbols";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdSymbols";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ternaryExpression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rTopConstReference";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUnaryExpression";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUnlessModStatement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUnlessStatement";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getType";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/PsiTypeInferenceVisitor";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexes";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/PsiTypeInferenceVisitor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionType";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCollectionElementTypes";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getHashElementType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssocList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitRBinaryExpression";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitRBoolMatchingExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitRInstanceVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRClassVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitRGlobalVariable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitRConstant";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitGroupedExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRHeredocId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitRIfModStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRIfStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitRLambda";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitRModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitRArray";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayIndexing";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssignmentExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitRBoolNegExpression";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitRReturnStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitRStringLiteral";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitRDStringLiteral";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitRSymbol";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitRSymbols";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitRDSymbols";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitRWords";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitRDWords";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitRTernaryExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitRTopConstReference";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnaryExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnlessModStatement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitRUnlessStatement";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionType";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionElementTypes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getHashElementType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitWords";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitSymbols";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 34, 36, 38, 39, 40 -> new IllegalStateException(string);
        };
    }
}

