/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBracedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public final class PsiNilAnalysisVisitor
extends RubyElementVisitor {
    private ThreeState myResult;
    @NotNull
    private final Function<? super RPsiElement, ThreeState> myCanBeNilComputer;
    private static final List<Class<?>> NOT_NIL_ELEMENTS = Arrays.asList(RLiteral.class, RBracedExpression.class, RSymbol.class, RBoolNegExpression.class, RLambda.class, RModule.class, RClass.class);

    private PsiNilAnalysisVisitor(@NotNull Function<? super RPsiElement, ThreeState> canBeNilComputer) {
        if (canBeNilComputer == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(0);
        }
        this.myResult = ThreeState.UNSURE;
        this.myCanBeNilComputer = canBeNilComputer;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(1);
        }
        if (NOT_NIL_ELEMENTS.stream().anyMatch(clazz -> clazz.isInstance(element))) {
            this.myResult = ThreeState.NO;
            return;
        }
        if (element instanceof RPsiElement) {
            this.myResult = this.myCanBeNilComputer.apply((RPsiElement)((RPsiElement)element));
        }
    }

    public void visitGroupedExpression(@NotNull RGroupedExpression groupedExpression) {
        RPsiElement expression;
        if (groupedExpression == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(2);
        }
        if ((expression = groupedExpression.getExpression()) != null) {
            this.myResult = this.myCanBeNilComputer.apply((RPsiElement)expression);
        }
    }

    public void visitRBoolMatchingExpression(@NotNull RBoolMatchingExpression expression) {
        if (expression == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(3);
        }
        this.myResult = expression.getOperationType() == RubyTokenTypes.tMATCH ? this.myCanBeNilComputer.apply((RPsiElement)expression) : ThreeState.NO;
    }

    public void visitRTernaryExpression(@NotNull RTernaryExpression ternaryExpression) {
        if (ternaryExpression == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(4);
        }
        RPsiElement trueCommand = ternaryExpression.getTrueCommand();
        RPsiElement falseCommand = ternaryExpression.getFalseCommand();
        if (trueCommand != null) {
            this.myResult = this.myCanBeNilComputer.apply((RPsiElement)trueCommand);
        } else if (falseCommand != null) {
            this.myResult = this.myCanBeNilComputer.apply((RPsiElement)falseCommand);
        }
    }

    public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(5);
        }
        if (assignmentExpression.getValue() != null) {
            this.myResult = this.myCanBeNilComputer.apply((RPsiElement)assignmentExpression.getValue());
        }
    }

    public void visitRSelfAssignmentExpression(RSelfAssignmentExpression selfAssignmentExpression) {
        this.myResult = this.myCanBeNilComputer.apply((RPsiElement)selfAssignmentExpression.getObject());
        if (selfAssignmentExpression.getValue() != null) {
            IElementType op = selfAssignmentExpression.getOperationType();
            if (op == RubyTokenTypes.tAND_OP_ASGN) {
                this.myResult = NilAnalysisUtil.mergeCanBeNil(this.myResult, this.myCanBeNilComputer.apply((RPsiElement)selfAssignmentExpression.getValue()));
            } else if (op == RubyTokenTypes.tOR_OP_ASGN) {
                ThreeState anotherValue = this.myCanBeNilComputer.apply((RPsiElement)selfAssignmentExpression.getValue());
                this.myResult = this.myResult == ThreeState.NO || anotherValue == ThreeState.NO ? ThreeState.NO : (this.myResult == ThreeState.YES && anotherValue == ThreeState.YES ? ThreeState.YES : ThreeState.UNSURE);
            }
        }
    }

    public static ThreeState getCanBeNil(@NotNull PsiElement element, @NotNull Function<? super RPsiElement, ThreeState> canBeNilComputer) {
        if (element == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(6);
        }
        if (canBeNilComputer == null) {
            PsiNilAnalysisVisitor.$$$reportNull$$$0(7);
        }
        PsiNilAnalysisVisitor visitor = new PsiNilAnalysisVisitor(canBeNilComputer);
        element.accept((PsiElementVisitor)visitor);
        return visitor.myResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeNilComputer";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ternaryExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/PsiNilAnalysisVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGroupedExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBoolMatchingExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRTernaryExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRAssignmentExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCanBeNil";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

