/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors;

import com.intellij.codeInsight.controlflow.ConditionalInstruction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionTypeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.RCaseStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public class NilAnalysisConditionVisitor
extends RubyElementVisitor {
    boolean myResult;
    @NotNull
    final SymbolicExpressionProvider myProvider;
    @NotNull
    final SymbolicExecutionContext myContext;
    @NotNull
    final Map<SymbolicExpression, ThreeState> myCanBeNilMap;

    public NilAnalysisConditionVisitor(boolean result, @NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context, @NotNull Map<SymbolicExpression, ThreeState> canBeNilMap) {
        if (provider == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(1);
        }
        if (canBeNilMap == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(2);
        }
        this.myResult = result;
        this.myProvider = provider;
        this.myContext = context;
        this.myCanBeNilMap = canBeNilMap;
    }

    public static void processCondition(@NotNull ConditionalInstruction condition, @NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context, @NotNull Map<SymbolicExpression, ThreeState> canBeNilMap) {
        if (condition == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(4);
        }
        if (context == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(5);
        }
        if (canBeNilMap == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(6);
        }
        NilAnalysisConditionVisitor visitor = new NilAnalysisConditionVisitor(condition.getResult(), provider, context, canBeNilMap);
        PsiElement element = condition.getCondition();
        if (element instanceof RCondition) {
            visitor.visitRCondition((RCondition)element);
        } else {
            element.accept((PsiElementVisitor)visitor);
        }
    }

    public ThreeState getCanBeNil(@NotNull SymbolicExpression expression) {
        ThreeState canBeNil;
        if (expression == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(7);
        }
        return (canBeNil = this.myCanBeNilMap.get(expression)) != null ? canBeNil : ThreeState.UNSURE;
    }

    public void visitRCondition(@NotNull RCondition rCondition) {
        if (rCondition == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(8);
        }
        rCondition.getFirstChild().accept((PsiElementVisitor)this);
    }

    public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
        IElementType operationType;
        if (rBinaryExpression == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(9);
        }
        if ((operationType = rBinaryExpression.getOperationType()) == RubyTokenTypes.tNEQ || operationType == RubyTokenTypesCore.tEQ) {
            RPsiElement leftOperand = rBinaryExpression.getLeftOperand();
            RPsiElement rightOperand = rBinaryExpression.getRightOperand();
            if (leftOperand == null || rightOperand == null) {
                return;
            }
            boolean leftIsNil = RubyPsiUtil.isNil(leftOperand);
            boolean rightIsNil = RubyPsiUtil.isNil(rightOperand);
            if (leftIsNil && !rightIsNil) {
                this.overrideSymbolicVariable(rightOperand, ThreeState.fromBoolean((boolean)(this.myResult ^ operationType == RubyTokenTypes.tNEQ)));
            } else if (!leftIsNil && rightIsNil) {
                this.overrideSymbolicVariable(leftOperand, ThreeState.fromBoolean((boolean)(this.myResult ^ operationType == RubyTokenTypes.tNEQ)));
            }
        }
    }

    public void visitRBoolNegExpression(@NotNull RBoolNegExpression rBoolNegExpression) {
        if (rBoolNegExpression == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(10);
        }
        this.myResult = !this.myResult;
        rBoolNegExpression.getLastChild().accept((PsiElementVisitor)this);
    }

    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(11);
        }
        if (this.myResult) {
            this.overrideSymbolicVariable((RPsiElement)rIdentifier, ThreeState.NO);
        }
    }

    public void visitRListOfExpressions(@NotNull RListOfExpressions expressions) {
        if (expressions == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(12);
        }
        if (!this.myResult) {
            return;
        }
        RCaseStatement caseStatement = RCaseStatementNavigator.getByWhenCondition((PsiElement)expressions);
        if (caseStatement == null) {
            return;
        }
        RPsiElement expression = caseStatement.getExpression();
        if (expression == null) {
            return;
        }
        Project project = expressions.getProject();
        if (ContainerUtil.and((Iterable)expressions.getElements(), it -> this.isNonNilConstant(project, (RPsiElement)it))) {
            this.overrideSymbolicVariable(expression, ThreeState.NO);
        }
    }

    public void visitRReference(@NotNull RReference rReference) {
        if (rReference == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(13);
        }
        if (rReference.getReceiver() == null) {
            return;
        }
        if (rReference instanceof RDotReference && ((RDotReference)rReference).isSafeNavigation() && !this.myResult) {
            return;
        }
        String command = rReference.getCommand();
        if ("nil?".equals(command)) {
            this.overrideSymbolicVariable(rReference.getReceiver(), ThreeState.fromBoolean((boolean)this.myResult));
        } else if ("blank?".equals(command)) {
            if (!this.myResult) {
                this.overrideSymbolicVariable(rReference.getReceiver(), ThreeState.NO);
            }
        } else if ("present?".equals(command)) {
            if (this.myResult) {
                this.overrideSymbolicVariable(rReference.getReceiver(), ThreeState.NO);
            }
        } else if (!NilAnalysisUtil.isClassMethod(rReference.getProject(), "NilClass", command)) {
            this.overrideSymbolicVariable(rReference.getReceiver(), ThreeState.NO);
        }
    }

    public void visitRCall(@NotNull RCall rCall) {
        PsiElement psiCommand;
        if (rCall == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(14);
        }
        if (!((psiCommand = rCall.getPsiCommand()) instanceof RDotReference)) {
            return;
        }
        String command = ((RDotReference)psiCommand).getCommand();
        if (!"is_a?".equals(command)) {
            return;
        }
        List arguments = rCall.getArguments();
        if (arguments.size() != 1) {
            return;
        }
        RPsiElement receiver = rCall.getReceiver();
        if (receiver == null || receiver.getName() == null) {
            return;
        }
        SymbolicExpression receiverExpression = this.myContext.getLocalMemory().readLocalValue(receiver.getName());
        if (this.getCanBeNil(receiverExpression) == ThreeState.NO) {
            return;
        }
        if (RTypeUtilCore.isNotEmpty((RType)this.getType((RPsiElement)arguments.get(0))) && this.myResult) {
            this.overrideSymbolicVariable(receiver, ThreeState.NO);
        }
    }

    public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignmentExpression) {
        if (assignmentExpression == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(15);
        }
        assignmentExpression.getObject().accept((PsiElementVisitor)this);
    }

    public void visitRSelfAssignmentExpression(@NotNull RSelfAssignmentExpression selfAssignmentExpression) {
        if (selfAssignmentExpression == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(16);
        }
        this.visitRAssignmentExpression((RAssignmentExpression)selfAssignmentExpression);
    }

    public void visitGroupedExpression(@NotNull RGroupedExpression groupedExpression) {
        RPsiElement expression;
        if (groupedExpression == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(17);
        }
        if ((expression = groupedExpression.getExpression()) != null) {
            expression.accept((PsiElementVisitor)this);
        }
    }

    public void visitRCompoundStatement(@NotNull RCompoundStatement rCompoundStatement) {
        List statements;
        if (rCompoundStatement == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(18);
        }
        if (!(statements = rCompoundStatement.getStatements()).isEmpty()) {
            ((RPsiElement)statements.get(statements.size() - 1)).accept((PsiElementVisitor)this);
        }
    }

    private void overrideSymbolicVariable(@NotNull RPsiElement element, @NotNull ThreeState newValue) {
        if (element == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(19);
        }
        if (newValue == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(20);
        }
        if (element.getName() == null) {
            return;
        }
        SymbolicExpression prevExpression = this.myContext.getLocalMemory().readLocalValue(element.getName());
        SymbolicExpression expression = NilAnalysisUtil.assignNewSymbolicExpressionIfNil(this.myProvider, this.myContext, element, prevExpression);
        if (expression != null) {
            this.myCanBeNilMap.put(expression, newValue);
        }
    }

    @NotNull
    private RType getType(@NotNull RPsiElement element) {
        if (element == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(21);
        }
        RType rType = this.myProvider.getSymbolicExpression(element, this.myContext).getType((SymbolicExpressionTypeHolder)this.myContext.getComponent(TypeInferenceComponent.class));
        if (rType == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(22);
        }
        return rType;
    }

    private boolean isNonNilConstant(@NotNull Project project, @NotNull RPsiElement element) {
        if (project == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(23);
        }
        if (element == null) {
            NilAnalysisConditionVisitor.$$$reportNull$$$0(24);
        }
        if (!(element instanceof RConstant) && !(element instanceof RColonReference)) {
            return false;
        }
        RType nilClassType = RTypeFactory.createSingletonTypeByFqn(project, "NilClass", (PsiElement)element);
        return RTypeUtilCore.isNullOrEmpty((RType)nilClassType) || !this.getType(element).equals(nilClassType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeNilMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCondition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBinaryExpression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolNegExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rReference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfAssignmentExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCompoundStatement";
                break;
            }
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/NilAnalysisConditionVisitor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/visitors/NilAnalysisConditionVisitor";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processCondition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCanBeNil";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitRCondition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitRBinaryExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRBoolNegExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitRIdentifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRListOfExpressions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitRReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitRCall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssignmentExpression";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitRSelfAssignmentExpression";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitGroupedExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitRCompoundStatement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "overrideSymbolicVariable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 22: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isNonNilConstant";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22 -> new IllegalStateException(string);
        };
    }
}

