/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary;

import com.google.common.io.CountingInputStream;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.io.AbstractStringEnumerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProviderCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SummaryBuilderInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.Summary;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.SummaryImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;

public final class SummaryUtil {
    public static void serializeSummary(@NotNull Summary summary, @NotNull StubOutputStream stream) throws IOException {
        if (summary == null) {
            SummaryUtil.$$$reportNull$$$0(0);
        }
        if (stream == null) {
            SummaryUtil.$$$reportNull$$$0(1);
        }
        SummaryUtil.doSerializeSummary(summary, stream);
    }

    @NotNull
    public static Summary deserializeSummary(@NotNull StubInputStream dataInputStream) throws IOException {
        if (dataInputStream == null) {
            SummaryUtil.$$$reportNull$$$0(2);
        }
        return SummaryUtil.doDeserializeSummary(dataInputStream);
    }

    @NotNull
    static SymbolicExpression getSymbolicExpression(@NotNull RPsiElement psi) {
        ControlFlowHolder holder;
        if (psi == null) {
            SummaryUtil.$$$reportNull$$$0(3);
        }
        if ((holder = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)psi, ControlFlowHolder.class)) == null) {
            SymbolicExpression symbolicExpression = SymbolicExpressionProviderCore.INVALID_SYMBOLIC_EXPRESSION;
            if (symbolicExpression == null) {
                SummaryUtil.$$$reportNull$$$0(4);
            }
            return symbolicExpression;
        }
        SymbolicExpressionProvider caching = SummaryUtil.getSymbolicExpressionProviderCaching(holder);
        if (caching == null) {
            SymbolicExpression symbolicExpression = SymbolicExpressionProviderCore.INVALID_SYMBOLIC_EXPRESSION;
            if (symbolicExpression == null) {
                SummaryUtil.$$$reportNull$$$0(5);
            }
            return symbolicExpression;
        }
        SymbolicExpression expression = caching.tryGetSymbolicExpression(psi);
        if (expression == null) {
            SymbolicExpression symbolicExpression = SymbolicExpressionProviderCore.INVALID_SYMBOLIC_EXPRESSION;
            if (symbolicExpression == null) {
                SummaryUtil.$$$reportNull$$$0(6);
            }
            return symbolicExpression;
        }
        SymbolicExpression symbolicExpression = expression;
        if (symbolicExpression == null) {
            SummaryUtil.$$$reportNull$$$0(7);
        }
        return symbolicExpression;
    }

    @Nullable
    private static SymbolicExpressionProvider getSymbolicExpressionProviderCaching(@NotNull ControlFlowHolder holder) {
        if (holder == null) {
            SummaryUtil.$$$reportNull$$$0(8);
        }
        return (SymbolicExpressionProvider)CachedValuesManager.getCachedValue((PsiElement)holder, () -> {
            SymbolicExecutionResult result = new SummaryBuilderInstance(holder).performAnalysis(true);
            if (result == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{holder});
            }
            return CachedValueProvider.Result.create((Object)result.getMethodContext(), (Object[])new Object[]{holder});
        });
    }

    @NotNull
    static Summary computeSummaryForMethod(@NotNull RMethod method) {
        if (method == null) {
            SummaryUtil.$$$reportNull$$$0(9);
        }
        SummaryBuilderInstance instance = new SummaryBuilderInstance((ControlFlowHolder)method);
        SymbolicExecutionResult result = instance.performAnalysis(false);
        Summary summary = instance.computeSummary(result);
        if (summary == null) {
            SummaryUtil.$$$reportNull$$$0(10);
        }
        return summary;
    }

    private static void doSerializeSummary(@NotNull Summary summary, @NotNull StubOutputStream stream) throws IOException {
        if (summary == null) {
            SummaryUtil.$$$reportNull$$$0(11);
        }
        if (stream == null) {
            SummaryUtil.$$$reportNull$$$0(12);
        }
        SymbolicExpression returnValue = summary.getReturnValue();
        SymbolicExpressionUtil.serialize(StreamEx.ofNullable((Object)returnValue).append((Collection)summary.getSymbolicExpressionsForArguments()).append((Collection)summary.getYields()).toList(), stream);
        stream.writeVarInt(summary.getSymbolicExpressionsForArguments().size());
        for (SymbolicExpression expression : summary.getSymbolicExpressionsForArguments()) {
            stream.writeVarInt(expression.getId());
        }
        stream.writeVarInt(summary.getYields().size());
        for (SymbolicExpression expression : summary.getYields()) {
            stream.writeVarInt(expression.getId());
        }
        stream.writeVarInt(returnValue == null ? 0 : returnValue.getId());
    }

    @NotNull
    private static Summary doDeserializeSummary(@NotNull StubInputStream dataInputStream) throws IOException {
        if (dataInputStream == null) {
            SummaryUtil.$$$reportNull$$$0(13);
        }
        Map<Integer, SymbolicExpression> id2SymbolicExpression = SymbolicExpressionUtil.deserialize(dataInputStream);
        ArrayList<SymbolicExpression> arguments = new ArrayList<SymbolicExpression>();
        ArrayList<SymbolicCall> yields = new ArrayList<SymbolicCall>();
        int argumentSize = dataInputStream.readVarInt();
        for (int i = 0; i < argumentSize; ++i) {
            arguments.add(id2SymbolicExpression.get(dataInputStream.readVarInt()));
        }
        int yieldSize = dataInputStream.readVarInt();
        for (int i = 0; i < yieldSize; ++i) {
            SymbolicExpression symbolicExpression = id2SymbolicExpression.get(dataInputStream.readVarInt());
            assert (symbolicExpression instanceof SymbolicCall) : "should be a symbolic call";
            yields.add((SymbolicCall)symbolicExpression);
        }
        return new SummaryImpl(id2SymbolicExpression.get(dataInputStream.readVarInt()), arguments, yields);
    }

    private static void checkSerializationCorrectness(@NotNull Summary summary) throws IOException {
        if (summary == null) {
            SummaryUtil.$$$reportNull$$$0(14);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        AbstractStringEnumerator enumerator = new AbstractStringEnumerator(){
            Map<String, Integer> myIntegerMap = new HashMap<String, Integer>();
            Map<Integer, String> myStringMap = new HashMap<Integer, String>();

            public void markCorrupted() {
            }

            public boolean isDirty() {
                return false;
            }

            public void force() {
            }

            public int enumerate(@Nullable String value) throws IOException {
                Integer id = this.myIntegerMap.computeIfAbsent(value, unused -> this.myIntegerMap.size() + 1);
                this.myStringMap.putIfAbsent(id, value);
                return id;
            }

            @Nullable
            public String valueOf(int idx) throws IOException {
                return this.myStringMap.get(idx);
            }

            public void close() throws IOException {
            }
        };
        StubOutputStream outputStream = new StubOutputStream((OutputStream)byteArrayOutputStream, enumerator);
        SummaryUtil.doSerializeSummary(summary, outputStream);
        CountingInputStream in = new CountingInputStream((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        StubInputStream stubInputStream = new StubInputStream((InputStream)in, enumerator);
        SummaryUtil.deserializeSummary(stubInputStream);
        if ((long)outputStream.getWrittenBytesCount() != in.getCount()) assert (false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataInputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/summary/SummaryUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/summary/SummaryUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolicExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSummaryForMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serializeSummary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserializeSummary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolicExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolicExpressionProviderCaching";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeSummaryForMethod";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doSerializeSummary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doDeserializeSummary";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkSerializationCorrectness";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10 -> new IllegalStateException(string);
        };
    }
}

