/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ArgMapping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodAnnotationDataUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicContextComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionEngineImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProviderImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionTypeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicTypeInferenceProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.TypeAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.InferenceAndAnnotationsMerger;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SymbolicContextInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.SymbolicExecutionInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.summary.Summary;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.ArrayValueSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.MergedSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpressionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.MigrationVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.SymbolicCallEvaluationVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.MultiSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.PsiElementSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.ClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RubyTypeProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RModuleType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.RubySerializableTypeResolver;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RMethodBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RVariableBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.indexes.RubyGlobalVariableDeclarationNameIndex;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class TypeInferenceInstance
extends SymbolicContextInstance {
    private static final Graph<Instruction> EMPTY_GRAPH = new Graph<Instruction>(){

        @NotNull
        public Collection<Instruction> getNodes() {
            List<Instruction> list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public Iterator<Instruction> getIn(Instruction n) {
            Iterator<Instruction> iterator = Collections.emptyIterator();
            if (iterator == null) {
                1.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        @NotNull
        public Iterator<Instruction> getOut(Instruction n) {
            Iterator<Instruction> iterator = Collections.emptyIterator();
            if (iterator == null) {
                1.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/TypeInferenceInstance$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOut";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final int MAX_SUMMARY_SUBSTITUTION = 50;
    private static final int MAX_YIELD_SUMMARY_SUBSTITUTION = 10;
    public static final String YIELD = "yield";
    @NotNull
    private final Symbol myAnchor;
    @NotNull
    protected final Graph<Instruction> myGraph;
    private int mySummarySubstitutionCounter;
    private int mySummarySubstitutionLimit;
    private Set<Pair<PsiElement, PsiElement>> mySummarySubstitutionEntries;

    public TypeInferenceInstance(@NotNull Symbol anchor, @NotNull Graph<Instruction> graph, @NotNull SymbolicExpressionProvider provider) {
        if (anchor == null) {
            TypeInferenceInstance.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            TypeInferenceInstance.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            TypeInferenceInstance.$$$reportNull$$$0(2);
        }
        super(provider);
        this.mySummarySubstitutionCounter = 0;
        this.mySummarySubstitutionLimit = 0;
        this.mySummarySubstitutionEntries = new HashSet<Pair<PsiElement, PsiElement>>();
        this.myGraph = graph;
        this.myAnchor = anchor;
    }

    public TypeInferenceInstance(@NotNull Symbol anchor, @NotNull Graph<Instruction> graph, @Nullable PsiElement invocationPoint) {
        if (anchor == null) {
            TypeInferenceInstance.$$$reportNull$$$0(3);
        }
        if (graph == null) {
            TypeInferenceInstance.$$$reportNull$$$0(4);
        }
        this(anchor, graph, new SymbolicExpressionProviderImpl(invocationPoint, anchor.getProject()));
    }

    @Override
    public void fun(SymbolicExecutionContext context, SymbolicExpressionProvider methodContext, Instruction instruction) {
        super.fun(context, methodContext, instruction);
        PsiElement element = instruction.getElement();
        if (element instanceof RGlobalVariable) {
            RGlobalVariable globalVariable = (RGlobalVariable)element;
            this.processGlobalVariable(context, globalVariable);
        } else if (element instanceof RVariableBase) {
            RVariableBase variable = (RVariableBase)element;
            this.processVariables(context, variable);
        } else if (element instanceof RPossibleCall || element instanceof RBinaryExpression || element instanceof RUnaryExpression) {
            this.processCallAccess(context, instruction, (RPsiElement)element);
        }
        context.fun(instruction, this.mySymbolicExpressionProvider);
    }

    @NotNull
    public static RType getTypeOfRVariable(@NotNull RVariableBase rVariable, @Nullable PsiElement invocationPoint) {
        if (rVariable == null) {
            TypeInferenceInstance.$$$reportNull$$$0(5);
        }
        Symbol symbolContext = SymbolUtil.getScopeContextWithCaching((PsiElement)rVariable);
        Objects.requireNonNull(symbolContext, "RVariableBase should have a context symbol");
        TypeInferenceInstance typeInferenceInstance = new TypeInferenceInstance(symbolContext, EMPTY_GRAPH, invocationPoint);
        SymbolicExecutionContext context = typeInferenceInstance.initialContext();
        SymbolicExpression expression = typeInferenceInstance.evaluateRVariable(context, rVariable, invocationPoint);
        RType rType = expression.getType((SymbolicExpressionTypeHolder)context.getComponent(TypeInferenceComponent.class));
        if (rType == null) {
            TypeInferenceInstance.$$$reportNull$$$0(6);
        }
        return rType;
    }

    @Nullable
    public static Symbol lookupConstant(@NotNull FQN fqn, @NotNull Symbol anchor, @NotNull RPsiElement context, @Nullable PsiElement invocationPoint) {
        if (fqn == null) {
            TypeInferenceInstance.$$$reportNull$$$0(7);
        }
        if (anchor == null) {
            TypeInferenceInstance.$$$reportNull$$$0(8);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(9);
        }
        TypeInferenceInstance typeInferenceInstance = new TypeInferenceInstance(anchor, EMPTY_GRAPH, invocationPoint);
        SymbolicExecutionContext initialContext = typeInferenceInstance.initialContext();
        SymbolicExpressionProvider provider = typeInferenceInstance.getMethodContext();
        Ref result = Ref.create();
        CallContext callContext = new CallContext(provider.createSymbolicVariable(), anchor, context, invocationPoint, null);
        List components = fqn.asList();
        int size = components.size();
        for (int i = 0; i < size; ++i) {
            String name = (String)components.get(i);
            if (result.get() == null) {
                result.set((Object)provider.createSymbolicCall(Collections.emptyList(), name, null, true, false));
            } else {
                result.set((Object)provider.createSymbolicCall(Collections.emptyList(), name, (SymbolicExpression)result.get(), true, false));
            }
            if (i == size - 1) {
                return TypeInferenceInstance.resolveSymbolicCall((SymbolicCall)result.get(), initialContext, callContext);
            }
            result.set((Object)typeInferenceInstance.evaluateSymbolicCall((SymbolicCall)result.get(), initialContext, callContext));
        }
        return null;
    }

    @Override
    @NotNull
    protected List<SymbolicContextComponent> createComponents() {
        List<SymbolicContextComponent> list = Collections.singletonList(new TypeInferenceComponent(this.mySymbolicExpressionProvider));
        if (list == null) {
            TypeInferenceInstance.$$$reportNull$$$0(10);
        }
        return list;
    }

    private void processCallAccess(@NotNull SymbolicExecutionContext context, @NotNull Instruction instruction, @NotNull RPsiElement callableElement) {
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(11);
        }
        if (instruction == null) {
            TypeInferenceInstance.$$$reportNull$$$0(12);
        }
        if (callableElement == null) {
            TypeInferenceInstance.$$$reportNull$$$0(13);
        }
        if (callableElement instanceof RIdentifier) {
            SymbolicExpression evaluatedParameter;
            RIdentifier identifier = (RIdentifier)callableElement;
            if (identifier.isMethodParameterDeclaration() && (evaluatedParameter = SymbolicTypeInferenceProvider.evaluateMethodParameterFromProviders(this.mySymbolicExpressionProvider, context, identifier, (PsiElement)identifier)) != null) {
                this.mySymbolicExpressionProvider.setSymbolicExpression((RPsiElement)identifier, evaluatedParameter);
                return;
            }
            if (identifier.isParameter()) {
                this.tryUpdateTypeForParameterUsingMethodAnnotationData(context, identifier);
                return;
            }
            if (identifier.isLocalVariable()) {
                return;
            }
        }
        SymbolicExpression symbolicExpression = this.mySymbolicExpressionProvider.getSymbolicExpression(callableElement, context);
        if (callableElement instanceof RBlockCall) {
            return;
        }
        if (symbolicExpression instanceof SymbolicCall) {
            SymbolicExpression realSelfExpression;
            RBlockCall scopeHolder;
            SymbolicCall call = (SymbolicCall)symbolicExpression;
            RBlockCall blockCall = RBlockCallNavigator.getByCall((RPsiElement)callableElement);
            RCodeBlock rCodeBlock = blockCall != null ? blockCall.getBlock() : null;
            TypeInferenceComponent component = (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class);
            SymbolicExpression selfExpression = this.mySymbolicExpressionProvider.getSelfExpression((PsiElement)callableElement);
            if (selfExpression.getType((SymbolicExpressionTypeHolder)component) == REmptyType.INSTANCE && (scopeHolder = (RBlockCall)ObjectUtils.doIfCast((Object)ScopeUtilCore.findScopeHolder((PsiElement)callableElement), RCodeBlock.class, RBlockCallNavigator::getByBlock)) != null) {
                RType typeFromProviders = (RType)ObjectUtils.doIfNotNull((Object)scopeHolder, RubyTypeProvider::getBlockSelfTypeFromProviders);
                if (typeFromProviders != null) {
                    component.updateSymbolicExpressionType(selfExpression, typeFromProviders);
                } else if (!scopeHolder.isValidNamespace()) {
                    this.mySymbolicExpressionProvider.setSelfExpression((PsiElement)callableElement, this.mySymbolicExpressionProvider.getSelfExpression((PsiElement)scopeHolder));
                }
            }
            if ((realSelfExpression = this.mySymbolicExpressionProvider.getSelfExpression((PsiElement)callableElement)).getType((SymbolicExpressionTypeHolder)component) == REmptyType.INSTANCE) {
                component.updateSymbolicExpressionType(realSelfExpression, RTypeUtil.getTypeForSelf((PsiElement)callableElement, this.myAnchor));
            }
            CallContext callContext = new CallContext(realSelfExpression, this.myAnchor, callableElement, (PsiElement)callableElement, rCodeBlock);
            if (this.isBlockCallToCodeBlock(instruction)) {
                this.inferBlockParameterTypes(context, instruction, call, callContext);
            } else {
                this.mySummarySubstitutionCounter = 0;
                this.mySummarySubstitutionLimit = 50;
                this.mySummarySubstitutionEntries = new HashSet<Pair<PsiElement, PsiElement>>();
                SymbolicExpression evaluatedCall = this.evaluateSymbolicCall(call, context, callContext);
                if (!(callableElement instanceof RAssignmentExpression)) {
                    this.mySymbolicExpressionProvider.setSymbolicExpression(callableElement, evaluatedCall);
                }
            }
        }
    }

    private void tryUpdateTypeForParameterUsingMethodAnnotationData(@NotNull SymbolicExecutionContext context, @NotNull RIdentifier identifier) {
        RContainer container;
        MethodAnnotationData data;
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(14);
        }
        if (identifier == null) {
            TypeInferenceInstance.$$$reportNull$$$0(15);
        }
        if ((data = InferenceAndAnnotationsMerger.getAnnotationDataFromSymbolIfPossible((RElementWithFQN)(container = identifier.getParentContainer()))) == null) {
            return;
        }
        SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression((RPsiElement)identifier, context);
        Optional<SerializableType> serializableType = Optional.ofNullable(identifier.getName()).map(arg_0 -> ((MethodAnnotationData)data).getParameterType(arg_0));
        Boolean isProbableNil = serializableType.map(SerializableTypeUtil::isProbableNil).orElse(false);
        RType type = serializableType.map(it -> it.resolve(this.mySymbolicExpressionProvider.getProject(), (PsiElement)identifier)).orElse(null);
        if (type == null) {
            return;
        }
        ((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)).updateSymbolicExpressionType(expression, type);
        if (isProbableNil.booleanValue()) {
            ((NilAnalysisComponent)context.getComponent(NilAnalysisComponent.class)).updateCanBeNil(expression, ThreeState.YES);
        }
    }

    public void processVariables(@NotNull SymbolicExecutionContext context, @NotNull RVariableBase variable) {
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(16);
        }
        if (variable == null) {
            TypeInferenceInstance.$$$reportNull$$$0(17);
        }
        String name = variable.getName();
        if (variable.isDeclaration() || name == null || context.getLocalMemory().tryReadLocalValue(name) != null) {
            return;
        }
        Symbol symbol = ResolveUtil.resolveToFirstSymbolWithCaching(variable.getReferences());
        if (symbol == null) {
            return;
        }
        SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression((RPsiElement)variable, context);
        if (RTypeUtilCore.isNullOrEmpty((RType)expression.getType((SymbolicExpressionTypeHolder)context.getComponent(TypeInferenceComponent.class)))) {
            RType rType = RTypeFactory.createModuleOrClassType(variable.getProject(), symbol);
            if (RTypeUtilCore.isNullOrEmpty((RType)rType)) {
                rType = RTypeFactory.createTypeBySymbol(symbol);
            }
            if (RTypeUtilCore.isNotEmpty((RType)rType)) {
                ((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)).updateSymbolicExpressionType(expression, rType);
                return;
            }
        }
        ArrayList<SymbolicExpression> expressions = new ArrayList<SymbolicExpression>();
        for (PsiElement element : symbol.getAllDeclarations((PsiElement)variable)) {
            RInstanceVariable field;
            SerializableType type;
            RVariableBase var;
            RVariableBase varDeclPsi = element instanceof RVariableBase ? (var = (RVariableBase)element) : TypeInferenceInstance.convertToAttrAssign(symbol, (PsiElement)variable);
            if (varDeclPsi == null) continue;
            if (varDeclPsi instanceof RInstanceVariable && !(type = RTypeUtil.getInstanceVariableYardType(field = (RInstanceVariable)varDeclPsi)).equals(SerializableTypeUtil.EMPTY)) {
                expressions.add(this.mySymbolicExpressionProvider.createTypedSymbolicExpression(type));
                continue;
            }
            expressions.add(this.evaluateRVariable(context, varDeclPsi, (PsiElement)variable));
        }
        if (!expressions.isEmpty()) {
            this.mySymbolicExpressionProvider.setSymbolicExpression((RPsiElement)variable, this.mySymbolicExpressionProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)expressions)));
        }
    }

    private void processGlobalVariable(@NotNull SymbolicExecutionContext context, @NotNull RGlobalVariable globalVariable) {
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(18);
        }
        if (globalVariable == null) {
            TypeInferenceInstance.$$$reportNull$$$0(19);
        }
        String name = globalVariable.getName();
        if (globalVariable.isDeclaration()) {
            return;
        }
        SymbolicExpression evaluatedVariable = SymbolicTypeInferenceProvider.evaluateVariableFromProviders(this.mySymbolicExpressionProvider, context, (RVariable)globalVariable, (PsiElement)globalVariable);
        if (evaluatedVariable != null) {
            this.mySymbolicExpressionProvider.setSymbolicExpression((RPsiElement)globalVariable, evaluatedVariable);
            return;
        }
        Project project = globalVariable.getProject();
        GlobalSearchScope searchScope = globalVariable.getResolveScope();
        ArrayList expressions = new ArrayList();
        RubyGlobalVariableDeclarationNameIndex.getInstance().processElements(project, (SearchScope)searchScope, name, element -> {
            if (element instanceof RVariableBase) {
                RVariableBase variable = (RVariableBase)element;
                expressions.add(this.evaluateRVariable(context, variable, (PsiElement)globalVariable));
            }
            return true;
        });
        if (!expressions.isEmpty()) {
            this.mySymbolicExpressionProvider.setSymbolicExpression((RPsiElement)globalVariable, this.mySymbolicExpressionProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)expressions)));
        }
    }

    @NotNull
    private SymbolicExpression evaluateRVariable(@NotNull SymbolicExecutionContext context, @NotNull RVariableBase<?> variable, @Nullable PsiElement invocationPoint) {
        SymbolicExpression evaluatedVariable;
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(20);
        }
        if (variable == null) {
            TypeInferenceInstance.$$$reportNull$$$0(21);
        }
        if ((evaluatedVariable = SymbolicTypeInferenceProvider.evaluateVariableFromProviders(this.mySymbolicExpressionProvider, context, variable, (PsiElement)ObjectUtils.coalesce((Object)invocationPoint, variable))) != null) {
            SymbolicExpression symbolicExpression = evaluatedVariable;
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(22);
            }
            return symbolicExpression;
        }
        SymbolicExpression variableExpression = variable.getAssignedSymbolicExpression();
        if (variableExpression == null) {
            SymbolicExpression symbolicExpression = this.mySymbolicExpressionProvider.createSymbolicVariable();
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(23);
            }
            return symbolicExpression;
        }
        List<SymbolicExpression> expressions = SymbolicExpressionUtil.getTopologicallySortedExpressions(Collections.singletonList(variableExpression));
        HashMap caller2callee = new HashMap();
        expressions.forEach(it -> {
            SymbolicExpression migrated = MigrationVisitor.migrate(it, caller2callee, this.mySymbolicExpressionProvider);
            caller2callee.put(it, migrated);
            this.mySymbolicExpressionProvider.registerMigratedSymbolicExpression(migrated);
        });
        Symbol anchor = Objects.requireNonNull(SymbolUtil.getScopeContextWithCaching(variable), () -> {
            RElementWithFQN container = SymbolUtil.getContextContainer((PsiElement)variable);
            return "%s, is valid: %s".formatted(container, container.isValid());
        });
        CallContext callContext = new CallContext(this.mySymbolicExpressionProvider.createSymbolicVariable(), anchor, (RPsiElement)variable, invocationPoint, null);
        Computable evaluate = () -> this.evaluateSymbolicExpression(context, (SymbolicExpression)caller2callee.get(variableExpression), callContext);
        SymbolicExpression expression = (SymbolicExpression)RecursionManager.doPreventingRecursion(variable, (boolean)false, (Computable)evaluate);
        SymbolicExpression symbolicExpression = (SymbolicExpression)ObjectUtils.notNull((Object)expression, (Object)variableExpression);
        if (symbolicExpression == null) {
            TypeInferenceInstance.$$$reportNull$$$0(24);
        }
        return symbolicExpression;
    }

    private void inferBlockParameterTypes(@NotNull SymbolicExecutionContext context, @NotNull Instruction instruction, @NotNull SymbolicCall call, @NotNull CallContext callContext) {
        List<ArgumentInfo> argumentInfos;
        Symbol symbol;
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(25);
        }
        if (instruction == null) {
            TypeInferenceInstance.$$$reportNull$$$0(26);
        }
        if (call == null) {
            TypeInferenceInstance.$$$reportNull$$$0(27);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(28);
        }
        if ((symbol = TypeInferenceInstance.resolveSymbolicCall(call, context, callContext)) == null) {
            return;
        }
        RCodeBlock block = TypeInferenceInstance.getCodeBlock(instruction);
        if (block.getBlockArguments() != null) {
            argumentInfos = block.getBlockArguments().getArgumentInfos();
        } else {
            context.getLocalMemory().clearNumberedParameters(RubyPsiUtilCore.getLanguageLevel((PsiElement)block));
            argumentInfos = IntStream.rangeClosed(1, 10).mapToObj(i -> new ArgumentInfo("_" + i, ArgumentInfo.Type.SIMPLE)).toList();
        }
        List<SymbolicExpression> evaluatedBlockParameters = SymbolicTypeInferenceProvider.evaluateBlockParametersFromProviders(this.mySymbolicExpressionProvider, context, call, callContext, argumentInfos);
        if (evaluatedBlockParameters != null) {
            ((StreamEx)StreamEx.zip(argumentInfos, evaluatedBlockParameters, Pair::create).filter(it -> it.getSecond() != null)).forEach(pair -> {
                String name = ((ArgumentInfo)pair.getFirst()).getName();
                SymbolicExpression expression = (SymbolicExpression)pair.getSecond();
                context.getLocalMemory().writeLocalValue(name, expression);
                if (name.equals("_1") && !RubyPsiUtilCore.getLanguageLevel((PsiElement)block).isLessThan(LanguageLevel.RUBY34)) {
                    context.getLocalMemory().writeLocalValue("it", expression);
                }
            });
            return;
        }
        PsiElement methodDeclaration = (PsiElement)ContainerUtil.getOnlyItem((Collection)symbol.getAllDeclarations(callContext.getInvocationPoint()));
        if (methodDeclaration != null) {
            List<SymbolicExpression> blockParameterExpressions = InferenceAndAnnotationsMerger.mergeBlockParameterData(argumentInfos, (Computable<List<SymbolicExpression>>)((Computable)() -> this.getBlockParamTypesFromAnnotations(symbol, methodDeclaration)), (Computable<List<SymbolicExpression>>)((Computable)() -> {
                List<SymbolicCall> yieldExpressions = this.computeYieldExpressions(context, call, callContext, methodDeclaration);
                LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElementOrLatest((PsiElement)methodDeclaration);
                List yieldExpressionsAndMappings = ContainerUtil.map(yieldExpressions, expr -> Pair.create((Object)expr, TypeInferenceInstance.mapSymbolicCallToArgumentList(expr, argumentInfos, languageLevel)));
                TypeInferenceComponent component = (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class);
                ArrayList<SymbolicExpression> argumentInfoTypes = new ArrayList<SymbolicExpression>();
                for (int i = 0; i < argumentInfos.size(); ++i) {
                    ArrayList<SymbolicExpression> expressionsFromDifferentYields = new ArrayList<SymbolicExpression>();
                    for (Pair exprAndArgMapping : yieldExpressionsAndMappings) {
                        SymbolicExpression yieldExpression;
                        RType type;
                        SymbolicCall yieldCall = (SymbolicCall)exprAndArgMapping.getFirst();
                        if (yieldCall.getArguments().size() == 1 && argumentInfos.size() > 1 && RTypeUtilCore.isArrayType((RType)(type = (yieldExpression = ((SymbolicCall.SymbolicArgumentInfo)ContainerUtil.getOnlyItem((Collection)yieldCall.getArguments())).getExpression()).getType((SymbolicExpressionTypeHolder)component))) && type instanceof RCollectionType) {
                            List elementTypes = ((RCollectionType)type).getElementTypes();
                            if (elementTypes.size() != 1 && i >= elementTypes.size()) continue;
                            SymbolicExpression expression = this.mySymbolicExpressionProvider.createSymbolicVariable();
                            component.updateSymbolicExpressionType(expression, i < elementTypes.size() ? (RType)elementTypes.get(i) : (RType)elementTypes.get(0));
                            context.getLocalMemory().writeLocalValue(((ArgumentInfo)argumentInfos.get(i)).getName(), expression);
                            expressionsFromDifferentYields.add(expression);
                            continue;
                        }
                        ArgMapping.MappingRange argumentRange = (ArgMapping.MappingRange)((Map)exprAndArgMapping.getSecond()).get(argumentInfos.get(i));
                        if (argumentRange == null || argumentRange.count() != 1) continue;
                        expressionsFromDifferentYields.add(((SymbolicCall.SymbolicArgumentInfo)((SymbolicCall)exprAndArgMapping.getFirst()).getArguments().get(argumentRange.first())).getExpression());
                    }
                    if (!expressionsFromDifferentYields.isEmpty()) {
                        argumentInfoTypes.add(this.mySymbolicExpressionProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)expressionsFromDifferentYields)));
                        continue;
                    }
                    argumentInfoTypes.add(null);
                }
                return argumentInfoTypes;
            }));
            ((StreamEx)StreamEx.zip(argumentInfos, blockParameterExpressions, Pair::create).filter(pair -> pair.getSecond() != null)).forEach(pair -> context.getLocalMemory().writeLocalValue(((ArgumentInfo)pair.getFirst()).getName(), (SymbolicExpression)pair.getSecond()));
        }
    }

    @NotNull
    private List<SymbolicExpression> getBlockParamTypesFromAnnotations(@NotNull Symbol methodSymbol, @NotNull PsiElement methodDeclaration) {
        if (methodSymbol == null) {
            TypeInferenceInstance.$$$reportNull$$$0(29);
        }
        if (methodDeclaration == null) {
            TypeInferenceInstance.$$$reportNull$$$0(30);
        }
        MethodAnnotationData annotationData = InferenceAndAnnotationsMerger.getAnnotationDataFromSymbolIfPossible(methodSymbol, methodDeclaration);
        if (methodDeclaration instanceof RMethod && annotationData != null) {
            List list = ContainerUtil.map((Collection)annotationData.getYieldParameterTypes(), type -> this.mySymbolicExpressionProvider.createTypedSymbolicExpression(type));
            if (list == null) {
                TypeInferenceInstance.$$$reportNull$$$0(31);
            }
            return list;
        }
        List<SymbolicExpression> list = Collections.emptyList();
        if (list == null) {
            TypeInferenceInstance.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    private List<SymbolicCall> computeYieldExpressions(@NotNull SymbolicExecutionContext context, @NotNull SymbolicCall call, @NotNull CallContext callContext, @NotNull PsiElement methodDeclaration) {
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(33);
        }
        if (call == null) {
            TypeInferenceInstance.$$$reportNull$$$0(34);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(35);
        }
        if (methodDeclaration == null) {
            TypeInferenceInstance.$$$reportNull$$$0(36);
        }
        if (!(methodDeclaration instanceof RMethodBase)) {
            List<SymbolicCall> list = Collections.emptyList();
            if (list == null) {
                TypeInferenceInstance.$$$reportNull$$$0(37);
            }
            return list;
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElementOrLatest((PsiElement)methodDeclaration);
        List list = StreamEx.of((Object)methodDeclaration).toFlatList(it -> {
            RMethodBase methodBase = (RMethodBase)it;
            Summary summary = methodBase.getSummary();
            if (summary == null || summary.getYields().size() > 10) {
                return Collections.emptyList();
            }
            CallContext newCallContext = callContext.with((RPsiElement)methodBase).with(call).with(Objects.requireNonNull(SymbolUtil.getScopeContextWithCaching((PsiElement)methodBase), "RMethodBase should have a parent scope")).resetCodeBlock();
            return this.evaluateYieldedValuesBySummary(call, methodBase.getArgumentInfos(), context, languageLevel, summary, newCallContext);
        });
        if (list == null) {
            TypeInferenceInstance.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    private SymbolicExpression evaluateSymbolicCall(@NotNull SymbolicCall symbolicCall, @NotNull SymbolicExecutionContext context, @NotNull CallContext callContext) {
        RType rType;
        PsiElement psiElement;
        Symbol symbol;
        Symbol anchorFromElement;
        if (symbolicCall == null) {
            TypeInferenceInstance.$$$reportNull$$$0(39);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(40);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(41);
        }
        Symbol originAnchor = callContext.getAnchor();
        SymbolicExpression evaluatedCall = SymbolicTypeInferenceProvider.evaluateSymbolicCallFromProviders(this.mySymbolicExpressionProvider, context, symbolicCall, callContext);
        if (evaluatedCall != null) {
            SymbolicExpression symbolicExpression = evaluatedCall;
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(42);
            }
            return symbolicExpression;
        }
        if (callContext.myElement instanceof RAssignmentExpression) {
            SymbolicCall symbolicCall2 = symbolicCall;
            if (symbolicCall2 == null) {
                TypeInferenceInstance.$$$reportNull$$$0(43);
            }
            return symbolicCall2;
        }
        String name = symbolicCall.getName();
        if (name.startsWith("$")) {
            Project project = callContext.myAnchor.getProject();
            Collection elements = RubyGlobalVariableDeclarationNameIndex.getInstance().getElements(project, (SearchScope)GlobalSearchScope.allScope((Project)project), StringUtil.trimStart((String)name, (String)"$"));
            if (ContainerUtil.getOnlyItem((Collection)elements) instanceof RGlobalVariable) {
                SymbolicExpression expression = (SymbolicExpression)ObjectUtils.doIfCast(elements.iterator().next(), RVariableBase.class, RVariableBase::getAssignedSymbolicExpression);
                SymbolicExpression symbolicExpression = (SymbolicExpression)ObjectUtils.coalesce((Object)expression, (Object)symbolicCall);
                if (symbolicExpression == null) {
                    TypeInferenceInstance.$$$reportNull$$$0(44);
                }
                return symbolicExpression;
            }
        }
        if (YIELD.equals(name)) {
            SymbolicExpression symbolicExpression = Optional.ofNullable(this.getYieldCallResultExpression(symbolicCall, context, callContext)).orElseGet(() -> this.mySymbolicExpressionProvider.createSymbolicVariable());
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(45);
            }
            return symbolicExpression;
        }
        RPsiElement element = callContext.getElement();
        if (!(element instanceof RMethod) && (anchorFromElement = SymbolUtil.getScopeContextWithCaching((PsiElement)element)) != null) {
            originAnchor = anchorFromElement;
        }
        if ((symbol = TypeInferenceInstance.resolveSymbolicCall(symbolicCall, context, callContext.with(originAnchor))) == null) {
            SymbolicCall symbolicCall3 = symbolicCall;
            if (symbolicCall3 == null) {
                TypeInferenceInstance.$$$reportNull$$$0(46);
            }
            return symbolicCall3;
        }
        if (symbol.getType() == Type.CONSTANT && (psiElement = symbol.getPsiElement()) instanceof RVariableBase) {
            RVariableBase var = (RVariableBase)psiElement;
            return this.evaluateRVariable(context, var, callContext.getInvocationPoint());
        }
        if (Types.MODULE_OR_CLASS_OR_FILE.contains(symbol.getType()) && RTypeUtilCore.isNotEmpty((RType)(rType = RTypeFactory.createModuleOrClassType(callContext.myElement.getProject(), symbol)))) {
            ((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)).updateSymbolicExpressionType((SymbolicExpression)symbolicCall, rType);
            SymbolicCall symbolicCall4 = symbolicCall;
            if (symbolicCall4 == null) {
                TypeInferenceInstance.$$$reportNull$$$0(47);
            }
            return symbolicCall4;
        }
        if (symbol instanceof MultiSymbol) {
            SymbolicExpression expression = this.mySymbolicExpressionProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)ContainerUtil.map((Collection)((MultiSymbol)symbol).getSymbols(), s -> this.evaluateSymbolCallWithSymbol(this.mySymbolicExpressionProvider.createSymbolicCall(symbolicCall.getArguments(), name, symbolicCall.getReceiver(), symbolicCall.isConstant(), symbolicCall.isBlockGiven()), context, callContext, (Symbol)s))));
            this.mySymbolicExpressionProvider.registerMigratedSymbolicExpression(expression);
            SymbolicExpression symbolicExpression = expression;
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(48);
            }
            return symbolicExpression;
        }
        return this.evaluateSymbolCallWithSymbol(symbolicCall, context, callContext, symbol);
    }

    @Nullable
    private SymbolicExpression getYieldCallResultExpression(@NotNull SymbolicCall symbolicCall, @NotNull SymbolicExecutionContext context, @NotNull CallContext callContext) {
        if (symbolicCall == null) {
            TypeInferenceInstance.$$$reportNull$$$0(49);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(50);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(51);
        }
        return InferenceAndAnnotationsMerger.mergeBlockReturnData((NullableComputable<SymbolicExpression>)((NullableComputable)() -> {
            RMethod coveringMethod = RubyPsiUtil.getContainingRMethod((PsiElement)callContext.getElement());
            if (coveringMethod == null) {
                return null;
            }
            return Optional.ofNullable(coveringMethod.getAnnotationData().getYieldReturnType()).map(type -> this.mySymbolicExpressionProvider.createTypedSymbolicExpression(type)).orElse(null);
        }), (NullableComputable<SymbolicExpression>)((NullableComputable)() -> {
            if (callContext.myCurrentCodeBlock == null) {
                return null;
            }
            RCodeBlock codeBlock = callContext.myCurrentCodeBlock;
            RBlockArgumentList arguments = codeBlock.getBlockArguments();
            SymbolicExecutionContext newContext = arguments != null ? this.createContextForInlining(symbolicCall, context, (RArgumentList)arguments, callContext) : context.copy();
            return this.doInlining((ControlFlowHolder)codeBlock, newContext, context);
        }));
    }

    @NotNull
    private SymbolicExpression doInlining(@NotNull ControlFlowHolder controlFlowHolder, final @NotNull SymbolicExecutionContext initialContext, @NotNull SymbolicExecutionContext calleeContext) {
        if (controlFlowHolder == null) {
            TypeInferenceInstance.$$$reportNull$$$0(52);
        }
        if (initialContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(53);
        }
        if (calleeContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(54);
        }
        RControlFlow controlFlow = controlFlowHolder.getControlFlow();
        Graph graph = RControlFlowUtil.getGraphWithoutRBlockCall((RControlFlow)controlFlow);
        Instruction[] instructions = controlFlow.getInstructions();
        SymbolicExecutionEngineImpl engine = new SymbolicExecutionEngineImpl(graph, (SymbolicExecutionInstance)new TypeInferenceInstance(this.myAnchor, graph, this.mySymbolicExpressionProvider){

            @Override
            @NotNull
            public SymbolicExecutionContext initialContext() {
                SymbolicExecutionContext symbolicExecutionContext = initialContext;
                if (symbolicExecutionContext == null) {
                    2.$$$reportNull$$$0(0);
                }
                return symbolicExecutionContext;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/TypeInferenceInstance$2", "initialContext"));
            }
        });
        ArrayList<SymbolicExpression> returnExpressions = new ArrayList<SymbolicExpression>();
        engine.performSymbolicExecution();
        SymbolicExecutionContext context = (SymbolicExecutionContext)engine.getResult().getInstruction2OutContext().get(instructions[instructions.length - 1]);
        if (context == null) {
            SymbolicExpression symbolicExpression = this.mySymbolicExpressionProvider.createSymbolicVariable();
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(55);
            }
            return symbolicExpression;
        }
        for (Instruction it : instructions[instructions.length - 1].allPred()) {
            if (!(it.getElement() instanceof RPsiElement)) continue;
            SymbolicExpression expression = this.mySymbolicExpressionProvider.getSymbolicExpression((RPsiElement)it.getElement(), context);
            returnExpressions.add(expression);
        }
        TypeInferenceComponent component = (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class);
        TypeInferenceComponent calleeComponent = (TypeInferenceComponent)calleeContext.getComponent(TypeInferenceComponent.class);
        SymbolicExpression returnValue = this.mySymbolicExpressionProvider.createExpression(id -> MergedSymbolicExpressionImpl.fromList((SymbolicExpression.IdSupplier)id, (List)returnExpressions));
        for (SymbolicExpression expression : SymbolicExpressionUtil.getTopologicallySortedExpressions(returnExpressions)) {
            RType rType = expression.getType((SymbolicExpressionTypeHolder)component);
            if (!RTypeUtilCore.isNotEmpty((RType)rType)) continue;
            calleeComponent.updateSymbolicExpressionType(expression, rType);
        }
        SymbolicExpression symbolicExpression = returnValue;
        if (symbolicExpression == null) {
            TypeInferenceInstance.$$$reportNull$$$0(56);
        }
        return symbolicExpression;
    }

    @NotNull
    private SymbolicExecutionContext createContextForInlining(@NotNull SymbolicCall call, @NotNull SymbolicExecutionContext context, @NotNull RArgumentList argumentList, @NotNull CallContext callContext) {
        if (call == null) {
            TypeInferenceInstance.$$$reportNull$$$0(57);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(58);
        }
        if (argumentList == null) {
            TypeInferenceInstance.$$$reportNull$$$0(59);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(60);
        }
        SymbolicExecutionContext newContext = context.copy();
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElementOrLatest((PsiElement)argumentList);
        Map<ArgumentInfo, ArgMapping.MappingRange> map = TypeInferenceInstance.mapSymbolicCallToArgumentList(call, argumentList.getArgumentInfos(), languageLevel);
        for (ArgumentInfo info : argumentList.getArgumentInfos()) {
            ArgMapping.MappingRange range = map.get(info);
            if (range == null || range.count() != 1) continue;
            newContext.getLocalMemory().writeLocalValue(info.getName(), this.evaluateSymbolicExpression(newContext, ((SymbolicCall.SymbolicArgumentInfo)call.getArguments().get(range.first())).getExpression(), callContext));
        }
        SymbolicExecutionContext symbolicExecutionContext = newContext;
        if (symbolicExecutionContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(61);
        }
        return symbolicExecutionContext;
    }

    @NotNull
    private SymbolicExpression evaluateSymbolCallWithSymbol(@NotNull SymbolicCall symbolicCall, @NotNull SymbolicExecutionContext context, @NotNull CallContext callContext, @NotNull Symbol symbol) {
        RType typeFromTypedSymbol;
        if (symbolicCall == null) {
            TypeInferenceInstance.$$$reportNull$$$0(62);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(63);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(64);
        }
        if (symbol == null) {
            TypeInferenceInstance.$$$reportNull$$$0(65);
        }
        RPsiElement element = callContext.getElement();
        RVariableBase variable = TypeInferenceInstance.convertToAttrAssign(symbol, (PsiElement)element);
        RType rType = RubyTypeProvider.createTypeBySymbolFromProviders((Symbol)symbol, Collections.emptyList());
        if (RTypeUtilCore.isNotEmpty((RType)rType)) {
            ((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)).updateSymbolicExpressionType((SymbolicExpression)symbolicCall, rType);
            SymbolicCall symbolicCall2 = symbolicCall;
            if (symbolicCall2 == null) {
                TypeInferenceInstance.$$$reportNull$$$0(66);
            }
            return symbolicCall2;
        }
        ThreeState nilability = RTypeUtil.getNilabilityFromSymbol(symbol);
        if (nilability != ThreeState.UNSURE) {
            context.withComponent(NilAnalysisComponent.class, component -> component.updateCanBeNil((SymbolicExpression)symbolicCall, nilability));
        }
        if (RTypeUtilCore.isNotEmpty((RType)(typeFromTypedSymbol = RTypeUtil.getTypeFromTypedSymbol((PsiElement)element, symbol)))) {
            ((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)).updateSymbolicExpressionType((SymbolicExpression)symbolicCall, typeFromTypedSymbol);
        } else {
            if (variable != null) {
                return this.evaluateRVariable(context, variable, (PsiElement)element);
            }
            if (symbol instanceof ClassModuleSymbol && symbolicCall.getArguments().isEmpty()) {
                SymbolicExpression expression = this.mySymbolicExpressionProvider.createTypedSymbolicExpression(SerializableTypeUtil.createFullyQualifiedType((String)symbol.getFQNWithNesting().getFullPath()));
                ((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)).updateSymbolicExpressionType(expression, RTypeFactory.createTypeBySymbol(symbol));
                SymbolicExpression symbolicExpression = expression;
                if (symbolicExpression == null) {
                    TypeInferenceInstance.$$$reportNull$$$0(67);
                }
                return symbolicExpression;
            }
            if (symbol instanceof PsiElementSymbol) {
                RType typeInferredBySymbolicExecution;
                Symbol anchor;
                PsiElement invocationPoint1;
                Project project;
                RType returnTypeFromComment;
                SerializableType serializableReturnTypeFromComment;
                RMethodBase calledMethod = (RMethodBase)ObjectUtils.tryCast((Object)symbol.getPsiElement(), RMethodBase.class);
                if (calledMethod == null) {
                    SymbolicCall symbolicCall3 = symbolicCall;
                    if (symbolicCall3 == null) {
                        TypeInferenceInstance.$$$reportNull$$$0(68);
                    }
                    return symbolicCall3;
                }
                LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElementOrLatest((PsiElement)calledMethod);
                Summary summary = calledMethod.getSummary();
                if (summary == null || summary.getReturnValue() == null) {
                    SymbolicCall symbolicCall4 = symbolicCall;
                    if (symbolicCall4 == null) {
                        TypeInferenceInstance.$$$reportNull$$$0(69);
                    }
                    return symbolicCall4;
                }
                CallContext newCallContext = callContext.with((RPsiElement)calledMethod).with(symbolicCall).with(Objects.requireNonNull(SymbolUtil.getScopeContextWithCaching((PsiElement)calledMethod), "RMethodBase should have a parent scope"));
                if (!(callContext.getElement() instanceof RPossibleCall)) {
                    newCallContext = newCallContext.resetCodeBlock();
                }
                SymbolicExpression expression = this.evaluateReturnValueBySummary(symbolicCall, calledMethod.getArgumentInfos(), context, languageLevel, summary, callContext, newCallContext);
                RType selfType = symbolicCall.getReceiver() != null ? symbolicCall.getReceiver().getType((SymbolicExpressionTypeHolder)context.getComponent(TypeInferenceComponent.class)) : callContext.getSelf().getType((SymbolicExpressionTypeHolder)context.getComponent(TypeInferenceComponent.class));
                PsiElement invocationPoint = callContext.getInvocationPoint();
                MethodAnnotationData methodAnnotationData = InferenceAndAnnotationsMerger.getAnnotationDataFromSymbolIfPossible(symbol, (PsiElement)calledMethod);
                if (TypeInferenceInstance.favorAnnotationTypeOverInferredType(methodAnnotationData, serializableReturnTypeFromComment = Optional.ofNullable(methodAnnotationData).map(it -> MethodAnnotationDataUtil.evaluateReturnTypeByInvocationPoint(it, this.mySymbolicExpressionProvider.getProject(), invocationPoint)).orElse(SerializableTypeUtil.EMPTY), returnTypeFromComment = RubySerializableTypeResolver.resolveType((SerializableType)serializableReturnTypeFromComment, (Project)(project = this.mySymbolicExpressionProvider.getProject()), (RType)selfType, (PsiElement)(invocationPoint1 = newCallContext.getInvocationPoint()), (Symbol)(anchor = newCallContext.getAnchor()), (RPsiElement)newCallContext.getElement()), typeInferredBySymbolicExecution = expression.getType((SymbolicExpressionTypeHolder)context.getComponent(TypeInferenceComponent.class)))) {
                    if (expression.getAttributeValue((AttributeKey)TypeAttribute.INSTANCE) != null) {
                        expression.removeAttribute((AttributeKey)TypeAttribute.INSTANCE);
                    }
                    ((TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class)).updateSymbolicExpressionType(expression, returnTypeFromComment);
                    TypeInferenceInstance.updateCanBeNilBasedOnMethodAnnotationData(expression, serializableReturnTypeFromComment, context);
                }
                SymbolicExpression symbolicExpression = expression;
                if (symbolicExpression == null) {
                    TypeInferenceInstance.$$$reportNull$$$0(70);
                }
                return symbolicExpression;
            }
        }
        SymbolicCall symbolicCall5 = symbolicCall;
        if (symbolicCall5 == null) {
            TypeInferenceInstance.$$$reportNull$$$0(71);
        }
        return symbolicCall5;
    }

    private static void updateCanBeNilBasedOnMethodAnnotationData(@NotNull SymbolicExpression expression, @NotNull SerializableType serializableReturnTypeFromComment, @NotNull SymbolicExecutionContext context) {
        if (expression == null) {
            TypeInferenceInstance.$$$reportNull$$$0(72);
        }
        if (serializableReturnTypeFromComment == null) {
            TypeInferenceInstance.$$$reportNull$$$0(73);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(74);
        }
        context.withComponent(NilAnalysisComponent.class, component -> {
            if (SerializableTypeUtil.isProbableNil((SerializableType)serializableReturnTypeFromComment)) {
                component.updateCanBeNil(expression, ThreeState.YES);
            }
        });
    }

    @NotNull
    private SymbolicExpression evaluateReturnValueBySummary(@NotNull SymbolicCall call, @NotNull List<ArgumentInfo> argumentInfos, @NotNull SymbolicExecutionContext context, @NotNull LanguageLevel languageLevel, @NotNull Summary summary, @NotNull CallContext argumentContext, @NotNull CallContext callContext) {
        if (call == null) {
            TypeInferenceInstance.$$$reportNull$$$0(75);
        }
        if (argumentInfos == null) {
            TypeInferenceInstance.$$$reportNull$$$0(76);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(77);
        }
        if (languageLevel == null) {
            TypeInferenceInstance.$$$reportNull$$$0(78);
        }
        if (summary == null) {
            TypeInferenceInstance.$$$reportNull$$$0(79);
        }
        if (argumentContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(80);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(81);
        }
        Map<SymbolicExpression, SymbolicExpression> callee2caller = this.buildCallee2CallerMapping(call, argumentInfos, context, languageLevel, summary, argumentContext);
        SymbolicExpression retValue = callee2caller.get(summary.getReturnValue());
        if (++this.mySummarySubstitutionCounter > this.mySummarySubstitutionLimit) {
            SymbolicExpression symbolicExpression = retValue;
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(82);
            }
            return symbolicExpression;
        }
        if (!this.mySummarySubstitutionEntries.add((Pair<PsiElement, PsiElement>)new Pair((Object)callContext.myElement, (Object)callContext.myInvocationPoint))) {
            SymbolicExpression symbolicExpression = retValue;
            if (symbolicExpression == null) {
                TypeInferenceInstance.$$$reportNull$$$0(83);
            }
            return symbolicExpression;
        }
        SymbolicExpression retValueSimplified = retValue.trySimplify(this.mySymbolicExpressionProvider);
        return this.evaluateSymbolicExpression(context, retValueSimplified, callContext);
    }

    @NotNull
    private List<SymbolicCall> evaluateYieldedValuesBySummary(@NotNull SymbolicCall call, @NotNull List<ArgumentInfo> argumentInfos, @NotNull SymbolicExecutionContext context, @NotNull LanguageLevel languageLevel, @NotNull Summary summary, @NotNull CallContext callContext) {
        if (call == null) {
            TypeInferenceInstance.$$$reportNull$$$0(84);
        }
        if (argumentInfos == null) {
            TypeInferenceInstance.$$$reportNull$$$0(85);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(86);
        }
        if (languageLevel == null) {
            TypeInferenceInstance.$$$reportNull$$$0(87);
        }
        if (summary == null) {
            TypeInferenceInstance.$$$reportNull$$$0(88);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(89);
        }
        Map<SymbolicExpression, SymbolicExpression> callee2caller = this.buildCallee2CallerMapping(call, argumentInfos, context, languageLevel, summary, callContext);
        List list = ContainerUtil.map((Collection)summary.getYields(), yield -> this.evaluateYield(context, callContext, callee2caller, (SymbolicCall)yield));
        if (list == null) {
            TypeInferenceInstance.$$$reportNull$$$0(90);
        }
        return list;
    }

    @NotNull
    private SymbolicCall evaluateYield(@NotNull SymbolicExecutionContext context, @NotNull CallContext callContext, @NotNull Map<SymbolicExpression, SymbolicExpression> caller2callee, @NotNull SymbolicCall yield) {
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(91);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(92);
        }
        if (caller2callee == null) {
            TypeInferenceInstance.$$$reportNull$$$0(93);
        }
        if (yield == null) {
            TypeInferenceInstance.$$$reportNull$$$0(94);
        }
        ArrayList<SymbolicCall.SymbolicArgumentInfo> arguments = new ArrayList<SymbolicCall.SymbolicArgumentInfo>();
        for (SymbolicCall.SymbolicArgumentInfo argument : yield.getArguments()) {
            arguments.add(this.evaluateSymbolicArgument(context, caller2callee, argument, callContext));
        }
        SymbolicCall symbolicCall = this.mySymbolicExpressionProvider.createSymbolicCall(arguments, yield.getName(), yield.getReceiver(), yield.isConstant(), false);
        if (symbolicCall == null) {
            TypeInferenceInstance.$$$reportNull$$$0(95);
        }
        return symbolicCall;
    }

    @NotNull
    private SymbolicCall.SymbolicArgumentInfo evaluateSymbolicArgument(@NotNull SymbolicExecutionContext context, @NotNull Map<SymbolicExpression, SymbolicExpression> caller2callee, @NotNull SymbolicCall.SymbolicArgumentInfo argument, @NotNull CallContext callContext) {
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(96);
        }
        if (caller2callee == null) {
            TypeInferenceInstance.$$$reportNull$$$0(97);
        }
        if (argument == null) {
            TypeInferenceInstance.$$$reportNull$$$0(98);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(99);
        }
        this.mySummarySubstitutionCounter = 0;
        this.mySummarySubstitutionLimit = 10;
        this.mySummarySubstitutionEntries = new HashSet<Pair<PsiElement, PsiElement>>();
        SymbolicExpression migratedArgument = this.evaluateSymbolicExpression(context, caller2callee.get(argument.getExpression()), callContext);
        return new SymbolicCall.SymbolicArgumentInfo(argument.getType(), argument.getKeyName(), migratedArgument);
    }

    @NotNull
    private SymbolicExpression evaluateSymbolicExpression(@NotNull SymbolicExecutionContext context, @NotNull SymbolicExpression expression, @NotNull CallContext callContext) {
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(100);
        }
        if (expression == null) {
            TypeInferenceInstance.$$$reportNull$$$0(101);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(102);
        }
        SymbolicExpression symbolicExpression = SymbolicCallEvaluationVisitor.evaluate(expression, this.mySymbolicExpressionProvider, (NotNullFunction<SymbolicCall, SymbolicExpression>)((NotNullFunction)call -> this.evaluateSymbolicCall((SymbolicCall)call, context, callContext)));
        if (symbolicExpression == null) {
            TypeInferenceInstance.$$$reportNull$$$0(103);
        }
        return symbolicExpression;
    }

    @NotNull
    private Map<SymbolicExpression, SymbolicExpression> buildCallee2CallerMapping(@NotNull SymbolicCall call, @NotNull List<ArgumentInfo> parameterInfos, @NotNull SymbolicExecutionContext context, @NotNull LanguageLevel languageLevel, @NotNull Summary summary, @NotNull CallContext argumentContext) {
        if (call == null) {
            TypeInferenceInstance.$$$reportNull$$$0(104);
        }
        if (parameterInfos == null) {
            TypeInferenceInstance.$$$reportNull$$$0(105);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(106);
        }
        if (languageLevel == null) {
            TypeInferenceInstance.$$$reportNull$$$0(107);
        }
        if (summary == null) {
            TypeInferenceInstance.$$$reportNull$$$0(108);
        }
        if (argumentContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(109);
        }
        Map<ArgumentInfo, ArgMapping.MappingRange> argMap = TypeInferenceInstance.mapSymbolicCallToArgumentList(call, parameterInfos, languageLevel);
        HashMap<SymbolicExpression, SymbolicExpression> callee2caller = new HashMap<SymbolicExpression, SymbolicExpression>();
        SymbolicExpression blockGivenSymbolicExpression = call.isBlockGiven() ? this.mySymbolicExpressionProvider.getTrueSymbolicExpression() : this.mySymbolicExpressionProvider.getFalseSymbolicExpression();
        callee2caller.put(this.mySymbolicExpressionProvider.getBlockGivenSymbolicExpression(), blockGivenSymbolicExpression);
        for (int i = 0; i < parameterInfos.size(); ++i) {
            SymbolicExpression expression;
            ArgumentInfo info = parameterInfos.get(i);
            ArgMapping.MappingRange range = argMap.get(info);
            if (info.getType() == ArgumentInfo.Type.ARRAY) {
                List arrayArgs = (range != null ? StreamSupport.stream(range.spliterator(), false) : Stream.empty()).map(argumentIndex -> ((SymbolicCall.SymbolicArgumentInfo)call.getArguments().get((int)argumentIndex)).getExpression()).collect(Collectors.toList());
                SymbolicExpression arrayArgSymbolicExpression = this.mySymbolicExpressionProvider.createExpression(id -> new ArrayValueSymbolicExpressionImpl((SymbolicExpression.IdSupplier)id, arrayArgs));
                callee2caller.put((SymbolicExpression)summary.getSymbolicExpressionsForArguments().get(i), arrayArgSymbolicExpression);
                continue;
            }
            if (info.getType() == ArgumentInfo.Type.HASH) {
                expression = this.mySymbolicExpressionProvider.createTypedSymbolicExpression(SerializableTypeUtil.createFullyQualifiedType((String)"Hash"));
                callee2caller.put((SymbolicExpression)summary.getSymbolicExpressionsForArguments().get(i), expression);
                continue;
            }
            if (range == null || range.count() != 1) continue;
            expression = this.evaluateSymbolicExpression(context, ((SymbolicCall.SymbolicArgumentInfo)call.getArguments().get(range.first())).getExpression(), argumentContext);
            callee2caller.put((SymbolicExpression)summary.getSymbolicExpressionsForArguments().get(i), expression);
        }
        List symbolicExpression = StreamEx.of((Object)summary.getReturnValue()).append((Collection)summary.getYields()).nonNull().toList();
        List<SymbolicExpression> expressions = SymbolicExpressionUtil.getTopologicallySortedExpressions(symbolicExpression);
        expressions.forEach(it -> callee2caller.put((SymbolicExpression)it, MigrationVisitor.migrate(it, callee2caller, this.mySymbolicExpressionProvider)));
        callee2caller.values().forEach(it -> this.mySymbolicExpressionProvider.registerMigratedSymbolicExpression(it));
        HashMap<SymbolicExpression, SymbolicExpression> hashMap = callee2caller;
        if (hashMap == null) {
            TypeInferenceInstance.$$$reportNull$$$0(110);
        }
        return hashMap;
    }

    @Nullable
    private static Symbol resolveSymbolicCall(@NotNull SymbolicCall symbolicCall, @NotNull SymbolicExecutionContext context, @NotNull CallContext callContext) {
        Symbol symbol;
        if (symbolicCall == null) {
            TypeInferenceInstance.$$$reportNull$$$0(111);
        }
        if (context == null) {
            TypeInferenceInstance.$$$reportNull$$$0(112);
        }
        if (callContext == null) {
            TypeInferenceInstance.$$$reportNull$$$0(113);
        }
        String name = symbolicCall.getName();
        PsiElement invocationPoint = callContext.getInvocationPoint();
        Symbol anchor = callContext.getAnchor();
        if (symbolicCall.getReceiver() == null) {
            if (symbolicCall.isConstant()) {
                symbol = SymbolUtil.lookupConstant(anchor, callContext.getElement(), FQN.of((String)name), Types.EMPTY_CONTEXT_RESOLVE_TYPES, invocationPoint);
            } else {
                SymbolicExpression self = callContext.getSelf();
                RType selfType = self.getType((SymbolicExpressionTypeHolder)context.getComponent(TypeInferenceComponent.class));
                if (selfType instanceof RModuleType) {
                    selfType = ((RModuleType)selfType).getOriginalType();
                }
                if (RubyTokenTypes.kSUPER.toString().equals(name)) {
                    symbol = Optional.ofNullable(RubyPsiUtil.getContainingRMethod((PsiElement)callContext.getElement())).map(method -> (Symbol)RubySuperMethodsSearch.search(method).findFirst()).orElse(null);
                } else if (selfType instanceof RSymbolType) {
                    Symbol contextSymbol = ((RSymbolType)selfType).getSymbol();
                    symbol = SymbolUtil.lookupMethod(contextSymbol, FQN.of((String)name), Types.EMPTY_CONTEXT_RESOLVE_TYPES.difference(Types.MODULE_OR_CLASS_OR_CONSTANT), invocationPoint);
                } else {
                    symbol = selfType.getMemberForName(name, Symbol.Filter.ACCEPT_ALL, invocationPoint);
                }
            }
        } else {
            RType type = symbolicCall.getReceiver().getType((SymbolicExpressionTypeHolder)context.getComponent(TypeInferenceComponent.class));
            if (symbolicCall.isConstant()) {
                if (type instanceof RModuleType) {
                    RModuleType moduleType = (RModuleType)type;
                    type = moduleType.getGenericType();
                }
                symbol = type.getMemberForName(name, it -> Types.MODULE_OR_CLASS_OR_CONSTANT.contains(it.getType()), invocationPoint);
            } else {
                symbol = type.getMemberForName(name, it -> !Types.FIELDS.contains(it.getType()), invocationPoint);
            }
        }
        if (symbol != null && symbol.getType() == Type.ALIAS) {
            symbol = SymbolUtil.getMethodSymbolByAlias(symbol);
        }
        return symbol;
    }

    private boolean isBlockCallToCodeBlock(@NotNull Instruction instruction) {
        List instructions;
        if (instruction == null) {
            TypeInferenceInstance.$$$reportNull$$$0(114);
        }
        if ((instructions = StreamEx.of((Iterator)this.myGraph.getOut((Object)instruction)).toList()).size() != 1 || !(((Instruction)instructions.get(0)).getElement() instanceof RPsiElement)) {
            return false;
        }
        if ((instructions = StreamEx.of((Iterator)this.myGraph.getOut((Object)((Instruction)instructions.get(0)))).toList()).size() != 1 || ((Instruction)instructions.get(0)).num() != 0) {
            return false;
        }
        PsiElement psiElement = instruction.getElement();
        if (!(psiElement instanceof RPsiElement)) {
            return false;
        }
        RPsiElement element = (RPsiElement)psiElement;
        return RBlockCallNavigator.getByCall((RPsiElement)((RPsiElement)ObjectUtils.coalesce((Object)((RPsiElement)ObjectUtils.tryCast((Object)element.getParent(), RLambdaCall.class)), (Object)element))) != null;
    }

    @NotNull
    private static RCodeBlock getCodeBlock(@NotNull Instruction instruction) {
        RPsiElement element;
        RBlockCall blockCall;
        PsiElement psiElement;
        if (instruction == null) {
            TypeInferenceInstance.$$$reportNull$$$0(115);
        }
        if ((psiElement = instruction.getElement()) instanceof RPsiElement && (blockCall = RBlockCallNavigator.getByCall((RPsiElement)((RPsiElement)ObjectUtils.coalesce((Object)((RPsiElement)ObjectUtils.tryCast((Object)(element = (RPsiElement)psiElement).getParent(), RLambdaCall.class)), (Object)element)))) != null) {
            RCodeBlock rCodeBlock = blockCall.getBlock();
            if (rCodeBlock == null) {
                TypeInferenceInstance.$$$reportNull$$$0(116);
            }
            return rCodeBlock;
        }
        throw new IllegalArgumentException("Instruction: " + String.valueOf(instruction) + "; element: " + String.valueOf(instruction.getElement()));
    }

    @Nullable
    private static RVariableBase convertToAttrAssign(@NotNull Symbol symbol, @Nullable PsiElement invocationPoint) {
        Collection<RVariableBase> result;
        if (symbol == null) {
            TypeInferenceInstance.$$$reportNull$$$0(117);
        }
        return (result = SymbolUtil.getFieldAssignmentsForAttributeAccessor(symbol, invocationPoint)) != null && !result.isEmpty() ? result.iterator().next() : null;
    }

    @NotNull
    private static Map<ArgumentInfo, ArgMapping.MappingRange> mapSymbolicCallToArgumentList(@NotNull SymbolicCall call, @NotNull List<ArgumentInfo> argumentInfos, @NotNull LanguageLevel languageLevel) {
        Map map;
        if (call == null) {
            TypeInferenceInstance.$$$reportNull$$$0(118);
        }
        if (argumentInfos == null) {
            TypeInferenceInstance.$$$reportNull$$$0(119);
        }
        if (languageLevel == null) {
            TypeInferenceInstance.$$$reportNull$$$0(120);
        }
        if ((map = ArgMapping.get(argumentInfos, index -> ((SymbolicCall.SymbolicArgumentInfo)call.getArguments().get((int)index)).getKeyName(), (List)ContainerUtil.map((Collection)call.getArguments(), SymbolicCall.SymbolicArgumentInfo::getType), (LanguageLevel)languageLevel)) == null) {
            Map<ArgumentInfo, ArgMapping.MappingRange> map2 = Collections.emptyMap();
            if (map2 == null) {
                TypeInferenceInstance.$$$reportNull$$$0(121);
            }
            return map2;
        }
        Map map3 = map;
        if (map3 == null) {
            TypeInferenceInstance.$$$reportNull$$$0(122);
        }
        return map3;
    }

    private static boolean favorAnnotationTypeOverInferredType(@Nullable MethodAnnotationData methodAnnotationData, @NotNull SerializableType serializableReturnTypeFromComment, @NotNull RType returnTypeFromComment, @Nullable RType typeInferredBySymbolicExecution) {
        if (serializableReturnTypeFromComment == null) {
            TypeInferenceInstance.$$$reportNull$$$0(123);
        }
        if (returnTypeFromComment == null) {
            TypeInferenceInstance.$$$reportNull$$$0(124);
        }
        if (serializableReturnTypeFromComment == SerializableTypeUtil.EMPTY || "Object".equals(returnTypeFromComment.getPresentableName())) {
            return false;
        }
        if (RTypeUtil.isMorePrecise(typeInferredBySymbolicExecution, returnTypeFromComment) == ThreeState.NO) {
            return false;
        }
        return !RTypeUtilCore.isNotEmpty((RType)typeInferredBySymbolicExecution) || methodAnnotationData == null || !methodAnnotationData.doesContainInformationInheritedFromSuper();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 10, 22, 23, 24, 31, 32, 37, 38, 42, 43, 44, 45, 46, 47, 48, 55, 56, 61, 66, 67, 68, 69, 70, 71, 82, 83, 90, 95, 103, 110, 116, 121, 122 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rVariable";
                break;
            }
            case 6: 
            case 10: 
            case 22: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 55: 
            case 56: 
            case 61: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 82: 
            case 83: 
            case 90: 
            case 95: 
            case 103: 
            case 110: 
            case 116: 
            case 121: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/TypeInferenceInstance";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 33: 
            case 40: 
            case 50: 
            case 58: 
            case 63: 
            case 74: 
            case 77: 
            case 86: 
            case 91: 
            case 96: 
            case 100: 
            case 106: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 26: 
            case 114: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callableElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVariable";
                break;
            }
            case 27: 
            case 34: 
            case 57: 
            case 75: 
            case 84: 
            case 104: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 28: 
            case 35: 
            case 41: 
            case 51: 
            case 60: 
            case 64: 
            case 81: 
            case 89: 
            case 92: 
            case 99: 
            case 102: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callContext";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSymbol";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDeclaration";
                break;
            }
            case 39: 
            case 49: 
            case 62: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicCall";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlowHolder";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialContext";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeContext";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 65: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 72: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 73: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializableReturnTypeFromComment";
                break;
            }
            case 76: 
            case 85: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfos";
                break;
            }
            case 78: 
            case 87: 
            case 107: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 79: 
            case 88: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 80: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentContext";
                break;
            }
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caller2callee";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = YIELD;
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfos";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTypeFromComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/TypeInferenceInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeOfRVariable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponents";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateRVariable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockParamTypesFromAnnotations";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "computeYieldExpressions";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSymbolicCall";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "doInlining";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextForInlining";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSymbolCallWithSymbol";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateReturnValueBySummary";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateYieldedValuesBySummary";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateYield";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateSymbolicExpression";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCallee2CallerMapping";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeBlock";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "mapSymbolicCallToArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfRVariable";
                break;
            }
            case 6: 
            case 10: 
            case 22: 
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 55: 
            case 56: 
            case 61: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 82: 
            case 83: 
            case 90: 
            case 95: 
            case 103: 
            case 110: 
            case 116: 
            case 121: 
            case 122: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lookupConstant";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processCallAccess";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryUpdateTypeForParameterUsingMethodAnnotationData";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processVariables";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalVariable";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "evaluateRVariable";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "inferBlockParameterTypes";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getBlockParamTypesFromAnnotations";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "computeYieldExpressions";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSymbolicCall";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getYieldCallResultExpression";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "doInlining";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createContextForInlining";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSymbolCallWithSymbol";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "updateCanBeNilBasedOnMethodAnnotationData";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "evaluateReturnValueBySummary";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "evaluateYieldedValuesBySummary";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "evaluateYield";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSymbolicArgument";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSymbolicExpression";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "buildCallee2CallerMapping";
                break;
            }
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbolicCall";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isBlockCallToCodeBlock";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getCodeBlock";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "convertToAttrAssign";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "mapSymbolicCallToArgumentList";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "favorAnnotationTypeOverInferredType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 10, 22, 23, 24, 31, 32, 37, 38, 42, 43, 44, 45, 46, 47, 48, 55, 56, 61, 66, 67, 68, 69, 70, 71, 82, 83, 90, 95, 103, 110, 116, 121, 122 -> new IllegalStateException(string);
        };
    }

    public static class CallContext {
        @NotNull
        private final SymbolicExpression mySelf;
        @NotNull
        private final Symbol myAnchor;
        @NotNull
        private final RPsiElement myElement;
        @Nullable
        private final PsiElement myInvocationPoint;
        @Nullable
        private final RCodeBlock myCurrentCodeBlock;

        public CallContext(@NotNull SymbolicExpression self, @NotNull Symbol anchor, @NotNull RPsiElement element, @Nullable PsiElement invocationPoint, @Nullable RCodeBlock codeBlock) {
            if (self == null) {
                CallContext.$$$reportNull$$$0(0);
            }
            if (anchor == null) {
                CallContext.$$$reportNull$$$0(1);
            }
            if (element == null) {
                CallContext.$$$reportNull$$$0(2);
            }
            this.mySelf = self;
            this.myAnchor = anchor;
            this.myElement = element;
            this.myInvocationPoint = invocationPoint;
            this.myCurrentCodeBlock = codeBlock;
        }

        @NotNull
        public SymbolicExpression getSelf() {
            SymbolicExpression symbolicExpression = this.mySelf;
            if (symbolicExpression == null) {
                CallContext.$$$reportNull$$$0(3);
            }
            return symbolicExpression;
        }

        @NotNull
        public Symbol getAnchor() {
            Symbol symbol = this.myAnchor;
            if (symbol == null) {
                CallContext.$$$reportNull$$$0(4);
            }
            return symbol;
        }

        @NotNull
        public RPsiElement getElement() {
            RPsiElement rPsiElement = this.myElement;
            if (rPsiElement == null) {
                CallContext.$$$reportNull$$$0(5);
            }
            return rPsiElement;
        }

        @Nullable
        public PsiElement getInvocationPoint() {
            return this.myInvocationPoint;
        }

        @Nullable
        public RCodeBlock getCurrentCodeBlock() {
            return this.myCurrentCodeBlock;
        }

        @NotNull
        private CallContext with(@NotNull SymbolicCall symbolicCall) {
            if (symbolicCall == null) {
                CallContext.$$$reportNull$$$0(6);
            }
            if (symbolicCall.getReceiver() != null) {
                return new CallContext(symbolicCall.getReceiver(), this.myAnchor, this.myElement, this.myInvocationPoint, this.myCurrentCodeBlock);
            }
            CallContext callContext = this;
            if (callContext == null) {
                CallContext.$$$reportNull$$$0(7);
            }
            return callContext;
        }

        @NotNull
        private CallContext with(@NotNull Symbol anchor) {
            if (anchor == null) {
                CallContext.$$$reportNull$$$0(8);
            }
            return new CallContext(this.mySelf, anchor, this.myElement, this.myInvocationPoint, this.myCurrentCodeBlock);
        }

        @NotNull
        private CallContext with(@NotNull RPsiElement element) {
            if (element == null) {
                CallContext.$$$reportNull$$$0(9);
            }
            return new CallContext(this.mySelf, this.myAnchor, element, this.myInvocationPoint, this.myCurrentCodeBlock);
        }

        private CallContext resetCodeBlock() {
            return new CallContext(this.mySelf, this.myAnchor, this.myElement, this.myInvocationPoint, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "self";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/TypeInferenceInstance$CallContext";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbolicCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/TypeInferenceInstance$CallContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelf";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnchor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "with";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "with";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }
}

