/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance;

import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicTypeInferenceProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.TypeInferenceComponent;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.instance.TypeInferenceInstance;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RClassType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RProcType;

public final class DefaultSymbolicTypeInferenceProvider
implements SymbolicTypeInferenceProvider {
    private static final Set<String> FORCE_NOT_OVERRIDDEN_NEW = Set.of("ActiveRecord::Inheritance::ClassMethods.new", "Struct::$$SINGLETON$$.new");
    private static final List<String> PROC_METHOD_CALL_NAMES = List.of("call", "yield", "[]");

    @Override
    @Nullable
    public SymbolicExpression evaluateSymbolicCall(@NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall, @NotNull TypeInferenceInstance.CallContext callContext) {
        RType receiverType;
        Symbol resolvedMethod;
        if (provider == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(1);
        }
        if (symbolicCall == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(2);
        }
        if (callContext == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(3);
        }
        TypeInferenceComponent component = (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class);
        String name = symbolicCall.getName();
        if (name.equals("new") && (resolvedMethod = SymbolicTypeInferenceProvider.getReceiverType(symbolicCall, component, callContext).getMemberForName(symbolicCall.getName(), Symbol.Filter.ACCEPT_ALL, callContext.getInvocationPoint())) != null && FORCE_NOT_OVERRIDDEN_NEW.contains(resolvedMethod.getFQNWithNesting().getFullPath())) {
            return this.evaluateConstructorCall(provider, context, symbolicCall, callContext);
        }
        if (name.equals("self")) {
            return callContext.getSelf();
        }
        Project project = callContext.getAnchor().getProject();
        REmptyType rType = REmptyType.INSTANCE;
        if (name.endsWith("?")) {
            rType = RTypeFactory.createBoolType(project);
        }
        if (PROC_METHOD_CALL_NAMES.contains(name) && (receiverType = SymbolicTypeInferenceProvider.getReceiverType(symbolicCall, component, callContext)) instanceof RProcType) {
            rType = ((RProcType)receiverType).getReturnType();
        }
        if (RTypeUtilCore.isNotEmpty((RType)rType)) {
            SymbolicExpression expression = provider.createSymbolicVariable();
            component.updateSymbolicExpressionType(expression, (RType)rType);
            return expression;
        }
        return null;
    }

    @Override
    @NotNull
    public SymbolicExpression evaluateConstructorCall(@NotNull SymbolicExpressionProvider provider, @NotNull SymbolicExecutionContext context, @NotNull SymbolicCall symbolicCall,  @NotNull TypeInferenceInstance.CallContext callContext) {
        if (provider == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(5);
        }
        if (symbolicCall == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(6);
        }
        if (callContext == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(7);
        }
        TypeInferenceComponent component = (TypeInferenceComponent)context.getComponent(TypeInferenceComponent.class);
        RType receiverType = SymbolicTypeInferenceProvider.getReceiverType(symbolicCall, component, callContext);
        receiverType = (RType)ContainerUtil.findInstance(RTypeUtil.flattenUnionAndIntersectionType(receiverType), RClassType.class);
        SymbolicExpression expression = provider.createSymbolicVariable();
        if (receiverType != null) {
            RType expressionType = ((RClassType)receiverType).getGenericType();
            component.updateSymbolicExpressionType(expression, expressionType);
        }
        SymbolicExpression symbolicExpression = expression;
        if (symbolicExpression == null) {
            DefaultSymbolicTypeInferenceProvider.$$$reportNull$$$0(8);
        }
        return symbolicExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicCall";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/DefaultSymbolicTypeInferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/instance/DefaultSymbolicTypeInferenceProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateConstructorCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateSymbolicCall";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateConstructorCall";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

