/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExecutionContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.SymbolicExpressionProviderCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.NilAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.attribute.TypeAttribute;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.BooleanValueSymbolicExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.LocalSymbolicVariableImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCall;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicCallImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.SymbolicExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.symbolicExpression.attribute.AttributeKey;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.visitors.PsiParsingVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class SymbolicExpressionProviderImpl
implements SymbolicExpressionProvider {
    private static final int MAX_SYMBOLIC_EXPRESSION_RETAINED_SIZE = 100;
    private static final SymbolicExpression TRUE_SYMBOLIC_EXPRESSION = new BooleanValueSymbolicExpressionImpl(() -> SymbolicExpressionProviderCore.TRUE_SYMBOLIC_EXPRESSION_ID, true);
    private static final SymbolicExpression FALSE_SYMBOLIC_EXPRESSION = new BooleanValueSymbolicExpressionImpl(() -> SymbolicExpressionProviderCore.FALSE_SYMBOLIC_EXPRESSION_ID, false);
    @NotNull
    private final Map<String, SymbolicExpression> myEntryPointSymbolicVariables;
    @NotNull
    private final Map<RPsiElement, SymbolicExpression> myExpression2SymbolicVariables;
    @NotNull
    private final IntSet myMigratedSymbolicExpressions;
    private int myCurId;
    @Nullable
    private final PsiElement myInvocationPoint;
    @NotNull
    private final Project myProject;
    private final Map<PsiElement, SymbolicExpression> mySelfExpressions;
    @NotNull
    private final LanguageLevel myLanguageLevel;

    public SymbolicExpressionProviderImpl(@Nullable PsiElement invocationPoint, @NotNull Project project) {
        if (project == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(0);
        }
        this.myEntryPointSymbolicVariables = new HashMap<String, SymbolicExpression>();
        this.myExpression2SymbolicVariables = new HashMap<RPsiElement, SymbolicExpression>();
        this.myMigratedSymbolicExpressions = new IntOpenHashSet();
        this.myCurId = SymbolicExpressionProviderCore.FIRST_AVAILABLE_SYMBOLIC_EXPRESSION_ID;
        this.mySelfExpressions = new HashMap<PsiElement, SymbolicExpression>();
        this.myInvocationPoint = invocationPoint;
        this.myProject = project;
        this.myLanguageLevel = RubyLanguageLevelService.getLanguageLevelByElementOrLatest((PsiElement)invocationPoint);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(1);
        }
        return project;
    }

    @Nullable
    public PsiElement getInvocationPoint() {
        return this.myInvocationPoint;
    }

    @NotNull
    public SymbolicExpression createSymbolicVariable() {
        return new LocalSymbolicVariableImpl(() -> this.getIdAndIncrement());
    }

    @NotNull
    public SymbolicExpression readAtEntryPoint(@NotNull String name) {
        SymbolicExpression symbolicExpression;
        if (name == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(2);
        }
        if ((symbolicExpression = this.myEntryPointSymbolicVariables.get(name)) != null) {
            SymbolicExpression symbolicExpression2 = symbolicExpression;
            if (symbolicExpression2 == null) {
                SymbolicExpressionProviderImpl.$$$reportNull$$$0(3);
            }
            return symbolicExpression2;
        }
        symbolicExpression = this.createSymbolicVariable();
        this.writeAtEntryPoint(name, symbolicExpression);
        SymbolicExpression symbolicExpression3 = symbolicExpression;
        if (symbolicExpression3 == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(4);
        }
        return symbolicExpression3;
    }

    public void writeAtEntryPoint(@NotNull String name, @NotNull SymbolicExpression expression) {
        if (name == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(5);
        }
        if (expression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(6);
        }
        this.myEntryPointSymbolicVariables.put(name, expression);
    }

    @NotNull
    public SymbolicExpression getSymbolicExpression(@NotNull RPsiElement e, @NotNull SymbolicExecutionContext context) {
        SymbolicExpression expression;
        if (e == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(7);
        }
        if (context == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(8);
        }
        if ((expression = this.myExpression2SymbolicVariables.get(e)) != null) {
            SymbolicExpression symbolicExpression = expression;
            if (symbolicExpression == null) {
                SymbolicExpressionProviderImpl.$$$reportNull$$$0(9);
            }
            return symbolicExpression;
        }
        expression = PsiParsingVisitor.createSymbolicExpressionByPsiElement(e, this, context);
        if (expression == null) {
            expression = this.createSymbolicVariable();
        }
        SymbolicExpression simplified = expression.trySimplify((SymbolicExpressionProvider)this);
        this.myExpression2SymbolicVariables.put(e, simplified);
        SymbolicExpression symbolicExpression = simplified;
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(10);
        }
        return symbolicExpression;
    }

    @Nullable
    public SymbolicExpression tryGetSymbolicExpression(@NotNull RPsiElement element) {
        if (element == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(11);
        }
        return this.myExpression2SymbolicVariables.get(element);
    }

    public void setSymbolicExpression(@NotNull RPsiElement e, @NotNull SymbolicExpression symbolicExpression) {
        if (e == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(12);
        }
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(13);
        }
        this.myExpression2SymbolicVariables.put(e, symbolicExpression);
    }

    @NotNull
    public SymbolicCall createSymbolicCall(@NotNull List<SymbolicCall.SymbolicArgumentInfo> arguments, @NotNull String fqn, @Nullable SymbolicExpression receiver, boolean isConstant, boolean isBlockGiven) {
        if (arguments == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(14);
        }
        if (fqn == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(15);
        }
        int argumentsSize = 0;
        for (SymbolicCall.SymbolicArgumentInfo argument : arguments) {
            argumentsSize += argument.getExpression().getRetainedSize();
        }
        return new SymbolicCallImpl(() -> this.getIdAndIncrement(), argumentsSize > 100 ? Collections.emptyList() : arguments, fqn, receiver, isConstant, isBlockGiven);
    }

    @NotNull
    public SymbolicExpression createTypedSymbolicExpression(@NotNull SerializableType type) {
        if (type == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(16);
        }
        if (type.equals(SerializableTypeUtil.TRUE)) {
            SymbolicExpression symbolicExpression = this.getTrueSymbolicExpression();
            if (symbolicExpression == null) {
                SymbolicExpressionProviderImpl.$$$reportNull$$$0(17);
            }
            return symbolicExpression;
        }
        if (type.equals(SerializableTypeUtil.FALSE)) {
            SymbolicExpression symbolicExpression = this.getFalseSymbolicExpression();
            if (symbolicExpression == null) {
                SymbolicExpressionProviderImpl.$$$reportNull$$$0(18);
            }
            return symbolicExpression;
        }
        if (type.equals(SerializableTypeUtil.NIL)) {
            SymbolicExpression symbolicExpression = this.getNilSymbolicExpression();
            if (symbolicExpression == null) {
                SymbolicExpressionProviderImpl.$$$reportNull$$$0(19);
            }
            return symbolicExpression;
        }
        SymbolicExpression symbolicExpression = this.createSymbolicVariable();
        symbolicExpression.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)type);
        SymbolicExpression symbolicExpression2 = symbolicExpression;
        if (symbolicExpression2 == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(20);
        }
        return symbolicExpression2;
    }

    @NotNull
    public SymbolicExpression getTrueSymbolicExpression() {
        SymbolicExpression symbolicExpression = TRUE_SYMBOLIC_EXPRESSION;
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(21);
        }
        return symbolicExpression;
    }

    @NotNull
    public SymbolicExpression getFalseSymbolicExpression() {
        SymbolicExpression symbolicExpression = FALSE_SYMBOLIC_EXPRESSION;
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(22);
        }
        return symbolicExpression;
    }

    @NotNull
    public SymbolicExpression getNilSymbolicExpression() {
        SymbolicExpression symbolicExpression = SymbolicExpressionProviderCore.NIL_SYMBOLIC_EXPRESSION;
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(23);
        }
        return symbolicExpression;
    }

    @NotNull
    public SymbolicExpression getBlockGivenSymbolicExpression() {
        SymbolicExpression symbolicExpression = SymbolicExpressionProviderCore.BLOCK_GIVEN_SYMBOLIC_EXPRESSION;
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(24);
        }
        return symbolicExpression;
    }

    @NotNull
    public SymbolicExpression createExpression(@NotNull @NotNull Function<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SymbolicExpression.IdSupplier, @NotNull SymbolicExpression> create) {
        SymbolicExpression result;
        if (create == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(25);
        }
        SymbolicExpression symbolicExpression = (result = create.apply(() -> this.getIdAndIncrement())).getRetainedSize() >= 100 ? this.createSymbolicVariable() : result;
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(26);
        }
        return symbolicExpression;
    }

    public void registerMigratedSymbolicExpression(@NotNull SymbolicExpression symbolicExpression) {
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(27);
        }
        this.myMigratedSymbolicExpressions.add(symbolicExpression.getId());
    }

    public boolean isMigratedSymbolicExpression(@NotNull SymbolicExpression symbolicExpression) {
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(28);
        }
        return this.myMigratedSymbolicExpressions.contains(symbolicExpression.getId());
    }

    public boolean isSelfExpression(@NotNull SymbolicExpression expression) {
        if (expression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(29);
        }
        return this.mySelfExpressions.containsValue(expression);
    }

    @NotNull
    public SymbolicExpression getSelfExpression(@NotNull PsiElement element) {
        if (element == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(30);
        }
        SymbolicExpression symbolicExpression = this.mySelfExpressions.computeIfAbsent((PsiElement)ObjectUtils.coalesce((Object)ScopeUtilCore.findScopeHolder((PsiElement)element), (Object)element), __ -> this.createSymbolicVariable());
        if (symbolicExpression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(31);
        }
        return symbolicExpression;
    }

    public void setSelfExpression(@NotNull PsiElement element, @NotNull SymbolicExpression expression) {
        if (element == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(32);
        }
        if (expression == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(33);
        }
        this.mySelfExpressions.put((PsiElement)ObjectUtils.coalesce((Object)ScopeUtilCore.findScopeHolder((PsiElement)element), (Object)element), expression);
    }

    private int getIdAndIncrement() {
        return ++this.myCurId;
    }

    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = this.myLanguageLevel;
        if (languageLevel == null) {
            SymbolicExpressionProviderImpl.$$$reportNull$$$0(34);
        }
        return languageLevel;
    }

    static {
        TRUE_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)SerializableTypeUtil.TRUE);
        TRUE_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)NilAttribute.INSTANCE, (Object)ThreeState.NO);
        FALSE_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)SerializableTypeUtil.FALSE);
        FALSE_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)NilAttribute.INSTANCE, (Object)ThreeState.NO);
        SymbolicExpressionProviderCore.NIL_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)SerializableTypeUtil.NIL);
        SymbolicExpressionProviderCore.NIL_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)NilAttribute.INSTANCE, (Object)ThreeState.YES);
        SymbolicExpressionProviderCore.BLOCK_GIVEN_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)NilAttribute.INSTANCE, (Object)ThreeState.NO);
        SymbolicExpressionProviderCore.BLOCK_GIVEN_SYMBOLIC_EXPRESSION.setAttributeValue((AttributeKey)TypeAttribute.INSTANCE, (Object)SerializableTypeUtil.BOOLEAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 9, 10, 17, 18, 19, 20, 21, 22, 23, 24, 26, 31, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/SymbolicExpressionProviderImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolicExpression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbolicExecution/SymbolicExpressionProviderImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readAtEntryPoint";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolicExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypedSymbolicExpression";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrueSymbolicExpression";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFalseSymbolicExpression";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getNilSymbolicExpression";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockGivenSymbolicExpression";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfExpression";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 31: 
            case 34: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readAtEntryPoint";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeAtEntryPoint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolicExpression";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryGetSymbolicExpression";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSymbolicExpression";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSymbolicCall";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTypedSymbolicExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerMigratedSymbolicExpression";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isMigratedSymbolicExpression";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isSelfExpression";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSelfExpression";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setSelfExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 9, 10, 17, 18, 19, 20, 21, 22, 23, 24, 26, 31, 34 -> new IllegalStateException(string);
        };
    }
}

