/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyLocalVariablesProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.impl.LocalVariableDeclarationVisitor;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class ScopeUtil {
    private static final Key<Set<ScopeHolder>> FAILED_DFA_SCOPES = Key.create((String)"ruby.failed.dfa.scopes");
    private static final Logger LOG = Logger.getInstance(ScopeUtil.class);

    private ScopeUtil() {
    }

    public static Collection<ScopeVariable> collectScopeVariables(PsiElement element) {
        ScopeHolder holder = (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeHolder.class);
        if (holder == null) {
            return Collections.emptyList();
        }
        return holder.getScope().getDeclaredVariables(element);
    }

    @NotNull
    public static List<String> collectScopeVariableNames(@NotNull PsiElement element) {
        ScopeHolder holder;
        if (element == null) {
            ScopeUtil.$$$reportNull$$$0(0);
        }
        if ((holder = (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeHolder.class)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ScopeUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = holder.getScope().getScopeVariableNames(element);
        if (list == null) {
            ScopeUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<String> collectAllScopeVariableNames(@NotNull Scope scope) {
        if (scope == null) {
            ScopeUtil.$$$reportNull$$$0(3);
        }
        List list = scope.getAllScopeVariableNames();
        if (list == null) {
            ScopeUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static Collection<PsiElement> collectLocalVariables(PsiElement element) {
        ScopeHolder holder = (ScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeHolder.class);
        if (holder == null) {
            return Collections.emptyList();
        }
        Scope scope = holder.getScope();
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        RPsiElement scopeElement = ScopeUtilCore.getScopeElement((PsiElement)element);
        while (true) {
            result.addAll(scope.getLocalVariables((PsiElement)scopeElement, element));
            if (scopeElement == holder) {
                return result;
            }
            scopeElement = ScopeUtilCore.getScopeElement((PsiElement)scopeElement);
        }
    }

    @Nullable
    public static Scope getNearestScope(@NotNull PsiElement element) {
        ScopeHolder holder;
        if (element == null) {
            ScopeUtil.$$$reportNull$$$0(5);
        }
        return (Scope)ObjectUtils.doIfNotNull((Object)((holder = ScopeUtilCore.findScopeHolder((PsiElement)element)) instanceof RCodeBlock ? holder.getParentContainer() : holder), ScopeHolder::getScope);
    }

    @Nullable
    public static RPsiElement getLocalVariableScope(RPsiElement element) {
        if (RubyUsageAnalyzerCore.isParameter((RPsiElement)element)) {
            return ScopeUtilCore.getParameterScope((RPsiElement)element);
        }
        return ScopeUtilCore.findScopeHolder((PsiElement)element);
    }

    public static void addFailedDfaScopesSetToSession(LocalInspectionToolSession session) {
        session.putUserDataIfAbsent(FAILED_DFA_SCOPES, new HashSet());
    }

    @Nullable
    public static String getLastReturnName(ScopeHolder scopeHolder) {
        Instruction[] instructions = scopeHolder.getControlFlow().getInstructions();
        Collection prevInstructions = instructions[instructions.length - 1].allPred();
        if (prevInstructions.size() == 1) {
            prevInstructions = RControlFlowUtil.collectPredecessorsWithoutCompoundAndBlockStatements((Instruction[])instructions, (Instruction)((Instruction)prevInstructions.iterator().next()));
        }
        if (prevInstructions.size() > 1) {
            return null;
        }
        Instruction instruction = (Instruction)prevInstructions.iterator().next();
        PsiElement element = instruction.getElement();
        if (element == null) {
            return null;
        }
        RPsiElement statement = RubyPsiUtilCore.getStatement((PsiElement)element);
        if (statement instanceof RAssignmentExpression) {
            return ((RAssignmentExpression)statement).getObject().getText();
        }
        if (statement instanceof RIdentifier) {
            return ((RIdentifier)statement).getName();
        }
        return null;
    }

    @NotNull
    public static Map<String, PsiElement> computeLocalVariableDeclarations(@NotNull ScopeHolder scopeHolder) {
        if (scopeHolder == null) {
            ScopeUtil.$$$reportNull$$$0(6);
        }
        LocalVariableDeclarationVisitor visitor = new LocalVariableDeclarationVisitor(scopeHolder);
        try {
            scopeHolder.acceptChildren((PsiElementVisitor)visitor);
        }
        catch (StackOverflowError e) {
            LOG.warn(RBundle.message((String)"ruby.local.variables.too.complex.error") + " File: " + scopeHolder.getContainingFile().getName() + ". File text: \n" + StringUtil.shortenTextWithEllipsis((String)scopeHolder.getContainingFile().getText(), (int)512, (int)256), (Throwable)e);
        }
        HashMap<String, PsiElement> declarationMap = new HashMap<String, PsiElement>(visitor.getDeclarationsMap());
        for (RubyLocalVariablesProvider provider : RubyLocalVariablesProvider.EP_NAME.getExtensionList()) {
            declarationMap.putAll(provider.collectDeclarations((PsiElement)scopeHolder));
        }
        HashMap<String, PsiElement> hashMap = declarationMap;
        if (hashMap == null) {
            ScopeUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/scope/ScopeUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/resolve/scope/ScopeUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectScopeVariableNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllScopeVariableNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeLocalVariableDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectScopeVariableNames";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectAllScopeVariableNames";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNearestScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeLocalVariableDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 7 -> new IllegalStateException(string);
        };
    }
}

