/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.references;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.PsiCallReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.RubyRenameHelper;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.ReferenceCompletionUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReferenceBase;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.accessmodifier.AccessModifierProblem;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RDuckType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfoUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RMultiAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.fields.RInstanceVariableImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public class RQualifiedReference
extends RQualifiedReferenceBase
implements PsiCallReference {
    public static final Predicate<Symbol> NAME_FILTER = symbol -> {
        String name = symbol.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        char c = name.charAt(0);
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || '_' == c;
    };
    @NotNull
    private final RPsiElement myWholeReference;
    @Nullable
    private final RPsiElement myRefObject;
    @NotNull
    private final PsiElement myRefValue;

    public RQualifiedReference(@NotNull RPsiElement wholeReference, @Nullable RPsiElement refObject, @NotNull PsiElement refValue) {
        if (wholeReference == null) {
            RQualifiedReference.$$$reportNull$$$0(0);
        }
        if (refValue == null) {
            RQualifiedReference.$$$reportNull$$$0(1);
        }
        this(wholeReference, refObject, refValue, RQualifiedReference.getName(wholeReference, refValue));
    }

    public RQualifiedReference(@NotNull RPsiElement wholeReference, @Nullable RPsiElement refObject, @NotNull PsiElement refValue, @NotNull String name) {
        if (wholeReference == null) {
            RQualifiedReference.$$$reportNull$$$0(2);
        }
        if (refValue == null) {
            RQualifiedReference.$$$reportNull$$$0(3);
        }
        if (name == null) {
            RQualifiedReference.$$$reportNull$$$0(4);
        }
        super(wholeReference.getProject(), refObject != null ? refObject.getText() : "", name);
        this.myWholeReference = wholeReference;
        this.myRefObject = refObject;
        this.myRefValue = refValue;
    }

    @Override
    protected boolean isValidResult(boolean valid, Symbol symbolVariant) {
        return valid && RQualifiedReference.matchesArgumentCount(symbolVariant, RQualifiedReference.getCallArgumentCount(this.myWholeReference.getParent()));
    }

    @NotNull
    public PsiElement getElement() {
        RPsiElement rPsiElement = this.myWholeReference;
        if (rPsiElement == null) {
            RQualifiedReference.$$$reportNull$$$0(5);
        }
        return rPsiElement;
    }

    private static int getCallArgumentCount(PsiElement callCandidate) {
        if (callCandidate instanceof RCall) {
            RCall parentCall = (RCall)callCandidate;
            List args = parentCall.getCallArguments().getElements();
            return args.size();
        }
        return 0;
    }

    @NotNull
    public PsiElement getRefValue() {
        PsiElement psiElement = this.myRefValue;
        if (psiElement == null) {
            RQualifiedReference.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    public PsiElement handleChangeSignature(ChangeInfo changeInfo) {
        PsiElement psiElement = this.myWholeReference.getParent();
        if (psiElement instanceof RCall) {
            RCall oldCall = (RCall)psiElement;
            if (changeInfo.isParameterSetOrOrderChanged()) {
                RListOfExpressions oldArguments = oldCall.getCallArguments();
                RCall newCall = (RCall)oldCall.copy();
                RListOfExpressions args = newCall.getCallArguments();
                List elements = args.getElements();
                if (!elements.isEmpty()) {
                    args.deleteChildRange((PsiElement)elements.get(0), (PsiElement)elements.get(elements.size() - 1));
                    ParameterInfo[] infos = changeInfo.getNewParameters();
                    List oldArgumentsElements = oldArguments.getElements();
                    for (ParameterInfo info : infos) {
                        String defaultValue;
                        if (info.getOldIndex() >= 0) {
                            args.add((PsiElement)oldArgumentsElements.get(info.getOldIndex()));
                            continue;
                        }
                        if (this.myRefObject == null || (defaultValue = info.getDefaultValue()) == null) continue;
                        args.add((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)this.myRefObject, (String)defaultValue));
                    }
                    newCall = (RCall)oldCall.replace((PsiElement)newCall);
                    return newCall.getPsiCommand();
                }
            }
        }
        return this.getElement();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RQualifiedReference reference = (RQualifiedReference)o;
        return Objects.equals(this.myWholeReference, reference.myWholeReference) && Objects.equals(this.myRefObject, reference.myRefObject) && Objects.equals(this.myRefValue, reference.myRefValue);
    }

    @Nullable
    public RPsiElement getRefObject() {
        return this.myRefObject;
    }

    @NotNull
    public TextRange getRangeInElement() {
        int relativeStartOffset = this.myRefValue.getTextOffset() - this.myWholeReference.getTextOffset();
        TextRange textRange = TextRange.from((int)relativeStartOffset, (int)this.myRefValue.getTextLength());
        if (textRange == null) {
            RQualifiedReference.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myName;
        if (string == null) {
            RQualifiedReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            RQualifiedReference.$$$reportNull$$$0(9);
        }
        this.checkName(newName);
        boolean foundHelper = false;
        for (RubyRenameHelper helper : RubyRenameHelper.EP_NAME.getExtensionList()) {
            String nameFromHelper = helper.calculateNewName(this, this.myRefValue.getText(), newName);
            if (nameFromHelper == null) continue;
            newName = nameFromHelper;
            foundHelper = true;
            break;
        }
        if (!foundHelper) {
            newName = StringUtil.trimEnd((String)newName, (String)"=");
            newName = RInstanceVariableImpl.normalizeNameIfNeeded((String)newName);
        }
        RPsiElement element = RubyElementFactoryCore.createElementFromText((PsiElement)this.myRefValue, (String)newName);
        RubyPsiUtilCore.replaceInParent((PsiElement)this.myRefValue, (PsiElement)element);
        return element;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myWholeReference.hashCode();
        result = 31 * result + Objects.hashCode(this.myRefObject);
        result = 31 * result + this.myRefValue.hashCode();
        return result;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            RQualifiedReference.$$$reportNull$$$0(10);
        }
        for (RubyRenameHelper helper : RubyRenameHelper.EP_NAME.getExtensionList()) {
            String text = helper.calculateTextFromElement(this, element);
            if (text == null) continue;
            RPsiElement newElement = RubyElementFactoryCore.createElementFromText((PsiElement)this.getElement(), (String)text);
            return this.myWholeReference.replace((PsiElement)newElement);
        }
        if (element instanceof PsiNamedElement) {
            this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return null;
    }

    @Override
    @NotNull
    protected Predicate<Symbol> createCompletionFilter(boolean getVariants) {
        Predicate<Symbol> filter = RubyCompletionProvider.createCompletionFilter(this.myWholeReference);
        Predicate<Symbol> predicate = getVariants && this.myWholeReference instanceof RReference ? NAME_FILTER.and(this.doesSymbolHaveCorrectVisibility()).and(filter) : filter;
        if (predicate == null) {
            RQualifiedReference.$$$reportNull$$$0(11);
        }
        return predicate;
    }

    private Predicate<Symbol> doesSymbolHaveCorrectVisibility() {
        PsiElement element = this.getElement();
        RReference root = (RReference)PsiTreeUtil.getParentOfType((PsiElement)element, RReference.class, (boolean)false);
        RPsiElement explicitReceiver = root != null ? root.getReceiver() : null;
        RType implicitReceiverType = root != null ? RTypeUtil.getTypeForSelf((PsiElement)root) : null;
        RType explicitReceiverType = this.getRefObjectType();
        return symbol -> {
            if (!(symbol instanceof RMethodSymbol)) {
                return true;
            }
            AccessModifierProblem problem = AccessModifierProblem.calculateAccessModifierProblem((RMethodSymbol)symbol, implicitReceiverType, explicitReceiverType, explicitReceiver);
            return problem == null;
        };
    }

    @Override
    public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RQualifiedReference.$$$reportNull$$$0(12);
        }
        if (result == null) {
            RQualifiedReference.$$$reportNull$$$0(13);
        }
        ReferenceCompletionUtil.doWithReferenceCompletion(this.myRefValue, () -> super.addCompletions(parameters, context, result));
    }

    @Override
    @NotNull
    public RType getRefObjectType() {
        if (this.myRefObject instanceof RExpression && this.myRefObject.isValid()) {
            RType originalType = RTypeUtil.getType((PsiElement)this.myRefObject);
            if (originalType == REmptyType.INSTANCE) {
                return this.createNotTypedObjectType();
            }
            if (originalType instanceof RDuckType) {
                RType rType = RTypeUtil.intersect(originalType, this.createNotTypedObjectType());
                if (rType == null) {
                    RQualifiedReference.$$$reportNull$$$0(14);
                }
                return rType;
            }
            RType rType = originalType;
            if (rType == null) {
                RQualifiedReference.$$$reportNull$$$0(15);
            }
            return rType;
        }
        return this.createNotTypedObjectType();
    }

    @NotNull
    private RType createNotTypedObjectType() {
        if (this.myWholeReference instanceof RColonReference) {
            REmptyType rEmptyType = REmptyType.INSTANCE;
            if (rEmptyType == null) {
                RQualifiedReference.$$$reportNull$$$0(16);
            }
            return rEmptyType;
        }
        RType rType = RTypeFactory.createNotTypedObjectSymbolType(this.getProject());
        if (rType == null) {
            RQualifiedReference.$$$reportNull$$$0(17);
        }
        return rType;
    }

    @NotNull
    private static String getName(@NotNull RPsiElement wholeReference, @NotNull PsiElement refValue) {
        if (wholeReference == null) {
            RQualifiedReference.$$$reportNull$$$0(18);
        }
        if (refValue == null) {
            RQualifiedReference.$$$reportNull$$$0(19);
        }
        Object name = refValue.getText();
        if (refValue instanceof RConstant) {
            String string = name;
            if (string == null) {
                RQualifiedReference.$$$reportNull$$$0(20);
            }
            return string;
        }
        RAssignmentExpression assignment = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)wholeReference);
        if (assignment != null) {
            if (assignment instanceof RMultiAssignmentExpression && assignment.getOperationType() == null) {
                String string = name;
                if (string == null) {
                    RQualifiedReference.$$$reportNull$$$0(21);
                }
                return string;
            }
            if (RubyTextUtil.isCID((String)name)) {
                name = (String)name + "=";
            }
        }
        String string = name;
        if (string == null) {
            RQualifiedReference.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static boolean matchesArgumentCount(Symbol variant, int callArgumentCount) {
        if (variant instanceof CallableSymbol) {
            CallableSymbol symbol = (CallableSymbol)variant;
            List infos = symbol.getArgumentInfos();
            if (infos == null) {
                return true;
            }
            if (callArgumentCount < ArgumentInfoUtil.getMinNumberOfSimpleArguments((List)infos)) {
                return false;
            }
            int maxCount = ArgumentInfoUtil.getMaxNumberOfSimpleArguments((List)infos);
            if (maxCount != -1 && callArgumentCount > maxCount) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 11, 14, 15, 16, 17, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeReference";
                break;
            }
            case 1: 
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RQualifiedReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/references/RQualifiedReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompletionFilter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefObjectType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotTypedObjectType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 11, 14, 15, 16, 17, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

