/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramInfo;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDTag;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.YARDOverloadDirective;
import org.jetbrains.plugins.ruby.rdoc.yard.tags.base.YARDVariableRelatedTag;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramInfo.RubyParameterInfoDelegateProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.ROverloadedSyntheticMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.REmptyType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableTypeUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySpaceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfoPresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public final class RubyParameterInfoHandler
implements ParameterInfoHandler<RPossibleCall, CallableSymbol> {
    public RPossibleCall findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        Object[] items;
        int offset;
        PsiFile file;
        RPossibleCall call;
        if (context == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((call = RubyParameterInfoHandler.findParameterOwner(file = context.getFile(), offset = context.getOffset())) == null) {
            return null;
        }
        CallableSymbol result = RubyParameterInfoHandler.tryToResolve(call);
        if (result == null) {
            return null;
        }
        if (result instanceof RMethodSymbol) {
            List<CallableSymbol> parameterInfo = RubyParameterInfoHandler.calculateParameterInfo((RMethodSymbol)result);
            items = parameterInfo.toArray(new CallableSymbol[0]);
        } else {
            items = new CallableSymbol[]{result};
        }
        context.setItemsToShow(items);
        return call;
    }

    public void showParameterInfo(@NotNull RPossibleCall element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public RPossibleCall findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return RubyParameterInfoHandler.findParameterOwner(context.getFile(), context.getOffset());
    }

    public void updateUI(CallableSymbol element, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(4);
        }
        for (RubyParameterInfoDelegateProvider provider : RubyParameterInfoDelegateProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            if (!provider.canProcess(element)) continue;
            provider.updateParameterInfoPresentation(element, context);
            return;
        }
        RubyParameterInfoHandler.updateRMethodPresentation(element, context);
    }

    @Nullable
    public static RPossibleCall findParameterOwner(@NotNull PsiFile file, int offset) {
        boolean hasParentheses;
        RPossibleCall call;
        PsiElement element;
        if (file == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(5);
        }
        PsiElement initial = offset == file.getTextLength() ? PsiTreeUtil.getDeepestLast((PsiElement)file) : file.findElementAt(offset);
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)initial);
        PsiElement psiElement = element = RubySpaceUtil.isAnySpace((PsiElement)initial) || elementType == RubyTokenTypes.tDOT || elementType == RubyTokenTypes.tCOLON2 ? PsiTreeUtil.prevVisibleLeaf((PsiElement)initial) : initial;
        if (element == null) {
            return null;
        }
        RPossibleCall candidate = RCallNavigator.getRealCall((RPossibleCall)((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)element, RPossibleCall.class)));
        if (candidate == null || !candidate.isCall() && candidate.getParent() instanceof RReference) {
            return null;
        }
        RPossibleCall rPossibleCall = call = candidate.isCall() ? candidate : RCallNavigator.getRealCall((RPossibleCall)((RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)candidate, RPossibleCall.class, (boolean)true)));
        if (call == null || !call.isCall()) {
            return null;
        }
        boolean bl = hasParentheses = PsiTreeUtil.findSiblingForward((PsiElement)call.getFirstChild(), (IElementType)RubyTokenTypes.tfLPAREN, null) != null;
        if (hasParentheses) {
            return call.getTextRange().contains(offset) ? call : null;
        }
        Project project = call.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        int line = document.getLineNumber(offset);
        int callLine = document.getLineNumber(call.getTextRange().getEndOffset());
        return call.getTextOffset() <= offset && (line <= callLine || PsiTreeUtil.getDeepestLast((PsiElement)call) instanceof PsiErrorElement) ? call : null;
    }

    public static String updateRMethodPresentation(@NotNull CallableSymbol method, @NotNull ParameterInfoUIContext context) {
        List argumentList;
        if (method == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if ((argumentList = method.getArgumentInfos(true)) == null) {
            return context.setupUIComponentPresentation(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]), -1, -1, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
        }
        PsiElement psiMethod = method.getPsiElement();
        return RubyParameterInfoHandler.updateUIForArgumentInfos(context, method, argumentList, (Function<? super String, ? extends RType>)((Function)argName -> {
            if (psiMethod == null) {
                return REmptyType.INSTANCE;
            }
            SerializableType serializableType = null;
            if (method instanceof ROverloadedSyntheticMethodSymbol) {
                serializableType = Optional.ofNullable(((ROverloadedSyntheticMethodSymbol)method).getAnnotationData().getYARDMethodData()).map(it -> it.getParameterType(argName)).orElse(null);
            }
            if (SerializableTypeUtil.isEmpty(serializableType)) {
                serializableType = Optional.of(method).filter(it -> it instanceof RMethodSymbol).map(it -> ((RMethodSymbol)it).getAnnotationData()).map(it -> it.getParameterType(argName)).orElse(null);
            }
            return serializableType != null ? serializableType.resolve(psiMethod.getProject(), psiMethod) : REmptyType.INSTANCE;
        }));
    }

    public static String updateUIForArgumentInfos(@NotNull ParameterInfoUIContext context, @NotNull CallableSymbol method, @NotNull List<? extends ArgumentInfo> argumentInfos, @NotNull Function<? super String, ? extends RType> typeByArgNameEvaluator) {
        if (context == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (method == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(9);
        }
        if (argumentInfos == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (typeByArgNameEvaluator == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(11);
        }
        String methodName = method.getName();
        int index = context.getCurrentParameterIndex();
        StringBuilder buff = new StringBuilder();
        int start = -1;
        int end = -1;
        if (!argumentInfos.isEmpty()) {
            for (int i = 0; i < argumentInfos.size(); ++i) {
                if (i > 0) {
                    buff.append(", ");
                }
                ArgumentInfo argumentInfo = argumentInfos.get(i);
                String argumentText = ArgumentInfoPresentation.getPresentableString(method.getProject(), argumentInfo, ArgumentInfoPresentation.SHORT);
                boolean highlightInserted = false;
                if (start == -1 && (i == index || argumentInfo.getType() == ArgumentInfo.Type.ARRAY && index != -1)) {
                    start = buff.length();
                    end = start + argumentText.length();
                    highlightInserted = true;
                }
                buff.append(argumentText);
                RType type = (RType)typeByArgNameEvaluator.fun((Object)argumentInfo.getName());
                if (type == REmptyType.INSTANCE) continue;
                String typeInfo = " \u2190 " + RFrozenType.clearFrozenStatus(type).getPresentableName();
                buff.append(typeInfo);
                end += highlightInserted ? typeInfo.length() : 0;
            }
            if (CodeInsightSettings.getInstance().SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                String prefix = methodName + "(";
                String postfix = ")";
                buff.insert(0, prefix);
                if (start != -1) {
                    start += prefix.length();
                    end += prefix.length();
                }
                buff.append(")");
            }
        } else {
            buff.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        return context.setupUIComponentPresentation(buff.toString(), start, end, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    @Nullable
    private static CallableSymbol tryToResolve(RPossibleCall possibleCall) {
        PsiPolyVariantReference reference;
        RPossibleCall element2resolve;
        if (possibleCall instanceof RCall) {
            RCall call = (RCall)possibleCall;
            v0 = call.getPsiCommand();
        } else {
            v0 = element2resolve = possibleCall;
        }
        if (element2resolve instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)element2resolve;
            element2resolve = assignment.getObject();
        }
        if ((reference = (PsiPolyVariantReference)ObjectUtils.tryCast((Object)element2resolve.getReference(), PsiPolyVariantReference.class)) == null) {
            return null;
        }
        Symbol result = ResolveUtil.resolveToSymbolWithCaching((PsiReference)reference);
        if (result instanceof CallableSymbol) {
            return (CallableSymbol)result;
        }
        List<? extends Symbol> results = ResolveUtil.resolveToSymbolsWithCaching(reference, true);
        return (CallableSymbol)ObjectUtils.tryCast((Object)ContainerUtil.getOnlyItem(results), CallableSymbol.class);
    }

    public void updateParameterInfo(@NotNull RPossibleCall element, @NotNull UpdateParameterInfoContext context) {
        RCall rCall;
        if (element == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if (context == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(13);
        }
        int index = -1;
        int carret = context.getOffset();
        RCall rCall2 = rCall = element instanceof RCall ? (RCall)element : RCallNavigator.getByCommand((PsiElement)element);
        if (rCall != null) {
            RListOfExpressions callArgs = rCall.getCallArguments();
            index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)callArgs.getNode(), (int)carret, (IElementType)RubyTokenTypes.tCOMMA);
            if (index == -1 && callArgs.getTextRange().getStartOffset() == carret + 1) {
                index = 0;
            }
        } else if (element instanceof RAssignmentExpression) {
            RAssignmentExpression assignment = (RAssignmentExpression)element;
            PsiElement operation = assignment.getOperation();
            if (operation != null && operation.getTextRange().getEndOffset() <= carret) {
                index = 0;
            }
        } else if (carret > element.getTextRange().getEndOffset()) {
            index = 0;
        }
        context.setCurrentParameter(index);
    }

    private static boolean areSignaturesAlmostEqual(@Nullable List<ArgumentInfo> first, @Nullable List<ArgumentInfo> second) {
        if (first == null || second == null || first.size() != second.size()) {
            return false;
        }
        List firstCleaned = ContainerUtil.map(first, it -> new ArgumentInfo(it.getName(), it.getType().cleanDefaultValue()));
        List secondCleaned = ContainerUtil.map(second, it -> new ArgumentInfo(it.getName(), it.getType().cleanDefaultValue()));
        return firstCleaned.equals(secondCleaned);
    }

    private static boolean yardTagsEqualsByMetaData(@NotNull YARDTag tag1, @NotNull YARDTag tag2) {
        if (tag1 == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(14);
        }
        if (tag2 == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(15);
        }
        if (!tag1.getClass().equals(tag2.getClass())) {
            return false;
        }
        if (tag1 instanceof YARDVariableRelatedTag) {
            return ((YARDVariableRelatedTag)tag1).getName().equals(((YARDVariableRelatedTag)tag2).getName());
        }
        return true;
    }

    private static boolean contains(List<YARDTag> tags, YARDTag element) {
        return ContainerUtil.or(tags, it -> RubyParameterInfoHandler.yardTagsEqualsByMetaData(it, element));
    }

    @NotNull
    private static List<CallableSymbol> calculateParameterInfo(@NotNull RMethodSymbol methodSymbol) {
        if (methodSymbol == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(16);
        }
        boolean skipRealSignature = false;
        List originalMethodSignature = methodSymbol.getArgumentInfos();
        List overloads = methodSymbol.getSyntheticOverloads();
        if (ContainerUtil.or((Iterable)overloads, overload -> RubyParameterInfoHandler.areSignaturesAlmostEqual(originalMethodSignature, overload.getArgumentInfos()))) {
            List tags = methodSymbol.getInheritedYARDTags();
            List tagsUnderOverloads = StreamEx.of((Collection)tags).select(YARDOverloadDirective.class).flatMap(it -> it.getChildTags().stream()).toList();
            if (tags.stream().filter(it -> !(it instanceof YARDOverloadDirective)).noneMatch(topLevelNotOverloadTag -> RubyParameterInfoHandler.contains(tagsUnderOverloads, topLevelNotOverloadTag))) {
                skipRealSignature = true;
            }
        }
        SmartList parameterInfo = new SmartList();
        if (!skipRealSignature) {
            parameterInfo.add(methodSymbol);
        }
        parameterInfo.addAll(overloads);
        SmartList smartList = parameterInfo;
        if (smartList == null) {
            RubyParameterInfoHandler.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfos";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeByArgNameEvaluator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag1";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag2";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSymbol";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramInfo/RubyParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramInfo/RubyParameterInfoHandler";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findParameterOwner";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateRMethodPresentation";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateUIForArgumentInfos";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "yardTagsEqualsByMetaData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateParameterInfo";
                break;
            }
            case 17: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17 -> new IllegalStateException(string);
        };
    }
}

