/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.AnyParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.DynamicHashKeyProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.EnumParam;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.HashKeyParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.MatchContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.MatchResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefExpression;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefLeaf;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.variables.RConstantImpl;

public class ParamDefHash
extends ParamDefExpression {
    private static final Set<@NlsSafe String> EXPECTED_TYPES = Set.of("Hash");
    private final Map<String, ParamDefExpression> myMap = new HashMap<String, ParamDefExpression>();
    private final Map<String, Object> myKeyMap = new HashMap<String, Object>();
    private final Map<DynamicHashKeyProvider, ParamDefExpression> myProviders = new HashMap<DynamicHashKeyProvider, ParamDefExpression>();
    private final boolean myKeysAreOptional;
    private final boolean myAcceptOnly19;
    private final ParamDefExpression myDefaultExpression;

    public ParamDefHash() {
        this(true, false, null);
    }

    public ParamDefHash(boolean keysAreOptional, boolean acceptOnly19, @Nullable ParamDefExpression defaultExpression) {
        this.myKeysAreOptional = keysAreOptional;
        this.myAcceptOnly19 = acceptOnly19;
        this.myDefaultExpression = defaultExpression;
    }

    public ParamDefHash(boolean keysAreOptional, @Nullable ParamDefExpression defaultExpression) {
        this(keysAreOptional, false, defaultExpression);
    }

    @Override
    public MatchResult match(MatchContext context) {
        boolean atAssocList = false;
        if (context.current() instanceof RAssocList) {
            atAssocList = true;
            if (context.getTarget() == context.current()) {
                return new MatchResult(AnyParamDef.getInstance(), context.paramContext());
            }
            context.push((RPsiElement)((RAssocList)context.current()));
        }
        do {
            PsiElement current;
            if ((current = context.current()) instanceof RAssoc) {
                RAssoc assoc = (RAssoc)current;
                if (PsiTreeUtil.isAncestor((PsiElement)assoc.getKey(), (PsiElement)context.getTarget(), (boolean)false)) {
                    context.push(assoc.getKey());
                    return new MatchResult(new HashKeyParamDef(this), context.paramContext());
                }
                String text = (String)ObjectUtils.doIfNotNull((Object)assoc.getKey(), element -> RubyPsiUtilCore.getElementText((PsiElement)element));
                ParamDefExpression expr = this.myMap.get(text);
                if (!context.atTarget()) continue;
                if (expr == null) {
                    expr = (ParamDefExpression)ContainerUtil.getOnlyItem(this.myProviders.values(), (Object)this.myDefaultExpression);
                }
                if (expr != null) {
                    if (expr instanceof ParamDefLeaf) {
                        context.pushLeaf(assoc.getValue());
                    } else {
                        context.push(assoc.getValue());
                    }
                    return expr.match(context);
                }
                if (!this.areKeysOptional()) continue;
                return new MatchResult(AnyParamDef.getInstance(), context.paramContext());
            }
            if (!ParamDefHash.isValidForIncompleteHash(current) || !context.atTarget() || context.peekNext() != null) continue;
            return new MatchResult(new HashKeyParamDef(this), context.paramContext());
        } while (context.advance());
        if (atAssocList) {
            context.pop();
        }
        return null;
    }

    public boolean areKeysOptional() {
        return this.myKeysAreOptional;
    }

    public boolean acceptsOnly19() {
        return this.myAcceptOnly19;
    }

    private static boolean isValidForIncompleteHash(@Nullable PsiElement current) {
        return current instanceof RSymbol || current != null && RConstantImpl.isDummyIdentifier((PsiElement)current);
    }

    @Override
    public boolean canMatch(MatchContext context, boolean strong) {
        PsiElement current = context.current();
        return current instanceof RAssoc || current instanceof RSymbol && context.peekNext() == null || current instanceof RAssocList || current != null && RConstantImpl.isDummyIdentifier((PsiElement)current);
    }

    @Override
    public @NotNull Set<@NlsSafe String> getArgumentExpectedTypes() {
        Set<String> set = EXPECTED_TYPES;
        if (set == null) {
            ParamDefHash.$$$reportNull$$$0(0);
        }
        return set;
    }

    public ParamDefHash addKey(Object key, ParamDefExpression value) {
        if (key instanceof DynamicHashKeyProvider) {
            this.myProviders.put((DynamicHashKeyProvider)key, value);
        } else {
            this.myMap.put(key.toString(), value);
            this.myKeyMap.put(key.toString(), key);
        }
        return this;
    }

    public Collection<String> getKeys(RubyCallArgumentContext context) {
        HashSet<String> result = new HashSet<String>(this.myMap.keySet());
        for (DynamicHashKeyProvider provider : this.myProviders.keySet()) {
            result.addAll(provider.getKeys(context));
        }
        return result;
    }

    public boolean hasKey(@NotNull RubyCallArgumentContext context, @Nullable String key) {
        if (context == null) {
            ParamDefHash.$$$reportNull$$$0(1);
        }
        return this.myKeyMap.containsKey(key) || ContainerUtil.or(this.myProviders.keySet(), provider -> provider.hasKey(context, key));
    }

    public boolean isSymbolKey(String key) {
        Object o = this.myKeyMap.get(key);
        return o == null || EnumParam.isRubySymbol(o);
    }

    @Nullable
    public PsiElement resolveKey(RubyCallArgumentContext context) {
        RPsiElement element = context.getArgumentElement();
        String text = element instanceof RSymbol ? ((RSymbol)element).getValue() : TextUtil.removeQuoting((String)element.getText());
        for (DynamicHashKeyProvider provider : this.myProviders.keySet()) {
            PsiElement resolve = provider.resolveKey(context, text);
            if (resolve == null) continue;
            return resolve;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/matcher/ParamDefHash";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentExpectedTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/matcher/ParamDefHash";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

