/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBracedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class MatchContext {
    private final PsiElement myTarget;
    private final RCall myCall;
    private PsiElement myCurArgument;
    private final Stack<RPsiElement> myArgStack = new Stack();

    public MatchContext(PsiElement target, RCall call, PsiElement curArgument) {
        this.myTarget = target;
        this.myCall = call;
        this.myCurArgument = curArgument;
    }

    public MatchContext copy() {
        MatchContext context = new MatchContext(this.myTarget, this.myCall, this.myCurArgument);
        context.myArgStack.addAll(this.myArgStack);
        return context;
    }

    public boolean atTarget() {
        return PsiTreeUtil.isAncestor((PsiElement)this.current(), (PsiElement)this.myTarget, (boolean)false);
    }

    public PsiElement getTarget() {
        return this.myTarget;
    }

    public RCall getCall() {
        return this.myCall;
    }

    public PsiElement current() {
        if (!this.myArgStack.isEmpty()) {
            return (PsiElement)this.myArgStack.peek();
        }
        return this.myCurArgument;
    }

    public boolean advance() {
        if (this.current() == null) {
            return false;
        }
        RPsiElement next = this.peekNext();
        if (this.myArgStack.isEmpty()) {
            this.myCurArgument = next;
        } else {
            this.myArgStack.set(this.myArgStack.size() - 1, (Object)next);
        }
        return this.current() != null;
    }

    @Nullable
    public RPsiElement peekNext() {
        PsiElement result;
        PsiElement current = this.current();
        if (current == null) {
            return null;
        }
        for (result = current.getNextSibling(); result != null && (result instanceof PsiWhiteSpace || result.getNode().getElementType() == RubyTokenTypes.tCOMMA || result.getNode().getElementType() == RubyTokenTypes.tRBRACE || !(result instanceof RPsiElement)); result = result.getNextSibling()) {
        }
        return (RPsiElement)result;
    }

    public void push(RPsiElement value) {
        if (value instanceof RBracedExpression) {
            this.pushFirstInList(((RBracedExpression)value).getElements());
        } else {
            this.pushLeaf(value);
        }
    }

    public void pushLeaf(RPsiElement value) {
        this.myArgStack.push((Object)value);
    }

    private void pushFirstInList(List<RPsiElement> elementList) {
        if (!elementList.isEmpty()) {
            this.myArgStack.push((Object)elementList.get(0));
        } else {
            this.myArgStack.push(null);
        }
    }

    @NotNull
    public RubyCallArgumentContext paramContext() {
        return new RubyCallArgumentContext(this.myCall, (RPsiElement)this.current());
    }

    public void pop() {
        this.myArgStack.pop();
    }
}

