/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public class RubyCallArgumentContext {
    @NotNull
    private final RPsiElement myArgumentElement;
    @NotNull
    private final RCall myCall;

    public RubyCallArgumentContext(@NotNull RCall call, @NotNull RPsiElement argumentElement) {
        if (call == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(0);
        }
        if (argumentElement == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(1);
        }
        this.myCall = call;
        this.myArgumentElement = argumentElement;
    }

    @NotNull
    public RPsiElement getArgumentElement() {
        RPsiElement rPsiElement = this.myArgumentElement;
        if (rPsiElement == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(2);
        }
        return rPsiElement;
    }

    @NotNull
    public RCall getCall() {
        RCall rCall = this.myCall;
        if (rCall == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(3);
        }
        return rCall;
    }

    @NotNull
    public PsiFile getRFile() {
        RCall rCall = this.getCall();
        PsiFile psiFile = rCall.getContainingFile();
        if (psiFile == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @Nullable
    public RClass getRClass() {
        return RubyPsiUtil.getContainingRClass((PsiElement)this.getCall());
    }

    @Nullable
    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getArgumentElement());
    }

    @NotNull
    public Project getProject() {
        Project project = this.getCall().getProject();
        if (project == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    public List<RPsiElement> getNeighbourArguments() {
        RPsiElement element;
        for (element = this.getArgumentElement(); element != null && !RubyCallArgumentContext.isAssocList((PsiElement)element); element = element.getParent()) {
        }
        if (element instanceof RAssocList) {
            List list = ((RAssocList)element).getElements();
            if (list == null) {
                RubyCallArgumentContext.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (element instanceof RListOfExpressions) {
            List list = ((RListOfExpressions)element).getElements();
            if (list == null) {
                RubyCallArgumentContext.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<RPsiElement> list = Collections.emptyList();
        if (list == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public RPsiElement getArgument(int index) {
        List arguments = this.getCall().getArguments();
        if (index < 0 || index >= arguments.size()) {
            return null;
        }
        return (RPsiElement)arguments.get(index);
    }

    @Nullable
    public RAssoc getArgument(@NotNull String key) {
        if (key == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(9);
        }
        for (RAssoc assoc : ContainerUtil.filterIsInstance(this.getNeighbourArguments(), RAssoc.class)) {
            if (!key.equals(assoc.getKeyText())) continue;
            return assoc;
        }
        return null;
    }

    public boolean hasArgument(@NotNull String key) {
        if (key == null) {
            RubyCallArgumentContext.$$$reportNull$$$0(10);
        }
        return this.getNeighbourArguments().stream().anyMatch(element -> element instanceof RAssoc && key.equals(((RAssoc)element).getKeyText()));
    }

    private static boolean isAssocList(PsiElement element) {
        return element instanceof RAssocList || element instanceof RListOfExpressions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyCallArgumentContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/RubyCallArgumentContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNeighbourArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getArgument";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

