/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.configuration.RailsPaths;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.ParamDefResolveVisitor;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.LookupItemType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefImplUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;

public class ParamDefBase
extends ParamDef {
    @Override
    @NotNull
    public InspectionResult inspectReference(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            ParamDefBase.$$$reportNull$$$0(0);
        }
        RPsiElement element = context.getArgumentElement();
        if (this.inspectionEnabledFor(context)) {
            if (this.resolveReferenceForInspectionHook(context) == null) {
                InspectionResult inspectionResult = this.warningInspection(context, element);
                if (inspectionResult == null) {
                    ParamDefBase.$$$reportNull$$$0(1);
                }
                return inspectionResult;
            }
            InspectionResult inspectionResult = InspectionResult.createOkResult((PsiElement)element);
            if (inspectionResult == null) {
                ParamDefBase.$$$reportNull$$$0(2);
            }
            return inspectionResult;
        }
        if (ParamDefResolveVisitor.isProbablyAcceptable((PsiElement)element)) {
            InspectionResult inspectionResult = InspectionResult.createProbablyAcceptibleResult((PsiElement)element);
            if (inspectionResult == null) {
                ParamDefBase.$$$reportNull$$$0(3);
            }
            return inspectionResult;
        }
        if (ParamDefResolveVisitor.isCompositeElement((PsiElement)element)) {
            InspectionResult inspectionResult = InspectionResult.createNotApplicableResult((PsiElement)element, "String", "Symbol");
            if (inspectionResult == null) {
                ParamDefBase.$$$reportNull$$$0(4);
            }
            return inspectionResult;
        }
        InspectionResult inspectionResult = InspectionResult.createIgnoredResult((PsiElement)element);
        if (inspectionResult == null) {
            ParamDefBase.$$$reportNull$$$0(5);
        }
        return inspectionResult;
    }

    @Nullable
    protected PsiElement resolveReferenceForInspectionHook(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            ParamDefBase.$$$reportNull$$$0(6);
        }
        return this.resolveReference(context);
    }

    public InspectionResult warningInspection(RubyCallArgumentContext context, RPsiElement element) {
        return InspectionResult.createDefaultWarningResult((PsiElement)element);
    }

    protected boolean inspectionEnabledFor(RubyCallArgumentContext context) {
        return ParamDefResolveVisitor.isSimple((PsiElement)context.getArgumentElement());
    }

    @NotNull
    protected List<VirtualFile> viewRoots(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            ParamDefBase.$$$reportNull$$$0(7);
        }
        List<VirtualFile> list = (module = context.getModule()) != null ? RailsPaths.getInstance(module).findFiles("app/views") : Collections.emptyList();
        if (list == null) {
            ParamDefBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    protected static RailsApp railsApp(RubyCallArgumentContext context) {
        Module module = context.getModule();
        return module != null ? RailsApp.fromModule(module) : null;
    }

    @NotNull
    protected static List<VirtualFile> controllerRoots(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            ParamDefBase.$$$reportNull$$$0(9);
        }
        List<VirtualFile> list = (module = context.getModule()) != null ? RailsPaths.getInstance(module).findFiles("app/controllers") : Collections.emptyList();
        if (list == null) {
            ParamDefBase.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    protected static List<VirtualFile> modelRoots(@NotNull RubyCallArgumentContext context) {
        Module module;
        if (context == null) {
            ParamDefBase.$$$reportNull$$$0(11);
        }
        List<VirtualFile> list = (module = context.getModule()) != null ? RailsPaths.getInstance(module).findFiles("app/models") : Collections.emptyList();
        if (list == null) {
            ParamDefBase.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    protected static String elementText(@NotNull RubyCallArgumentContext context) {
        if (context == null) {
            ParamDefBase.$$$reportNull$$$0(13);
        }
        String string = StringUtil.notNullize((String)RubyPsiUtilCore.getElementText((PsiElement)context.getArgumentElement()));
        if (string == null) {
            ParamDefBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected static void processFiles(@Nullable Project project, @Nullable VirtualFile root, @NotNull Consumer<VirtualFile> virtualFileConsumer) {
        if (virtualFileConsumer == null) {
            ParamDefBase.$$$reportNull$$$0(15);
        }
        if (root == null || project == null) {
            return;
        }
        ProjectRootManager.getInstance((Project)project).getFileIndex().iterateContentUnderDirectory(root, virtualFile -> {
            ProgressManager.checkCanceled();
            if (!virtualFile.isDirectory()) {
                virtualFileConsumer.consume((Object)virtualFile);
            }
            return true;
        });
    }

    public static String relativePath(VirtualFile root, VirtualFile file) {
        StringBuilder s = new StringBuilder();
        while (!Comparing.equal((Object)file.getParent(), (Object)root)) {
            s.insert(0, file.getParent().getName());
            file = file.getParent();
        }
        return s.toString();
    }

    @Nullable
    public static LookupElement createLookupItem(RubyCallArgumentContext context, String value, Icon icon) {
        return ParamDefBase.createTypedLookupItem(context, value, null, LookupItemType.String, icon);
    }

    @Contract(value="_, null, _, _ -> null; _, !null, _, _ -> !null;")
    public static LookupElement createLookupItem(RubyCallArgumentContext context, String value, LookupItemType itemType, Icon icon) {
        return ParamDefBase.createTypedLookupItem(context, value, null, itemType, icon);
    }

    @Contract(value="_, null, _, _, _ -> null; _, !null, _, _, _ -> !null;")
    public static LookupElement createTypedLookupItem(RubyCallArgumentContext context, String value, @Nullable String typeText, LookupItemType itemType, Icon icon) {
        return value != null ? ParamDefImplUtil.createSimpleLookupItem(value, typeText, itemType, context.getArgumentElement(), icon) : null;
    }

    @Nullable
    public static PsiFile findPsiFile(RubyCallArgumentContext context, VirtualFile file) {
        return (PsiFile)ObjectUtils.doIfNotNull((Object)file, arg_0 -> ((PsiManager)PsiManager.getInstance((Project)context.getProject())).findFile(arg_0));
    }

    @Nullable
    public static PsiFile findPsiFileUnder(RubyCallArgumentContext context, VirtualFile root, String name) {
        String[] components;
        if (root == null) {
            return null;
        }
        VirtualFile file = root;
        for (String s : components = name.split("/")) {
            if ((file = file.findChild(s)) != null) continue;
            return null;
        }
        return ParamDefBase.findPsiFile(context, file);
    }

    @NotNull
    public static List<VirtualFile> railsStdPathsFiles(@NotNull RubyCallArgumentContext context, @NotNull String methodName) {
        Module module;
        if (context == null) {
            ParamDefBase.$$$reportNull$$$0(16);
        }
        if (methodName == null) {
            ParamDefBase.$$$reportNull$$$0(17);
        }
        if ((module = context.getModule()) == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                ParamDefBase.$$$reportNull$$$0(18);
            }
            return list;
        }
        RailsPaths paths = RailsPaths.getInstance(module);
        List<VirtualFile> list = switch (methodName) {
            case "getJavascriptsRootURL" -> paths.findFiles("public/javascripts");
            case "getStylesheetsRootURL" -> paths.findFiles("public/stylesheets");
            case "getAppAssetsRootURL" -> paths.findFiles("app/assets");
            case "getImagesRootURL" -> paths.findFiles("public", "images");
            case "getPublicRootURL" -> paths.findFiles("public");
            default -> Collections.emptyList();
        };
        if (list == null) {
            ParamDefBase.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 10, 12, 14, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/ParamDefBase";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileConsumer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/ParamDefBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "viewRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "controllerRoots";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "modelRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "elementText";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "railsStdPathsFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inspectReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceForInspectionHook";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "viewRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "controllerRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modelRoots";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "elementText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "railsStdPathsFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 10, 12, 14, 18, 19 -> new IllegalStateException(string);
        };
    }
}

