/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDependency;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.RubyCallArgumentContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;

public class ClassOrModuleDependency
implements ParamDependency<PsiElement> {
    private final Collection<String> myFQNs;
    private final boolean myIsClass;

    public ClassOrModuleDependency(@NotNull String fqn, boolean isClass) {
        if (fqn == null) {
            ClassOrModuleDependency.$$$reportNull$$$0(0);
        }
        this(Collections.singleton(fqn), isClass);
    }

    public ClassOrModuleDependency(@NotNull Collection<String> fqns, boolean isClass) {
        if (fqns == null) {
            ClassOrModuleDependency.$$$reportNull$$$0(1);
        }
        assert (!fqns.isEmpty()) : "list of classes must not be empty";
        this.myFQNs = Sets.newHashSet(fqns);
        this.myIsClass = isClass;
    }

    @Override
    @Nullable
    public PsiElement getValue(RubyCallArgumentContext context) {
        for (String fqn : this.myFQNs) {
            Symbol aClass = SymbolUtil.findConstantByFQN(context.getProject(), this.myIsClass ? Type.CLASS : Type.MODULE, FQN.Builder.fromString((String)fqn), (PsiElement)context.getArgumentElement());
            if (aClass == null) continue;
            return aClass.getPsiElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fqn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fqns";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/paramDefs/ClassOrModuleDependency";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

