/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.nativerb;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ThreeState;
import com.intellij.util.xmlb.annotations.XMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.nativerb.StubsGenRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

@com.intellij.openapi.components.State(name="RubyStubsGeneratedCache", storages={@Storage(value="gemmanager.xml", roamingType=RoamingType.DISABLED)})
public class RubyStubBuilderService
implements PersistentStateComponent<State> {
    private static final String NO_STUBS_NEEDED = "no";
    private final LocalFileSystem myFileSystem;
    private final Alarm myAlarm = new Alarm();
    private final Set<GemInfo> myGemsToProcess = new LinkedHashSet<GemInfo>();
    private final HashMap<String, String> myGemsCache = new HashMap();
    private final BackgroundTaskQueue myQueue = new BackgroundTaskQueue(null, RBundle.message((String)"stub.builder.service.updating.stubs"));

    public RubyStubBuilderService() {
        this.myFileSystem = LocalFileSystem.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualFile getStubs(@NotNull GemInfo gem) {
        if (gem == null) {
            RubyStubBuilderService.$$$reportNull$$$0(0);
        }
        Set<GemInfo> set = this.myGemsToProcess;
        synchronized (set) {
            String stubVersion = this.myGemsCache.get(RubyStubBuilderService.getGemKey(gem));
            if (stubVersion == null || NO_STUBS_NEEDED.equals(stubVersion)) {
                return null;
            }
        }
        File location = RubyStubBuilderService.getStubLocation(gem);
        if (location == null) {
            return null;
        }
        return this.myFileSystem.findFileByIoFile(location);
    }

    private void addStubsIfNeeded(@Nullable Sdk sdk, @Nullable Library library) {
        if (library == null || sdk == null) {
            return;
        }
        String libraryName = library.getName();
        if (!RubySdkUtil.isMRISdk(sdk)) {
            return;
        }
        Pair<String, String> nameAndVersion = GemInfo.getNameAndVersion(libraryName);
        File location = nameAndVersion != null ? RubyStubBuilderService.getStubLocation(sdk, (String)nameAndVersion.first, (String)nameAndVersion.second) : null;
        VirtualFile root = location != null ? this.myFileSystem.refreshAndFindFileByIoFile(location) : null;
        VirtualFile[] roots = library.getFiles(OrderRootType.CLASSES);
        if (root == null || Arrays.asList(roots).contains(root)) {
            return;
        }
        Library.ModifiableModel libModel = library.getModifiableModel();
        String url = root.getUrl();
        libModel.addRoot(url, OrderRootType.CLASSES);
        libModel.addRoot(url, OrderRootType.SOURCES);
        for (int i = 0; i < roots.length; ++i) {
            libModel.moveRootUp(url, OrderRootType.CLASSES);
            libModel.moveRootUp(url, OrderRootType.SOURCES);
        }
        libModel.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStubsUpdate(final @NotNull Module module, Set<GemInfo> toAdd) {
        if (module == null) {
            RubyStubBuilderService.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!Registry.is((String)"ruby.enable.native.stubs.builder", (boolean)false)) {
            return;
        }
        final Project project = module.getProject();
        Set<GemInfo> set = this.myGemsToProcess;
        synchronized (set) {
            HashSet<GemInfo> toUpdate = new HashSet<GemInfo>();
            for (GemInfo gem : toAdd) {
                boolean hasUpToDateStubs;
                String generatedVersion = this.myGemsCache.get(RubyStubBuilderService.getGemKey(gem));
                File location = RubyStubBuilderService.getStubLocation(gem);
                if (location == null || NO_STUBS_NEEDED.equals(generatedVersion)) continue;
                boolean bl = hasUpToDateStubs = StringUtil.compare((String)generatedVersion, (String)"1", (boolean)false) >= 0 && location.exists();
                if (!hasUpToDateStubs) {
                    this.myGemsToProcess.add(gem);
                    continue;
                }
                toUpdate.add(gem);
            }
            this.addStubsWithMergingEvents(project, toUpdate);
            this.myAlarm.cancelAllRequests();
        }
        this.myAlarm.addRequest(() -> {
            Set<GemInfo> set = this.myGemsToProcess;
            synchronized (set) {
                if (this.myGemsToProcess.isEmpty() || project.isDisposed()) {
                    return;
                }
            }
            DumbService.getInstance((Project)project).runWhenSmart(() -> this.myQueue.run(new Task.Backgroundable(project, RBundle.message((String)"stub.builder.service.updating.stubs"), true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    ArrayList<GemInfo> gems;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Set<GemInfo> set = RubyStubBuilderService.this.myGemsToProcess;
                    synchronized (set) {
                        if (RubyStubBuilderService.this.myGemsToProcess.isEmpty()) {
                            return;
                        }
                        gems = new ArrayList<GemInfo>(RubyStubBuilderService.this.myGemsToProcess);
                    }
                    HashSet<GemInfo> toUpdate = new HashSet<GemInfo>();
                    indicator.setIndeterminate(false);
                    for (int i = 0; i < gems.size(); ++i) {
                        if (project.isDisposed() || indicator.isCanceled()) {
                            return;
                        }
                        GemInfo gem = (GemInfo)gems.get(i);
                        indicator.setFraction(1.0 * (double)i / (double)gems.size());
                        indicator.setText(RBundle.message((String)"stub.builder.service.generating.stubs", (Object[])new Object[]{gem.getName()}));
                        ThreeState state = StubsGenRunner.generateStubs(module, gem, RubyStubBuilderService.getStubLocation(gem));
                        Set<GemInfo> set2 = RubyStubBuilderService.this.myGemsToProcess;
                        synchronized (set2) {
                            if (state == ThreeState.NO) {
                                RubyStubBuilderService.this.myGemsCache.put(RubyStubBuilderService.getGemKey(gem), RubyStubBuilderService.NO_STUBS_NEEDED);
                            } else if (state == ThreeState.YES) {
                                RubyStubBuilderService.this.myGemsCache.put(RubyStubBuilderService.getGemKey(gem), "1");
                            }
                        }
                        toUpdate.add(gem);
                    }
                    RubyStubBuilderService.this.addStubsWithMergingEvents(project, toUpdate);
                    Set<GemInfo> set3 = RubyStubBuilderService.this.myGemsToProcess;
                    synchronized (set3) {
                        RubyStubBuilderService.this.myGemsToProcess.removeAll(gems);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/codeInsight/nativerb/RubyStubBuilderService$1", "run"));
                }
            }));
        }, 3000);
    }

    private void addStubsWithMergingEvents(@NotNull Project project, Set<GemInfo> gems) {
        if (project == null) {
            RubyStubBuilderService.$$$reportNull$$$0(2);
        }
        WriteAction.runAndWait(() -> ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(() -> {
            LibraryTable.ModifiableModel model = GemModificationUtil.getLibraryTableModifiableModel();
            for (GemInfo gem : gems) {
                this.addStubsIfNeeded(gem.getSdk(), gem.getLibrary(model));
            }
            if (model.isChanged()) {
                model.commit();
            } else {
                GemModificationUtil.disposeLibraryTableModifiableModel(model);
            }
        }));
    }

    private static String getGemKey(GemInfo gem) {
        return gem.getName() + ", " + gem.getNullableVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Set<GemInfo> set = this.myGemsToProcess;
        synchronized (set) {
            return new State((Map)this.myGemsCache.clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        if (state == null) {
            RubyStubBuilderService.$$$reportNull$$$0(3);
        }
        Set<GemInfo> set = this.myGemsToProcess;
        synchronized (set) {
            this.myGemsCache.clear();
            this.myGemsCache.putAll(state.map);
        }
    }

    @Nullable
    private static File getStubLocation(GemInfo gem) {
        if (gem.isFromPath() && gem.getNullableVersion() == null) {
            return null;
        }
        Sdk sdk = gem.getSdk();
        if (!RubySdkUtil.isMRISdk(sdk)) {
            return null;
        }
        return RubyStubBuilderService.getStubLocation(sdk, gem.getName(), gem.getVersion());
    }

    private static File getStubLocation(@NotNull Sdk sdk, String name, String version) {
        if (sdk == null) {
            RubyStubBuilderService.$$$reportNull$$$0(4);
        }
        return RubySdkUtil.getStubsDir(sdk).resolve(name).resolve(version).toFile();
    }

    public static RubyStubBuilderService getInstance() {
        return (RubyStubBuilderService)ApplicationManager.getApplication().getService(RubyStubBuilderService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/nativerb/RubyStubBuilderService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStubs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "requestStubsUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addStubsWithMergingEvents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getStubLocation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class State {
        @XMap(propertyElementName="generated_stubs")
        public Map<String, String> map;

        public State() {
            this.map = new HashMap<String, String>();
        }

        public State(Map<String, String> map) {
            this.map = map;
        }
    }
}

