/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.lineMarkers;

import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;

public abstract class RubyToolTipProvider
implements Function<PsiElement, String> {
    @NonNls
    private static final String NEWLINE_AND_SPACES = "<br>&nbsp;&nbsp;";
    @NonNls
    private static final String COMMA_AND_SPACE = ",&nbsp;";
    protected final Collection<? extends PsiElement> myElements;

    protected RubyToolTipProvider(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            RubyToolTipProvider.$$$reportNull$$$0(0);
        }
        this.myElements = elements;
    }

    public String fun(PsiElement psiElement) {
        RContainer container = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RContainer.class);
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getMessageString(container));
        buffer.append("&nbsp;").append(RBundle.message((String)"in"));
        LinkedHashSet<String> locations = this.getPresentableLocations(container);
        int size = locations.size();
        String separator = size <= 10 ? NEWLINE_AND_SPACES : COMMA_AND_SPACE;
        boolean first = true;
        int length = 0;
        for (String location : locations) {
            if (location == null) continue;
            if (first) {
                buffer.append(size == 1 ? "&nbsp;" : NEWLINE_AND_SPACES);
                first = false;
            } else if (length > 50) {
                buffer.append(NEWLINE_AND_SPACES);
                length = 0;
            } else {
                buffer.append(separator);
                if (!Strings.areSameInstance((String)separator, (String)NEWLINE_AND_SPACES)) {
                    length += location.length();
                }
            }
            buffer.append(location);
        }
        return buffer.toString();
    }

    protected LinkedHashSet<String> getPresentableLocations(RContainer container) {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        for (PsiElement psiElement : this.myElements) {
            locations.add(RContainerPresentationUtil.getLocation((RPsiElement)((RPsiElement)psiElement)));
        }
        return locations;
    }

    protected abstract String getMessageString(RContainer var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/plugins/ruby/ruby/codeInsight/lineMarkers/RubyToolTipProvider", "<init>"));
    }
}

