/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.completion.namedArguments;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rdoc.yard.psi.MethodNameFakePsiElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ArgMapping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.IncomingType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionGrouping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyCompletionProviderUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.namedArguments.RubyNamedArgumentInsertHandler;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public class RubyNamedArgumentCompletionProvider
extends RubyTrackedCompletionProvider {
    public static final RubyNamedArgumentCompletionProvider INSTANCE = new RubyNamedArgumentCompletionProvider();

    private RubyNamedArgumentCompletionProvider() {
        super((Language)RubyLanguage.INSTANCE);
    }

    @Override
    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement argument;
        if (parameters == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((argument = parameters.getPosition().getParent()) == null) {
            return;
        }
        RCall rCall = (RCall)PsiTreeUtil.getParentOfType((PsiElement)argument.getParent(), RCall.class, (boolean)true);
        List<RPsiElement> argumentsElements = RubyNamedArgumentCompletionProvider.getRCallArgumentListElements(rCall);
        if (argumentsElements == null) {
            return;
        }
        boolean isInsideAssocList = argumentsElements.contains(PsiTreeUtil.getParentOfType((PsiElement)argument, RAssocList.class));
        PsiElement method = RubyNamedArgumentCompletionProvider.getRMethod(rCall);
        List<ArgumentInfo> argumentInfos = RubyNamedArgumentCompletionProvider.getArgumentInfos(method);
        if (argumentInfos == null) {
            return;
        }
        HashSet<String> existingNames = new HashSet<String>();
        int currentArgumentIndex = RubyNamedArgumentCompletionProvider.calculateExistingNamesAndArgumentIndex(argument, argumentsElements, existingNames);
        ArrayList<RPsiElement> argumentsWithoutCompletion = new ArrayList<RPsiElement>(argumentsElements);
        argumentsWithoutCompletion.remove(currentArgumentIndex);
        ArgumentInfo info = RubyNamedArgumentCompletionProvider.getArgumentInfo(argumentInfos, argumentsElements, currentArgumentIndex, isInsideAssocList);
        if (info != null && info.getType().isPositional() && method instanceof RMethod) {
            ((StreamEx)StreamEx.of((Collection)((RMethod)method).getOptionInfos()).filter(optionInfo -> optionInfo.getArgumentName().equals(info.getName()))).forEach(optionInfo -> RubyNamedArgumentCompletionProvider.addCompletionIfNamedArgument(new ArgumentInfo(optionInfo.getOptionName(), optionInfo.isRequired() ? ArgumentInfo.Type.KEYREQ : ArgumentInfo.Type.NAMED), result));
        }
        if (RubyNamedArgumentCompletionProvider.canCompleteNamedArgument(argumentInfos, argumentsWithoutCompletion, currentArgumentIndex) && (info == null || !info.getType().isPositional())) {
            argumentInfos.stream().filter(argumentInfo -> !existingNames.contains(argumentInfo.getName())).forEach(argumentInfo -> RubyNamedArgumentCompletionProvider.addCompletionIfNamedArgument(argumentInfo, result));
        }
    }

    @Nullable
    private static ArgumentInfo getArgumentInfo(@NotNull List<ArgumentInfo> argumentInfos, @NotNull List<RPsiElement> arguments, int argumentNo, boolean isInsideAssocList) {
        LanguageLevel languageLevel;
        List incomingTypes;
        Function1 getAssocText;
        Map mapping;
        if (argumentInfos == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(3);
        }
        if (arguments == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(4);
        }
        if ((mapping = ArgMapping.get(argumentInfos, (Function1)(getAssocText = index -> index != argumentNo ? ((RAssoc)arguments.get((int)index)).getKeyText() : ((RPsiElement)arguments.get((int)index)).getText()), incomingTypes = IntStream.range(0, arguments.size()).mapToObj(index -> argumentNo != index ? ArgMapping.getIncomingType((PsiElement)((PsiElement)arguments.get(index))) : (isInsideAssocList ? IncomingType.NONE : IncomingType.ASSOC)).collect(Collectors.toList()), (LanguageLevel)(languageLevel = RubyLanguageLevelService.getLanguageLevelByElementOrLatest((PsiElement)((PsiElement)ContainerUtil.getFirstItem(arguments)))))) == null) {
            return null;
        }
        return ArgMapping.getArgumentInfoByIncomingArgumentNo((Map)mapping, (int)argumentNo);
    }

    private static int calculateExistingNamesAndArgumentIndex(@NotNull PsiElement argument, @NotNull List<RPsiElement> argumentsElements, @NotNull Set<String> existingNames) {
        if (argument == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(5);
        }
        if (argumentsElements == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(6);
        }
        if (existingNames == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(7);
        }
        int currentArgumentIndex = -1;
        int size = argumentsElements.size();
        for (int i = 0; i < size; ++i) {
            PsiElement argumentElement = (PsiElement)argumentsElements.get(i);
            if (argumentElement instanceof RAssoc) {
                existingNames.add(((RAssoc)argumentElement).getKeyText());
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)argumentElement, (PsiElement)argument, (boolean)false)) continue;
            currentArgumentIndex = i;
        }
        assert (currentArgumentIndex != -1);
        return currentArgumentIndex;
    }

    @Contract(value="null -> null")
    @Nullable
    static List<RPsiElement> getRCallArgumentListElements(@Nullable RCall call) {
        if (call == null) {
            return null;
        }
        RListOfExpressions arguments = call.getCallArguments();
        return arguments.getElements();
    }

    private static boolean canCompleteNamedArgument(@NotNull List<ArgumentInfo> argumentInfos, @NotNull List<RPsiElement> argumentsElements, int positionInArgumentList) {
        int simpleArgumentsInSignature;
        Map mapping;
        if (argumentInfos == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(8);
        }
        if (argumentsElements == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(9);
        }
        if ((mapping = ArgMapping.get(argumentInfos, argumentsElements)) == null) {
            return false;
        }
        int simpleArgumentsInCall = ContainerUtil.count(mapping.keySet(), it -> it.getType() == ArgumentInfo.Type.SIMPLE);
        if (simpleArgumentsInCall != (simpleArgumentsInSignature = ContainerUtil.count(argumentInfos, it -> it.getType() == ArgumentInfo.Type.SIMPLE))) {
            return false;
        }
        return RubyNamedArgumentCompletionProvider.canNamedArgumentBeOnPosition(mapping, argumentInfos.size(), positionInArgumentList);
    }

    private static boolean canNamedArgumentBeOnPosition(@NotNull Map<ArgumentInfo, ArgMapping.MappingRange> mapping, int signatureSize, int position) {
        if (mapping == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(10);
        }
        int kwBeginPosition = -1;
        int kwEndPosition = signatureSize;
        for (ArgumentInfo argumentInfo : mapping.keySet()) {
            ArgumentInfo.Type currentType = argumentInfo.getType();
            ArgMapping.MappingRange range = mapping.get(argumentInfo);
            if (currentType.isPositionalOrRest()) {
                kwBeginPosition = Math.max(kwBeginPosition, range.last());
            }
            if (!currentType.isBlock()) continue;
            kwEndPosition = Math.min(kwEndPosition, range.first());
        }
        return kwBeginPosition < position && position <= kwEndPosition;
    }

    private static void addCompletionIfNamedArgument(@NotNull ArgumentInfo argumentInfo, @NotNull CompletionResultSet result) {
        if (argumentInfo == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(11);
        }
        if (result == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(12);
        }
        if (argumentInfo.getType() == ArgumentInfo.Type.KEYREQ) {
            RubyNamedArgumentCompletionProvider.addNamedArgumentCompletion(argumentInfo, RBundle.message((String)"required.named.argument"), AllIcons.Nodes.NewParameter, result);
        }
        if (argumentInfo.getType() == ArgumentInfo.Type.NAMED) {
            RubyNamedArgumentCompletionProvider.addNamedArgumentCompletion(argumentInfo, RBundle.message((String)"optional.named.argument"), AllIcons.Nodes.Parameter, result);
        }
    }

    private static void addNamedArgumentCompletion(@NotNull ArgumentInfo argumentInfo, @NotNull String typeText, @NotNull Icon icon, @NotNull CompletionResultSet result) {
        if (argumentInfo == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(13);
        }
        if (typeText == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(14);
        }
        if (icon == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(15);
        }
        if (result == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(16);
        }
        if (RubyCompletionProviderUtil.lookupStringShouldBeProcessed(argumentInfo.getName(), result)) {
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)new RubyLookupElement(argumentInfo.getName(), null, typeText, true, icon, null, (InsertHandler<RubyLookupElement>)new RubyNamedArgumentInsertHandler()), (double)RubyCompletionGrouping.LOCAL_OR_PARAMETER.getValue());
            result.addElement(lookupElement);
        }
    }

    @Nullable
    private static PsiElement getRMethod(@NotNull RCall call) {
        PsiReference reference;
        if (call == null) {
            RubyNamedArgumentCompletionProvider.$$$reportNull$$$0(17);
        }
        if ((reference = call.getPsiCommand().getReference()) == null) {
            return null;
        }
        return reference.resolve();
    }

    @Nullable
    private static List<ArgumentInfo> getArgumentInfos(@Nullable PsiElement methodLike) {
        if (methodLike instanceof RMethod) {
            return ((RMethod)methodLike).getArgumentInfos();
        }
        if (methodLike instanceof MethodNameFakePsiElement) {
            MethodNameFakePsiElement documentationMethod = (MethodNameFakePsiElement)methodLike;
            if (documentationMethod.getDocumentationMethod() == null) {
                return null;
            }
            return documentationMethod.getDocumentationMethod().getArguments().getArgumentInfos();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsElements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentInfo";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/completion/namedArguments/RubyNamedArgumentCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionsTracked";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgumentInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateExistingNamesAndArgumentIndex";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canCompleteNamedArgument";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "canNamedArgumentBeOnPosition";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionIfNamedArgument";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addNamedArgumentCompletion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getRMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

